#import <foundation/NSString.h>
#import <foundation/NSArray.h>
#import <foundation/NSUtilities.h>

#import <TCKit/TCKit.h>

#import "ServicesController.h"
#import "AppController.h"
#import "SlurpeeAdaptor.h"
#import "Preferences.h"

@implementation ServicesController

- serviceCreateNewtonNoteFromPasteboard:(id)pasteboard
	userData:(const char *)userData 
	error:(char **)errorMessage
{
	SlurpeeAdaptor *adaptor = [SlurpeeAdaptor adaptorWithStream:
		[[appController newton] stream]];
	NSArray *typesArray;
	char *data;
	unsigned length;

	[adaptor setDelegate:self];
	typesArray = [NSArray arrayWithCStringArray:[pasteboard types]];
	NSLog([typesArray description]);

    if ([pasteboard readType:NXAsciiPboardType data:&data length:&length] ||
		[pasteboard readType:NXRTFPboardType data:&data length:&length]) {
		[adaptor createNoteTitled:LOCALIZED_STRING(@"untitled", @"", @"")
			contents:[SlurpeeAdaptor stringByConvertingUNIXtoMac:
				[NSString stringWithCString:data]]
			font:[SlurpeeAdaptor newtonFontWithFamily:
				[[Preferences preferences] defaultFontFamily] face:0 
				size:[[Preferences preferences] defaultFontSize]]
			folder:[[Preferences preferences] defaultFolderForNotes]];
	}
	else
		*errorMessage = LOCALIZED_CSTRING(@"errBadNoteService", @"", @"");

	return self;
}

- serviceCreateNewtonOutlineFromPasteboard:(id)pasteboard
	userData:(const char *)userData 
	error:(char **)msg
{
	return self;
}

- serviceInstallNewtonPackageFromPasteboard:(id)pasteboard
	userData:(const char *)userData 
	error:(char **)msg
{
	return self;
}

- serviceExportFileToNotesFromPasteboard:(id)pasteboard
	userData:(const char *)userData 
	error:(char **)msg
{
	return self;
}

@end
