/*
 * SlurpeeAdaptor.h
 * Interface for a Newton Slurpee(tm) adaptor.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file Reference/License.rtf for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <dwy@ace.net>, 1997.
 */

@class NSArray;
@class TCStream;

@interface SlurpeeAdaptor:NSObject
{
	TCStream	*stream;
	id			delegate;

	unsigned	timeout;
}

/*" Font management "*/
+ (NSString *)newtonFontWithFamily:(NSString *)name face:(unsigned)face 
	size:(unsigned)size;

/*" UNIX to Macintosh text conversion "*/
+ (NSString *)stringByConvertingUNIXtoMac:(NSString *)originalString;

/*" Setting the unfiled folder name "*/
+ (void)setUnfiledFolderName:(NSString *)name;
+ (NSString *)unfiledFolderName;

/*" Creating adaptors "*/
+ adaptorWithStream:(TCStream *)newtonStream;
- initWithStream:(TCStream *)newtonStream;

/*" Timeouts "*/
- (unsigned)timeout;
- (void)setTimeout:(unsigned)value;

/*" Delegates "*/
- delegate;
- (void)setDelegate:anObject;

/*" Receiving "*/
- (NSString *)receiveTransmission;
- (void)dumpSoupNamed:(NSString *)name options:(NSString *)options
	formatting:(NSString *)formatting;

/*" Installing packages "*/
- (void)installPackageNamed:(NSString *)packageName data:(NSData *)data;

/*" Creating notes "*/
+ (NSString *)stringByJoiningNotesParagraphsInArray:(NSArray *)array;

- (void)createNoteTitled:(NSString *)title contents:(NSString *)contents
	font:(NSString *)font folder:(NSString *)folder;
- (void)createNoteTitled:(NSString *)title arrayOfParagraphs:(NSArray *)array;

- (void)createNoteWithContentsOfFile:(NSString *)filePath
	convertLineFeed:(BOOL)convertFlag
	font:(NSString *)font
	folder:(NSString *)folder;
- (void)createNoteWithContentsOfFile:(NSString *)filePath;

/*" Working with soups "*/
- (NSArray *)arrayOfSoupNames;
- (NSData *)soupNamed:(NSString *)soupName;

@end

@interface NSString (TCNSHexToBinaryConversion)

- (NSData *)dataByDecodingHex;

@end

/*" Methods implemented by the delegate and called during
	receiveTransmission "*/
@interface Object (SlurpeeAdaptorDelegate)

- (void)adaptorWillBeginTransfer:(SlurpeeAdaptor *)adaptor;
- (void)adaptor:(SlurpeeAdaptor *)adaptor transferInProgress:(NSData *)data;
- (void)adaptor:(SlurpeeAdaptor *)adaptor finishedTransfer:(NSString *)data;

@end

