#import <foundation/NSString.h>
#import <foundation/NSException.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

#import <TCKit/TCKit.h>

#import "SlurpeeAdaptor.h"

@implementation SlurpeeAdaptor

static NSString *unfiledFolderName = nil;

+ (NSString *)newtonFontWithFamily:(NSString *)name face:(unsigned)face 
	size:(unsigned)size
{
	return [NSString stringWithFormat:@"{family: '%@, face: %d, size: %d}",
		name, face, size];
}

+ adaptorWithStream:(TCStream *)newtonStream
{
	return [[[self alloc] initWithStream:newtonStream] autorelease];
}

+ (NSString *)stringByConvertingUNIXtoMac:(NSString *)originalString
{
	return [[originalString componentsSeparatedByString:@"\n"]
		componentsJoinedByString:@"\r\n"];
}

+ (void)setUnfiledFolderName:(NSString *)name
{
	[unfiledFolderName release];
	unfiledFolderName = [name copy];
}

+ (NSString *)unfiledFolderName
{
	return unfiledFolderName;
}

- init
{
	[super init];

	[NSException raise:@"SlurpeeAdaptorException"
		format:@"Adaptor needs stream, bare -init called"];

	return nil;
}

- initWithStream:(TCStream *)newtonStream
{
	[super init];

	stream = [newtonStream copy];
	[stream setCloseOnDealloc:NO];

	timeout = 30;

	return self;
}

- (unsigned)timeout
{
	return timeout;
}

- (void)setTimeout:(unsigned)value
{
	timeout = value;
}

- delegate
{
	return delegate;
}

- (void)setDelegate:anObject
{
	delegate = anObject;
}

- (void)dumpSoupNamed:(NSString *)name options:(NSString *)options
	formatting:(NSString *)formatting
{
	[stream writeString:[NSString stringWithFormat:
		LOCALIZED_STRING(@"genericCommandSpec", @"", @""),
			name, options, formatting]];
}

- (void)installPackageNamed:(NSString *)packageName data:(NSData *)data
{
	NSString *packageString = [NSString stringWithFormat:@"%@!\\\r\n%@\r\n",
		[packageName stringByPaddingToByteBoundary:4 padCharacter:@" "],
		[[[data stringByConvertingToHexEncodedASCII]
			componentsBrokenIntoPartsOfLength:72]
			componentsJoinedByString:@"\\\r\n"]];

	[stream writeString:[NSString stringWithFormat:
		LOCALIZED_STRING(@"packageInstallSpec", @"", @""),
		packageName, packageString]];
}

+ (NSString *)stringByJoiningNotesParagraphsInArray:(NSArray *)array
{
	return [array componentsJoinedByString:
		LOCALIZED_STRING(@"slurpeeParagraphDelimiter", @"\r\n-----\r\n", @"")];
}

- (void)createNoteTitled:(NSString *)title contents:(NSString *)contents
	font:(NSString *)font folder:(NSString *)folder
{
	NSString *noteSpec = [NSString stringWithFormat:
		LOCALIZED_STRING(@"notesEntrySpec", @"", @""),
		((folder != nil) ? ([folder isEqual:
			[SlurpeeAdaptor unfiledFolderName]] ? @"nil" : folder) : @"nil"),
		(font ? font : [SlurpeeAdaptor newtonFontWithFamily:@"espy" face:0 size:9]),
		(title ? title : LOCALIZED_STRING(@"untitled", @"Untitled", @"")),
		contents];

	[stream writeString:noteSpec];
}

- (void)createNoteTitled:(NSString *)title arrayOfParagraphs:(NSArray *)array
{
	[self createNoteTitled:title 
		contents:[SlurpeeAdaptor stringByJoiningNotesParagraphsInArray:array]
		font:nil folder:nil];
}

- (void)createNoteWithContentsOfFile:(NSString *)filePath
	convertLineFeed:(BOOL)convertFlag
	font:(NSString *)font
	folder:(NSString *)folder;
{
	NSString *dataString = [[[NSString alloc] initWithData:
			[NSData dataWithContentsOfFile:filePath]
		encoding:NSNEXTSTEPStringEncoding] autorelease];

	if (convertFlag)
		[self createNoteTitled:
				[[filePath componentsSeparatedByString:@"/"] lastObject]
			contents:[SlurpeeAdaptor stringByConvertingUNIXtoMac:dataString]
			font:font
			folder:folder];
	else
		[self createNoteTitled:[[filePath componentsSeparatedByString:@"/"]
			lastObject] contents:dataString font:font folder:folder];
}

- (void)createNoteWithContentsOfFile:(NSString *)filePath
{
	return [self createNoteWithContentsOfFile:filePath convertLineFeed:NO
		font:nil folder:nil];
}

- (NSString *)receiveTransmission
{
	NSMutableData *totalData = [NSMutableData new];
	NSString *dataString;

	if ([delegate respondsTo:@selector(adaptorWillBeginTransfer:)])
		[delegate adaptorWillBeginTransfer:self];

	do {
		NSData *tempData = [stream readWithTimeout:timeout];
		NSString *tempString;

		if ([tempData length] == 0)
			break;

		[totalData appendData:tempData];
		tempString = [[[NSString alloc] 
			initWithData:tempData encoding:NSASCIIStringEncoding] 
			autorelease];

		if ([delegate respondsTo:@selector(adaptor:transferInProgress:)])
			[delegate adaptor:self transferInProgress:totalData];

		if ([tempString hasSuffix:
			LOCALIZED_STRING(@"slurpeeTransmissionFooter", @"", @"")])
			break;
	} while(YES);

	dataString = [[[[NSString alloc] initWithData:totalData
			encoding:NSASCIIStringEncoding]
		autorelease] stringByRemovingSuffix:
			LOCALIZED_STRING(@"slurpeeTransmissionFooter", @"", @"")];

	if ([delegate respondsTo:@selector(adaptor:finishedTransfer:)])
		[delegate adaptor:self finishedTransfer:dataString];

	return dataString;
}

- (NSArray *)arrayOfSoupNames
{
	NSMutableArray *array;

	[stream writeString:LOCALIZED_STRING(@"packageListDumpSpec", @"", @"")];

	array = [[[self receiveTransmission]
		componentsSeparatedByString:@"\r\n"]
		mutableCopy];
	[array removeObjectsEqualTo:@""];
	return [array copy];
}

- (NSData *)soupNamed:(NSString *)soupName
{
	NSString *packageString;

	[stream writeString:[NSString stringWithFormat:
		LOCALIZED_STRING(@"packageDumpSpec", @"", @""), soupName]];

	packageString = [[[self receiveTransmission] componentsSeparatedByString:
			LOCALIZED_STRING(@"slurpeeBinaryHeaderDelimiter", @"", @"")]
		objectAtIndex:1];

	NSLog(@"processing..");
	packageString = [[packageString componentsSeparatedByString:
			LOCALIZED_STRING(@"slurpeeBinaryLineDelimiter", @"", @"")]
		componentsJoinedByString:@""];

#if 0
	[[packageString dataUsingEncoding:NSASCIIStringEncoding]
		writeToFile:@"/tmp/pdata.asc" atomically:NO];

	[[packageString dataByDecodingHex]
		 writeToFile:@"/tmp/pdata" atomically:NO];
#endif

	return [packageString dataByDecodingHex];
}

- (void)dealloc
{
	[stream release];
	[super dealloc];
}

@end

@implementation NSString (TCNSHexToBinaryConversion)

- (NSData *)dataByDecodingHex
{
	NSMutableData *myData = [NSMutableData dataWithLength:[self length]/2];
	char *dataPtr = [myData mutableBytes];
	const char *srcPtr = [self cString];
	int value;
	unsigned i;

	for (i = 0; i < [self length]; i += 2) {
		sscanf((srcPtr+i), "%02X", &value);
		dataPtr[i/2] = (char)value;
	}

	return [[myData copy] autorelease];
}

@end

