#import <appkit/appkit.h>

@class SlurpeeAdaptor;
@class NewtonController;

#define TCExportWillPrompt		0
#define TCExportWillConvert		1
#define TCExportWillNotConvert	2

@interface SlurpeeController:Object
{
	id		commandParameterForm;
	id		commandPanel;
	id		keyboardPanel;
	id		keyboardResponderView;
    id		packageListBrowser;
    id		packageListWindow;
	id		packageListTransferButton;
	id		packageListStatus;

	NSArray	*packageListArray;
}

- (SlurpeeAdaptor *)adaptorFromNewton:(NewtonController *)controller;
- (SlurpeeAdaptor *)adaptorFromCurrentNewton;

- (BOOL)newtonIsConnected;

- deliverCommand:sender;

- listPackages:sender;

- orderFrontCommandPanel:sender;
- orderFrontKeyboardPanel:sender;

- (unsigned)shouldConvertFileNamed:(NSString *)name;

- notesExportFile:sender;
- notesImportFile:sender;
- notesNew:sender;

- transferPackage:sender;

- browserAction:sender;

@end
