#import <TCKit/TCKit.h>

#import "AppController.h"
#import "PackageController.h"
#import "NewtonController.h"
#import "SlurpeeAdaptor.h"
#import "NoteController.h"

#import "TCKeyConsumerView.h"

@implementation TCKeyConsumerView

- (BOOL)acceptsFirstResponder
{
	return YES;
}

- becomeFirstResponder
{
	newtonStream = [[[appController newton] stream] retain];
	return self;
}

- (BOOL)performKeyEquivalent:(NXEvent *)theEvent
{
	char key;

	if (theEvent->data.key.charSet == NX_ASCIISET) {
		key = (char)theEvent->data.key.charCode;
		[newtonStream write:&key length:sizeof(char)];
		[newtonStream flush];
	}

	return YES;
}

- resignFirstResponder
{
	[newtonStream release];
	return self;
}

@end
