/*
 * TCNewtonPackage.h
 * Interface declaration for a Newton package object.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file doc/LICENSE for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <dwy@ace.net>, 1997.
 *         for NEXTSTEP 3.3, OpenStep ready.
 */

#import <foundation/NSObject.h>
#import <foundation/NSBundle.h>
#import <foundation/NSData.h>
#import <foundation/NSDate.h>
#import <foundation/NSException.h>

/*" Constants for NPHeader.flags "*/
#define TCNewtonPackageIsDispatchOnly		0x80000000
#define TCNewtonPackageIsCopyProtected		0x40000000
#define TCNewtonPackageIsUncompressed		0x10000000

/*" The InfoRef structure describes offsets into package data "*/
typedef union {
	struct _np_ref {
		unsigned short		offset;
		unsigned short		length;
	} ref;
	unsigned value;
} NPInfoRef;

#define NPInfoRefIsASCII		sizeof(char)
#define NPInfoRefIsUnicode		sizeof(unichar)

/*" The Newton uses an epoch of the first instant of Jan 1 1904.
 *  FoundationKit (and OpenStep) is the first instant of Jan 1 2001.
 * i Delta is -97 years, or 3058992000 seconds. 
 "*/
#define NEpochYearDelta					(1904.00-2001.00)

typedef struct {
	char		signature[8];
	char		reserved[4];
	unsigned	flags;
	unsigned	version;
	NPInfoRef	copyrightRef;
	NPInfoRef	nameRef;
	unsigned	size;
	unsigned	creationDateRep;
	char		moreReserved[4];
	char		yetMoreReserved[4];
	unsigned	headerSize;
	unsigned	numParts;
} NPHeader;

#define NPPartIsProtocol		0
#define NPPartIsFrames			1
#define NPPartIsRaw				2

#define NPPartIsAutoLoaded		0x00000010
#define NPPartIsAutoRemoved		0x00000020
#define NPPartIsCompressed		0x00000040
#define NPPartIsNotify			0x00000080

typedef struct {
	unsigned	dataStartOffset;
	unsigned	compressedSize;
	unsigned	uncompressedSize;
	char		partType[4];
	char		reserved[4];
	unsigned	partFlags;
	NPInfoRef	notificationMessage;
	NPInfoRef	compressor;
} NPPartHeader;

#define NEWTON_PACKAGE_MAGIC		"package0"

@interface TCNewtonPackage:NSObject
{
	NSData			   *packageData;
	NPHeader		   *packageHeader;
	NPPartHeader	  **packagePartHeaders;
	unichar			   *stringTable;
}

/*" Returns an autoreleased package "*/
+ packageWithContentsOfFile:(NSString *)fileName;
+ packageWithData:(NSData *)someData;

/*" Initializers "*/
- initWithContentsOfFile:(NSString *)fileName;

- initWithData:(NSData *)someData;
- initWithDataNoCopy:(NSData *)someData;

/*" Accessing the string table "*/
- (NPHeader *)headerStructure;
- (const unichar *)stringTable;
- (NSString *)stringWithInfoRef:(NPInfoRef)aRef type:(unsigned)refType;

/*" Accessors "*/
- (NSString *)packageSignature;

- (BOOL)isDispatchOnly;
- (BOOL)isCopyProtected;
- (BOOL)isCompressed;

- (NSString *)copyrightInfo;
- (NSString *)packageName;

- (unsigned)packageVersion;

- (NSDate *)creationDate;

- (unsigned)headerSize;
- (unsigned)partCount;

- (NSData *)packageData;

/*" Accessing part headers "*/
- (NPPartHeader *)partHeaderAtIndex:(unsigned)anIndex;

@end
