#import "../TCNewtonPackage.h"

#import <libc.h>

void main (int argc, char *argv[])
{
	TCNewtonPackage *package;
	unsigned i;

	if (argc < 2) {
		fprintf(stderr, "usage: npkginfo package\n");
		exit(-1);
	}

	package = [TCNewtonPackage packageWithContentsOfFile:
		[NSString stringWithCString:argv[1]]];

	printf("package %s:\n", argv[1]);

	printf("\tsignature %s\n", [[package packageSignature] cString]);

	printf("\tisDispatchOnly %s\n", [package isDispatchOnly] ? "YES" : "NO");
	printf("\tisCopyProtected %s\n", [package isCopyProtected] ? "YES" : "NO");
	printf("\tisCompressed %s\n", [package isCompressed] ? "YES" : "NO");

	printf("\tpackageVersion %d\n", [package packageVersion]);

	printf("\tcopyrightInfo %s\n", (char *)[[[package copyrightInfo]
		dataUsingEncoding:NSASCIIStringEncoding
		allowLossyConversion:YES] bytes]);
	printf("\tpackageName %s\n", (char *)[[[package packageName]
		dataUsingEncoding:NSASCIIStringEncoding
		allowLossyConversion:YES] bytes]);

	printf("\theaderSize %d\n", [package headerSize]);
	printf("\tcreationDate %s\n", 
		([package creationDate] != nil) ?
		[[[package creationDate] descriptionWithCalendarFormat:
			@"%A, %d-%b-%Y %I:%M:%S%p %Z" timeZone:
			[NSTimeZone defaultTimeZone]] cString] :
		"not set");
	printf("\tpartCount %d\n", [package partCount]);

	printf("\tpart info:\n");
	for(i = 0; i < [package partCount]; ++i) {
		NPPartHeader *p = [package partHeaderAtIndex:i];

		printf("\t\tdelta: %ld\n", (char *)p-(char *)[package headerStructure]);
		printf("\t\tdataStartOffset: %d\n", 
			NXSwapBigIntToHost(p->dataStartOffset));
		printf("\t\tcompressedSize: %d\n", 
			NXSwapBigIntToHost(p->compressedSize));
		printf("\t\tuncompressedSize: %d\n",
			NXSwapBigIntToHost(p->uncompressedSize));
		printf("\t\tpartType: %4s\n", p->partType);
		printf("\t\tnotificationMessage: %s\n",
			[[package stringWithInfoRef:p->notificationMessage
				type:NPInfoRefIsASCII] cString]);
		printf("\t\tcompressor: %s\n",
			[[package stringWithInfoRef:p->compressor
				type:NPInfoRefIsASCII] cString]);
	}
}
