//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//  $Id: Newton.H,v 1.13 1997/10/29 22:29:11 spoonman Exp $

#ifndef _NEWTON_H_

//
// BEGIN USER CONFIGURABLE SECTION
//

// use X-Modem protocol to install packages via YAPI
// #define NewtonYAPI 1

  // Any additional options desired for the commands below may be
  // added as long as they are consistant with the examples provied.
  // For example, the unixPRINT command could be "lpr -h" instead of
  // just "lpr".  The "Syntax" provided below is how the Newton object
  // calls the commands provided in the following #defines.  In the
  // examples below "tempfile" is created by the Newton object and
  // contains the output of the soups slurped from the serial line.

  // UNIX mail command
  //   Syntax:
  //     unixMAIL address unixMAILsubject "subject" < tempfile
  //     example: mail aehall@netcom.com -s "My email's subject" < tempfile
  //   or (see unixMAILsubject below)
  //     unixMAIL address < tempfile
  //     example: mail aehall@netcom.com < tempfile
#define unixMAIL   "mail"
  //   Comment out the following line if your system's mail command
  //   doesn't support sending a subject on the command line
#define unixMAILsubject "-s"

  // UNIX print command
  //   Syntax:
  //     unixPRINT < tempfile
  //     example: lpr < tempfile
#define unixPRINT  "lpr"

  // UNIX fax command
  //   Syntax:
  //     unixFAX < tempfile
  //     example: fax < tempfile
#define unixFAX "fax"

#ifdef NewtonYAPI
  // UNIX X-MODEM command
  //   Syntax:
  //   cat DEVICE | unixSX package > DEVICE
  //   example: cat /dev/newton | sx yapi.pkg > /dev/newton
#define unixSX "sx"
#endif

//
// END USER CONFIGURABLE SECTION
//


#include <stdio.h>
#include <string.h>
#include <stdbool.h>

// this is to access filedesc()
#define _STREAM_COMPAT
#include <SFile.h>

#define NewtonVERSION     "2.81"
#define NewtonTITLE       "Newton/UNIX Connection Library v" NewtonVERSION
#define NewtonCOPYRIGHT   "Copyright (C) 1995-1997  A. E. Hall"

// Default Newton Device
#define NewtonDEVICE      "/dev/newton"

#define NewtonEOF         EOF             // -1
#define NewtonOK          0
#define NewtonERROR       1
#define NewtonEOL         '\r'            // Newton's EOL character (^J)

#define SlurpeeBYE        "BYE!\n"        // Slurpee's Done
#define SlurpeeDUMP       "DUMP!\n"       // Slurpee's Dump
#define SlurpeeNoteDelim  "-----\n"       // Notes delimiter

  class Newton
    {
    private:
      SFile NewtonDevice;              // The Newton Device Itself!
      String NewtonDeviceName;         // The Newton Device (as in /dev/tty1)!
      int NewtonFD;                    // The Newton Device File Descriptor
      // the following variables need to go!!!
      // they are a result of quickly integrating lpkg code...
      FILE *NewtonFDS;
      // has to be a char because Newton Connection returns a signed
      // int and we need scount & rcount to be signed ints too (8 bits long)
      char scount, rcount;

      //
      // Methods in Newton.C
      //
      int setSerial(int, int, char, int); // Set up the serial port 

      //
      // Methods in Outbox.C
      //
      int ProcessOutbox(const int);    // Process the Outbox

      //
      // Methods in Inbox.C
      //
      int ProcessInbox(const int);     // Process the Inbox

    public:
      //
      // Methods in Newton.C
      //
      Newton();
      ~Newton();
      int Open(String, int, int, char, int);       // open Newton serial port
      int Open(const char *, int, int, char, int);
      int Close();                  // close Newton serial port
      int Flush();                  // flush Newton serial port 
      int Drain();                  // wait for Newton output
      int isOpen();                 // TRUE if Newton is open, else FALSE
      int isConnected();            // TRUE if Newton is connected to Slurpee
      int wakeUp();                 // Wake up Newton if it's asleep

      //
      // Methods in Read.C
      //
      int ReadChar(char &);         // read a character fro Newton
      int ReadLine(String &);       // read from Newton until NewtonEOL
      int ReadLine(char **);
      int ReadToFile(const String); // read from Newton to a file
      int ReadToFile(const char *);
      int ReadToFile(const FILE *);

      //
      // Methods in Write.C
      //
      int WriteChar(const char);                 // write a character to Newton
      int WriteString(const String);             // write a String to Newton
      int WriteString(const char *);             // write a string to Newton
      int WriteFromFile(const String, const bool); // write file to Newton
      int WriteFromFile(const char *, const bool);
      int WriteFromFile(const FILE *, const bool);

      //
      // Methods in Package.C
      //
#ifdef NewtonYAPI
      int LoadPackageXMODEM(const String); // load a package to Newton via YAPI
      int LoadPackageXMODEM(const char *);
#endif
      int LoadPackage(const String);             // load a package to Newton
      int LoadPackage(const char *); 
      int ReadFrame(char *);
      int SendFrame(char *, int);
      int SendLA(unsigned char, unsigned char);
      int SendData(char *, int);
      int ReceiveData(char *, int); 
      int WaitConnection();
      int SendDisconnect();


      //
      // Methods in NPP.C
      //
      String NewtPreProcessor(const String); // preprocess a Newt file
      String NewtPreProcessor(const char *);
      String NewtPreProcessor(const FILE *);

      //
      // Methods in Outbox.C
      //
      int PrintOutbox();
      int FaxOutbox();
      int BeamOutbox();
      int EmailOutbox(); 

      //
      // Methods in Inbox.C
      //
      int BeamInbox();
      int EnhancementInbox();
      int EmailInbox(); 

    };

#endif

