//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include "Newton.H"

char Write_C_rcsid[] = "$Id: Write.C,v 1.6 1997/09/13 15:39:21 spoonman Exp $";

// Write a character to the NewtonDevice
int Newton::WriteChar(const char letter)
  {
  String tmpString;

  tmpString = letter;
  if (tmpString == "\n")
    {
    tmpString = NewtonEOL;
    };
  NewtonDevice.write(tmpString, tmpString.length());
  Drain(); // wait for output to complete!
  return(NewtonOK);
  };

// Write a string to the NewtonDevice
int Newton::WriteString(const String string)
  {
  WriteString(string.chars());
  };

// Write a string to the NewtonDevice
int Newton::WriteString(const char *string)
  {
  int error;

  while (*string)
    {
    error = WriteChar(*string);
    string++;
    };
  return(NewtonOK);
  };

// Write from a File to the NewtonDevice
int Newton::WriteFromFile(const String FileName, const bool doNPP)
  {
  return(WriteFromFile(FileName.chars(), doNPP));
  };

// Write from a File to the NewtonDevice
int Newton::WriteFromFile(const char *FileName, const bool doNPP)
  {
  FILE *FilePointer;
  int ReturnCode;

  if (!strcmp(FileName,"-"))  // if user wants stdin
    {
    ReturnCode = WriteFromFile(stdin, doNPP);
    }
  else
    {
    if ((FilePointer=fopen(FileName, "r")) == NULL)
      {
      fprintf(stderr,"Newton: error reading file: %s\n",FileName);
      return(NewtonERROR);
      };
    ReturnCode = WriteFromFile(FilePointer, doNPP);
    fclose(FilePointer);
    };
  return(ReturnCode);
  };

// Write from FILE to the NewtonDevice
int Newton::WriteFromFile(const FILE *FilePointer, const bool doNPP)
  {
  String NPPFileName;
  char letter;

  if (doNPP == TRUE)
     {
     NPPFileName = NewtPreProcessor(FilePointer);
     WriteFromFile(NPPFileName, FALSE);
     unlink(NPPFileName.chars());
     }
  else
    {
    while ((letter=fgetc((FILE *)FilePointer)) != EOF)
      {
      WriteChar(letter);
      };
    };

  return(NewtonOK);
  };

