VERSION 5.00
Begin VB.Form RaySetup 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "EZ2TV"
   ClientHeight    =   4665
   ClientLeft      =   2115
   ClientTop       =   435
   ClientWidth     =   3555
   Icon            =   "RaySetup.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4665
   ScaleWidth      =   3555
   ShowInTaskbar   =   0   'False
   Begin VB.CheckBox chkColorBar 
      Caption         =   "Color Bar Select"
      Height          =   255
      Left            =   1800
      TabIndex        =   22
      Top             =   960
      Width           =   1695
   End
   Begin VB.CommandButton cmdHorizAdjust 
      Caption         =   "Horiz"
      Height          =   315
      Left            =   1845
      TabIndex        =   21
      Top             =   4200
      Width           =   690
   End
   Begin VB.CommandButton cmdVertAdjust 
      Caption         =   "Vert"
      Height          =   315
      Left            =   2760
      TabIndex        =   20
      Top             =   4200
      Width           =   690
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   240
      TabIndex        =   19
      Top             =   3720
      Width           =   1275
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   240
      TabIndex        =   18
      Top             =   3240
      Width           =   1275
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   240
      TabIndex        =   17
      Top             =   2760
      Width           =   1275
   End
   Begin VB.CheckBox chkBlanking 
      Caption         =   "Video Blank Select"
      Height          =   255
      Left            =   1800
      TabIndex        =   16
      Top             =   240
      Width           =   1770
   End
   Begin VB.Frame Frame1 
      Caption         =   "Blanking Color"
      Height          =   675
      Left            =   1785
      TabIndex        =   13
      Top             =   1275
      Width           =   1695
      Begin VB.OptionButton optBlankBlack 
         Caption         =   "Black"
         Height          =   255
         Left            =   945
         TabIndex        =   15
         Top             =   315
         Width           =   720
      End
      Begin VB.OptionButton optBlankBlue 
         Caption         =   "Blue"
         Height          =   255
         Left            =   120
         TabIndex        =   14
         Top             =   315
         Value           =   -1  'True
         Width           =   975
      End
   End
   Begin VB.CheckBox chkPhase 
      Caption         =   "Video Phase Select"
      Height          =   285
      Left            =   1800
      TabIndex        =   12
      Top             =   600
      Width           =   1695
   End
   Begin VB.CommandButton cmdAdvanced 
      Caption         =   "Advanced >>"
      Height          =   375
      Left            =   240
      TabIndex        =   11
      Top             =   4200
      Width           =   1275
   End
   Begin VB.Frame Frame6 
      Caption         =   "Standard"
      Height          =   645
      Left            =   1785
      TabIndex        =   8
      Top             =   2010
      Width           =   1695
      Begin VB.OptionButton optPAL 
         Caption         =   "PAL"
         Height          =   255
         Left            =   945
         TabIndex        =   10
         Top             =   315
         Width           =   660
      End
      Begin VB.OptionButton optNTSC 
         Caption         =   "NTSC"
         Height          =   255
         Left            =   105
         TabIndex        =   9
         Top             =   315
         Value           =   -1  'True
         Width           =   765
      End
   End
   Begin VB.CheckBox chkVGAOnly 
      Caption         =   "Display on VGA only, or"
      Height          =   495
      Left            =   210
      TabIndex        =   7
      Top             =   120
      Value           =   1  'Checked
      Width           =   1380
   End
   Begin VB.Frame frmOutputEnable 
      Caption         =   "Output Signal"
      Enabled         =   0   'False
      Height          =   855
      Left            =   210
      TabIndex        =   4
      Top             =   630
      Width           =   1275
      Begin VB.OptionButton optSVHSOut 
         Caption         =   "S-VHS"
         Enabled         =   0   'False
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   480
         Width           =   1095
      End
      Begin VB.OptionButton optCompOut 
         Caption         =   "Composite"
         Enabled         =   0   'False
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   240
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Filter Selection"
      Height          =   1095
      Left            =   240
      TabIndex        =   0
      Top             =   1560
      Width           =   1275
      Begin VB.OptionButton optFilterMax 
         Caption         =   "Maximum"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   720
         Width           =   1095
      End
      Begin VB.OptionButton optFilterMedium 
         Caption         =   "Medium"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   480
         Value           =   -1  'True
         Width           =   1095
      End
      Begin VB.OptionButton optFilterNone 
         Caption         =   "None"
         Height          =   255
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   975
      End
   End
   Begin VB.Shape shapeImage 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   885
      Left            =   2160
      Top             =   3060
      Width           =   990
   End
   Begin VB.Shape shapeScreen 
      FillColor       =   &H00C0C0C0&
      FillStyle       =   0  'Solid
      Height          =   1275
      Left            =   1965
      Top             =   2880
      Width           =   1380
   End
End
Attribute VB_Name = "RaySetup"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Const DisplayChoice = 42
Const SizeOfWord = 2

Const RayCmdBlankToggle = 1
Const RayCmdHShift = 3
Const RayCmdVShift = 2
Const RayCmdSignalNormal = 7
Const RayCmdSignalBlack = 4
Const RayCmdSignalBars = 6
Const RayCmdSignalRamp = 5
Const RayCmdStandardNTSC = 8
Const RayCmdStandardPAL = 9
Const RayCmdFilterToggle = 16
Const RayCmdCompToggle = 20
Const RayCmdSVHSToggle = 21
Const RayCmdPhaseToggle = 22
Const RayCmdResetToggle = 23
Const RayCmdPowerToggle = 24
Const RayCmdBlankBlack = 32
Const RayCmdBlankBlue = 33
Const RayCmdInit = 127

Const CompOut = 0
Const SVHSOut = 1

Public DisplayMode As Integer
Public advancedShowing As Boolean
Public UpdateCard As Boolean
Public curHorizValue As Integer
Public curHorizDirection As Integer
Public curVertValue As Integer
Public curVertDirection As Integer
Public curFilter As Integer

Private Declare Function ExtEscape Lib "GDI32" (ByVal hDC As Long, ByVal nEscape As Integer, ByVal nCount As Integer, lpInData As Any, ByVal cbOutput As Integer, lpOutData As Any) As Integer

Private Sub chkBlanking_Click()
    If UpdateCard = True Then
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdBlankToggle, 0&, 0&)
    End If
End Sub

Private Sub chkColorBar_Click()
    Dim i As Integer
    
    If chkColorBar.Value = 1 Then
        For i = 1 To 4 - curFilter
            result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdFilterToggle, 0&, 0&)
        Next i
    Else
        For i = 1 To curFilter
            result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdFilterToggle, 0&, 0&)
        Next i
    End If
End Sub

Private Sub chkPhase_Click()
    If UpdateCard = True Then
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdPhaseToggle, 0&, 0&)
    End If
End Sub

Private Sub chkVGAOnly_Click()
    If chkVGAOnly.Value = 1 Then
        frmOutputEnable.Enabled = False
        optCompOut.Enabled = False
        optSVHSOut.Enabled = False
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdResetToggle, 0&, 0&)
    Else
        frmOutputEnable.Enabled = True
        optCompOut.Enabled = True
        optSVHSOut.Enabled = True
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdInit, 0&, 0&)
        DisplayMode = CompOut
        optCompOut.Value = True
        optFilterMax.Value = True
        UpdateCard = False
        chkBlanking.Value = 0
        chkPhase.Value = 0
        UpdateCard = True
        curHorizValue = 0
        curHorizDirection = 8
        curVertValue = 0
        curVertDirection = 8
        shapeImage.Move shapeScreen.Left + 192, shapeScreen.Top + 192
    End If
End Sub

Private Sub cmdAdvanced_Click()
    If advancedShowing = True Then
        cmdAdvanced.Caption = "Advanced>>"
        RaySetup.Width = 1800
        advancedShowing = False
    Else
        cmdAdvanced.Caption = "<<Advanced"
        RaySetup.Width = 3765
        advancedShowing = True
    End If
End Sub

Private Sub cmdCancel_Click()
    ReadSettingsFromFile
    Me.Visible = False
End Sub

Private Sub cmdExit_Click()
    
    Dim nd As NOTIFYICONDATA
    Dim nRet As Integer

    nd.uID = 100
    nd.cbSize = Len(nd)
    nd.hwnd = frmPopUp.hwnd
    nd.uCallbackMessage = WM_USER + 1
    nRet = Shell_NotifyIconA(NIM_DELETE, nd)

    SaveSettingsToFile
    Unload RaySetup
    Unload frmPopUp
    End

End Sub

Private Sub cmdHorizAdjust_Click()
    If curHorizValue = 64 Then
        curHorizDirection = -8
    ElseIf curHorizValue = -64 Then
        curHorizDirection = 8
    End If
    curHorizValue = curHorizValue + curHorizDirection
    shapeImage.Move shapeScreen.Left + 192 + curHorizValue * 3
    result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdHShift, 0&, 0&)
End Sub

Private Sub cmdOK_Click()
    SaveSettingsToFile
    Me.Visible = False
End Sub


Private Sub cmdVertAdjust_Click()
    If curVertValue = 64 Then
        curVertDirection = -8
    ElseIf curVertValue = -64 Then
        curVertDirection = 8
    End If
    curVertValue = curVertValue + curVertDirection
    shapeImage.Move shapeImage.Left, shapeScreen.Top + 192 + curVertValue * 3
    result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdVShift, 0&, 0&)
End Sub

Private Sub Form_Load()
    Me.Width = 1800
    Me.Top = 0
    Me.Left = 0
    advancedShowing = False
    ReadSettingsFromFile
    curFilter = 1
    result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdResetToggle, 0&, 0&)
    result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdInit, 0&, 0&)
End Sub


Private Sub optBlankBlack_Click()
    result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdBlankBlack, 0&, 0&)
End Sub

Private Sub optBlankBlue_Click()
    result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdBlankBlue, 0&, 0&)
End Sub

Private Sub optCompOut_Click()
    If DisplayMode = SVHSOut Then
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdCompToggle, 0&, 0&)
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdSVHSToggle, 0&, 0&)
        DisplayMode = CompOut
    End If
End Sub

Private Sub optFilterMax_Click()
    Dim i As Integer
    Dim counter As Integer
    
    If chkColorBar.Value = 0 Then
        counter = 1 - curFilter
        If counter < 0 Then
            counter = counter + 4
        End If
        
        For i = 1 To counter
            result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdFilterToggle, 0&, 0&)
        Next i
    End If
    
    curFilter = 1
End Sub

Private Sub optFilterMedium_Click()
    Dim i As Integer
    Dim counter As Integer
    
    If chkColorBar.Value = 0 Then
        counter = 2 - curFilter
        If counter < 0 Then
            counter = counter + 4
        End If
        
        For i = 1 To counter
            result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdFilterToggle, 0&, 0&)
        Next i
    End If
    
    curFilter = 2
End Sub

Private Sub optFilterNone_Click()
    Dim i As Integer
    Dim counter As Integer
    
    If chkColorBar.Value = 0 Then
        counter = 3 - curFilter
        If counter < 0 Then
            counter = counter + 4
        End If
        
        For i = 1 To counter
            result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdFilterToggle, 0&, 0&)
        Next i
    End If
    
    curFilter = 3
End Sub

Private Sub optSVHSOut_Click()
    If DisplayMode = CompOut Then
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdCompToggle, 0&, 0&)
        result% = ExtEscape(Me.hDC, DisplayChoice, SizeOfWord, RayCmdSVHSToggle, 0&, 0&)
        DisplayMode = SVHSOut
    End If
End Sub

Private Sub scrollHorizontal_Change()
    shapeImage.Move shapeScreen.Left + 192 + scrollHorizontal.Value * 3
End Sub

Private Sub scrollVertical_Change()
    shapeImage.Move shapeImage.Left, shapeScreen.Top + 192 + scrollVertical.Value * 3
End Sub

Public Sub SaveSettingsToFile()
    SaveSetting "EZCard", "ActiveOut", "VGAOnly", chkVGAOnly.Value
    SaveSetting "EZCard", "ActiveOut", "CompOut", optCompOut.Value
    SaveSetting "EZCard", "ActiveOut", "SVHSOut", optSVHSOut.Value
    SaveSetting "EZCard", "Standard", "NTSC", optNTSC.Value
    SaveSetting "EZCard", "Standard", "PAL", optPAL.Value
    SaveSetting "EZCard", "Blanking", "BlankOn", chkBlanking.Value
    SaveSetting "EZCard", "Blanking", "Blue", optBlankBlue.Value
    SaveSetting "EZCard", "Blanking", "Black", optBlankBlack.Value
    SaveSetting "EZCard", "Filter", "None", optFilterNone.Value
    SaveSetting "EZCard", "Filter", "Medium", optFilterMedium.Value
    SaveSetting "EZCard", "Filter", "Maximum", optFilterMax.Value
    SaveSetting "EZCard", "Position", "Horizontal", curHorizValue
    SaveSetting "EZCard", "Position", "Vertical", curVertValue
    SaveSetting "EZCard", "Direction", "Horizontal", curHorizDirection
    SaveSetting "EZCard", "Direction", "Vertical", curVertDirection
    SaveSetting "EZCard", "Phase", "Phase", chkPhase.Value
    
End Sub

Public Sub ReadSettingsFromFile()
    chkVGAOnly.Value = GetSetting("EZCard", "ActiveOut", "VGAOnly", 1)
    optCompOut.Value = GetSetting("EZCard", "ActiveOut", "CompOut", True)
    optSVHSOut.Value = GetSetting("EZCard", "ActiveOut", "SVHSOut", False)
    optNTSC.Value = GetSetting("EZCard", "Standard", "NTSC", True)
    optPAL.Value = GetSetting("EZCard", "Standard", "PAL", False)
    chkBlanking.Value = GetSetting("EZCard", "Blanking", "BlankOn", 0)
    optBlankBlue.Value = GetSetting("EZCard", "Blanking", "Blue", True)
    optBlankBlack.Value = GetSetting("EZCard", "Blanking", "Black", False)
    optFilterNone.Value = GetSetting("EZCard", "Filter", "None", False)
    optFilterMedium.Value = GetSetting("EZCard", "Filter", "Medium", True)
    optFilterMax.Value = GetSetting("EZCard", "Filter", "Maximum", False)
    curHorizValue = GetSetting("EZCard", "Position", "Horizontal", 0)
    curHorizDirection = GetSetting("EZCard", "Direction", "Horizontal", 8)
    curVertValue = GetSetting("EZCard", "Position", "Vertical", 0)
    curVertDirection = GetSetting("EZCard", "Direction", "Vertical", 8)
    shapeImage.Move shapeScreen.Left + 192 + curHorizValue * 3, shapeScreen.Top + 192 + curVertValue * 3
    chkPhase.Value = GetSetting("EZCard", "Phase", "Phase", 0)
End Sub
