/******************************************************
 *
 * sup 0.1.0
 *
 * Extracts a package from a sloup-format binary package dump
 *
 * Useage: sup <infile> [<outfile>]
 *
 * Written 8Jun2000 by J.B. Hemlock
 * All rights reversed.
 *
 *******************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>

int main(int argc, char **argv)
{
	char *lpszInFile = NULL, *lpszOutFile = NULL;
	int fDynAlloc = 0;
	FILE *fpIn, *fpOut;
	char szLineBuf[1024];
#ifdef _DEBUG_LINE_READ
	char szOldLine[1024];
#endif
	char *lpszEndChar; /* for strtoul */
	unsigned char byOut;	/* Output byte */

	/* Sanity check */
	if (sizeof(unsigned char) != 1)
	{
		printf("Panic! sizeof(unsigned char) != 1. I'm outta here!\n");
		return 5;
	}

	/* Parse our args */
	switch (argc)
	{
	case 3:
		lpszOutFile = *(argv+2);
		/* Fall-through */
	case 2:
		lpszInFile = *(argv+1);
		break;
	default:
		printf("sup -- The sloup-format binary package extractor\nExtracts a Newton package from a sloup binary package dump\nWritten 8Jun2000 by J.B. Hemlock, all rights reversed.\n\nUseage: sup <infile> [<outfile>]\n");
		return 1;
		break;
	}

	/* If we don't have an out file, then generate an out file name from the in file. */
	if (!lpszOutFile)
	{
		lpszOutFile = (char *)malloc(sizeof(char)*(strlen(lpszInFile)+5));
		if (!lpszOutFile)
		{
			printf("sup error: out of memory!\n");
			return 2;
		}
		sprintf(lpszOutFile, "%s.pkg", lpszInFile);
		fDynAlloc = 1;
	}

	/* Open the in file and the out file and process... */
	fpIn = fopen(lpszInFile, "r");
	if (!fpIn)
	{
		printf("sup error: Couldn't open input file %s\n", lpszInFile);
		return 3;
	}
	fpOut = fopen(lpszOutFile, "wb");
	if (!fpOut)
	{
		printf("sup error: Couldn't open output file %s\n", lpszOutFile);
		fclose(fpIn);
		return 4;
	}
	/* Run through the input file. The first line is discarded. The last line is discarded.
	 * everything else is treated as encoded binary data (in hex). Read two characters, 
	 * translate them into a byte, and write it.
	 */
	fgets(szLineBuf, 1024, fpIn);
	/* First line is of the format "INTERCAL	!\". Discard it.
	 * Note: I should actually check it in the future, though... Not now.
	 */
	while (!feof(fpIn))
	{
		/* Get two characters and convert them to a byte */
#ifdef _DEBUG_LINE_READ
		sprintf(szOldLine, "%s", szLineBuf);
#endif
		fgets(szLineBuf, 3, fpIn);
		/* The file ends with "BYE!". If we've read in "BY", exit... */
		if (*szLineBuf == 'B' && *(szLineBuf+1) == 'Y')
			break;
		if ((*szLineBuf != '\\') && (*szLineBuf != '\n'))
		{
			byOut = (unsigned char)strtoul(szLineBuf, &lpszEndChar, 16);
			fwrite(&byOut, 1, 1, fpOut);
		}
	}

	/* Clean up */
	if (fDynAlloc)
		free(lpszOutFile);
	fclose(fpIn);
	fclose(fpOut);

	return 0;
}
