%define manualdir       /var/www/html/manual/%{name}

Name:       log4shib
Version:    1.0
Release:    1
Summary:    Log for C++, Shibboleth Edition
License:    LGPL
Group:      Development/Libraries
Vendor:     Internet2
URL:        http://shibboleth.internet2.edu/
Source:     http://shibboleth.internet2.edu/downloads/%name-%version.tar.gz
BuildRoot:  %_tmppath/%name-%version-root

%description
Log for C++ is a library of classes for flexible logging to files, syslog,
and other destinations. It is modeled after the Log for Java library and
stays as close to its API as is reasonable.

%package devel
Summary: development tools for Log for C++
Group: Development/Libraries
Requires: %name = %version

%description devel
The %name-devel package contains the static libraries and header files
needed for development with %name.

%package doc
Summary: HTML formatted API documention for Log for C++
Group: Development/Libraries
#can't set doc package to noarch without setting the others as well.
#BuildArch: noarch
%{!?_without_doxygenrpm:BuildRequires: doxygen}

%description doc
The %name-doc package contains HTML formatted API documention generated by
the popular doxygen documentation generation tool.

%prep
%setup -q

%build
%configure %{!?_without_doxygenrpm:--enable-doxygen} 
%{__make}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT
%{__make} DESTDIR=$RPM_BUILD_ROOT docdir=$RPM_BUILD_ROOT/%{manualdir} install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT

%ifnos solaris2.8 solaris2.9 solaris2.10
%post -p /sbin/ldconfig
%endif

%post devel
if test "x$RPM_INSTALL_PREFIX0" != "x" ; then
    %{__perl} -pi -e"s|^libdir='[^\']*'|libdir='$RPM_INSTALL_PREFIX0/lib'|" $RPM_INSTALL_PREFIX0/lib/liblog4shib.la
    %{__perl} -pi -e"s|^prefix=\"[^\"]*\"|prefix=\"$RPM_INSTALL_PREFIX0\"|" $RPM_INSTALL_PREFIX0/bin/log4shib-config
fi

%ifnos solaris2.8 solaris2.9 solaris2.10 
%postun -p /sbin/ldconfig
%endif

%files
%defattr(-,root,root,755)
%attr(755,root,root) %{_libdir}/lib*.so.*
%doc AUTHORS COPYING INSTALL NEWS README THANKS ChangeLog

%files devel
%defattr(-,root,root,755)
%{_includedir}
%{!?_without_doxygenrpm:%{_mandir}/*}
%attr(755,root,root) %{_bindir}/log4shib-config
%attr(755,root,root) %{_libdir}/*.so
%attr(644,root,root) %{_libdir}/*a
%attr(644,root,root) %{_libdir}/pkgconfig/log4shib.pc
%attr(644,root,root) %{_datadir}/aclocal/*.m4

%files doc
%defattr(-,root,root)
%{!?_without_doxygenrpm:%doc %{manualdir}}
