import assert from 'node:assert';

import { CharSet1 as CharSet } from '../src/charset.js';
// import { CharSet2 as CharSet } from '../src/charset.js';
// import { CharSet3 as CharSet } from '../src/charset.js';

describe('CharSet', function() {

    // Testing strategy
    //
    // CharSet()
    //   only one test case
    // size()
    //   partition on size: 0, 1, n
    // contains(e)
    //   partition on size: 0, 1, n
    //   partition on e present or not
    // add(e)/remove(e):
    //   partition on size before: 0, 1, n
    //   partition on size after: 0, 1, n
    //   partition on e present or not
    //


    it('should handle empty', function() {
        const cs: CharSet = new CharSet();
        assert.strictEqual(cs.size(), 0);
        assert.strictEqual(cs.contains('z'), false);
    });

    it('should handle a singleton set', function() {
        const cs: CharSet = new CharSet();
        cs.add('b'); // cs is now {b}
        assert.strictEqual(1, cs.size());
        assert.strictEqual(true, cs.contains('b'));
        assert.strictEqual(false, cs.contains('z'));
    });

    it('should handle redundant add', function() {
        const cs: CharSet = new CharSet();
        cs.add('b'); // cs is now {b}
        cs.add('b'); // cs is still {b}
        assert.strictEqual(1, cs.size());
        assert.strictEqual(true, cs.contains('b'));
        assert.strictEqual(false, cs.contains('z'));
    });

    it('should handle a two-element set', function() {
        const cs: CharSet = new CharSet();
        cs.add('b'); // cs is now {b}
        cs.add('c'); // cs is now {b, c}
        assert.strictEqual(2, cs.size());
        assert.strictEqual(true, cs.contains('b'));
        assert.strictEqual(true, cs.contains('c'));
        assert.strictEqual(false, cs.contains('y'));
    });

    it('should handle a three-element set', function() {
        const cs: CharSet = new CharSet();
        cs.add('b'); // cs is now {b}
        cs.add('c'); // cs is now {b, c}
        cs.add('d'); // cs is now {b, c, d}
        assert.strictEqual(3, cs.size());
        assert.strictEqual(true, cs.contains('b'));
        assert.strictEqual(true, cs.contains('c'));
        assert.strictEqual(true, cs.contains('d'));
        assert.strictEqual(false, cs.contains('x'));
    });

    it('should handle removing from a singleton set', function() {
        const cs: CharSet = new CharSet();
        cs.add('b'); // cs is now {b}
        cs.remove('b'); // cs is now {}
        assert.strictEqual(0, cs.size());
        assert.strictEqual(false, cs.contains('b'));
        assert.strictEqual(false, cs.contains('z'));
    });
    
    // TODO additional tests to cover all partitions of add() and remove()
    
});

