;; challenge-wrap.lisp,v 1.10 2003/07/16 18:45:03 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   "config" 
		   "environment"
		   "myrobots"
		   "ipc-functions"
		   "pprint-parse"
		   ))

(in-package nlp)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (cl-user::confirm-modules "nlp/proteus/basics/foreach"
			    "nlp/funtran/qx"
			    ))

(defun init-interrob (args)
  (set-cmdargs args)

  (setq *robots-home* (or (getenv "ROBOTS_HOME")
			  ""))
  (setq *robots-data-home* (concatenate
			    'string (or (getenv "ROBOTS_DATA_HOME") 
					"data") "/"))
  (setq *robot-name* (getenv "ROBOT_NAME"))

  (set-config)
  (my-init-spatial)
  )

(defun load-interrob (args)
  (init-interrob args)
  (load-challenge)
  (load "data/referents")
  (setf *gesture-init* t))

(defun run-interrob (args &optional form)
  (let ((*package* (find-package "NLP")))
    
    ;;(invoke-debugger "???")
    (init-interrob args)
    (cond ((not *just-make*)
	   (cond (*strict-02*
		  (trace-all *commands*)
		  (trace-all *foreign-calls*)))
	   
	   (dribble "interrob.log")
	   (eval form)
	   (run-loop))
	  (t (bye)))))

(defun compile-interrob (args)
  (let ((*package* (find-package "NLP")))
    (trace load-interrob)
    (load-interrob args)
    #+allegro(excl:dumplisp :name (concatenate
				   'string "bin/" (getenv "THIS_OS")
				   "/interrob.dxl"))
    (bye)
    ))



