;; config.lisp,v 1.6 2003/07/16 18:45:04 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
	   (if (not (fboundp 'confirm-modules))
	       (load "general/modules"))
	   (confirm-modules "packages"
			    ))

(in-package nlp)

(defparameter *cmdargs* nil)

(defun set-cmdargs (args)
  (setq *cmdargs* (copy-tree args)))

(defparameter *referents-file* "/referents.lisp")
(defparameter *function-redefs* nil)	;TODO an oversight?

(defparameter *mmi* t)
(defparameter *mmi-just-warn?* t);nil)
(defparameter *strict-02* nil)
(defparameter *just-make* nil)

(defparameter *90-degrees* (/ pi 2.0))
(defparameter *-90-degrees* (/ pi -2.0))

(defparameter *error-on-parser-answer* nil)

(defparameter *check-init* nil)		;as in local demo
(defparameter *demand-ipc* t)		;NIL in standalone.lisp

(defparameter *talkative* nil)		; in robotalk.lisp

(defun set-config ()
  (setq *just-make* nil)
  (cond ((member 'cl-user::-mmi *cmdargs*)
	 (setq *mmi-just-warn?* t)
	 (setq *mmi* nil))
	((member 'cl-user::+strict-02 *cmdargs*)
	 (setq *strict-02* t)
	 (setq *error-on-parser-answer* t))
	((member 'cl-user::+make *cmdargs*)
	 (setq *just-make* t))
	))

(defun make-only-p () (member 'cl-user::+make-only *cmdargs*))
