;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THIS IS THE REFERENTS FILE THAT IS BEING LOADED IN THE DEVELOPMENT
;;;; ENVIRONMENT.  DP 5/12/03

(in-package nlp)

(setq *objlist* nil *classlist* nil)

(setq *verb-slot-mappings* nil)

(setq *make-all-objs* t)

;;; Syntax:

;;; (MAKEOBJ OBJNAME CLASSES SPEC-WORDS (:ROLE { CLASSES | NAMES } )* )

;;; OBJNAME is the name of an entity
;;; CLASSES is its TINSEL semantic class (one or more)
;;; SPEC-WORDS is one or more of either (1) pronoun specifier (me, you) or
;;;     (2) permissible left noun modifiers
;;; :ROLE is a TINSEL role followed either by one or more semantic classes
;;;     or entity names (strings)

;;; If AN-STG nouns are not being interpreted by TINSEL they should be
;;; specified in SPEC-WORDS, otherwise as :ROLE arguments.

(makeobj r-observer r-observer (i me we))
(makeobj coyote system (you yourself coyote))
(makeobj roadrunner system (you yourself roadrunner))
(makeobj wolverine system (you yourself wolverine))
(makeobj mystique system (you yourself mystique))
(makeobj nightcrawler system (you yourself nightcrawler))
(makeobj magneto system (you yourself magneto))

(setq *you* '(george grace coyote roadrunner wolverine mystique nightcrawler magneto))

;; DP 9/8/99
;;  *self* gives the semantics the identity of the machine
;; that is being spoken to.  It
;; gives the individual robot an identity of sorts so
;; that it can act on only those commands that are directed
;; to it and not on any others.  In the case of plural
;; addressees, such as "robots", the list of addressees
;; contains the name of the robot and it therefore
;; can operate on commands given to several robots

(setq *self* (read-from-string (or (if (boundp '*robot-name*)
				       *robot-name*)
				   (format nil "~A"
					   (NLP::getenv "ROBOT_NAME")))))

;; the following declarations are added to give the sense of "other"
;; DP 11/22/99
(setf *listified-self* (cons *self* nil))
(setf *others* (set-difference *you* *listified-self*))

(makeobj left left left :relative-to (r-observer system thing))
(makeobj right right right :relative-to (r-observer system thing))

(makeobj on           on           on)
(makeobj off          off          off)
(makeobj here         here         here)
(makeobj there        there        there)
(makeobj around       around       around)
(makeobj back         back         back)
(makeobj down         down         down)
(makeobj up           up           up)
(makeobj over         over         over)
(makeobj forward      forward      forward)
(makeobj far          far          far)
(makeobj away         away         away)
;;(makeobj behind       behind       behind)
;;(makeobj in-front-of  in-front-of  in-front-of)
;(makeobj forward-time forward-time (forward forward-time))
;(makeobj backward-time backward-time (back backward-time))
;(makeobj time-direction time-direction time)
(makeobj map          map           nil)
(makeobj door         door          nil)

;; in trying to solve the BAFFLING "No such NIL exists" problem,
;; I still can't figure out whether a nil in the third slot is the culprit
;; or not.  Both table and pillar, for example, with different 3rd slots
;; act identically--SOMETIMES.  DP 5/15/03
(cond (*make-all-objs*
       (makeobj conference conference conference)
       (makeobj breakfast breakfast breakfast)
       (makeobj lunch lunch lunch)
       (makeobj dinner dinner dinner)
       (makeobj supper supper supper)
       (makeobj worm worm worm)
       (makeobj burrito burrito burrito)
       (makeobj taco taco taco)
       (makeobj tamale tamale tamale)
       (makeobj enchilada enchilada enchilada)
       (makeobj mexican-food mexican-food mexican-food);SCT->;
       (makeobj lobby lobby lobby)
       (makeobj query-mode query-mode query-mode)
       (makeobj steered-mode steered-mode steered-mode)
       (makeobj scripted-mode scripted-mode scripted-mode)
       (makeobj it  it it)
       (makeobj sign sign sign)
       (makeobj direct       direct        direct)
       (makeobj thing        thing         thing)
       (makeobj dennis       system        (you yourself dennis))
       (makeobj alan         system        (you yourself alan))
       (makeobj done         done          done)
       (makeobj finished     finished      finished)
       (makeobj open         open          open)
       (makeobj closed       closed        closed)
       (makeobj speed speed nil :theme system)
       (makeobj wind-speed wind-speed nil :theme system)
       (makeobj c-name c-name nil :relative-to system)
       (makeobj available available available)
       (makeobj hungry hungry hungry)
       (makeobj badge badge badge :relative-to (system r-observer))
       (makeobj CD CD CD)
       (makeobj disc disc disc :of object)
       (makeobj conference-proceedings conference-proceedings conference-proceedings)
       (makeobj conference-proceedings conference-proceedings conference-proceedings)
       (makeobj elevator-button elevator-button elevator-button)
;;       (makeobj time time time) ;SCT->;;
       (makeobj the-time-now c-time c-time)
       ;;       (makeobj favorite-topic c-topic c-topic) ;SCT
       (makeobj copy copy copy :of object)
       (makeobj hard-copy hard-copy hard-copy :of object)
       (makeobj paper-copy paper-copy paper-copy :of object)
       (makeobj electronic-copy electronic-copy electronic-copy :of object)
       (makeobj disc-version disc-version disc-version :of object)
       (makeobj electronic-version electronic-version electronic-version :of object)
       (makeobj talk  talk talk :relative-to (system))
       (makeobj c-talk c-talk c-talk :relative-to (system))
       (makeobj presentation presentation presentation :relative-to (system))
       (makeobj huitzuco-hall huitzuco-hall huitzuco-hall)
       (makeobj mezcala-hall mezcala-hall mexcala-hall)
       (makeobj olinala-hall olinala-hall olinala-hall)
       (makeobj cholula-hall cholula-hall cholula-hall)
       (makeobj chiceniza-hall chicheniza-hall chiceniza-hall)
       (makeobj teotihuacan-ballroom teotihuacan-ballroom teotihuacan-ballroom)
       (makeobj walmarts walmarts walmarts)
       (makeobj la-quebrada la-quebrada la-quebrada)
       (makeobj beach beach beach)
       (makeobj cliff-divers cliff-divers cliff-divers)
       (makeobj diver diver diver)
       
       (makeobj room  room nil :id (FIXNUM &))
       (makeobj end-of-sequence end-of-sequence  state)
       (makeobj object-gap   object-gap object-gap)
       (makeobj upstairs     upstairs      upstairs)
       (makeobj downstairs   downstairs    downstairs)
       (makeobj stairs       stairs        stairs)
       (makeobj robot        robot         robot)
       (makeobj object       object        object)
       (makeobj chair        chair         nil)
       (makeobj table        table         nil)
       (makeobj pillar       pillar        pillar)
       (makeobj box          box           nil)
       (makeobj computer     computer      nil)
       (makeobj tequila tequila tequila)
       (makeobj toy toy toy)
       (makeobj hall hall hall)
       (makeobj hallway hallway hallway)
       (makeobj elevator elevator elevator)
       (makeobj elevator-door elevator-door elevator-door)
       (makeobj elevator-doors elevator-doors elevator-doors)
       (makeobj assembly-level assembly-level nil)
       (makeobj floor-location floor-location floor-location)
       (makeobj ground-floor ground-floor floor-location)
       (makeobj ground-level ground-level location)
       (makeobj first-floor first-floor location)
       (makeobj first-level first-level location)
       (makeobj second-floor second-floor location)
       (makeobj second-level second-level location)
       (makeobj third-floor third-floor location)
       (makeobj third-level third-level location)
       (makeobj fourth-floor fourth-floor location)
       (makeobj fourth-level fourth-level location)
       (makeobj grace system (you yourself grace))
       (makeobj |Grace| c-name c-name)	;SCT
       ;;       (setf (get 'grace :relative-to)  ;SCT
       ;;	     c-name system))
       (makeobj george  system (you yourself george))
       (makeobj exhibit-hall exhibit-hall exhibit-hall )
;;     (makeobj desk        desk          desk  :relative-to system)
       (makeobj registration-area registration-area registration-area)
       (makeobj registration-line registration-line registration-line)
       (makeobj center center center :relative-to object)
       (makeobj front front front :relative-to object)
       (makeobj registration-desk   registration-desk   registration-desk)
       (makeobj escalator   escalator   excalator)
;;       ))

(makeobj area	    area          nil)
(makeobj region       region        nil)
(makeobj perimeter    perimeter     nil)
(makeobj way          way           way) ;SCT deleted duplicate
(makeobj path         path          nil)
(makeobj wind         wind          nil)
(makeobj weather      weather       nil :relative-to (location))
(makeobj value        value         nil)

(makeobj WASHINGTON-DC washington-dc #|town|#  (washington-dc) :name "Washington DC")
(makeobj WASHINGTON-STATE washington-state  (washington-state) :name "Washington state") ;SCT
(makeobj ANCHORAGE town  (anchorage) :name "Anchorage")
(makeobj ATLANTA town  (atlanta) :name "Atlanta")
(makeobj BOSTON town  (boston) :name "Boston")
(makeobj CHICAGO town  (chicago) :name "Chicago")
(makeobj DALLAS town  (dallas) :name "Dallas")
(makeobj DENVER town (denver) :name "Denver")
(makeobj HONOLULU town  (honolulu) :name "Honolulu")
(makeobj HOUSTON town  (houston) :name "Houston")
(makeobj LOS-ANGELES town (los-angeles) :name "Los Angeles")
(makeobj MIAMI town  (miami) :name "Miami")
(makeobj NEW-YORK town    (new-york) :name "New York")
(makeobj NEW-YORK-CITY town (new-york-city) :name "New York City")
(makeobj SAN-FRANCISCO town  (san-francisco) :name "San Francisco")

(makeobj ACAPULCO town (acapulco) :name "Acapulco")
(makeobj ANTARCTICA country    (antarctica) :name "Antarctica")
(makeobj ATHENS town    (athens) :name "Athens")
(makeobj BAGHDAD town    (baghdad) :name "Baghdad")
(makeobj BEIJING town    (beijing) :name "Beijing")
(makeobj BERLIN town    (berlin) :name "Berlin")
(makeobj BOMBAY town    (bombay) :name "Bombay")
(makeobj CAPETOWN town  (capetown) :name "Capetown")
(makeobj HONG-KONG town    (hong-kong) :name "Hong Kong")
(makeobj ISLAMABAD town    (islamabad) :name "Islamabad")
(makeobj JERUSALEM town    (jerusalem) :name "Jerusalem")
(makeobj KABUL town  (kabul) :name "Kabul")
(makeobj KUWAIT country    (kuwait) :name "Kuwait")
(makeobj KUWAIT-CITY town  (kuwait-city) :name "Kuwait City")
(makeobj LONDON town    (london) :name "London")
(makeobj MADRID town (madrid) :name "Madrid")
(makeobj MEXICO-CITY town (mexico-city) :name "Mexico City")
(makeobj MEXICO country (MEXICO) :name "Mexico")
(makeobj MONTREAL town  (montreal) :name "Montreal")
(makeobj MOSCOW town    (moscow) :name "Moscow")
(makeobj PARIS town    (paris) :name "Paris")
(makeobj REYKJAVIK town (reykjavik) :name "Reykjavik" )
(makeobj ROME town (rome) :name "Rome")
(makeobj SYDNEY town (sydney) :name "Sydney")
(makeobj TOKYO town   (tokyo) :name "Tokyo")
(makeobj TORONTO town    (toronto) :name "Toronto")
(makeobj WILLIAMS-FIELD town    (williams-field) :name "Antarctica (Williams Field)")
(makeobj UNITED-STATES country (united-states) :name "United States")
(makeobj ENGLAND country (england) :name "England")
(makeobj FRANCE country (france) :name "France")
(makeobj GERMANY country (germany) :name "Germany") 
(makeobj ITALY country (italy) :name "Italy")
(makeobj CENTRAL-AMERICA country (central-america) :name "Central America") ;; okay, this is wrong, but it's easier
(makeobj SOUTH-AMERICA country (south-america) :name "South America") ;; yes, I know!
(makeobj SPAIN country (spain) :name "Spain") 
(makeobj JAPAN country (japan) :name "Japan") 
(makeobj CANADA country (canada) :name "Canada")
(makeobj CHINA country (china) :name "China")
(makeobj AUSTRALIA country (australia) :name "Australia")
(makeobj INDIA country (india) :name "India")
(makeobj ISRAEL country (israel) :name "Israel")
(makeobj GREECE country (greece) :name "Greece")
(makeobj AFRICA country (africa) :name "Africa")
(makeobj SOUTH-AFRICA country (south-africa) :name "South Africa")
(makeobj KOREA country (korea) :name "Korea")
(makeobj RUSSIA country (russia) :name "Russia")
(makeobj POLAND country (poland) :name "Poland")
(makeobj BRAZIL country (brazil) :name "Brazil")
(makeobj ARGENTINA country (argentina) :name "Argentina")
(makeobj PERU country (peru) :name "Peru")
(makeobj VENEZUELA country (venezuela) :name "Venezuela")
(makeobj ECUADOR country (ecuador) :name "Ecuador")
(makeobj PARAGUAY country (paraguay) :name "Paraguay")
(makeobj COLOMBIA country (colomia) :name "Colombia")
(makeobj CHILE country (chile) :name "Chile")


(makeobj label        label        nil)
(makeobj waypoint-0 waypoint   nil :id 0)
(makeobj waypoint-1 waypoint   nil :id 1)
(makeobj waypoint-2 waypoint   nil :id 2)
(makeobj waypoint-3 waypoint   nil :id 3)
(makeobj waypoint-4 waypoint   nil :id 4)
(makeobj waypoint-gesture waypoint-gesture nil)
(makeobj door-gesture door-gesture nil)
(makeobj chair-gesture chair-gesture nil)
;;(makeobj area-gesture area-gesture nil)
;;(makeobj region-gesture region-gesture nil)
(makeobj path-gesture path-gesture nil)
(makeobj attention    attention     nil)
(makeobj at-ease      at-ease       at-ease)
(makeobj goodbye  goodbye  goodbye)
(makeobj hello    hello    hello)
(makeobj degree       degree       nil)
(makeobj inch         inch         nil)
(makeobj home         home         home)
(makeobj direction    direction    nil)
(makeobj waypoint     waypoint     nil)
(makeobj opposite    loc-direction    opposite)
(makeobj nearest         waypoint    nearest)
(makeobj closest         waypoint    closest)
;(makeobj actions      do-action    nil)       ; what do I do now
;(makeobj time         time         now)
(makeobj me           me           nil)
;(makeobj beginning    beginning    nil  :theme system)
;(makeobj time-end     time-end     nil  :theme system)
;(makeobj rotation     rotate       nil)
(makeobj location      loc-direction  nil)
(makeobj complete     complete   complete)
(makeobj completely    completely   nil)
;;(makeobj c-name           c-name           nil)
;(makeobj speed          speed          simulation :theme system)
;(makeobj designation    designation    nil)
;(makeobj type           type           platform)
;(makeobj classification classification nil)
;(makeobj heading        heading        nil)

;(makeobj slower         rel-speed      slower)
;(makeobj faster         rel-speed      faster)


(makeobj gas thing nil)
(makeobj tear-gas tear-gas nil)
(makeobj nerve-gas nerve-gas nil)
(makeobj mustard-gas mustard-gas nil)
(makeobj c-s-gas c-s-gas nil)
(makeobj oxygen oxygen nil)

(makeobj chemical thing nil)
(makeobj sensor          thing      nil :relative-to (system))
(makeobj gas-sensor      gas-sensor      nil :relative-to (system))
(makeobj chemical-sensor chemical-sensor   nil :relative-to (system))
))
;(setf (get 'type           'collective) t)
;(setf (get 'speed          'collective) t)
;(setf (get 'designation    'collective) t)
;(setf (get 'heading        'collective) t)
;(setf (get 'classification 'collective) t)

;(setf (get 'name           'collective) t)

(setf (get 'gas 'collective) t)
