;robotreferents.lisp,v 1.1.1.1 2003/05/16 16:20:28 thomas Exp
(setq *objlist* nil *classlist* nil)

(setq *verb-slot-mappings* nil)

;;; Syntax:

;;; (MAKEOBJ OBJNAME CLASSES SPEC-WORDS (:ROLE { CLASSES | NAMES } )* )

;;; OBJNAME is the name of an entity
;;; CLASSES is its TINSEL semantic class (one or more)
;;; SPEC-WORDS is one or more of either (1) pronoun specifier (me, you) or
;;;     (2) permissible left noun modifiers
;;; :ROLE is a TINSEL role followed either by one or more semantic classes
;;;     or entity names (strings)

;;; If AN-STG nouns are not being interpreted by TINSEL they should be
;;; specified in SPEC-WORDS, otherwise as :ROLE arguments.
(makeobj query-mode query-mode query-mode)
(makeobj scripted-mode scripted-mode scripted-mode)
(makeobj steered-mode steered-mode steered-mode)
(makeobj end-of-sequence end-of-sequence end-of-sequence)
(makeobj object-gap object-gap object-gap)
(makeobj r-observer r-observer (i me))
(makeobj coyote system (you yourself coyote))
(makeobj grace system (you yourself grace))
(makeobj dennis system (you yourself dennis))
(makeobj conference-attendee system (you yourself conference-attendee))
(makeobj roadrunner system (you yourself roadrunner))
(makeobj wolverine system (you yourself wolverine))
(makeobj mystique system (you yourself mystique))
(makeobj nightcrawler system (you yourself nightcrawler))
(makeobj magneto system (you yourself magneto))


(setq *you* '(coyote roadrunner wolverine mystique nightcrawler magneto grace dennis conference-attendee))

;; DP 9/8/99
;;  *self* gives the semantics the identity of the machine
;; that is being spoken to.  It
;; gives the individual robot an identity of sorts so
;; that it can act on only those commands that are directed
;; to it and not on any others.  In the case of plural
;; addressees, such as "robots", the list of addressees
;; contains the name of the robot and it therefore
;; can operate on commands given to several robots
(setq *self* (read-from-string (format nil "~A" (NLP::getenv "ROBOT_NAME"))))


;; the following declarations are added to give the sense of "other"
;; DP 11/22/99
(setf *listified-self* (cons *self* nil))
(setf *others* (set-difference *you* *listified-self*))

(makeobj sign sign sign)
(makeobj left left left :relative-to (r-observer system thing))
(makeobj right right right :relative-to (r-observer system thing))
(makeobj front front front :relative-to (object))
(makeobj center center center :relative-to (object))

(makeobj on           on           on)
(makeobj in           in           in)
(makeobj off          off          off)
(makeobj here         here         here)
(makeobj there        there        there)
(makeobj done         done         done)
(makeobj finished     finished     finished)
(makeobj around       around       around)
(makeobj back         back         back)
(makeobj down         down         down)
(makeobj up           up           up)
(makeobj downstairs  downstairs    downstairs)
(makeobj upstairs    upstairs      upstairs)
(makeobj over         over         over)
(makeobj forward      forward      forward)
(makeobj far          far          far)
(makeobj away         away         away)
(makeobj halfway     halfway       halfway)
;;(makeobj behind       behind       behind)
;;(makeobj in-front-of  in-front-of  in-front-of)
;(makeobj forward-time forward-time (forward forward-time))
;(makeobj backward-time backward-time (back backward-time))
;(makeobj time-direction time-direction time)
(makeobj registration-desk registration-desk nil)
(makeobj registration-area registration-area nil)
(makeobj registration-line registration-line nil)
(makeobj desk desk nil)
(makeobj exhibit-hall exhibit-hall nil)
(makeobj button button nil)
(makeobj elevator-button elevator-button nil)
(makeobj hall hall nil)
(makeobj hallway hallway nil)
(makeobj map          map           nil)
(makeobj door         door          nil)
;;(makeobj chair        chair         nil)
;;(makeobj table        table         nil)
;;(makeobj pillar       pillar        nil)
;;(makeobj box          box           nil)
;;(makeobj computer     computer      nil)
(makeobj floor        floor         nil)
(makeobj level        level         nil)
(makeobj first-floor first-floor nil)
(makeobj first-level first-level nil)
(makeobj second-floor second-floor nil)
(makeobj second-level second-level nil)
(makeobj third-floor third-floor nil)
(makeobj third-level third-level nil)
(makeobj fourth-floor fourth-floor nil)
(makeobj fourth-level fourth-level nil)
(makeobj ground-floor ground-floor  nil)
(makeobj ground-level ground-level nil)
(makeobj assembly-level assembly-level nil)
(makeobj street-level street-level nil)
(makeobj banquet-level banquet-level nil)
(makeobj restaurant-level restaurant-level nil)
(makeobj lobby lobby nil)
(makeobj elevator elevator nil)
(makeobj elevator-door elevator-door nil)
(makeobj elevator-doors elevator-doors nil)
(makeobj escalator escalator nil)
(makeobj stairs stairs nil)
(makeobj area	    area          nil)
(makeobj region       region        nil)
(makeobj perimeter    perimeter     nil)
(makeobj way          way           nil)
(makeobj path         path          nil)
(makeobj wind         wind          nil)
(makeobj wind-speed   wind-speed    nil)
(makeobj speed        speed         nil)
;(makeobj object       object       nil)
(makeobj label        label        nil)
(makeobj waypoint-0 waypoint   nil :id 0)
(makeobj waypoint-1 waypoint   nil :id 1)
(makeobj waypoint-2 waypoint   nil :id 2)
(makeobj waypoint-3 waypoint   nil :id 3)
(makeobj waypoint-4 waypoint   nil :id 4)
(makeobj waypoint-gesture waypoint-gesture nil)
(makeobj door-gesture door-gesture nil)
(makeobj chair-gesture chair-gesture nil)
;;(makeobj area-gesture area-gesture nil)
;;(makeobj region-gesture region-gesture nil)
(makeobj path-gesture path-gesture nil)
(makeobj attention    attention     nil)
(makeobj at-ease      at-ease       at-ease)
(makeobj goodbye  goodbye  goodbye)
(makeobj hello    hello    hello)
(makeobj degree       degree       nil)
(makeobj inch         inch         nil)
(makeobj home         home         home)
(makeobj direction    direction    nil)
(makeobj waypoint     waypoint     nil)
(makeobj opposite    loc-direction    opposite)
(makeobj nearest         waypoint    nearest)
(makeobj closest         waypoint    closest)
;(makeobj actions      do-action    nil)       ; what do I do now
;(makeobj time         time         now)
;(makeobj me           r-observer          nil)
;(makeobj beginning    beginning    nil  :theme system)
;(makeobj time-end     time-end     nil  :theme system)
;(makeobj rotation     rotate       nil)
(makeobj location      loc-direction  nil)
(makeobj complete     complete   complete)
(makeobj completely    completely   nil)
(makeobj direct direct direct)
(makeobj directly directly nil)

(makeobj name           name           nil)
;(makeobj speed          speed          simulation :theme system)
;(makeobj designation    designation    nil)
;(makeobj type           type           platform)
;(makeobj classification classification nil)
;(makeobj heading        heading        nil)

;(makeobj slower         rel-speed      slower)
;(makeobj faster         rel-speed      faster)


