;;robotsemantics.lisp,v 1.21 2003/07/16 18:45:12 thomas Exp
;; ======================================================================
;;; Interbot


;;; SEMANTICS

;;; Kenneth Wauchope
;;; Navy Center for Applied Research in Artificial Intelligence
;;; Naval Research Laboratory, Code 5512
;;; Washington, DC 20375-5337

;;; Adapted to a robotics domain:
;;; Dennis Perzanowski

;;; TINSEL representation of InterVIEWER domain.
;;; InterBOT representation modified by Dennis Perzanowski
;;; ======================================================================

;;; THE FOLLOWING IS BASED ON KEN WAUCHOPE'S INTERVIEWER SEMANTICS, UTILIZING
;;; HIS TINSEL REPRESENTATIONS.  THEY HAVE BEEN ADAPTED FOR A ROBOTICS
;;; APPLICATION.  DENNIS PERZANOWSKI 9/12/95
;;; BASIC
(defframe gesture)
; the following defframe is to handle "functional" nouns, such as
; "my left" and "your left" which are not actually objects but are
; really related or relative to some direction.
(defframe FN)
(defframe thing)                                        ;it, they, what...
(defframe attribute :isa thing)
(defframe attributable :isa thing)

(defframe ordinal)
(defcon one ordinal)
(defcon two ordinal)
(defframe system)			;robots, humans
;; I did not have robots and humans as part of system DP 5/30/03
(defframe r-observer)
;;(defframe location :isa thing)
(defframe location)

(defframe direction)
;;(defnpred thing (something))
;;this needs to be re-thought to something like:
;; (defnpred thing (thing))
;; (defnpred speed (thing))
;; (defnpred wind-speed (thing))
(defnpred thing (thing))
  ;; (named-thing :name (NAME)))
(defframe something :isa thing)
(defframe p-vp-gap :isa p-action :agent r-observer)
(defpred vp-gap (p-vp-gap :agent (S)))
(defframe p-action :isa action :agent system)
(defframe p-continue :agent system :goal (action goal-direction) :to-loc (thing loc-direction))
(defframe interjection)
(defpred keep (p-continue :agent (S) :goal (O)))
(defframe state)
(defframe finished :isa state)
(defcon finished finished)
(defframe done :isa state)
(defcon done done)
(defframe open :isa state)
(defcon open open)
(defframe closed :isa state)
(defcon closed closed)


(defframe p-get-off :isa action :agent system :goal (object) :location (location area))
(defframe p-get-on :isa action :agent system :goal (object area))
(defframe p-get :isa action :agent system :to-loc (object location))
(defpred get-off (p-get-off :agent (S) :goal (O &) :location (ON &)))
(defpred get-on (p-get-on :agent (S) :goal (O)))
(defpred get (p-get :agent (S) :to-loc (TO)))

;(defframe p-go :isa action :agent system 
;  :goal (space-direction) 
;  :to-loc (location loc-direction object) :theme (action)
;  :relative-to (system r-observer))
;
;(defpred go (p-go :agent (S) 
;                  :goal (O LOC &) 
;                  :theme (O &) 
;                  :to-loc (TO ON LOC &) 
;                  :position (AT ON &)
;                  :relative-to (O &)))

;; goal-direction is being included in p-see to account for "what do you see over there?" DP 2/28/02
(defframe p-see :isa action :agent system :theme (person thing) :position (goal-direction loc-direction) :relative-to (system) :behind (system object) :near (system object) :in-front-of (system object) )
(defpred see (p-see :agent (S) :theme (O) :position (TO ON LOC &) :relative-to (O &) :behind (behind &) :near (near &) :in-front-of (in-front-of &) ))

(defframe distance)
(defframe degree)
(defframe inch)
(defframe named-thing :isa thing :name string)
(defframe agent)                                        ;who = which agent
(defframe patient)
(defframe attention)
(defnpred attention (attention))
;;(defframe at-ease)
(defcon at-ease at-ease)
;;(defframe system :isa (agent named-thing timeable attributable))
;;(defframe r-observer :isa (patient attributable))
(defnpred observer (r-observer))
(defframe action :agent system)
(defframe robot-action :isa action :agent system :patient system)
(defpred zero (robot-action :agent (S &) :patient (O)))

(defframe door :isa object)
(defframe chair :isa object)
(defframe table :isa object)
(defframe pillar :isa object)
(defframe box :isa object)
(defframe computer :isa object)
(defframe desk :isa (FN object) :relative-to system)
(defframe hall :isa area)
(defframe hallway :isa area)
(defframe registration-desk :isa desk) ;; SCT from object)
(defnpred registration-desk (registration-desk))
(defframe registration-area :isa area)
(defnpred registration-area (registration-area))
(defframe registration-line :isa area)
(defnpred registration-line (registration-line))
(defnpred desk (desk :relative-to (OF &)))
(defframe escalator :isa object)
(defnpred escalator (escalator))
(defframe elevator :isa object)
(defnpred elevator (elevator))
(defframe elevator-door :isa object)
(defnpred elevator-door (elevator-door))
(defframe elevator-doors :isa object)
(defnpred elevator-doors (elevator-doors))
(defframe stair :isa object)
(defnpred stair (stair))
;(defframe floor :isa (FN location) :count :ordinal)
(defframe floor-location :isa location)
(defframe floor :isa area)
(defframe level :isa area)
(defframe ground-floor :isa floor)
(defframe ground-level :isa floor)
;;(defframe first-floor :isa floor-location)
(defframe first-floor :isa floor)
(defframe first-level :isa floor)
(defframe second-floor :isa floor)
(defframe second-level :isa floor)
(defframe third-floor :isa floor)
(defframe third-level :isa floor)
(defframe fourth-floor :isa floor)
(defframe fourth-level :isa floor)
(defframe assembly-level :isa floor)
(defframe banquet-level :isa floor)
(defframe street-level :isa floor)	;like others, isn't always a floor
(defframe restaurant-level :isa floor)
(defframe lobby :isa area)
(defframe exhibit-hall :isa hall)

(defframe mode)
(defframe query-mode :isa mode)
(defnpred query-mode (query-mode))
(defframe steered-mode :isa mode)
(defnpred steered-mode (steered-mode))
(defframe scripted-mode :isa mode)
(defnpred scripted-mode (scripted-mode))
(defnpred lobby (lobby))
(defframe path :isa thing)
(defframe wind :isa thing)
(defframe speed :isa (attribute settable) :theme system)
(defframe wind-speed :isa (attribute settable) :theme system) ;TODO isa speed
;;(defframe wind-speed :isa speed)
(defframe path-gesture :isa gesture)
(defframe door-gesture :isa gesture)
(defframe waypoint :isa thing :id fixnum)
(defframe waypoint-gesture :isa gesture)
;;(defframe area-gesture :isa gesture)
;;(defframe region-gesture :isa gesture)
;;(defframe area :isa location) ??SCT
(defframe area :isa location)		; SCT but p-isa and p-be overlap
(defframe region :isa location)
(defframe perimeter :isa location)
(defframe p-exit :isa action :theme system)
(defpred exit (p-exit :agent (S &) :theme (O &)))
(defpred quit (p-stop :agent (S) :theme (O &)))
(defframe p-stop :isa action :theme action)
(defpred stop (p-stop :agent (S) :theme (O &)))
(defpred halt (p-stop :agent (S) :theme (O &)))
(defframe p-start :isa action :theme (action mode))
(defpred start (p-start :agent (S) :theme (O)))
(defpred end  (p-exit :agent (S) :theme (O)))
(defframe map :isa (thing))
(defframe wall :isa (thing))
(defframe sign :isa object)
(defnpred sign (sign))
(defframe object :isa thing :id fixnum)
(defnpred object (object :id (IDNUM &)))
(defframe label :isa (thing))
(defnpred label (label))
(defnpred robot (system))
(defframe sensor :isa (thing) :relative-to (system))
(defnpred sensor (sensor :relative-to (OF &)))
(defframe chemical-sensor :isa (sensor) :relative-to (system))
(defnpred chemical-sensor (chemical-sensor :relative-to (OF &)))
(defnpred gas-sensor (gas-sensor :relative-to (OF &)))
(defframe gas-sensor :isa (sensor) :relative-to (system))
(defframe way :isa goal-direction)
(defnpred way (way))
;(defcon way way)
(defnpred map (map))
(defnpred wall (wall))
(defnpred door (door))
(defnpred path (path))
(defnpred wind (wind))
(defnpred chair (chair))
(defnpred table (table))
(defnpred pillar (pillar))
(defnpred box (box))
(defnpred computer (computer))
;(defnpred floor (floor :count (count &)))
(defnpred floor (floor))
(defnpred level (level))
(defnpred ground-floor (ground-floor))
(defnpred ground-level (ground-level))
(defnpred first-floor (first-floor))
(defnpred first-level (first-level))
(defnpred second-floor (second-floor))
(defnpred second-level (second-level))
(defnpred third-floor (third-floor))
(defnpred third-level (third-level))
(defnpred fourth-floor (fourth-floor))
(defnpred fourth-level (fourth-level))
(defnpred assembly-level (assembly-level))
(defnpred banquet-level (banquet-level))
(defnpred street-level (street-level))
(defnpred restaurant-level (restaurant-level))
(defnpred hall (hall))
(defnpred exhibit-hall (exhibit-hall))
(defnpred hallway (hallway))
(defnpred wind-speed (wind-speed :theme (OF &)))
(defnpred speed (speed :theme (OF &)))
(defnpred path-gesture (path-gesture))
(defnpred door-gesture (door-gesture))
(defnpred chair-gesture (chair-gesture))
(defnpred waypoint-gesture (waypoint-gesture))
;(defnpred area-gesture (area-gesture))
;(defnpred region-gesture (region-gesture))
(defnpred area (area))
(defnpred region (region))
(defnpred perimeter (perimeter))
(defnpred waypoint (waypoint :id (IDNUM &)))
;(defnpred direction (loc-direction))
(defnpred direction (direction))
(defframe p-closest :obj object)
(defpred nearest (p-closest :obj (S)))
(defpred closest (p-closest :obj (S)))
(defframe space-direction :isa direction)
(defframe time-direction :isa direction)
(defframe back :isa space-direction)
(defnpred back (back :relative-to (of &)))
;;(defframe down :isa space-direction)
(defframe up :isa space-direction)
;;(defframe up :isa space-direction)
(defframe downstairs :isa loc-direction)
(defframe halfway :isa space-direction)
;(defframe space-location :isa location)
(defframe upstairs :isa loc-direction)
(defframe over :isa loc-direction)
(defframe away :isa loc-direction)
(defcon away away)
(defframe forward :isa space-direction )
(defframe forward-time :isa time-direction)
(defframe backward-time :isa time-direction)
(defcon back back)
(defcon forward forward)
(defcon backward-time backward-time)
(defcon forward-time forward-time)
(defcon down down)
(defcon up up)
(defcon downstairs downstairs)
(defcon upstairs upstairs)
(defcon halfway halfway)
(defframe left :isa (FN loc-direction)  :relative-to (thing system r-observer))
(defframe right :isa (FN loc-direction) :relative-to (thing system r-observer))
(defframe front :isa (FN loc-direction) :relative-to (object))
(defframe center :isa (FN loc-direction) :relative-to (object ))
;;(defframe up :isa (FN space-direction))
(defframe down :isa space-direction)
;; at this point 2/28/02, I'm not sure why the :isa has to be an FN.  With or
;; without it, the sentences parse and get interpreted, but there is no 
;; information about the location given. I'm just following the left/right pattern
;; above Need to investigate further.
;;(defframe behind :isa (FN loc-direction) :relative-to (thing system r-observer object))
;;(defframe opposite :isa (FN loc-direction) :relative-to (thing system r-observer object))
;;(defframe near :isa (FN loc-direction) :relative-to (thing system r-observer object))
;;(defframe across :isa (FN loc-direction) :relative-to (thing system r-observer object))
;;(defframe on :isa (FN loc-direction) :relative-to (thing (system r-observer)))
;;(defframe in-front-of :isa (FN loc-direction) :relative-to (thing system r-observer object))
;;(defframe front :isa (FN loc-direction) :relative-to (thing system r-observer object))
;;(defframe next-to :isa (FN loc-direction) :relative-to (thing system r-observer object))
(defframe around :isa loc-direction)
(defframe there :isa goal-direction)
(defframe here :isa goal-direction)
(defframe off :isa goal-direction)
;;(defframe on :isa goal-direction)
;;(defframe behind :isa loc-direction)
(defframe home :isa thing)
(defframe loc-direction :isa direction)
(defframe goal-direction :isa direction)
(defframe far :isa goal-direction)
(defcon far far)
(defcon left left)
(defcon there there)
(defcon here here)
(defcon home home)
(defcon over over)

(defnpred left (left :relative-to (OF &)))
(defnpred right (right :relative-to (OF &)))
(defnpred front (front :relative-to (OF &)))
(defnpred center (center :relative-to (OF &)))
(defcon right right)
(defcon around around)
(defframe goodbye :isa interjection)
(defframe hello :isa interjection)
(defcon hello hello)
(defcon goodbye goodbye)
(defpred continue (p-continue :agent (S &) :goal (O LOC TO &) :to-loc (O LOC TO &)))
(defframe p-pay :isa action :agent (system) :theme (attention))
(defpred pay (p-pay :agent (S) :theme (O)))

(defframe elevator-button :isa button)
(defnpred elevator-button (elevator-button))
(defframe button :isa object)
(defnpred button (button))
(defframe p-push :isa action :agent system :theme (object) :goal (location) :recipient (system))
(defpred push (p-push :agent (S) :theme (O) :goal (FOR TO &) :recipient (FOR &)))
(defpred press (p-push :agent (S) :theme (O) :goal (FOR TO &) :recipient (FOR &)))
(defframe p-excuse :isa action :agent system :recipient (system))
(defpred excuse (p-excuse :agent (S) :recipient (O)))

(defframe p-point :isa action :agent system  :recipient system
  :to-loc (thing direction area) :relative-to (thing))
(defpred point (p-point :agent (S) :recipient (O &) :to-loc (IN-THE-DIRECTION-OF TO IN &) :relative-to (O OF &)))

;;(defframe p-press :isa action :agent (system) :theme (object) :goal (location))
;;(defpred press (p-press :agent (S) :theme (O) :goal (TO FOR &)))

(defframe p-wake :isa action :agent (system) :theme (time))
(defpred wake-up (p-wake :agent (S) :theme (O &)))

(defframe p-listen :isa action :agent (system) :relative-to (r-observer))
(defpred listen (p-listen :agent (S) :relative-to (TO &)))

(defpred listen-up (p-listen :agent (S) :relative-to (TO &)))

(defframe p-sleep :isa action :agent (system))
(defpred sleep (p-sleep :agent (S)))

(defframe p-exist :theme (thing) :to-loc (loc-direction thing) :goal (goal-direction thing))
(defpred exist (p-exist :theme (S) :to-loc (O NEAR OVER LOC AT BY &) :goal (O LOC &)))


(defframe p-show :isa action 
  :agent (system) 
  :relative-to (r-observer 
		system)			;SCT
  :goal (thing))
(defpred load (p-show :agent (S) :goal (O)))
(defpred show (p-show :agent (S) :relative-to (IO &) :goal (O)))

(defframe description :isa thing)

(defframe p-describe :isa action :agent (system) :goal (thing))

(defpred describe (p-describe :agent (S) :goal (O)))

(defframe p-park :isa action :agent (system) :theme (system) :to-loc (loc-direction) :goal (goal-direction))
(defpred park (p-park :agent (S) :theme (O & ) :to-loc (OVER LOC &) :goal (LOC &)))

(defframe p-assign :isa action :agent (system) :theme (thing) :goal (TO thing))
(defpred assign (p-assign :agent (S) :theme (O) :goal (TO O))) 
(defpred call (p-assign :agent (S) :theme (IO O) :goal (TO O)))

;;(defpred go (move-distance :agent (S) :distance (O &) :goal (O LOC &) :behind (BEHIND &) :NEAR (NEAR &)  :IN-FRONT-OF (IN-FRONT-OF &)   :to-loc (TO O LOC &)  :manner (O &)))

;(defpred go (gesture-go :agent (S &) :goal ( O LOC ) :distance (O &) :to-loc (TO THROUGH LOC O &)))

;(defframe gesture-go 
;  :isa action :agent (system) :distance (string) :goal (goal-direction) :to-loc (object thing gesture))


(defframe p-use :isa action
                :agent (system)
		:theme (object)
		:goal (goal-direction space-direction )
		:to-loc (thing floor-location area)
		:up-distance (string)
		:down-distance (string))

(defpred take (p-use :agent (S) :theme (O) :goal (LOC &)  :to-loc (TO  &)
                     :up-distance (UP LOC &)
		     :down-distance (DOWN LOC &)))


(defpred use (p-use :agent (S) :theme (O) :to-loc (TO &)))

;; Semantically the following sentences are identical:  
;; STOP MONITORING NERVE GAS and STOP MONITORING FOR NERVE GAS
;; the issue here is the VINGO + FOR with an object.
;; In order not to get an ambiguous parse, the FOR argument is lumped together with other THEMEs.
;; While someone might object to the name of the role in such sentences, the intent here is
;; simply to assign a role in order for their to be appropriate and identical logical forms
;; for these two sentences.  DP: 8/8/00

(defframe p-detect :isa action :agent (system) :theme (thing &) :to-loc (loc-direction thing &) :goal (goal-direction thing &))
(defpred detect (p-detect :agent (S) :theme (FOR O &) :to-loc (NEAR OVER LOC AT BY &) :goal (LOC &)))
(defpred sense (p-detect :agent (S) :theme (FOR O &) :to-loc (NEAR OVER LOC AT BY &) :goal (LOC &)))
(defpred smell (p-detect :agent (S) :theme (FOR O &) :to-loc (NEAR OVER LOC AT BY &) :goal (LOC &)))
(defpred sniff (p-detect :agent (S) :theme (FOR O &) :to-loc (NEAR OVER LOC AT BY &) :goal (LOC &)))
(defpred monitor (p-detect :agent (S) :theme (FOR O &) :to-loc (NEAR OVER LOC AT BY &) :goal (LOC &)))

;;;;(defframe p-start-specif-act :isa action :agent (system) :patient (thing) :to-loc (loc-direction thing) :goal (goal-direction thing) :relative-to (system))
(defframe p-start-specif-act :isa action :agent (system) :patient (thing) :relative-to (system) :goal (ON goal-direction))
;;;;(defpred turn-on (p-start-specif-act :agent (S) :patient (O) :to-loc (NEAR OVER LOC AT BY &) :goal (ON LOC &) :relative-to (O &)))
(defpred turn-on (p-start-specif-act :agent (S) :patient (O) :relative-to (O &) :goal (goal-direction &)))
(defframe p-stop-specif-act :isa action :agent (system) :patient (thing) :to-loc (loc-direction thing) :goal (OFF goal-direction thing) :relative-to (system))
(defpred turn-off (p-stop-specif-act :agent (S) :patient (O) :to-loc (NEAR OVER LOC AT BY &) :goal (goal-direction &) :relative-to (O &)))

;;(defframe explore-distance :isa action :agent (system) :goal (goal-direction) :to-loc (loc-direction thing distance gesture)
;;    :relative-to (thing system r-observer) :manner (complete))

;;(defpred patrol (explore-distance :agent (S) :goal (O LOC &) 
;;                 :to-loc (TO O LOC) :relative-to (O &) :manner (O &)))

;;(defpred explore (explore-distance :agent (S) :goal (O LOC &) 
;;	 :to-loc (TO O LOC) :relative-to (O &) :manner (O &)))

(defpred explore (gesture-explore :agent (S &) :goal (LOC O &) :to-loc (LOC O &)))
(defframe gesture-explore :isa action :agent (system) :goal (goal-direction) :to-loc (thing gesture location area))

(defpred patrol (gesture-explore :agent (S &) :goal (LOC O &) :to-loc (LOC O &)))

(defframe follow-direction :isa action :agent (system) :to-loc (loc-direction object location ) :at-loc (location )  :at-direction (loc-direction) :goal (r-observer thing goal-direction)) 
(defpred follow (follow-direction :agent (S) :to-loc (TO LOC  &) :at-direction (AT ON  &) :at-loc (ON AT &) :goal (LOC O &)))
(defframe gesture-follow :isa action :agent (system) :goal (goal-direction) :to-loc (thing gesture))
(defpred follow (gesture-follow :agent (S &) :goal (LOC O) :to-loc (LOC O)))

(defframe come-direction :isa action :to-loc (r-observer loc-direction) :goal goal-direction) 

(defpred come (come-direction :agent (S) :to-loc (TO LOC O &) :goal (LOC O &)))

(defframe p-come-from :isa action :agent (r-observer system) :loc (country town location ))
(defpred come (p-come-from :agent (S) :loc (FROM)))
(defpred be (p-come-from :agent (S) :loc (FROM )))
(defframe place)
(defnpred place (place))
;;(defpred come (p-stative :theme (S) :co-theme (O &) :from-loc (from  &)))

;; removing location from :to-loc to reduce ambiguity DP 5/20/02
(defframe move-distance :isa action :agent (system)
  :co-agent (system) 
  :distance (string)
  :goal (space-direction goal-direction)
  :at-loc (thing)
  :on-loc (floor-location)
  :loc (area)
  :to-loc (thing loc-direction location floor-location floor eating-event) 
  :near (object)
  :behind (object system)
  :in-front-of (object system)
  :manner (complete))

(defpred be (move-distance :agent (S) :to-loc (TO)))

(defpred move (move-distance :agent (S)
                             :distance (O &)
                             :goal (O LOC &) 
                             :behind (BEHIND &)
                             :NEAR (NEAR &)
                             :IN-FRONT-OF (IN-FRONT-OF &)
                             :at-loc (AT &)  
                             :on-loc (ON &) 
                             :to-loc (OVER TO O LOC &)   
                             :manner (O &)))

(defpred go (move-distance :agent (S) 
                           :co-agent (WITH &)
			   :distance (O &)
                           :goal (O LOC &) 
                           :behind (BEHIND &) 
                           :NEAR (NEAR &)  
                           :IN-FRONT-OF (IN-FRONT-OF &)  
                           :at-loc (AT &)  
                           :on-loc (ON &)
                           :loc (O DOWN &)
                           :to-loc (OVER TO LOC &)  
                           :manner (O &)))

(defframe p-jump :isa action :to-loc (direction))

(defpred jump (p-jump :agent (S &) :patient (S &) :to-loc (LOC &)))

(defframe turn-degrees 
  :isa action 
  :agent (system)			;SCT added
  :to-loc ( distance direction  r-observer) :past-loc (thing) :at-loc (thing) :distance string :manner (complete) :relative-to (system r-observer))

;;(defframe find-goal :isa action :goal (object location) :to-loc (direction))

;;(defpred turn (find-goal :agent (S) :goal (O AT) :to-loc (LOC &)))

(defpred turn (turn-degrees  :agent (S)  :distance (O &) :to-loc (TO LOC &)   :past-loc (PAST &) :at-loc (AT LOC &) :manner (O MANNER &) :relative-to (O &)))
;;(defpred turn-on (p-start-specif-act :agent (S) :patient (O) :goal (ON)))
;;(defpred turn-off (p-stop-specif-act :agent (S) :patient (O) :goal (OFF)))

(defframe go-direction-distance :isa action :agent (system &) 
  :goal (goal-direction) :to-loc (string space-direction loc-direction))

(defframe back-direction-distance :isa action :agent (system &) :distance (string)
  :goal (goal-direction) :to-loc (loc-direction))

(defpred back (back-direction-distance :agent (S &) :goal (O LOC &)  :distance (O &) :to-loc (TO LOC O &)))

;;(defframe go-coordinate :isa action :agent system :goal string :to-loc string)

;;adding go-coordinate for go to (coordinate) alpha 5.
(defframe go-direction-gesture :isa action :agent system 
  :goal (string goal-direction) :to-loc (space-direction loc-direction))

;;(defpred go (go-coordinate :agent (S &) :goal (O LOC &) :to-loc (O TO)))

(defpred make (p-remember :agent (S &) :theme (IO LOC) :goal (LOC O)))

(defpred change (p-remember :agent (S &) :theme (O) :to-loc (OVER TO LOC &) :goal (OVER TO LOC)))

(defpred remember (p-remember :agent (S &) :theme (IO LOC) :goal (LOC O)))

(defframe p-remember :isa p-action :theme (gesture loc thing waypoint-gesture) :goal (goal-direction loc thing ) :to-loc (thing loc-direction))

(defframe p-thank :isa action :agent system :recipient system)

(defpred thank (p-thank :agent (S) :recipient (O)))

(defadjunct when (:when turn-degrees p-get-off p-get-on p-get))

;; from muck:(defadjunct IN (at-loc action locale)(within-time action date))
;; (defadjunct in (in action location area))

(defframe manner)
(defframe complete :isa manner)
(defframe completely :isa manner)
(defframe direct :isa manner)
(defframe directly :isa manner)
(defcon complete complete)
(defcon direct direct)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defframe face-action :isa action :agent (system) :goal (distance loc-direction r-observer thing) 
       :to-loc (system distance loc-direction thing) :relative-to (thing system r-observer))
(defpred face (face-action :agent (S &) :goal (LOC O &) :to-loc (TO LOC O) :relative-to (O &)))

(defframe p-face-action :isa action :agent (system) :to-loc (r-observer))
(defpred face (p-face-action :agent (S &) :to-loc (O)))

(defframe look :isa action :to-loc space-direction)
(defpred look (look :agent (S) :to-loc (LOC)))

(defframe p-say :isa action :agent (system) :theme (interjection thing))
					;SCT added thing for wh-questions
(defpred say (p-say :agent (S &) :theme (O)))

(defframe end-of-sequence :isa state)
(defnpred end-of-sequence (end-of-sequence))

(defframe type :isa attribute)
(defframe designation :isa attribute)
(defframe classification :isa attribute)
(defframe c-name :isa (FN thing) :relative-to (system)) ;SCT Thing from attr
					;C-NAME because NAME already in proteus
(defnpred name (c-name :relative-to (OF &)))
(defnpred type (type))
(defnpred kind (type))

(defframe red)
(defframe orange)
(defframe gold)
(defframe yellow)
(defframe chartreuse)
(defframe green)
(defframe cyan)
(defframe blue)
(defframe magenta)
(defframe purple)

;;I had to add role opposite so that we could actually SEE what position the argument was taking
;; as in "IT IS ON THE FIRST FLOOR OPPOSITE THE EXHIBIT HALL."
;; I could have made the :position argument take opposite and across-from arguments, but
;; the actual position would have been lost.
;;taking out location from theme
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; position of something (object or location) relative to the
;;; observer (robotcentric) or something else (object location)
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defframe p-be
  :isa action
  :theme (thing event r-observer system area floor-location person) 
;;  :cotheme (thing) ;SCT p-isa, area above
  :position (system thing loc-direction location)
  :goal (goal-direction)
  :where-at (system location loc-direction thing area)
  :at-loc (system location loc-direction thing area)
  :where-at (system location loc-direction thing area)
  :behind-loc (thing system location area)
  :next-to-loc (thing system location area)
  :near-loc (thing system location area)
  :to-loc (location area thing direction)	;SCT added THING, DIRECTION
  :on-loc (location area thing direction) ;"
  :in-loc (location area thing)		;"
  :down-loc (location area object)
  :in-front-of-loc (thing system location area)
  :under (thing location area system)
  :loc (system thing loc-direction location area )
  ;; :on  (system thing loc-direction location area ) ;TODO make more narrow?
  :time (string)
  :across-from-loc (system loc-direction thing system location area)
  :manner (manner direct just right))


(defpred BE (p-be :theme (S) 
;;                            :theme (S &)
;;		  :cotheme (O &)	;SCT from P-ISA
		  :position (DOWN UP &) 
		  :where-at (WHERE-AT &)
		  :goal (LOC O  &)
                  :at-loc ( AT LOC  &)
                  :where-at (WHERE-AT &)
		  :behind-loc (BEHIND &)
		  :next-to-loc (NEXT-TO BY &)
                  :near-loc (NEAR &)
                  :to-loc (TO &)
                  :on-loc (ON &)
                  :in-loc (IN &)
                  :down-loc (DOWN &)
		  ;;    :loc (LOC  &)
		  :time (AT  &)
		  :in-front-of-loc (IN-FRONT-OF &)
		  :across-from-loc (opposite across-from across &)
                  :manner (MANNER O &)))

;;(defframe be-behind :isa action :theme (thing)
;;  :referent (thing system ) :manner (direct))

;;(defpred BE (be-behind :theme (S) 
;;		       :referent (behind) :manner (manner &)))

;;(defframe be-opposite :isa action :theme (thing)
;;  :referent (thing system) :manner (direct))

;;(defpred BE (be-opposite :theme (S)
;;			 :referent (opposite across across-from)
;;			 :manner (manner &)))

;;(defframe be-in-front-of :isa action :theme (thing)
;;  :referent (thing system)
;;  :manner (direct))

;;(defpred BE (be-in-front-of :theme (S)
;;			    :referent (in-front-of)
;;			    :manner (manner &)))

;;(defframe be-near :isa action :theme (thing)
;;  :referent (thing system))
;;(defpred BE (be-near :theme (S) :referent (by near next-to)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; position of the observer relative to something (object location)
;;; object-centric
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;(defframe be-relative-to :theme (system)
;;          :near (thing)
;;	  :in-front-of (thing)
;;	  :behind (thing)
;;	  :loc (thing goal-direction loc-direction))

;;(defpred BE (be-relative-to :theme (S) :near (by near next-to &)
;;			    :in-front-of (in-front-of &)
;;			    :behind (behind &)
;;			    :loc (AT IN TO ON LOC &)))

;;we are trying to move the various arguments of "BE" into one predicate with various
;;arguments--rather than several be-foo predicates with individual arguments.
;; DP 6/2/03
;;(defframe p-be :theme (event thing) :at-loc (location area) :at-time (string time))
;;(defpred be (p-be :theme (S) :at-loc (IN  O &) :at-time (AT TIME O &)))

;;(defframe p-attribute-have-value :theme (attribute atmospheric-thing) :co-theme (attribute))
;;(defpred be (p-attribute-have-value :theme (S) :co-theme (O)))

(defframe p-attribute-have-value :theme (thing attribute atmospheric-thing)  :value (attribute) )

(defpred be  ;;SCT->;;
    (p-attribute-have-value :theme (S) :value (O )))

(defframe c-time :isa (time FN thing))		;SCT
(defframe time)
(defnpred time (c-time))
(defframe the-time-now :isa c-time)

;;(defframe be-somewhere-opposite :theme object :somewhere-opposite (location object thing))
;;(defpred BE (be-somewhere-opposite :theme (S) :somewhere-opposite (across)))

;;(defframe be-directly-opposite :theme object :opposite (object thing))
;;(defpred BE (be-directly-opposite :theme (S) :opposite (across-from)))

;;(defframe be-next-to :theme object :next-to (location object thing system))
;;(defpred BE (be-next-to :theme (S) :next-to (next-to)))

(defframe p-isa :theme (object system) :cotheme (thing loc-direction system area)) 

(defpred BE (p-isa :theme (S) :cotheme (IO O))) 

(defframe object-gap :isa object )	;dummy object?
(defcon object-gap object-gap)

;;(defframe p-location :theme (system r-observer object location) :at-loc (goal-direction location))
;;(defframe p-location :theme (thing) 
;;  :at-loc (goal-direction ))

;;(defpred BE (p-location :theme (S) :at-loc (AT LOC O &)))

(defnpred location (location))

(defrole in-front-of)
(defrole qualifier)
;;(defrole when)

(defcon I          system)
(defcon me         system)
(defcon dennis     system)
(defcon alan       system)


;;(defframe grace :isa system)

(defcon grace system)
(defframe name-grace :isa c-name)
(defnpred name-grace (name-grace))



(defcon george     system)

(defcon conference-attendee system)
(defcon coyote     system)
(defcon roadrunner system)
(defcon wolverine system)
(defcon mystique system)
(defcon nightcrawler system)
(defcon magneto system)
(defcon you        system)
(defcon yourself   system)
(defcon yourselves system)
(defcon we         r-observer)
(defcon it         thing)
(defcon he         system)
(defcon him        system)
(defcon this       thing)
(defcon these      thing)
(defcon that       thing)
(defcon them       thing)
(defcon they       thing)
(defcon anyone     platform)
(defcon anybody    platform)
(defcon someone    platform)
(defcon everyone   platform)
(defcon everybody  platform)
(defcon anything   thing)
(defcon something  thing)
(defcon everything thing)

;;(defcon directly directly)
(defcon just just)
; (defcon each-other  system)

;;; ---------------- NULL-N (any, any of them) -------------------------

(defframe subset :q-of thing)
(defnpred null-n (subset :q-of (Q-OF &)))

;;; --------------------------- MISC. ----------------------------------

(defq NULL-DET)
(defrole NAME MANNER LOC IO Q-OF TIME COUNT SPEED)
;;(defrole behind)
(defrole IDNUM GOAL LOC ALSO TIME Q-OF IO MANNER WHERE-AT)

;;; ---------------------------REPRESENTATIONS FOR SENTENCE FRAGMENTS----
;;; the following support "verbless" sentence fragements, e.g. "over there"

;;(defframe p-dummy-vp :isa action :agent (system &) :goal (string goal-direction) :to-loc (loc-direction))
;;;;(defpred nil (p-dummy-vp :agent (S &) :patient (S &) :goal (O LOC &) :to-loc (TO O LOC &) :manner (O &) :relative-to (O &)))

;;(defpred nil (p-dummy-vp :agent (S &) :patient (S &) (:goal (O LOC ) :to-loc (TO O LOC)) 
;;                                                     (:goal (O LOC))
;;              :to-loc (TO O LOC)
;;              :manner (O &) :relative-to (O &)))

;;; the following support "verbless" sentence fragements, e.g. "over there"
;;; It is also being used for "fragment-like" imperatives, e.g. ATTENTION!

(defframe p-dummy-vp :isa action :agent (system &) :distance (string) :goal (goal-direction) :to-loc (location loc-direction) :theme (attention at-ease))
(defpred nil (p-dummy-vp :agent (S &) :patient (S &) :distance (O &) :goal (O LOC &) :to-loc (TO O LOC &) :manner (O &) :relative-to (O &) :theme (O &) ))


;; the following definition is needed to process TOO as an op1 in the grammar and have
;; TINSEL understand that it is acting as a unary operator.  Thus, "coyote, you turn too" and
;; "coyote you too" will be interpreted correctly and then passed on to funtran and focal components
;; for additional processing.



;;the following are stub I created just to prevent Lisp from crashing
;;because of a non-defined function.  DP 5/22/02
;;also, "where is the registration desk?" at this point in the parsing
;;will go through, while "where is the pillar?" will yield "No such NIL exists."
;;because we handle objects differently now due to the spatial relations component.
;;(defun p-location (theme agent goal to-loc) nil)
;;(defun p-isa (theme agent goal to-loc) nil)
;;(defun p-use (isa theme agent goal to-loc distance) nil)

(defframe stairs :isa object)
(defnpred stairs (stairs))

(setf (get 'TOO 'logical-type) 'OP1)
(setf (get 'gas 'collective) t)
(setf (get 'stairs 'collective) t)
(setf (get 'sign 'collective) t)
(setf (get 'elevator 'collective) t)
(setf (get 'elevator-doors 'collective) t)

;; adding some frames and defpreds for incorporating CMU's registration
;; grammar for the Robot Challenge AAAI August 2003.
;; DP 5/20/03

(defframe room :isa area :id fixnum)
(defnpred room (room :id (IDNUM &)))

(defframe event)
(defframe c-talk :isa (FN event) :relative-to system)
(defnpred talk (c-talk :relative-to (OF &)))

(defnpred presentation (c-talk :relative-to (OF &)))
;;(defframe presentation :isa (FN event) :relative-to system) ;or isa c-talk?
;;(defnpred presentation (presentation :relative-to (OF &)))

;; we are going to have to do some post-processing on these following predicates
;; since Nautilus would generate ambiguities anyway for these verbs, based on
;; whether the arguments were choices (preferences) or desires (maybe one thing).
;; DP 5/22/03
(defframe p-prefer-or-desire :isa action :agent system :theme (action food  thing) :co-theme (event thing))
(defpred prefer (p-prefer-or-desire :agent (S) :theme (O) :co-theme (ON &)))
(defpred want (p-prefer-or-desire :agent (S) :theme (O) :co-theme (FOR ON &)))
(defpred like (p-prefer-or-desire :agent (S) :theme (O) :co-theme (ON &)))

;;additional post-processing must be done on the following "functional nouns"
;;since no functions have thus far been written for (FN hard-copy) etc.
;; DP 5/22/03
(defframe conference-proceedings :isa proceedings)
(defnpred conference-proceedings (conference-proceedings))
(defframe proceedings :isa object)
(defnpred proceedings (proceedings))
(defframe copy :isa (FN object) :of object)
(defnpred copy (copy :of (OF &)))
(defframe hard-copy :isa (FN object) :of object)
(defnpred hard-copy (hard-copy :of (OF &)))
(defframe paper-copy :isa (FN object) :of object)
(defnpred paper-copy (paper-copy :of (OF &)))
(defframe electronic-copy :isa (FN object) :of object)
(defnpred electronic-copy (electronic-copy :of (OF &)))
(defframe electronic-version :isa (FN object) :of object)
(defnpred electronic-version (electronic-version :of (OF &)))
(defframe disc-version :isa (FN object) :of object)
(defnpred disc-version (disc-version :of (OF &)))

(defframe p-have :isa action :agent (system ;SCT
				     r-observer) :theme thing :co-theme thing)
(defpred have (p-have :agent (S) :theme (O) :co-theme (ON &)))

;;(defframe CD :isa object)
;;(defnpred CD (CD))
(defframe CD :isa (FN object) :of object)
(defnpred CD (cd :of (OF &)))
(defframe disc :isa (FN object) :of object)
(defnpred disc (disc :of (OF &)))
(defframe badge :isa (FN object) :relative-to (system r-observer))
(defnpred badge (badge :relative-to (OF &)))
(defframe drink :isa thing)		;SCT
(defnpred drink (drink))
(defframe tequila :isa drink)		;SCT
(defnpred tequila (tequila))
(defframe toy :isa thing)
(defnpred toy (toy))

(defframe available :isa state)
(defcon available available)

(defframe hungry :isa state)
(defcon hungry hungry)

(defframe p-stative
  :isa action
  :theme (event thing goal-direction r-observer system object) 
  :co-theme (state time)) ;; SCT rm'd: time))

(defpred be (p-stative :theme (S) :co-theme (O TIME)))

;;(defframe p-be-from :isa action :theme (system r-observer) :loc (location))
;;(defpred be (p-be-from :theme (S) :loc (O LOC)))
;;(defcon from from)

(defframe p-give :isa action :agent system :theme (event))
(defpred give (p-give :agent (S) :theme (O)))

(defframe p-put :isa action :agent (system r-observer) :theme thing :loc (location))
(defpred put (p-put :agent (S) :theme (O) :loc (ON AT LOC &)))

(defframe p-know :isa action :agent (system r-observer) :theme (location))
(defpred know (p-know :agent (S)  :theme ( O LOC) ))

;; adding weather concepts for GRACE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; adding semantic notions for weather, includes cities and countries
;; DP 9/25/02
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defframe atmospheric-thing :isa attribute)
;;(defframe weather :isa (FN atmospheric-thing) :relative-to (location))
;;(defnpred weather (weather :relative-to (IN AT &)))
(defframe weather :isa (FN atmospheric-thing))
(defnpred weather (weather))
;;(defframe town)
(defframe town :isa location)
;;(defnpred town (town ))
(defframe country :isa location)
(defnpred country (country))
(defframe state-loc :isa location)
(defnpred state (state-loc))

(defframe value :isa thing)

(defcon anchorage town)

(defcon atlanta town)

(defcon boston town)

(defcon chicago town)

(defcon dallas  town)

(defcon denver town)

(defcon honolulu town)

(defcon houston town)

(defcon los-angeles town)

(defcon miami town)

(defcon new-york town)

(defcon new-york-city town)

(defcon san-francisco town)

(defframe washington-dc :isa (washington town)) ;SCT
(defframe washington-state :isa (washington state-loc)) ;SCT
(defframe washington :isa (location))	;SCT
(defnpred washington (washington))
(defnpred washington-dc (washington-dc))
(defnpred dc (washington-dc))
(defnpred washington-state (washington-state))

(defcon acapulco town)

(defcon antarctica country)

(defcon athens town)

(defcon baghdad town)

(defcon beijing town)

(defcon berlin town)

(defcon bombay town)

(defcon capetown town)

(defcon hong-kong town)

(defcon islamabad town)

(defcon jerusalem town)

(defcon kabul town)

(defcon kuwait country)

(defcon kuwait-city town)

(defcon london town)

(defcon madrid town)

(defcon mexico-city town)

(defcon montreal town)

(defcon moscow town)

(defcon paris town)

(defcon reykjavik town)

(defcon rome town)

(defcon sydney town)

(defcon tokyo town)

(defcon toronto town)

(defcon williams-field town)
(defcon mexico country)
(defcon united-states country)
(defcon ENGLAND country)
(defcon FRANCE country)
(defcon GERMANY country) 
(defcon ITALY country)
(defcon CENTRAL-AMERICA country) ;; yes, I know, but this is easier
(defcon SOUTH-AMERICA country) ;; okay
(defcon SPAIN country) 
(defcon JAPAN country) 
(defcon CANADA country)
(defcon CHINA country)
(defcon AUSTRALIA country)
(defcon INDIA country)
(defcon ISRAEL country)
(defcon GREECE country)
(defcon AFRICA country)
(defcon SOUTH-AFRICA country)
(defcon KOREA country)
(defcon RUSSIA country)
(defcon POLAND country)
(defcon BRAZIL country)
(defcon ARGENTINA country)
(defcon PERU country)
(defcon VENEZUELA country)
(defcon ECUADOR country)
(defcon PARAGUAY country)
(defcon COLOMBIA country)
(defcon CHILE country)

(defframe o |'| clock :isa time)
(defcon o |'| clock o |'| clock)

(defframe huitzuco-salon :isa hall)
(defframe huitzuco-hall :isa hall)
(defframe mezcala-salon :isa hall)
(defframe mezcala-hall :isa hall)
(defframe olinala-salon :isa hall)
(defframe olinala-hall :isa hall)
(defframe cholula-salon :isa hall)
(defframe cholula-hall :isa hall)
(defframe chicheniza-salon :isa hall)
(defframe chicheniza-hall :isa hall)
(defframe walmarts :isa area)		;???
(defframe grand-salon-teotihuacan :isa area)
(defframe teotihuacan-ballroom :isa area)
(defframe grand-salon :isa area)
(defframe grand-ballroom :isa area)
(defframe ballroom :isa area)

(defframe la-quebrada :isa area)
(defframe beach :isa area)
(defframe person)			;intentionally disjoint from THING??
(defframe cliff-divers :isa diver)	;SCT -> diver
(defframe diver :isa person)


(defnpred huitzuco-salon (huitzuco-hall))
(defnpred huitzuco-hall (huitzuco-hall))
(defnpred mezcala-salon (mezcala-hall))
(defnpred mezcala-hall (mezcala-hall))
(defnpred olinala-salon (olinala-hall))
(defnpred olinala-hall (olinala-hall))
(defnpred cholula-salon (cholula-hall))
(defnpred cholula-hall (cholula-hall))
(defnpred chicheniza-salon (chicheniza-hall))
(defnpred chicheniza-hall (chicheniza-hall))
(defnpred grand-salon-teotihuacan (teotihuacan-ballroom))
(defnpred teotihuacan-ballroom (teotihuacan-ballroom))
(defnpred grand-salon (teotihuacan-ballroom))
(defnpred grand-ballroom (teotihuacan-ballroom))
(defnpred ballroom (teotihuacan-ballroom))

(defnpred walmarts (walmarts))
(defnpred la-quebrada (la-quebrada))
(defnpred beach (beach))
(defnpred cliff-divers (cliff-divers))
(defnpred diver (diver))

(defframe p-register
  :isa action 
  :agent (system)
  :theme (event)
  :loc (loc-direction )
  :on-loc (area location floor-location)
  :at-loc (location floor-location area object))

(defpred register (p-register :agent (S) :theme (FOR &) :loc (O LOC  &)
			      :on-loc (ON &) :at-loc (AT &)))

(defframe p-eat-meal :isa action :agent (system) :meal (eating-event))

(defframe p-eat      
  :isa action
  :agent (system)
  :theme (thing) ;; SCT from (food )
  :meal (eating-event))

(defpred eat (p-eat-meal :agent (S) :meal (O &))
             (p-eat :agent (S) :theme (O) :meal (FOR &)))

(defframe eating-event :isa event)
(defframe edible-object :isa object)
(defframe food :isa edible-object)
(defframe breakfast :isa eating-event)
(defnpred breakfast (breakfast))
(defframe lunch :isa eating-event)
(defnpred lunch (lunch))
(defframe dinner :isa eating-event)
(defnpred dinner (dinner))
(defframe supper :isa eating-event)
(defnpred supper (supper))
(defframe worm :isa food )
(defnpred worm (worm))
(defframe burrito :isa food )
(defnpred burrito (burrito))
(defframe taco :isa food )
(defnpred taco (taco))
(defframe tamale :isa food )
(defnpred tamale (tamale))
(defframe enchilada :isa food )
(defnpred enchilada (enchilada))
(defframe mexican-food :isa food )
(defnpred mexican-food (mexican-food))
(defnpred food (food));SCT
(defnpred meal (eating-event));SCT

(defframe p-affirmative :agent (system) :theme (object-gap))
(defpred do (p-affirmative :agent (S) :theme (O)))

(defframe conference :isa event)
(defnpred conference (conference))

(defframe p-open :isa action :agent (system) :theme (object) :benefactor (system))
(defpred open (p-open  :agent (S) :theme (O) :benefactor (FOR &)))

(defframe p-tell :isa action
  :agent (system) 
  :theme (thing action)
  :goal (system ;SCT
	 r-observer))

(defpred tell* (p-tell :agent (s) :goal (IO) :theme (O &)))

;; (defframe c-topic :isa thing)
