;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; defcommand.lisp,v 1.7 2003/07/14 16:01:24 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   "config"
		   "state"
		   ))

(in-package :NLP)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; commands like "go here", "go over here", "go far" etc. 
;;; requires a gesture
;;; to-loc and through-loc are typically null
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand gesture-go (goal distance to-loc  manner)
  ((no-gesture-p) (talk-and-echo "Where?"))
  ((misunderstood-gesture-p) (talk-and-echo "I'm sorry. I don't understand the gesture."))
  ((one-hand-gesture-p) (talk-and-echo "I'm sorry. I didn't see you gesture in any direction."))
  ((two-vectors-gesture-p) (talk-and-echo "I'm confused. You pointed in two different directions."))
  ((vague-gesture-p) (move-robot-with-direction to-loc)) ; direction only
  ((distance-gesture-p) (move-robot-to-distance goal distance to-loc))
  ((palm-gesture-p) (move-robot-with-palm-gesture goal distance to-loc)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Optional gesture
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand move-distance (goal on-loc to-loc distance  manner near behind in-front-of)
  ((home-p to-loc) (GoWayPoint 0)
                   (talk-and-echo "Going home ..."))
  ((no-gesture-p) (move-robot-without-gesture
		   goal
		   distance
		   (locate on-loc to-loc near behind in-front-of)))
  ((misunderstood-gesture-p)
   (talk-and-echo "I'm sorry. I don't understand the gesture."))
  ;;check that a directional gesture is necessary
  ((and (one-hand-gesture-p)
	(not (loc-direction-p to-loc)))
   (talk-and-echo "I'm sorry. I didn't see you gesture in any direction."))
  ((and (one-hand-gesture-p)
	(loc-direction-p to-loc)
	(not (distance-goal-p distance)))
   (talk-and-echo (format nil "I'm sorry. I only saw one hand. I don't know how far you want me to move ~A." to-loc)))
  ((and (two-vectors-gesture-p)
	(loc-direction-p to-loc))
   (talk-and-echo "I'm confused. You pointed in two different directions."))
  ;; if a directional gesture is not necessary, ignore whatever error
  ((bad-gesture-p) (move-robot-without-gesture
		    goal distance (locate on-loc to-loc near behind in-front-of)))
  ((vague-gesture-p) (move-robot-with-gesture
		      goal
		      distance (locate on-loc to-loc near behind in-front-of)))
  ((distance-gesture-p) (move-robot-to-distance goal distance to-loc))
  ((palm-gesture-p) (move-robot-with-palm-gesture goal distance to-loc)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; optional distance gesture
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand back-direction-distance (goal distance to-loc)
  ((no-gesture-p) (backup-without-gesture goal distance to-loc))
  ((misunderstood-gesture-p)
   (talk-and-echo "I'm sorry. I don't understand the gesture."))
  ((or (one-hand-gesture-p)
       (two-vectors-gesture-p))
   (talk-and-echo "I'm sorry. That gesture didn't make sense with that command."))
  ((vague-gesture-p)
   (talk-and-echo "You want me to backup but pointed in a direction. What do you want me to do?"))
  ((distance-gesture-p) (backup-with-distance goal distance to-loc))
  ((palm-gesture-p)
   (talk-and-echo "That gesture didn't make sense with that command.")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Optional gesture
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defcommand find-goal (goal to-loc)
  (t (FindObject goal)
     (and to-loc
	  (assert-direction-2 :direction to-loc))))

(defcommand p-get-off (goal location)
  ((has-type goal 'elevator)
   (warn "send a message to get off the elevator")))

(defcommand p-get-on (goal)
  ((has-type goal 'elevator)
   (warn "send a message to get on the elevator")))

(defcommand turn-degrees (when distance to-loc manner command query)
  (command
   (cond (when (UnImplemented))
	 ((no-gesture-p) (turn-without-gesture distance to-loc manner))
	 ((misunderstood-gesture-p) 
	  (talk-and-echo "I'm sorry. I don't understand the gesture."))
	 ((one-hand-gesture-p) 
	  (talk-and-echo
	   "I'm sorry. I didn't see you gesture in any direction."))
	 ((two-vectors-gesture-p)
	  (talk-and-echo
	   "I'm confused. You pointed in two different directions."))
	 ((vague-gesture-p)
	  (turn-with-gesture distance to-loc manner))
	 ((distance-gesture-p)
	  (talk-and-echo 
	   "I'm sorry. you gestured a distance not a direction. I'm confused."))
	 ((palm-gesture-p) 
	  (talk-and-echo
	   "That gesture didn't make sense with that command."))))
  (query nil)
  (t nil))  
   
(defcommand gesture-explore (goal to-loc relative-to manner (toggle t))
  ((null toggle) (quit))
  ((no-gesture-p) (talk-and-echo "Where?"))
  ((misunderstood-gesture-p) (talk-and-echo "I'm sorry. I don't understand the gesture."))
  ((one-hand-gesture-p) (talk-and-echo "I'm sorry. I didn't see you gesture in any direction."))
  ((two-vectors-gesture-p) (talk-and-echo "I'm confused. You pointed in two different directions."))
  ((vague-gesture-p) (explore-with-gesture goal to-loc relative-to))
  ((distance-gesture-p) (talk-and-echo "I don't understand that gesture with that command."))
  ((palm-gesture-p) (explore-with-palm-gesture goal to-loc relative-to)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; No gesture verb
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand come-direction (goal to-loc)
  ((has-type to-loc 'r-observer)
   (talk-and-echo (random-pick '("Coming." "I'm on my way." "Okay. I'm coming." "Okay. I'm on my way.")))
   (MoveToMe))
  ((has-type goal 'here)
   (talk-and-echo (random-pick '("Coming." "I'm on my way." "Okay. I'm coming." "Okay. I'm on my way.")))
   (MovetoMe)))

;;you are somewhere
(defcommand be-relative-to (theme near in-front-of behind loc query command) 
  ;; do nothing for now
  ((not (or command query))
   (cond 
    (near
     (DestinationReached near))
    (in-front-of
     (DestinationReached in-front-of))
    (behind
     (error "Don't know what to do here"))
    ((and 
      (has-type loc 'thing)
      (bind-previous-ami-request)
      (eql loc (getf (context-args *previous-context*) :loc)))
     (DestinationReached loc))
    ((and 
      (has-type loc 'goal-direction)
      (bind-previous-ami-request)
      (symbolp (getf (context-args *previous-context*) :loc)) ; just checking
      (has-type (getf (context-args *previous-context*) :loc)
		'thing))
     (DestinationReached (getf (context-args *previous-context*) :loc)))
    ((and 
      (has-type loc 'goal-direction)
      (bind-previous-askwh))
     (DestinationReached (getf (context-args *previous-context*) :theme)))
    ((and
      (has-type loc 'goal-direction)
      (bind-previous-isa-request))
     (DestinationReached (getf (context-args *previous-context*) :cotheme)))
    ((has-type loc 'goal-direction)
     (Done))
    (loc
     (DestinationReached loc))))
  (t
   nil)) ;;(say-statement "I'm right here.")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; optional palm gesture
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand follow-direction (goal to-loc)
  ((has-type goal 'r-observer)
   (FollowMe))
  ((has-type goal 'object)		; follow the signs
   (UnImplemented))
  ((no-gesture-p) (talk-and-echo "You didn't indicate anything for me to follow.")) ((misunderstood-gesture-p) (talk-and-echo "I'm sorry. I don't understand the gesture."))
  ((or (one-hand-gesture-p)
       (two-vectors-gesture-p))
   (talk-and-echo "I'm sorry. I don't understand that gesture with that command"))
  ((vague-gesture-p) (talk-and-echo "I'd prefer a path on the palm pilot to follow. Thank you. "))
  ((distance-gesture-p) (talk-and-echo "I'd prefer some kind of path, not a distance. "))
  ((palm-gesture-p) (follow-with-palm-gesture goal to-loc)))

(defcommand face-action (to-loc)
  ((and (no-gesture-p)
	(eql to-loc 'r-observer))
   (FaceMe))
  ((no-gesture-p) (face-with-no-gesture to-loc))
  ((misunderstood-gesture-p) (talk-and-echo "I'm sorry. I don't understand the gesture."))
  ((one-hand-gesture-p) (talk-and-echo "I'm sorry. I didn't see you gesture in any direction."))
  ((two-vectors-gesture-p) (talk-and-echo "I'm confused. You pointed in two different directions."))
  ((vague-gesture-p) (face-with-gesture to-loc))
  ((distance-gesture-p) (talk-and-echo "I didn't understand that gesture with that command."))
  ((palm-gesture-p) (talk-and-echo "I didn't understand that gesture with that command.")))

(defcommand robot-action (patient)
  ((eql agent patient)
     (zero)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; the p- forms are for sentences with no verbs
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand p-start (goal theme command)
  ((consp theme)			;it's a function hopefully
   (apply (car theme) :command command :start t (cdr theme)))
  ((eql theme 'query-mode)
   (ChangeMode :query))
  ((eql theme 'steered-mode)
   (ChangeMode :steered))
  ((eql theme 'scripted-mode)
   (ChangeMode :scripted)))

(defcommand p-stop (goal theme command query)
  (command
   (cond ((null theme)				;TODO
	  (quit)			
	  (say-statement "stopping"))
	 (t (apply (car theme) :command command :not (not not) (cdr theme)))))
  (query
   (cond ((null theme)				;TODO
	  ;; (say-statement "I don't know.")   
	  nil); Should be T, NIL or ? (TODO?)
	 (t (apply (car theme) :query t :not (not not) (cdr theme)))))
  (t nil))   

(defcommand p-exit (theme)
  (t (talk-and-echo "Are you sure?")))

(defcommand p-excuse (recipient)
  (t (talk-and-echo "You're welcome ")))

(defcommand p-go (goal theme)
  (t (apply (car theme) (cdr theme))))

(defcommand p-detect (theme (toggle t))
  ((and (has-type theme 'gas)
	toggle)
     (ChemSensorOn))
  ((has-type theme 'gas)
     (ChemSensorOff)))



(defcommand p-stop-specif-act (patient)
  ((has-type patient 'gas-sensor)
     (ChemSensorOff)))

(defcommand p-start-specif-act (patient)
  ((has-type patient 'gas-sensor)
     (ChemSensorOn)))

(defcommand p-listen (command query)
  (command 
   (cond (not (cond (*attention-var*
		     (say-statement "Okay. I'm not listening.")
		     (setq *attention-var* nil))
		    (t 
		     (let ((*temporarily-attentive* t))
		       (say-statement "I haven't been listening.")))))
	 (t (cond (*attention-var* 
		   (say-statement "I have been listening."))
		  (t (setq *attention-var* t)
		     (say-statement "Okay. I'm listening."))))))
  (query *attention-var*)		;bug TELLIFALL says No, none. (TODO)
  (t (cond (not (cond (*attention-var*
		       (say-statement "Yes I am. I am listening."))
		      (t 
		       (let ((*temporarily-attentive* t))
			 (say-statement "That's true. I'm not listening.")))))
	   (t (cond (*attention-var* 
		     (say-statement "Yes. I'm listening."))
		    (t (let ((*temporarily-attentive* t))
			 (say-statement "No. I'm not listening."))))))))

(defcommand p-describe (goal)
  ((has-type (get-tinsel-type goal) 'thing)
   (talk-and-echo (obj-short-descr goal))))


(defcommand p-wake ()
  (t (setf *attention-var* t)
     (WakeUp)
     (talk-and-echo "I'm awake.")))

(defcommand p-sleep ()
  (t (ChangeMode :SLEEP)
     (setf *attention-var* nil)
     (talk-and-echo "I'm sleeping.")))

;;negation does not work because the keywork not is caught in the macro
(defcommand p-pay (theme)
  ((and not
	(eql theme 'attention))
   (setf *attention-var* nil)
   (talk-and-echo "I'm not paying attention anymore."))
  ((eql theme 'attention)
   (setf *attention-var* t)
   (talk-and-echo "I'm paying attention.")))

(defcommand p-thank (recipient)
  ((eql recipient *self*)
      (talk-and-echo (random-pick '("You're welcome." "No problem." "My pleasure." "Think nothing of it.")))))

(defcommand p-say (theme command query)
  (command 
   (cond ((eql theme 'hello)
	  (Greeting))
	 ((eql theme 'goodbye)
	  (talk-and-echo (random-pick '("Goodbye." "See ya."
					"Osta la veesta, baby." 
					"over and out."))))
	 (t (say-statement (format nil "~a" theme))
	    t)))
  (query t))

(defcommand p-jump (to-loc)
  ((eql to-loc 'up)
     (talk-and-echo "How high?")
     (sleep 1.5)
     (talk-and-echo "Just kidding. A little robot humor."))
  ((null to-loc)
     (talk-and-echo "Sending message minus \"9\" \"9\" \"9\" which, in robot-talk, means I am not going to do it.")))

(defcommand p-face-action (to-loc)
  ((has-type to-loc 'r-observer) (FaceMe)))

(defcommand p-continue ()
  ((bind-previous-continuable-action)
   (talk-and-echo "Okay")
   (apply (car (context-translation *previous-context*))
	  (cdr (context-translation *previous-context*))))
  (t (talk-and-echo "I don't know what you want me to do.")))

(defcommand p-show (goal)
  ((eql (get-tinsel-type goal) 'map)
   (talk-and-echo "Loading the map.")
     (ShowMap)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  challenge 
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand p-use (theme goal to-loc up-distance down-distance command)
  ((member theme '(elevator escalator stairs))
   (cond ((or command (member 'change-floor *current-goals*))
	  (cond ((no-gesture-p)
		 (change-floor-without-gesture theme goal to-loc up-distance 
					       down-distance))
		((vague-gesture-p)
		 (change-floor-with-gesture theme goal to-loc up-distance 
					    down-distance))))
	 (t
	  (push (list 'p-use :theme theme :goal goal :to-loc to-loc
		      :up-distance up-distance :down-distance down-distance)
		*kb*))))		;TODO not just a list of forms
  ;;((and (null goal)
  ;;      (null to-loc))
  ;; (say-statement "Use it for what?"))
  (t
   (say-statement "Sorry, I don't understand what you mean by that.")))
					;TODO 'take' also maps to P-USE

;;only relies on a gesture
;(defcommand assert-direction ()
;  ((no-gesture-p)
;   (talk-and-echo "where?"))
;  ((left-gesture-p)
;   (GoObstacle 1.6d0));90 degrees
;  ((right-gesture-p)
;   (GoObstacle -1.6d0)); -90 
;  ((forward-gesture-p)
;   (GoObstacle 0.0d0))
;  ((back-gesture-p)
;   (GoObstacle PI))) ; 180 degrees

(defcommand assert-direction ()
  ((no-gesture-p)
   (talk-and-echo "where?"))
  (t (GoObstacle (get-radians))))

;;check gesture agreement
(defcommand assert-direction-1 (theme referent direction)
  ((has-type referent 'object)
   (FindObject referent))
  ((has-type referent 'location)
   (FindObject referent))
  ((eql referent *self*)
   (case direction
     (:near (Turn PI))
     (:behind (GoObstacle PI))
     (:opposite (GoObstacle PI))
     (:in-front-of (GoObstacle 0.0d0)))))

;;check gesture agreement
(defcommand assert-direction-2 (direction)
  ((or (has-type direction 'floor)
       (has-type direction 'level))
   ;;imprecise floor information
   (talk-and-echo (format nil "Where on this ~(~A~) ?" direction)))
  ((eql direction 'upstairs)
   (talk-and-echo "Which floor should I go to upstairs?"))
  ((eql direction 'downstairs)
   (talk-and-echo "which floor should I go to downstairs?"))
  ((has-type direction 'floor)  ; SCT was -location)
   (ChangeFloor 'elevator nil direction))
  ((has-type direction 'object)
   (FindObject direction))
  ((has-type direction 'location)
   (FindObject direction))
  ((or (and (left-loc-p direction)
	(right-gesture-p))
       (and (right-loc-p direction)
	    (left-gesture-p)))
   (talk-and-echo (format nil "You said something but pointed in the opposite direction")))
  ((left-loc-p direction)
   (GoObstacle *90-degrees*))
  ((right-loc-p direction)
   (GoObstacle *-90-degrees*))
  ((back-p direction)
   (GoObstacle pi))
  ((has-type direction 'direction)	;some other direction
    (talk-and-echo "Which way?"))
  (t (print 'here)
     (Unimplemented)))

(defcommand p-press (command potential)
  (potential nil)
  (command
   (say-statement "Sorry, I'm not equipped to do that")
   t)					;or nil? TODO
  (t nil))

(defcommand p-push (command potential)
  (potential nil)
  (command
   (say-statement "Sorry, I'm not able to do that")
   t)					;or nil? TODO
  (t nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; do not produce any messages for those
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcommand p-get ()
  (t (UnImplemented)))




