(in-package :NLP)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  actuator messages
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; does nothing
(defmessage noop ()
  (send-token "0 0 0"))

;;Aligns wheels with turret on Nomad robots.  Dangerous, as it
;;completely forgets the robot's previous position and places the
;;robot at 0,0,0.
(defmessage zero ()
  (send-token "1 0 0"))

;; not implemented
(defmessage GoToObject ()
  (send-token "3 0 0"))


;;Move in the relative direction <int arg> degrees.  If <str arg>
;;is the word "obstacle" then go until you reach an obstacle,
;;otherwise treat <str arg> as a distance in inches to move.
(defmessage GoGesture (degrees distance)
  (send-token (format nil "4 ~D ~D" degrees distance)))

(defmessage GoObstacle (direction)
  (send-token (format nil "4 ~D obstacle" direction)))


;;Spawn the 'Follow' process to follow the object in front of
;;the robot (not currently implemented well).
(defmessage FollowMe ()
  (send-token "5 0 0"))

;; not implemented
(defmessage FaceObject (x y)
  (send-token (format nil "7 ~D ~D" x y)))

;;turn to face position where human was when last gesture was
;;observed
(defmessage FaceMe ()
  (send-token "8 0 0"))

(defmessage FaceHier (name)
  (send-token (format nil "8 0 ~A" name)))

;;Move to position where robot was when last gesture was observed.
(defmessage MovetoMe ()
  (send-token "9 0 0"))

;;not implemented
(defmessage TurnToObject ()
  (send-token "10 0 0"))

;;OBSOLETE, Do not use.
;;add a point with the number <int arg> to the waypoint file.
(defmessage LabelCoord ()
  (send-token "11 0 0"))

;;Move the robot in a straight line for a distance of <int arg> inches,
;;WITHOUT collision avoidance.
;;If <str arg> is "l" or "left", the robot moves left.
;;If <str arg> is "r" or "right", the robot moves right.
;;If <str arg> is "f" or "forward", the robot moves forward.
;;If <str arg> is "b" or "back", the robot moves backward.
(defmessage MoveForward (distance)
  (send-token (format nil "13 ~D f" distance)))

(defmessage MoveLeft (distance)
  (send-token (format nil "13 ~D l" distance)))

(defmessage MoveRight (distance)
  (send-token (format nil "13 ~D r" distance)))

(defmessage MoveBack (distance)
  (send-token (format nil "13 ~D b" distance)))

;;Turn the robot by <int arg> degrees (+ CCW, - CW).
(defmessage Turn (degrees)
  (send-token (format nil "15 ~D 0" degrees)))

;;Go to waypoint number <in arg>.  Use the path planner and
;;collision avoidance to do it.
(defmessage GoWayPoint (pointNumber)
  (send-token (format nil "17 ~D 0" pointNumber)))

;;OBSOLETE
;;Go to a specific coordinate location, BUT, coordinates are
;;of the form "A 29", or "G 2".  letter=<str arg>, number=<int arg>.
;;Mapping from these coords to x,y is done via a fixed transform.
(defmessage GoToCoord (x y)
  (send-token (format nil "18 ~A ~D" x y)))


;;Stop the robot immediately, terminate any concurrent
;;motion processes.
(defmessage Quit ()
  (send-token (format nil "19 0 0")))


;;not implemented
(defmessage GoThroughDoor (coords)
  (send-token (format nil "20 0 0")))


;;Go to x,y location x=<int arg>, y=<str arg>
(defmessage GoToLocation (x y)
  (send-token (format nil "21 ~D ~D" x y)))

;Pick a quadrant of the map in the direction <int arg> and
;explore randomly in that quadrant.  Continue
;until timeout or interrupted.
(defmessage ExploreAreaVector (quadrant)
  (send-token (format nil "22 ~D 0" quadrant)))

;;Go to x,y location x=<int arg>, y=<str arg>
(defmessage GoToPalmXY (x y)
  (send-token (format nil "23 ~D ~D" x y)))

;;Follow a path defined by a set of x,y points.  The 
;;number of x,y points is in <int arg>, and the points are all in
;;<long arg> in the format "<x1> <y1> <x2> <y2> ...".  Stop as
;;soon as the end is reached.
(defmessage FollowPathPalm (numPoints points)
  (send-token (format nil "24 ~D ~A" numPoints points)))

;;Randomly explore an area defined by a set of x,y points.  The 
;;number of x,y points is in <int arg>, and the points are all in
;;<long arg> in the format "<x1> <y1> <x2> <y2> ...".  Continue
;;until timeout or interrupted.
(defmessage ExploreAreaPoints (numPoints points)
  (send-token (format nil "25 ~D ~A" numPoints points)))

;;Force palmhelper to send a copy of the current map to
;;the PDA display.
(defmessage ShowMap ()
  (send-token "26 0 0"))

;;Pick a quadrant of the map in the direction <int arg> and
;;follow a fixed course within in that quadrant. Continue
;;until timeout or interrupted.
(defmessage ExplorePerimVector (quadrant)
  (send-token  (format nil "27 ~D 0" quadrant)))

(defmessage ExplorePerimPoints (num points)
  (send-token  (format nil "28 ~D ~A" num points)))

(defmessage ChemSensorOn ()
  (send-token "29 0 0"))

(defmessage ChemSensorOff()
  (send-token "30 0 0"))








  
  
  


  

