;;; Release: CMUCL_standalone_port (1.9)
;;; File: environment.lisp,v
;;; File date: 2003/07/16 19:15:04 (UTC)
;;; Author: SCT

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"))

(defparameter *source-prefix*		;a kluge!
  #+solaris2 "~"
  #-solaris2 "."			;linux or windows
  )

(in-package nlp)

(defvar *debug* nil)

(defun bye ()
  (or #+allegro (exit)
      #+cmu (ext:quit)
      (format t "Don't know how to shutdown!~%")))

(defparameter *source-prefix*		;NLP::...!
  #+unix "nlp/proteus"
  #-unix "."
  )

(defun dir-delim ()
  #+unix "/"
  #-unix "\\")

(defun getenv (var)
  "Cheat on certain env vars" ;Beware 
  (cond ((equal var "NAUTILUS_HOME") "nlp/nautilus")
	((equal var "PROTEUS_HOME") "nlp/proteus")
	((equal var "TINSEL_HOME") "nlp/tinsel")
	((equal var "FOCAL_HOME") "nlp/focal")
	((equal var "FUNTRAN_HOME") "nlp/funtran")
	((equal var "ROBOT_NAME")
	 (let ((name #+ALLEGRO (system:getenv var)
		     #+CLISP (system::getenv var)))
	   (if (and name (not (equal name "")))
	       name "COYOTE")))
	(t (or #+ALLEGRO (system:getenv var)
	       #+CLISP (system::getenv var)
	       nil))))

(defvar *robots-home* 
  (if (and (getenv "ROBOTS_HOME")
	   (not (equal "" (getenv "ROBOTS_HOME"))))
      (concatenate 'string (getenv "ROBOTS_HOME") "/")))

(defvar *robots-data-home* 
  (if (and (getenv "ROBOTS_DATA_HOME")
	   (not (equal "" (getenv "ROBOTS_DATA_HOME"))))
      (concatenate 'string (getenv "ROBOTS_DATA_HOME") "/")))

(defvar *robot-name* (getenv "ROBOT_NAME"))

(eval-when (:compile-toplevel :load-toplevel :execute)
 (defun load-dir-file (dir file)
   (let ((p (pathname (concatenate 'string dir file))))
     #-GCL (load p)
     #+GCL (if (probe-file p)(load p)
	     (unless (pathname-type p)
	       (let ((po (make-pathname :type "o" :defaults p))
		     (ps (make-pathname :type "lisp" :defaults p)))
		 ;; could also put in file-write-date comparisons
		 (if (probe-file po)(load po)(load ps)))))
     )))


(defparameter *compile* t)
(defparameter *recompile* nil)

(defun too-old-compile-p (filename)
  (let ((date (file-write-date (compile-file-pathname filename))))
    (or (null date)
	(< date (or (file-write-date filename)
		    (file-write-date
		     (concatenate 'string filename ".lisp")))))))	   

(defun load-compile (filename &optional prefix &key suffix)
  (declare (ignore suffix))
  (let ((pathname (format nil "~A~A" (or prefix *source-prefix*) filename)))
    (when *compile* 
      (if (or *recompile*
	      (too-old-compile-p pathname))
	  (compile-file pathname)))
    (load pathname)))
