;;; Release: CMUCL_standalone_port (1.5)
;;; File: extract-code.lisp,v
;;; File date: 2003/07/16 18:45:04 (UTC)
;;; Author: SCT

;;; If necessary, extend SET-FEATURES to add system-dependent
;;; symbols to *FEATURES*

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (export '(extract-nlp			;probably should be elsewhere
	    extract-code))
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "general/util"
		   "packages"		;needed for ~nlp extraction
		   "environment"))

(defparameter *nautilus-filenames* "nautilus-filenames")

(defparameter *skipped-defuns* nil)
(defparameter *skipped-defmacros* nil)
(defparameter *skipped-defvars* nil)
(defparameter *skipped-defparameters* nil)
(defparameter *skipped-defpackages* nil)
(defparameter *source-file* nil)

(defun without-no (file)
  (concat (prefix file ".") "." (suffix file ".")))

(defun without--rl (file)
  (concat (subseq file 0 (or (search "-rl" file) 
			     (position #\. file)))
	  "."
	  (suffix file ".")))

(defun source-file-name (name)
  (concat *source-prefix* (without--rl
			   (without-no name))))

(eval-when (:compile-toplevel :load-toplevel :execute)
 (let ((table (make-hash-table :test 'eq)))
   (defun clear-table ()
     (clrhash table))
   (defun good-number-p (nums symbol)
     (cond-it ((gethash symbol table)
	       (incf (gethash symbol table))
	       (member (1+ it) nums))
	      (t (setf (gethash symbol table) 0)
		 (if (member 0 nums)
		     t
		   nil))))
   (defun skip-em (elt list)
     (or (member elt list)
	 (and-it (member elt list :key 'safe-rcar)
		 (good-number-p (cdar it) elt))))))

(defparameter *tag* "[redefined]")

(defun cut (outstream elt)
  (format outstream "~%~%;; ~s" *tag*)
  (comment-with ";; " outstream "~s" elt))

(defparameter *trace-read-conditionals* nil)

(defun set-up-read-conditionals ()
  ;; TODO ...
  (let ((plus (get-dispatch-macro-character #\# #\+))
	(minus (get-dispatch-macro-character #\# #\-)))
    (declare (ignore minus))
    (set-dispatch-macro-character 
       #\#
       #\+
       #'(lambda (stream char num)
	   (funcall plus stream char num)))))	   
    
(defun set-features (&key allegro clisp)
  (let ((features *features*))
    (if (not allegro)
	(setq features (remove-if #'(lambda (s)
				      (search "ALLEGRO" (symbol-name s)))
				  features))
      (pushnew :allegro features))
    (if (not clisp)
	(setq features (remove-if #'(lambda (s)
				      (search "CLISP" (symbol-name s)))
				  features))
      (pushnew :clisp features))))
    
(defun extract-code (&key
		     (outstream t)
		     (file "nlp/nautilus/src/nautilus.no.lisp")
		     (printer #'(lambda (elt) 
				  (let ((*print-pretty* t))
				    (format outstream "~%~%~s" elt))))
		     (commenter #'(lambda (line)
				    (format outstream "~%~a~%" line)))
		     (cutter 'cut)
		     (allegro t)
		     (clisp nil)
		     )
  (let ((*skipped-defuns* nil)
	(*skipped-defmacros* nil)
	(*skipped-defvars* nil)
	(*skipped-defparameters* nil)
	(*skipped-defpackages* nil)
	(*source-file* nil)
	(*features*			;Dangerous?
	 (set-features :allegro allegro :clisp clisp)))
    (clear-table)
    (cond ((probe-file file)
	   (load file)
	   (if (null *source-file*)
	       (setq *source-file* (source-file-name file))))
	  (t
	   (setq *source-file* (source-file-name file))))
    (let ((*readtable* (copy-readtable)))
      (if *trace-read-conditionals*
	  (set-up-read-conditionals))
      (set-macro-character 
       #\newline
       #'(lambda (stream char)
	   (declare (ignore stream)
		    (ignore char))
	   (values)))
      (mapfile-with-comments
       #'(lambda (comments elt)
	   (dolist (comment comments)
		   (funcall commenter comment))
	   (if (atom elt)
	       (funcall printer elt)
	     (case (car elt)
		   (defun (if (not (skip-em (second elt) *skipped-defuns*))
			      (funcall printer elt)
			    (funcall cutter outstream elt)))
		   (defmacro (if (not (member (second elt)
					      *skipped-defmacros*))
				 (funcall printer elt)))
		   (defvar (if (not (member (second elt) 
					    *skipped-defvars*))
			       (funcall printer elt)
			     (funcall cutter outstream elt)))
		   (defparameter
		     (if (not (member (second elt) 
				      *skipped-defparameters*))
			 (funcall printer elt)
		       (funcall cutter outstream elt)))
		   (defpackage (if (not (member (second elt)
						*skipped-defpackages*
						:test 'equal))
				   (funcall printer elt)
				 (funcall cutter outstream elt)))
		   (t (funcall printer elt)))))
       *source-file*
       :comment-chars '(#\; #\newline)))))

;; Bug: Package NLP must be defined before extraction

(defun extract-nlp (&key (filenames-file *nautilus-filenames*)
			 (allegro t)
			 (clisp nil))
  (dofile (name filenames-file)
    (with-open-file (out (without-no name)
			 :direction :output :if-exists :supersede)
      (format out ";;;;;;;;;;;;;;;;;;;~%")
      (format out ";;;~%")
      (format out ";;; DO NOT EDIT!~%")
      (format out ";;;~%")
      (format out ";;; This file was extracted automatically from~%")
      (format out ";;;   ~s~%" (source-file-name name))
      (format out ";;;~%")
      (format out ";;; Original comments are retained, but may not apply,~%")
      (format out ";;; because of code filtering; ie, some code has been~%")
      (format out ";;; commented out. Such code is tagged '~a'.~%" *tag*)
      (format out ";;;~%~%")
      (format t "; ~s~%" name)
      (extract-code :outstream out :file name :allegro allegro :clisp clisp)
      (values))))

(defun load-nlp (&optional (os-name "Solaris"))
  (extract-nlp)
  (let ((*package* (find-package "NLP")))
    (cl-user::confirm-modules "proteus"
			      "nlp/proteus/basics/foreach"
			      "nlp/nautilus/src/nautilus"
			      "nlp/proteus/enhance/ptop-core"
			      "nlp/proteus/enhance/semchart"
			      "nlp/funtran/qx"
			      )))

(defun dump-nlp (&optional (os-name "Solaris"))
  (load-nlp os-name)
  (let ((*package* (find-package "NLP")))
    #+allegro(dumplisp :name (format nil "bin/~a/nautilus-core.dxl" os-name))
    ))
