;;; Release: CMUCL_standalone_port (1.4)
;;; File: ff.lisp,v
;;; File date: 2003/07/15 19:53:06 (UTC)
;;; Original Author: ?? (M. Abramson?)
;;;
;;; Major rewrites: 2/20 SCT (for FOREIGN-DEFUN macro)

;;; ff.lisp,v 1.4 2003/07/15 19:53:06 thomas Exp

;;; Foreign function declaraions.
;;;
;;; All foreign funcall calls should be made via FOREIGN-DEFUN,
;;; defined below. Redefine as needed for different implementations.

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "environment"
		   ;;"ipc"
		   ))

(in-package :NLP)

(defvar *gesture-c-home* (or (getenv "GESTURE_C_HOME")
			     ""))

#+:MSWINDOWS (load-dir-file *gesture-c-home* "/comm.dll")
#+:MSWINDOWS (load-dir-file *gesture-c-home* "/coord.dll")
#+:MSWINDOWS (load-dir-file *gesture-c-home* "/robot_foreign.dll")
#+:MSWINDOWS (load-dir-file *gesture-c-home* "/reco_comm.dll")
;; #+:MSWINDOWS (load (concatenate 'string *robots-home* "/bin/Comm.dll"))

(handler-case
 (progn
   #+:UNIX (load (concatenate 'string *gesture-c-home* "/" "robotinterface.so")))
 (error  ()))

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defun way-downcase (s)
    (substitute #\_ #\- (string-downcase (string s)))))

;;; Skeletal definitions for CLisp

(defparameter *types-allegro-to-clisp*
  '((:int . int)
    (:void . ?)				;??
    ((* :char) . c-string)
    (((* :char)) . c-string)
    (:short . int)			;??
    (:float . single-float)		;??
    )
  "An alist of Allegro foreign types and Clisp foreign types"
  )

(defun clisp-foreign-type (type)
  "Return CLisp foreign type corresponding to Allegro foreign type"
  (cdr (assoc type *types-allegro-to-clisp* :test 'equal)))

#+(and CLISP (not standalone))
  (defmacro foreign-defun (name params
				&key (fname (way-downcase name)) ;foreign-name
				(returning :int) 
				(strings-convert t))
    (declare (ignore strings-convert)) ;??
    "Foreign DEFUN for CLisp"
    `(ffi:def-call-out ,name
					; ... TO DO
		       (:return-type (clisp-foreign-type ,returning))))

;;; Definition for Allegro is complete (for now anyway)

#+(and ALLEGRO (not standalone))
  (defmacro foreign-defun (name params
				&key (fname    ;foreign-name
				      (way-downcase name)) 
				(returning :int)
				(strings-convert t))
    "Foreign DEFUN for Allegro"
    `(ff:def-foreign-call (,name ,fname)
			  ,params
			  :returning ,returning
			  :strings-convert ,strings-convert))

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'foreign-defun))
      (defmacro foreign-defun (name params &key &allow-other-keys)
	(declare (ignore params))
	`(defun ,name (&rest r &key &allow-other-keys)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Example expansions (Allegro):
;;
;;; (foreign-defun clear-gesture ()) 
;;  
;;  => (ff:def-foreign-call (clear-gesture "clear_gesture") 
;;           ()
;;           :returning :int 
;;           :strings-convert t)
;;
;;; (foreign-defun point-to-location-coords ((xval :int)
;;                                           (yval :int))
;;      :fname "RF_point_to_location_coords"
;;	:returning ((* :char)))
;;
;;  => (ff:def-foreign-call (point-to-location-coords 
;;                           "RF_point_to_location_coords")
;;           ((xval :int)
;;            (yval :int)) 
;;           :returning ((* :char)) 
;;           :strings-convert t)


;;; Old Allegros may need something like:
;; (if (equal returning '((* :char)))
;;     `(ff:char*-to-string
;;        (ff:def-foreign-call ... :returning :int ...))


(defmacro fdefun (name params &rest r)
  ;; Additional, system-independent functionality to be added here
  ;;
  `(foreign-defun ,name ,params ,@r))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;          viavoice
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(fdefun WSA-startup ()
	:fname "startup"
	:returning :short)

(fdefun WSA-cleanup ()
	:fname "cleanup"
	:returning :void)

(fdefun init-server () :returning :short)

(fdefun accept-client () :returning :short)

(fdefun init-client ((hostname (* :char))) :returning :void)
 
(fdefun get-viavoice-message ()
	:fname "receive_message"
	:returning ((* :char)))

(fdefun connect-server ((hostname (* :char))) :returning :short)

(fdefun close-port () :returning :void)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;       gestures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(fdefun clear-gesture ())

(fdefun get-gesture-helper () 
	:fname "RF_get_gesture"
	:returning ((* :char)))


(fdefun get-robot-state ()
	:fname "RF_get_robot_state"
	:returning ((* :char)))

(fdefun get-location-coords ((direction :int))
	:fname "RF_direction_to_location_coords"
	:returning ((* :char))) 

(fdefun point-to-location-coords ((xval :int)
				  (yval :int))
	:fname "RF_point_to_location_coords"
	:returning ((* :char)))

(fdefun send-gesturepose ((gestpose (* :char))) :fname "RF_send_gesturepose")

(fdefun init-robot ((interface_name (* :char))
		    (interface_port :int)
		    (nserver_name (* :char))
		    (nserver_port :int)
		    (robot_name (* :char))
		    (realrobot :int))
	:fname "RF_init_robot")


(fdefun trpl-talk ((msg (* :char))) :fname "RF_talk")

(fdefun which-waypoint ((direction :int)) :fname "RF_which_waypoint")

(fdefun init-gesture ((gesturemachine_name (* :char)) 
		      (gesture_port :int)
		      (gesture_wait :float)
		      (gesture_age :float))
	:fname "RF_init_gesture")		     

(fdefun send-token2 ((tokstr (* :char))) :fname "RF_send_token")
   
(defun send-token (string)
  (let ((r (send-token2 string)))
    (save-action (list* 'send-token string r))
    r))

(fdefun load-waypoints () :fname "COORD_load_waypoints")

(fdefun load-locations () :fname "COORD_load_locations") 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; the following functions are related to the spatial relationship
;; work that we started adding through Marge Skubic's work, summer 2001.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(fdefun init-spatial ((spatialmachine_name (* :char))
		      (spatial_port :int))    
	:fname "RF_init_spatial")

(fdefun get-num-objects () :fname "RF_spatial_get_num_objects")

(fdefun get-hl-descrip ()
	:fname "RF_spatial_get_hl_descrip"
	:returning ((* :char)))

(fdefun send-weather-request ((location (* :char))) :returning ((* :char)))

(fdefun get-hl-dir-helper ()
	:fname "RF_spatial_get_hl_descrip_dir"
	:returning ((* :char)))

(defun get-hl-dir (dir)
  (get-hl-dir-helper dir))		;TODO dir?

(fdefun get-nearest-obj ((objdata (* :char)))
	:fname "RF_spatial_get_nearest_obj"
	:returning ((* :char)))

(fdefun get-det-descrip ((obj (* :char)))
	:fname "RF_spatial_get_det_descrip"
	:returning ((* :char)))

(fdefun assign-label ((objnum :int)
		      (label (* :char)))
	:fname "RF_spatial_assign_label")

(fdefun get-object-info ((buf (* :char))
			 (fieldnum :int))
	:fname "RF_spatial_get_object_info"
	:returning ((* :char)))

(fdefun get-object-descrip ((obj (* :char)))
	:fname "RF_spatial_get_obj_descrip"
	:returning ((* :char)))

(fdefun get-object-point ((label (* :char))
			  (dir (* :char)))
	:fname "RF_spatial_get_obj_point"
	:returning ((* :char)))

(fdefun get-object-points ((label (* :char)))
	:fname "RF_spatial_get_obj_points"
	:returning ((* :char)))

(fdefun get-point-between ((label1 (* :char))
			   (label2 (* :char)))
	:fname "RF_spatial_between"
	:returning ((* :char)))

(fdefun mmi-init ()
	:fname "MMI_init"
	:returning :void)

