;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;focal.lisp,v 1.4 2003/07/14 19:05:39 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules  "packages"
		    "prediscr"
		    ))

(in-package nlp)

;;FOCAL calls found-elt to resolve unmodified NPs ("the box")
;;and lookup on modified ones ("the red box", "the box under the block").

(defun lookup (mod-list det number type &optional no-error relcls nlist)
  (let*  ((world (append *objlist* (and (or (null *check-init*)
					    (and *spatial-init*
						 (not (find type *objlist* 
							    :test #'eql))))
					(robot-objects type mod-list relcls
						       *objlist*))))
	  (result (lookup-sub mod-list world relcls nlist)))
    
    (process-det-and-number result (IF (AND (EQ DET 'NULL-DET)
					    (GETF MOD-LIST :ID))
				       'THE
				       DET)
			    number type)))


(defun world-elts (olist type spec det)
  (let ((elts (append olist (if (EQ DET 'SOME)
				(list (make-object type)) ;make a fake object
			      (and (or (null *check-init*)
				       (and *spatial-init*
					    (not (find type olist 
						       :test #'eql))))
				   (robot-objects type spec olist))))))
    elts))

(defun found-elt (type spec olist det val)
  (let* ((world (world-elts *objlist* #|olist|# type spec det))	;SCT #||#
	 (result (if (and (eql type 'system)
			  (null spec))
		     (found-elt-sub 'system *self* world)
		     (found-elt-sub type spec world))))
    (process-det-and-number result det val type)))


;;; [KW] CHECK-RELCLS: A hook for an application-specific function for
;;; checking the truth conditions imposed by restrictive relatives and
;;; predicate adjectives (THE FIGHTERS THAT ARE MOVING, THE MOVING
;;; FIGHTERS).

(defun check-relcls (object relcls nlist)
  (or (null relcls)
      (every #'(lambda (relcl)(check-relcl object relcl nlist)) relcls)))

(defun check-relcl (object relcl nlist &aux pred)
  (setq pred (second (my-assoc :CLASS relcl)))
  (cond 
   ((not (fboundp pred)) nil)
   (t (check-facts object relcl nlist))))

(defun check-facts (object relcl nlist)
  (declare (special nlist))
  (let ((tr (querify			;SCT
	     (translate-lf relcl :object object))))
    (eval tr)))

(defun flambda (foc)
  (destructuring-bind (var type class &optional arg argval) ;SCT TODO check!
		      foc
		      (when (keywordp arg)
			(list arg argval))))

(defun collect-args-from-parse ()
  (declare (special *alt-foc-list*))
  (mappend 'flambda
	   *alt-foc-list*))


(DEFUN FIND-REF (ANAPH &OPTIONAL (NO-ERROR t) MODIFIERS)
  (IF MODIFIERS
      NIL
    (IF (NOT (EQUAL (FOURTH ANAPH) ':AGENT))
        (VALID-REF ANAPH NO-ERROR MODIFIERS)
      (IF (CAN-REF? ANAPH *ACTOR-FOCUS* NO-ERROR MODIFIERS)
          (CONS ANAPH *ACTOR-FOCUS*)
        (VALID-REF ANAPH NO-ERROR MODIFIERS)))))
