;;foreign.lisp,v 1.1.1.1 2003/05/16 16:20:27 thomas Exp



(eval-when (load compile)
  (defpackage "NLP"
    (:use "COMMON-LISP" "FFI")))

(in-package "NLP")

(def-call-out write-comm
  (:name "write_comm")
  (:arguments (channel int)
              (buf c-string)
              (bufsize int))
  (:return-type int))
  
;(def-call-out read-comm
;  (:name "read_comm")
;  (:arguments (channel int)
;              (buf (c-ptr (c-array-max 2048)) :out :alloca)
;              (bufsize int))
;  (:return-type int))

(def-call-out init-internet-client
  (:name "init_internet_client")
  (:arguments (name c-string)
              (port int))
  (:return-type int))

(def-call-out get-gesture
  (:name "RF_get_gesture")
  (:return-type c-string))

(def-call-out get-robot-state
  (:name "RF_get_robot_state")
  (:return-type c-string))

(def-call-out get-location-coords
  (:name "RF_direction_to_location_coords")
  (:arguments (i int))
  (:return-type c-string))

(def-call-out point-to-location-coords
  (:name "RF_point_to_location_coords")
  (:arguments (x int)
	      (y int))
  (:return-type c-string))

(def-call-out send-gesturepose
  (:name "RF_send_gesturepose")
  (:arguments (gestpose c-string))
  (:return-type int))

(def-call-out init-robot
  (:name "RF_init_robot")
  (:arguments (name c-string)
	      (port int)
	      (servername c-string)
	      (serverport int)
	      (robotname c-string)
	      (realrobot int))
  (:return-type int))


(def-call-out talk
  (:name "RF_talk")
  (:arguments (msg c-string))
  (:return-type int))

(def-call-out which-waypoint
  (:name "RF_which_waypoint")
  (:arguments (direction int))
  (:return-type int))

(def-call-out init-gesture
  (:name "RF_init_gesture")
  (:arguments (hostname c-string)
	      (port int)
	      (wait single-float)
	      (age  single-float))
  (:return-type int))

(def-call-out send-token
  (:name "RF_send_token")
  (:arguments (tostr c-string))
  (:return-type int))

(def-call-out load-waypoints
  (:name "COORD_load_waypoints")
  (:return-type int))

(def-call-out load-locations
  (:name "COORD_load_locations")
  (:return-type int))

(def-call-out init-spatial
  (:name "RF_init_spatial")
  (:arguments (hostname c-string)
	      (port int))
  (:return-type int))

(def-call-out get-num-objects
  (:name "RF_spatial_get_num_objects")
  (:return-type int))

(def-call-out get-hl-descrip
  (:name "RF_spatial_get_hl_descrip")
  (:return-type c-string))

(def-call-out get-nearest-obj
  (:name "RF_spatial_get_nearest_obj")
  (:arguments (obj c-string))
  (:return-type c-string))

(def-call-out get-det-descrip
  (:name "RF_spatial_get_det_descrip")
  (:arguments (obj c-string))
  (:return-type c-string))

(def-call-out get-obj-points
  (:name "RF_spatial_get_obj_points")
  (:arguments (label c-string))
  (:return-type c-string))

(def-call-out assign-label
  (:name "RF_spatial_assign_label")
  (:arguments (objnum int)
	      (label c-string))
  (:return-type int))

(def-call-out get-object-descrip
  (:name "RF_spatial_get_obj_descrip")
  (:arguments (obj c-string))
  (:return-type c-string))




