;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;funtran.lisp,v 1.5 2003/07/14 19:04:28 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   "generation"
		   ))

(in-package :NLP)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (cl-user::confirm-modules "nlp/proteus/basics/foreach"
			    ))

 ;;; ======================================================================
 ;;; FUNTRAN (FUNctional TRANslator)

 ;;; Kenneth Wauchope
 ;;; Navy Center for Applied Research in Artificial Intelligence
 ;;; Naval Research Laboratory, Code 5512
 ;;; Washington, DC 20375-5337

 ;;; Submits TINSEL expressions to FOCAL reference resolution and then
 ;;; translates them into quantified logic expressions.
 ;;; ======================================================================
 ;;; DOMAIN-SPECIFIC HOOKS

 ;;; These can be given application-specific redefinitions elsewhere.

 ;;; November 18, 1996 Dennis Perzanowski: Attempting to modify code to
 ;;; enable robot interface.  Specifically, to get robot discourse totally
 ;;; on the side of the natural language processing side of the interface.
 ;;; Starting here with process-parses to see if a gesture has been made.

 ;;; PROCESS-PARSES is the PROTEUS hook for post-parse processing.

;; SCT replaced *YOU* by func call
(defun save-discourse-context ()
  (declare (special *actor-focus* *cur-focus* *foc-stack* *alt-foc-list*
	      #| *you* |# *deictics* *num-deictics*))
  (list *actor-focus* *cur-focus* *foc-stack* *alt-foc-list* 
	(last-named-addressee)
	*deictics* *num-deictics*))

(defun restore-discourse-context (context)
  (declare (special *actor-focus* *cur-focus* *foc-stack* *alt-foc-list*
                 #| *you* |#
		 ))
  (set-named-addressee :to (fifth context))
  (setq *actor-focus* (first context)
	*cur-focus* (second context)
	*foc-stack* (third context)
	*alt-foc-list* (fourth context)
     ;; *you* (fifth context)
	*deictics* (sixth context)
	*num-deictics* (seventh context)))

(defun process-parses (parselist)
  (declare (special *prior-succeeded* *original-context* current-context
		    *previous-robot-context*))
  
  (tally-deictics)
  (catch 'process-parses
    (setq *prior-succeeded* nil)
    (setq *original-context* (save-discourse-context)) ;store list of specials
    (let ((lfs (remove-if #'(lambda (lf) (not (has-semantics lf)))
			  (foreach p in parselist collect (get-lf p)))))
      (declare (special lfs))
      (format t "~%lfs= ~%")
      (pprint lfs)
      (terpri)
      (cond ((null lfs)
	     (talk-and-echo "Sorry, I don't understand."))
	    (t ;;(setf (context-lfs current-context) (car lfs))
	      ;;;; TODO uncomment this---but Allegro claims setf func undef!!
	     (run-discourse-and-translate lfs))))))
	
; Added to handle relative directions, such as "my/your left", 
; as well as "the left"--based on Ken Wauchope's work in MMWS. 9/5/97

(defun has-functional-type (val)
  (and (consp val)
       (if (member (first val) '(AND OR))
	   (has-functional-type (third val))
	 (has-type (get-class val) 'FN))))

(defun referential-ambiguity-error (context)
    (restore-discourse-context context)
    ;; (talk-and-echo "I'm sorry.  That was an ambiguous sentence.")
    (error 'ambiguity))

;(defun existential (pred)(eq pred 'EXIST-P))

;; need some summarization here instead of an enumeration (ma 01-02-02)
(defun format-answer (list)
  (let* ((first (first list))
	 (string (format-element first))
	 (rest (cdr list)))
    (if rest
	(concatenate 'string string 
		     (if (cdr rest) ", " " and ")
		     (format-answer rest))
      string)))

(defun format-id-elt (elt)
  (format nil "~(~A~) number ~D" (get-tinsel-type elt) (get elt :ID)))
			    
(defun format-element (elt) 
  (cond ((or (physobj-p elt)
	     (description-p elt))
	 (obj-short-descr elt))
	((has-type elt 'the-time-now)
	 (make-object-of-type 'c-time))
	((symbolp elt) 
	 (if (get elt :ID)
	     (format-id-elt elt)
	   (format nil "~(~{~a~^ ~}~)" (add-determiner elt))))	;SCT
	(t (format nil "~A" elt))))

(defun display-lf (lf)
  (declare (special *show-nlp-output*))
  (save-lf lf)
  (when *show-nlp-output*
	(format t "~%;Semantic interpretation:~%")(pprint lf)(terpri)))

(defun display-tr (tr &optional (label "Translation"))
  (declare (special *show-nlp-output*))
  (save-trans tr)
  (when *show-nlp-output*
	(format t "~%;~a:~%" label)
	(pprint tr)
	(terpri)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; macros
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;find a common class
;;for now just get the first class
(defun supclass (things)
  (get-tinsel-type (first things)))

;;the first setof identifies the subject
(defmacro tellhowmany (theme)
  `(let* ((answer ,theme)
	  (semclass (supclass answer)))
;;     (parser-answer response)
     (if (null answer)
	 (talk-and-echo "I don't sense anything")
       (talk-and-echo (format nil "I sense ~R ~(~A~:*~:P~)." (length answer) semclass)))
     (print "tellhowmany")
     (print semclass)
     (print answer)
     (generate-de-for-set answer)))

;;the first setof identifies the subject
;;we simplify here not to do the negative set "but ..."

; (defmacro tell (theme)
;   `(let* ((pos-set ,theme))
;      (if (stringp pos-set)
; 	 (talk-and-echo pos-set)
;        (let* (
; 	  (semclass (supclass pos-set))
; 	  (response (cond ((null pos-set) ; no cases
; 			   (cond ((has-type semclass 'THING)
; 				  "I sense nothing."); WHQ-N "what"
; 				 ((has-type semclass 'AGENT)
; 				  "I sense no one") ; WHQ-N "who"
; 				 (t "I don't sense anything"))); other WH(N)Q-N
; 			   ;; otherwise enumerate the cases
; 			   (t (format nil "~A" (format-answer pos-set))))))
;      (print "tell ")
;      (print semclass)
;      (print pos-set)
;      (talk-and-echo (string-downcase response))
;      (generate-de-for-set pos-set)))
;      ))


(defun process-translation2 (tr nlist &aux pred)
  (declare (special *performatives* *correction* *nextcode* nlist
		    *previous-qx* *alt-foc-list *previous-alt-foc-list*))
  (setq *previous-alt-foc-list* *alt-foc-list*)
  (cond ((not (consp tr))
					;ignore SCT
	 )
	((or (not (fboundp (first tr)))
	     (and (member (first tr) *performatives*)
		  (and (consp (second tr))
		       (not (fboundp (first (second tr)))))))
	 (parser-answer "Sorry, I cannot translate that."))
	(t (parser-message "[done] ")
	   (if (or (not (member (first tr) *performatives*))
		   (eq (first tr) 'COMMAND)
		   (or (stringp (second tr))
		       (queriable-pred (second tr))))
	       (if (stringp tr) tr
		 (if (fboundp (setq pred (predicate-of tr)))
;;; Finally, evaluate!-
		     (if *evaluate* 
			 (let ((*be-polite-now* nil))
			   (evaluate-tr tr))
		       (format t "~%(*EVALUTE* is NIL)~%"))
		   (parser-answer (format nil "Predicate ~A not defined."
					  pred))))
	     (parser-answer "I don't know.")))))

(defun process-translation (command etc)
  (handler-bind
   ((undefined-function 
     #'(lambda (condition) 
	 (cond ((and (consp command)
		     (eq (first command) 'command))
		(error 'bad-command))
	       (t			;other tests here?
		(let ((fname (cell-error-name condition)))
		  (store-value (default-function fname) condition)))
	       ;;(t
	       ;;  (error 'bad-utterance)))
	       ))))
   (process-translation2 command etc)))

(defun add-performative (type qx)
  (if (stringp qx)
      (list 'TELL qx)
    (let ((set-former (cond ((member (first qx) '(FORALL FORMOST FORMANY))
			     (if (eq 'setof (car (fourth qx)))
				 `(,(car (fourth qx)) ,(second (fourth qx))
				   ,(third (fourth qx))
				   (,(first qx) ,(second qx)
				    ,(third qx)
				    ,(fourth (fourth qx))))
			       `(SETOF ,@(cdr qx))))
			    ((member (first qx) '(EXISTS EXISTS!))
			     `(SETOF ,@(cdr qx)))
			    ((eq (first qx) 'NOT)
			     `(SETOF ,@(cdr (second qx))))
			    (t qx)))
	  (perform (case type
			 (ASKWH    'TELL)
			 (ASKCOUNT 'TELLHOWMANY)
			 (ASKQUANT 'TELL)         ; answer is a string
			 (IMPER    'COMMAND)
			 (REQUEST (case (first qx)
					(EXISTS  (if (comparative (third qx))
						     'TELLIFCOUNT
						   'TELLIFANY))
					(NOT     (if (eq (first (second qx))
							 'EXISTS!)
						     'TELLIF
						   'TELLIFNONE))
					(FORMANY 'TELLIFMANY)
					(FORMOST 'TELLIFMOST)
					(FORALL  'TELLIFALL)
					(t       'TELLIF))))))
      (case perform
	    ((TELLIF COMMAND) (list perform qx))
;;;	    ((TELLIFALL TELLIFANY) (list perform set-former (third qx)))

	    (t (list perform set-former))))))

(defun soft-quote (form)
  ;; SCT
  (mapcar #'(lambda (elt)
	      (if (or (is-var elt)
		      (constantp elt))
		  elt
		(list 'quote elt)))
	  form))

(defmacro pred (form)
  ;; SCT wrap forms with PRED, prettier than (LIST 'P-FOO :AGENT X34 ...) ??
  `(list ,@(soft-quote form)))

;; from ~nlp/funtran/funtran.lisp
(defun process-filler (filler object index-vals)
  (cond ((is-var filler)
         (if object (list 'quote object)
           (or (second (my-assoc filler index-vals))
               filler)))
        ((or (numberp filler)(stringp filler)) filler)
        ((HAS-FUNCTIONAL-TYPE filler)
	 (if (is-referential filler)
	     ;; change (DET VAR CLASS NUMBER MODS) to (VAR CLASS MODS)
	     (quantif (append (list (second filler)
				    (third filler))
			      (nthcdr 4 filler))
		      nil index-vals nil nil
		      :object object)
	   (quantif filler nil index-vals nil nil :object object)))
        ((is-referential filler)
         (second (my-assoc (second filler)
                           (if (is-each-other filler)
                               (reverse index-vals)
                             index-vals))))
	(t (let ((result
		  (quantif filler nil index-vals nil nil :object object)))
	     (if (consp result)
		 (list 'pred result)	;SCT
	       (list 'quote result))))))

;;(defun is-wh-np (val)
;;  (and (consp val)(member (first val) '(WHICH MANY MUCH WHERE-AT-WHICH))))
