;;; Release: CMUCL_standalone_port (1.5)
;;; File: modules.lisp,v
;;; File date: 2003/07/16 18:59:18 (UTC)
;;; Author: SCT

(in-package cl-user)

;; Warning: FIND-FILE searches up the directory tree for a place from which
;; a given relative path is found by PROBE-FILE

(defvar *lisp-modules* nil)

;; Bug! (?) filenames in system must be unique

(defparameter *dir-delim* 
  #+unix "/"
  #-unix "\\")

(defun one-up (name)
  (subseq name 0 (position (elt *dir-delim* 0) name :from-end t)))

(defun find-file (filename &optional (dir (one-up (namestring 
						   (car (directory 
							 (make-pathname
							  :name :wild)))))))
  (let ((name (concatenate 'string dir *dir-delim* filename ".lisp")))
    (cond ((probe-file name) name)
	  ((equal dir "") nil)
	  (t (find-file filename (one-up dir))))))

(defun confirm-module (file)
  (let ((path (find-file file)))
    (if path 
	(handler-bind
	 ((error #'(lambda (e)
		     (cond ((or (not (boundp '*debug*))
				(not *debug*))
			    (format t "; ERROR: ")
			    (write e :escape nil :stream t)
			    (return-from confirm-module))))))
	 (let* ((date (file-write-date (compile-file-pathname path)))
		(position (position (elt *dir-delim* 0) file :from-end t))
		(name (subseq file (if position (1+ position) 0)))
		(record (assoc name *lisp-modules* :test #'equal)))
	   (cond ((or (null date)
		      (< date (file-write-date path)))
		  (setq date (file-write-date (compile-file path)))))
	   (cond ((null record)
		  (push (cons name date) *lisp-modules*)
		  (load (subseq path 0 (position #\. path :from-end t))))
		 ((< (cdr record) date)
		  (setf (cdr record) date)
		  (load (subseq path 0 (position #\. path :from-end t)))))))
      (cond ((or (not (boundp '*debug*))
		 (not *debug*))
	     (format t "; ERROR: Can't find file ~s" file)
	     (return-from confirm-module))
	    (t (error "Can't find ~s" file))))))

(defun confirm-modules (&rest files)
  (dolist (file (or files (mapcar 'car *lisp-modules*)))
    (confirm-module file)))
