(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "packages"
		   ))

(in-package nlp)

(defun nominal-p (elt)
  (and (symbolp elt)
       (eq 'n (car (get elt 'word-defn)))))       

(defun singular-p (elt)
  (and (symbolp elt)
       (member 'singular (second (get elt 'word-defn))))) ;TODO check

(defun mass-noun-p (elt)
  (and (symbolp elt)
       (member 'nmass (second (get elt 'word-defn)))))

(defun add-determiner (elt)
  "Maps the symbol ELT to the list ([DET] ELT)"
  (if (nominal-p elt)
      (if (singular-p elt)
	  (if (mass-noun-p elt)
	      (list 'some elt)
	    (list (if (member (elt (string elt) 0)
			      '(#\A #\E #\I #\O #\U
				#\a #\e #\i #\o #\u))
		      'an 'a)
		  elt))
	(list 'some elt))
    (list elt)))
	
