;; ipc-functions.lisp,v 1.13 2003/07/16 18:45:04 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
	   (if (not (fboundp 'confirm-modules))
	       (load "general/modules"))
	   (confirm-modules "packages"
			    "environment"
			    "config"
			    ))

(in-package nlp)

(defvar *challenge-dir* (or (getenv "CHALLENGE_ROOT") ""))

(defparameter *mmi-lib* 
  (or (getenv "MMI_LIB")
      (concatenate 'string *challenge-dir* "/lib/" "libmmi.so"))
  )

(cond ((and *mmi* (not (probe-file *mmi-lib*)))
       (cond (*mmi-just-warn?*
	      (warn "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
	      (warn "!!")
	      (warn "!! Can't find ~s" *mmi-lib*)
	      (warn "!!")
	      (warn "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"))
	     (t (error "Can't find ~s" *mmi-lib*))))
      (*mmi*
       (load *mmi-lib* :print t :verbose t)))

(defvar *utterances* nil)

(defvar *internal-real-time-offset* (get-internal-real-time)) ;for fractional seconds

(defconstant DO_EXPRESSION_MSG "DoExpression")

;; 5/9/03  Commented out to fix MMI; this message
;; doesn't seem to be defined anywhere and we
;; have no clue what it's for.
;(defconstant SPEECH_MSG_NAME "SendMultiUtteranceMsg")

;; 5/9/03  Added corrected message name.
(defconstant SPEECH_MSG_NAME "SendUtteranceMsg")

;(defconstant SPEECH_FORMAT "UTT_Utterance_Msg_FORMAT")

(defconstant GESTURE_IN_NAME "BVS_DEICTIC_GESTURE_IN")

(defconstant GESTURE_OUT_NAME "BVS_DEICTIC_GESTURE_OUT")

(defconstant MODULE_NAME "Nautilus")

(defconstant GESTURE-INIT '(0 0 0 0))

(defvar *gesture-result* nil)

(defconstant 1970-OFFSET (encode-universal-time 0 0 0 1 1 1970 0))

;; 5/9/03  Commented out to fix MMI; this handler seemes to expect
;; multiple utterances in a single message, but we cannot figure
;; out who sends that type of message.
#|(IPC:IPC_defun_handler uttHandler (msgRef lispData clientData)
 (format T "uttHandler: Receiving ~A (~A) [~A]~%" 
          (IPC:IPC_msgInstanceName msgRef) lispData clientData)
 (setf *utterances* (coerce (aref lispData 2) 'list))
 (force-output excl::*dribble-stream*)
  )
|#

;; 5/9/03  Added corrected message handler.
(IPC:IPC_defun_handler uttHandler (msgRef lispData clientData)
 (format T "uttHandler: Receiving ~A (~A) [~A]~%" 
	  (IPC:IPC_msgInstanceName msgRef) lispData clientData)
 (setf *utterances* (list (aref lispData 1)))
 #+allegro(force-output excl::*dribble-stream*)
  )

(defun gesture-handler (gesture)
  (when (or (null gesture)
	    (and (zerop (gesture-direction-z gesture))
		 (zerop (gesture-direction-x gesture))))
      (setf *gesture-result* nil)
      (return-from gesture-handler))
  (let ((timestamp (set-timestamp)))
    (setf *gesture-result*
	 (list 2 (atan (- (Gesture-direction-x gesture))
		       (Gesture-direction-z gesture))
	       (TimeStamp-time timestamp) 0))))


;(defun decay-gesture ()
;  "check the age of the gesture and decay it if necessary"
;  (and *gesture-result*
;       (> (- (- (get-universal-time) 1970-OFFSET)
;                    (gesture-timestamp *gesture-result*))
;          +gesture-age-seconds+)        ;check the age of the gesture
;       (setf *gesture-result* nil)))
;       

(defun clear-gesture ()
  (setf *gesture-result* nil))

;(defun get-gesture ()
;  (decay-gesture)
;  (or *gesture-result*
;      (sleep +gesture-wait-seconds+)    ;sleep returns NIL
;      *gesture-result*                  ;check again
;      GESTURE-INIT)                     ;default
;  )


(defun get-gesture ()
  (let ((temp ))
    (when (IPC:IPC_ISMSGDEFINED GESTURE_IN_NAME)
      (IPC:IPC_queryResponseData GESTURE_IN_NAME (make-QueryGesture) temp
				 (* +gesture-wait-seconds+ 1000)))
    (gesture-handler temp)
    (or *gesture-result*
	GESTURE-INIT)))

(defun WaitForInput ()
  (IPC:IPC_PublishData MMI_Input (make-Generic))) ;TODO save-action

(defun talk (phrase)
  (when (IPC:IPC_ISMSGDEFINED DO_EXPRESSION_MSG)
    (IPC:IPC_PublishData  DO_EXPRESSION_MSG (format nil "speak(\"~A\")" phrase)))
  ;;indicates waiting for user's input
  ;; (WaitForInput)  TODO
  )

(defun set-timestamp ()
  (let ((fractional-time (get-internal-real-time)))
    (multiple-value-bind (seconds fractional-seconds)
	(truncate (/ (coerce (- fractional-time *internal-real-time-offset*) 'double-float)
		  internal-time-units-per-second))
      (declare (ignore seconds))
      (make-TimeStamp
       :time (+ (coerce (- (get-universal-time) 1970-OFFSET) 'double-float)
		fractional-seconds)))))

(defun line-or-obj (&optional prompt)
  (if prompt
      (format t prompt))
  (if (eql #\( (peek-char t))
      (read)
    (read-line)))

(defun read-eval-print (fd data)
  "Alternate stdin handler"
  (handler-case 
   (let ((input (line-or-obj (format nil "~%~a~%is ~alistening => "
				     *robot-name* 
				     (if *attention-var* "" "not ")))))
     (cond ((stringp input)
	    (cond ((eq 'q (read-from-string input nil nil))
		   (IPC:IPC_disconnect)
		   #+ALLEGRO (top-level:do-command "reset") 
		   #+LISPWORKS (abort)
		   )
		  (t (setq *utterances* (list input))))) ;SETQ or PUSH?
	   (t
	    (handler-case
	     (format t "~{~%~a~}~%"		;should be ~S
		     (multiple-value-list (eval input)))
	     (error (e)
	       (setq *utterances* (list (format nil "~{~s~^ ~}" input))))))))
   (error (e) (write e :escape nil :stream t))))

(defun stdinHnd (fd clientData)
  (declare (ignore fd))
  (let ((inputLine (read-line)))
    (case (aref inputLine 0)
      ((#\q #\Q) 
       (IPC:IPC_disconnect)
       #+ALLEGRO (top-level:do-command "reset") #+LISPWORKS (abort)
       (dribble) ; close any dribble files opened
       )
      (T (format T "stdinHnd [~s]: Received ~s" clientData inputLine)))))

(defun ipc-subscribe ()
   ;; Subscribe to the messages that this module listens to.
  ;;  NOTE: No need to subscribe to the RESPONSE1 message since it is a
  ;;        response to a query not a regular subscription!
  (format T "~%(IPC_subscribe ~s 'uttHandler ~s)~%" SPEECH_MSG_NAME
	  MODULE_NAME)
  (IPC:IPC_subscribe SPEECH_MSG_NAME 'uttHandler MODULE_NAME)

;  (format T "~%(IPC_subscribe ~s 'gestureHandler ~s)~%" GESTURE_OUT_NAME
;	  MODULE_NAME)
;  (IPC:IPC_subscribe GESTURE_OUT_NAME 'gestureHandler MODULE_NAME)
  )

(defun unImplemented ()
  (if (IPC:IPC_IsConnected)
      (ipc-publish MMI_Unimplemented (make-Generic))
    (warn "Unimplemented")))

(defun shut-down ()
  (when (ipc:ipc_IsConnected)
    (ShutDown)				; send an IPC message to others
    (ipc:ipc_disconnect))
  (quit))

(defun no-mesgs ()
  (ipc:ipc_setVerbosity 0))

(defun default-function (name)
  (cond ((member 'action (get name 'isa)) ;HAS-TYPE?
	 #'(lambda (&rest r) (values nil name)))
	(t
	 #'(lambda (&rest r) name))))

(defun ipc-connect ()

  ;; Connect to the central server
  (format T "~%Connecting as ~s ...~%" MODULE_NAME)
  (IPC:IPC_connect MODULE_NAME)

  ;; Define the named formats that the modules need
  ;;  (format T "~%(IPC_defineFormat ~s ~s)~%" SPEECH_DEVICE SPEECH_FORMAT)
  ;;  (IPC:IPC_defineFormat SPEECH_DEVICE SPEECH_FORMAT)

  ;; (format T "~%(IPC_defineFormat ~s ~s)~%" NRL_GESTURE NRL_Gesture_Pose_FORMAT)
  ;; (IPC:IPC_defineFormat NRL_GESTURE NRL_Gesture_Pose_FORMAT)

  (if (not *strict-02*)
      (ipc:ipc_setVerbosity 2))		;don't make lisp crash (!)

  (ipc-subscribe)

  (if *mmi* (MMI-init))			;where the IPC messages are defined
  
  ;; Subscribe a handler for tty input.
  ;;   Typing "q" will quit the program; Typing "m" will send MSG1;
  ;;   Typing "r" will send QUERY1 ("r" for response)
  ;; NOTE: 0 is the file descriptor number of stdin (the terminal)
  (format T "~%(IPC_subscribeFD ~d 'stdinHnd ~s)~%" 0 MODULE_NAME)
  (IPC:IPC_subscribeFD 0 (if *strict-02* 
			     'stdinHnd
			   'read-eval-print)
		       MODULE_NAME)

  (format T "~%Type 'q' to quit~%")

  (trace IPC:IPC_PublishData)
  )

(defvar *setup-error* nil)

(defun run-loop ()
  (handler-case (progn
		  (trace mmi-init)
		  (trace ipc-connect)
		  (ipc-connect))
    (error (e)
      (format t "ERROR: ")
      (write (setq *setup-error* e) :escape nil)
      (format t "~%Abandoning IPC initialization~%")))
  (tagbody
   ;; Loop so we can continue from keyboard interrupts without rebooting
   ;;  
   loop-start
   (when *utterances*
     (with-simple-restart (continue "continue computation")
       (handler-bind
	(#+allegro		 
	 (excl:interrupt-signal #'(lambda (s)
				    (if (not *debug*)
					(go loop-continue))))
	 (error #'(lambda (c)
		    (say-statement "There's something wrong with me.")
		    (cond ((not *debug*)
			   (format t "ERROR: ")
			   (write c :escape nil)
			   (format t "~%")
			   (say-statement "Please repeat.")
			   (go loop-continue)))
		    (say-statement "Entering debug mode.")
		    (say-statement "Please attend to my console window.")
		    (format t "~%"))))
	(interrob-process-sentences *utterances*))))
   loop-continue
   (setf *utterances* nil)
   (if *setup-error*
       (read-eval-print nil nil)
     (IPC:IPC_listenClear 1000))
   (go loop-start)))



#|
  (tagbody
   start
   (when *utterances*
     ;;(handler-case
     (handler-bind
      ((undefined-function		;should probably be elsewhere (TODO)
	#'(lambda (condition)
	    (let ((fname (cell-error-name condition)))
	      (store-value (default-function fname) condition))))
       (error 
	#'(lambda (condition)
	    (cond ((not *debug*)
		   (format t "~%ERROR: ")
		   (write condition :escape nil :stream t)
					;(unimplemented)
		   (say-statement "Sorry, internal error")
		   (go continue)
		   )))))
      (interrob-process-sentences *utterances*)))
   continue
   (setf *utterances* nil)
   (IPC:IPC_listenClear 1000)
   (go start)))

|#
