;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(in-package :NLP)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; published commands to be used in conjunction with the MMI ipc interface
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter +gesture-wait-seconds+ (read-from-string
				      (format nil "~a"
					      (getenv "GESTURE_WAIT"))))
(defparameter +gesture-age-seconds+ (read-from-string 
				     (format nil "~a"
					     (getenv "GESTURE_AGE"))))


(defun myhostname ()
  ;;get only the machine name 
  (first (split-string (getenv "HOSTNAME") #\.)))

(IPC:IPC_defstruct (TimeStamp)
  (time 0.0d0 :type double)
  (host (format nil "~10A" (myhostname)) :type (simple-array character (10))))


(IPC:IPC_defstruct (Point2D)
     (x 0.0d0 :type double)
     (y 0.0d0 :type double)
     )

(IPC:IPC_defstruct (Point3D)
   (x 0.0d0 :type double)
   (y 0.0d0 :type double)
   (z 0.0d0 :type double))

(IPC:IPC_defstruct (Gesture)
   (origin-x 0.0d0 :type double)
   (origin-y 0.0d0 :type double)
   (origin-z 0.0d0 :type double)
   (direction-x 0.0d0 :type double)
   (direction-y 0.0d0 :type double)
   (direction-z 0.0d0 :type double))

(IPC:IPC_defstruct (QueryGesture)
   (before-now 0 :type long)
   (duration +gesture-age-seconds+ :type long))

(defconstant UNI_Point2D_FORMAT_NAME "UNI_Point2D_FORMAT")

(IPC:IPC_defstruct (Point2DPolar)
    (range 0.0d0 :type double)
    (radians 0.0d0 :type double))

(IPC:IPC_defstruct (GoPolar)
    (point nil :type Point2DPolar)
    (Timestamp (set-timestamp) :type TimeStamp))
    
(defconstant UNI_Point2DPolar_FORMAT_NAME "UNI_Point2DPolar_FORMAT" )

(defun make-point-array (points)
  ;;points is a string in the format "<x1> <y1> <x2> <y2> ..."
  (let ((pointlst ))
    (do ((points (listify points) (cddr points)))
	((null points))
      (push (make-Point2D :x (car points) :y (cadr points))
	    pointlst))
    (coerce pointlst :array)))


(IPC:IPC_defstruct (Point2DList)
    (num 0 :type integer)
    (points nil :type array)
    (timestamp (set-timestamp) :type TimeStamp))

(defconstant MMI_Point2D_List_FORMAT_NAME "MMI_Point2D_List_FORMAT")

(IPC:IPC_defstruct (Direction)
    (dir 0.0d0 :type double)
    (timestamp (set-timestamp) :type TimeStamp))

(IPC:IPC_defstruct (Generic)
  (timestamp (set-timestamp) :type TimeStamp))

(defconstant MMI_Go_Explore "GoExplore") ;Point2DList

(defconstant MMI_Go_Explore_Direction "GoExplore") ;Direction

(defconstant MMI_Go_Patrol "GoPatrol")	;Point2DList

(defconstant MMI_Go_Patrol_Direction "GoPatrol") ;Direction

(defconstant MMI_Go_Polar "GoPolar")	;Point2DPolar

(defconstant MMI_Go_XY "GoXY")		;Point2D

(defconstant MMI_Turn "MMI_Turn" )		;Direction

(defconstant MMI_Go_Obstacle "GoObstacle") ;Direction

(IPC:IPC_defstruct (Waypoint)
  (waypoint 0 :type integer)
  (timestamp (set-timestamp) :type timeStamp))

;;message not defined right now
(defconstant MMI_Go_Waypoint "GoWayPoint")


; will have to be replaced with festival
;(defconstant MMI_Talk "tk") 

(defconstant MMI_Face_Me "FaceMe")	;NULL

(defconstant MMI_Stop "Stop")		;NULL

(defconstant MMI_Follow_Me "FollowMe")	;NULL

(defconstant MMI_Greeting "Greeting")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  registration task
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defconstant MMI_Is_Located "Is_Located")

(IPC:IPC_defstruct (is-located)
    (theme "" :type string)
    (position "" :type string)		;on, in, under, etc
    (referent "" :type string)
    (referent-isa "" :type string)
    (timestamp (set-timestamp) :type TimeStamp))

(IPC:IPC_defstruct (ChangeFloor)
    (bearing 999.0d0 :type double)
    (destination "" :type string)
    (timestamp (set-timestamp) :type TimeStamp))

(defconstant MMI_Use_Elevator "UseElevator")

(defconstant MMI_Use_Escalator "UseEscalator")

(defconstant MMI_Use_Stairs "UseStairs")

(IPC:IPC_defstruct (FindObj)
   (name "" :type string)
   (timestamp (set-timestamp) :type TimeStamp))

(defconstant MMI_Find "Find")

(defconstant MMI_Unimplemented "Unimplemented")

(defconstant YESNO_ENUM '(:INVALID_YES_NO :YES :NO :MAYBE :DUNNO))

(IPC:IPC_defstruct (YesNo)
   (answer :YES :type (or integer symbol))
   (timestamp (set-timestamp) :type TimeStamp))

(defconstant MMI_YesNo "YesNo")

(defconstant MODES_ENUM '(:QUERY :STEERED :FOLLOW_ME :SCRIPTED :SLEEP))

(IPC:IPC_defstruct (Mode)
    (autonomy :QUERY :type (or integer symbol))
    (timestamp (set-timestamp) :type TimeStamp))


(defconstant MMI_Mode "Autonomy_Mode")


(defconstant MMI_EOS "EndSequence")


(IPC:IPC_defstruct (Destination)
  (destination-name "" :type string)
  (timestamp (set-timestamp) :type TimeStamp))

(defconstant MMI_Destination "AtDestination")

(defconstant MMI_WakeUp "WakeUp")

(defconstant MMI_Shutdown "Shutdown")

(defconstant MMI_Input "HumanInput")

