(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
	   (if (not (fboundp 'confirm-modules))
	       (load "general/modules"))
	   (confirm-modules "config"
			    ))

;;warning: this variable is used in ipc-load.lisp
(defvar *IPC-DIRECTORY* (concatenate 'string
				     (or #+ALLEGRO
					 (sys:getenv "IPC_DIR")
					 "") 
				     "/"))

(defparameter *ipc-load* (concatenate 'string *IPC-DIRECTORY* "lisp/ipc-load.lisp"))

#+linux (load "/usr/lib/libpthread.so") 

(if nlp::*demand-ipc*
    (if (not (probe-file *ipc-load*))
	(error "Can't find ~s (Check environment variable IPC_DIR)" *ipc-load*)
      (load *ipc-load*))
  (format t "~%Warning: no IPC~%"))




