;;; Release: CMUCL_standalone_port (1.1)
;;; File: lexical-lookup.lisp,v
;;; File date: 2003/06/12 17:10:45 (UTC)
;;; Author: SCT

;;; Code to update the lexicon on the fly

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "robotalk"
		   ))

(in-package nlp)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (cl-user::confirm-modules "nlp/proteus/basics/foreach"
		  ))

(defparameter *max-huh-list* 2)		;max words robot will use in
					;"Don't have a lexicon entry for ..." 

(defparameter *unknown-words* (make-hash-table :test 'eq)
  "A table of symbols")

(defun setnpred (npred &rest frame-specs)
  "Function version of DEFNPRED"
  ;; WARNING: macro and function shouldn't be independent like they are now
  (pushnew npred *npreds*)
  (foreach spec in frame-specs do
	   (pushnew npred (get (first spec) 'nlex)))
  (setf (get npred 'npred-frame-specs)
	(append (get npred 'npred-frame-specs) frame-specs)))

  
;; Associate an NPRED (i.e. normalized noun) with one or more frame
;; specifications:
;
;(defmacro defnpred (npred &rest frame-specs)
;  `(progn (pushnew ',npred *npreds*)
;	  (foreach spec in ',frame-specs do
;		   (pushnew ',npred (get (first spec) 'nlex)))
;	  (setf (get ',npred 'npred-frame-specs)
;		(append (get ',npred 'npred-frame-specs) ',frame-specs))))

(defun setframe (name &rest keys/values)
  "Function version of DEFFRAME"
  ;; WARNING: macro and function shouldn't be independent like they are now
  (let ((isa (getf keys/values :isa)))
    (if (and isa (symbolp isa))
	(setq isa (list isa)))
    (setf (get name 'isa) isa)
    (pushnew name *frames*)
    (foreach i in isa do (pushnew name (get i 'asi)))
    (setf (get name 'slot-specs)
	  (form-slot-list (append
			   (apply #'append (foreach i in isa collect
						    (get i 'slot-specs)))
			   keys/values)))))

;; Renamed from ~nlp/proteus/parser/parse.lisp
;;
(defun orig-lexical-lookup (sentence)
  (let ((undefined-words nil))
    (foreach w in sentence do
	     (when (not (or (numberp w) (get w 'defined-word)))
	       (format *standard-output*  "*** undefined word ~A~%" w)
	       (setq undefined-words t)))
    (if undefined-words
	nil
      (list (apply #'vector
		   (foreach w in sentence collect (if (numberp w)
;;;							   w
						      (FORMAT NIL "~A" w)
						    (symbol-name w))))
	    (apply #'vector
		   (foreach w in sentence collect 
			    (if (numberp w)
				`(Q (t Xn ,w))
			      (get w 'word-defn))))))))

(defun lexical-lookup (sent)
  (let ((? (orig-lexical-lookup sent))
	(unknowns nil))
    (cond ((null ?)
	   ;; Try noun and OBJECT for unknown word
	   ;; TODO undo the guess if it doesn't parse
	   (setq unknowns 
		 (mapcan #'(lambda (x)
			     (cond ((and (symbolp x)
					 (not (get x 'defined-word)))
				    (setf (gethash x *unknown-words*)
					  t)
				    (noun-func :root x
					       :plural nil
					       :attributes '(ncount)
					       :class nil
					       :Xn nil)
				    (setframe x); :isa 'object)
				    (setnpred x (list x))
				    (list x))))
			 sent))
	   (setq ? (orig-lexical-lookup sent))))
    (if (not ?)
	(cond 
	 ((<= (length unknowns) *max-huh-list*)
	  (say-statement (format nil "Sorry, ~
                            I don't have a lexical entry for~(~{ ~a~^,~} ~a~)"
				 (butlast unknowns)
				 (if (cdr unknowns)
				     (format nil "or ~a"
					     (car (last unknowns)))
				   (car (last unknowns))))))
	 (t
	  (say-statement "Sorry, I don't know some of those words")
	  ;; TODO save unknowns to answer
	  ;;  "Robot, which words (don't you know)?"  ??
	  )))
    ?))
