;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;lookup.lisp,v 1.4 2003/07/14 16:04:34 thomas Exp

(in-package :NLP)


;; should correspond to the 16 basic descriptions in the spatial reasoner
(defvar *directions* '(("FRONT" (:in-front-of :forward))
		       ("LEFT" (:your-left :left))
		       ("REAR" (:behind :back))
		       ("RIGHT" (:your-right :right))
		       ("REAR_RIGHT" (:behind :back :your-right :right))
		       ("BEHIND_RIGHT" (:behind :back :your-right :right))
	    	       ("RIGHT_SHIFTED_BEHIND" (:behind :back :your-right :right))
		       
		       ("FRONT_RIGHT" (:in-front-of :forward :your-right :right))
		       ("FRONT_SHIFTED_RIGHT" (:in-front-of :forward :your-right :right))
		       ("RIGHT_SHIFTED_FRONT" (:in-front-of :forward :your-right :right))
		       ("REAR_LEFT" (:behind :back :your-left :left))
		       ("BEHIND_LEFT" (:behind :back :your-left :left))
		       ("BEHIND_SHIFTED_LEFT" (:behind :back :your-left :left))
		       ("LEFT_SHIFTED_BEHIND" (:behind :back :your-left :left))
		       ("FRONT_LEFT" (:in-front-of :forward :your-left :left))
		       ("FRONT_SHIFTED_LEFT" (:in-front-of :forward :your-left :left))
		       
		       ("LEFT_SHIFTED_FRONT" (:in-front-of :forward :your-left :left))))

(defstruct point x y dir)

(defun find-nearest-objects ()
  (let ((objects nil))
    (dolist (dir *directions*)
      (push (get-nearest-obj (car dir)) objects))
    (remove-duplicates
     (mapcar #'(lambda (objdescr)
		 (parse-object objdescr 'object '(NEAREST)))
	     (remove "NONE" objects :test #'string-equal)		   )
		       :key #'obj-id)))

(defun get-point (to-loc)
  ;; get the x,y coordinates of a point
  (let ((point (get to-loc :to-loc)))
;    (FaceObject (get to-loc :x-coord) (get to-loc :y-coord))
    (parse-object-point to-loc point)))

(defun locate (on-loc to-loc near behind in-front-of ;on-loc Challenge 02
		      &optional between-loc)
  (let ((obj to-loc))
    (cond (between-loc 
	   (setf obj between-loc))
	  (on-loc
	   (setq obj on-loc))		;challenge code (should be a floor)
	  ((and behind (physobj-p behind))
	   (setf obj behind)
	   (setf (get obj :to-loc) :BACK))
	  ((and near (physobj-p near))
	   (setf obj near))		;same as go to the object
	  ((and in-front-of (physobj-p in-front-of))
	   (setf obj in-front-of)
	   (setf (get obj :to-loc) :FRONT)))
    obj))

(defun format-hl-description (description)
  (or (remove-duplicates (remove-if #'empty-string-p
			    (split-string (remove #\. description :test #'char=)
					  #\newline))
		     :test #'string-equal)
      (list "NONE")))

	 
(defun hl-description (direction)
  (cond ((forward-p direction)
	 (format-answer (format-hl-description (get-hl-dir "FRONT"))))
	((left-loc-p direction)
	 (format-answer (format-hl-description (get-hl-dir "LEFT"))))
	((right-loc-p direction)
	 (format-answer (format-hl-description (get-hl-dir "RIGHT"))))
	((back-p direction)
	 (format-answer (format-hl-description (get-hl-dir "REAR"))))))


(defun find-nearest-object (constraints)
  ;get-nearest-object gets a new map
  (let ((LeftOrRight (find 'be-at-position constraints :key #'get-class
				   :test #'eql))
	(behind (find 'be-behind constraints :key #'get-class
				   :test #'eql))
	(front (find 'be-in-front-of constraints :key #'get-class :test #'eql)))
    (cond (LeftOrRight 
           (get-nearest-obj  (symbol-name (get-class (cadr (my-assoc :position
			     LeftOrRight))))))
	  (behind (get-nearest-obj "REAR"))
	  (front (get-nearest-obj "FRONT"))
	  (t (get-nearest-obj "ALL_DIR")))))
	  
(defun list-descrips ()			;SCT
  (let ((ds nil)
	(count 0)
	d)
    (loop 
     (setq d (get-object-descrip (format nil "#~s" (incf count))))
     (if (or (equal d "")
	     (equal d "NONE"))
	 (return (mapcar #'(lambda (d)
			     (parse-object d))
			 (nreverse ds))))
     (push d ds))))

;; get the current objects
(defun robot-objects (type modlist &optional constraints known-objects)
  (let ((id (and (consp modlist) (getf modlist :id))))
    (cond
          ((has-type type 'agent) nil)
	  ((has-type type 'location) nil)
          ((and (has-type type 'object)
		(or (find 'p-closest constraints :key #'get-class  :test #'eql)
		    (find 'be-near constraints :key #'get-class :test #'eql)))
	   (let ((obj (find-nearest-object constraints)))
	     (unless (string-equal obj "NONE")
	       (list (parse-object obj)))))
	  ((and (has-type type 'object)
		(numberp id))
	   ;assume using the same map
	   (let ((objdescr (get-object-descrip (format nil "#~D" id))))
	     (when (not (empty-string-p objdescr))
	       (list (parse-object objdescr)))))
	  ((eql type 'object) ; get all the objects
	   (if (and *addressee-is-me*
		    *talkative*)
	       (talk-and-echo "Looking ..."))
	   (let ((objects nil))
	     ;;get-num-objecs gets a dynamic map
	     (dotimes (n (get-num-objects))
	       (push (parse-object (get-object-descrip (format nil "#~D" (1+ n))) 'object)
		     objects))
	     (remove nil objects)))
	  ((has-type type 'object)	; get an object
	   (if (and *addressee-is-me*
		    *talkative*)
	       (talk-and-echo "Looking ..."))
	   (get-hl-descrip); get a new map
	   (get-typed-object type))
	  ((eql type 'thing)
   	   ;;(list (parse-hl-description (get-hl-descrip)))))))
	   (list-descrips)))))

(defun get-typed-object (label)
 (let ((obj (get-object-descrip (symbol-name label))))
   (when (not (or (empty-string-p obj) (string-equal obj "NONE")))
     (list (parse-object obj label)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; parse of the object description
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun robot-obj-num (description)
  (1+ (parse-integer (second description))))

(defun robot-obj-label (description)
  (first description))

(defun robot-obj-description (description)
  (nth 10 description))

(defun robot-obj-direction (description)
   (let ((robot-dir (string-upcase (substitute #\_ #\space (nth 8 description)))))
    (cadr (assoc robot-dir *directions* :test #'string-equal))))

(defun robot-obj-x (description)
  ;; convert to inches
  (round (* 12 (read-from-string (nth 4 description)))))

(defun robot-obj-y (description)
  ;; convert to inches
  (round (* 12 (read-from-string (nth 5 description)))))

(defun parse-hl-description (description)
  (let ((instance (gentemp "DESCRIPTION-")))
    (setf (get instance 'type) 'DESCRIPTION)
    (setf (get instance :description)
	  (format-answer (format-hl-description description))
;	  (remove #\newline description :test #'char=)
	  )
;    (setf (get instance :physobjs) (get-nearest-objects))
    instance))

;;maybe check for NONE here
(defun parse-object (description &optional (type 'object) spec)
  (let* ((list-description (split-string description #\,))
	 (instance (gentemp (format nil "~A-" type)))
	 (id (robot-obj-num list-description)))
    (setf (get instance 'type) type)
    (setf (get instance 'spec) spec)
    (setf (get instance :id) id)
    (setf (get instance :label)
	  (robot-obj-label list-description))
    (setf (get instance :direction)
	  (robot-obj-direction list-description))
    (setf (get instance :description)
	  (robot-obj-description list-description))
    (setf (get instance :x-coord)
	  (robot-obj-x list-description))
    (setf (get instance :y-coord)
	  (robot-obj-y list-description))
    instance))

(defun make-object (type)
  (let ((instance (gentemp (format nil "~A-" type))))
    (setf (get instance 'isa) (list type)) ;SCT added TODO check?
    (setf (get instance 'type) type)
    (setf (get instance :label) (symbol-name type))
    instance))

;get_lrfb_points does not seem to work too well
;so we'll use the specific left and right points for now
(defun parse-object-point (obj dir)
  (let* ((label (if (string-equal "object number" (subseq (obj-label obj) 0 13))
                    (format nil "#~D" (obj-id obj))
                  (obj-label obj)))
         (points (parse-object-points label)))
    (when points
     (find dir points :key #'point-dir))))
    

;(defun parse-object-point (obj dir)
;  (get-hl-descrip)                      ;get a new map
;  (let* ((label (if (string-equal "object number" (subseq (obj-label obj) 0 13))
;                    (format nil "#~D" (obj-id obj))
;                  (obj-label obj)))
;         (pointstr (get-object-point label (symbol-name dir))))
;    (unless (or (empty-string-p pointstr) (string-equal pointstr "NONE"))
;      (make-point :x (round (* 12 (read-from-string (string-elt pointstr 0))))
;                  :y (round (* 12 (read-from-string (string-elt pointstr 1))))))
;    ))

;;get_lrfb_points does not seem to work too well
(defun parse-object-points (label)
  (get-hl-descrip)			;get a new map
  (let ((pointstr (get-object-points label))
	(directions '(:LEFT :RIGHT :FRONT :BACK)) ;order of the points received
	(points))
    (unless (string-equal pointstr "NONE")
      (do ((pointers (split-string pointstr #\,) (cddr pointers)))
	  ((null pointers))
	(print pointers)
	(push (make-point :x (round (* 12 (read-from-string (first pointers))))
			    :y (round (* 12 (read-from-string (second pointers))))
			    :dir (pop directions))
			    points)))
      points))

