;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;macros.lisp,v 1.2 2003/06/20 15:31:00 thomas Exp
(in-package :NLP)


(defmacro while (test &rest body)
  `(do ()
       ((not ,test))
     ,@body))

(defmacro with-appropriate-gesture ((var pred) &body body)
  `(let ((,var '(0 0.0 0 0)))
     (declare (special ,var))
     ;; we always check for a gesture so as to clear the stack
     ;; we assume here that if the command is addressed to the robot
     ;; the gesture is also addressed to the robot
     (when *gesture-init*
       (if (gesture-pred-p ,pred) 
	   (progn (setf ,var (get-gesture))
		  (setf (context-gesture current-context) ,var))
	 (clear-gesture)))
     ,@body))

(defmacro with-context ((var) &body body)
  `(let ((,var (make-context)))
     (declare (special ,var))
     ,@body
     (push ,var *history*)))

(defmacro defcommand (pred args &rest rules)
  `(progn
     (push ',pred *commands*)		; keep a trace of all commands
     (defun ,pred (&rest params &key agent not ,@args &allow-other-keys)
       (declare (special current-context lfs *others*))
       (setf (context-command current-context) ',pred)
       (setf (context-args current-context) params)
       (cond ((attentive-p ',pred)
	      (let ((*assume-gesture-pred* nil))
		(with-appropriate-gesture (newrobotresult ',pred)
		  (cond  
		   ;; TODO get rid of negation-p? (what about Deny?)
		   ((negation-p (context-lfs current-context)) (Deny))
		   ;; ,@(parse-rules (list* 'agent 'not args) rules)
		   ,@rules
		   (t (warn "Nothing fired in ~A" ',pred)
		      t)))))
	     (t t)))))

(defmacro defsubcommand (pred args &rest rules)
  `(progn
     (push ',pred *commands*)
     (defun ,pred (,@args &key &allow-other-keys)
       (declare (special current-context *others*))
       (cond ;;,@(parse-rules args rules)
	,@rules
	(t (warn "Nothing fired in ~A" ',pred))))))

(defmacro defmessage (pred args command)
  `(progn
     (push ',pred *commands*)
     (defun ,pred (,@args)
       (declare (special current-context newrobotresult))
       (setf (context-translation current-context) (list ',pred ,@args))
       ,command
       (setf *history* nil)		;clear
       (setf (context-success current-context) t))))




