;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; myrobots.lisp,v 1.10 2003/07/15 19:41:33 thomas Exp

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules  "packages"
		    "environment"
		    "macros"
		    "ff"
		    "prediscr"
		    "state"
		    "robotalk"
		    "qx"
		    "process-sentence"
		    "semwdfunc"
		    "funtran"
		   ))

(in-package :NLP)

;; (defvar *robots-home* (getenv "ROBOTS_HOME"))

;; (defvar *robot-name* (getenv "ROBOT_NAME"))

(defvar *speech-input* nil)		;viavoice initialization

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; the following variables indicates whether initialization
;;; took place so that we don't do it another time
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *robot-init* nil)
(defvar *gesture-init* nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; commands to trace
;;; defcommands and defsubcommands are automatically
;;; marked for tracing
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar *commands* '(locate get-point get-gesture reload-grammars reload-dictionaries right left behind front center in-front-of p-dummy-vp bind-unsuccessful-command bind-previous-isa-request bind-previous-ami-request bind-uncertain-vv-parse bind-previous-askwh bind-end-of-sequence p-see p-isa negation-p p-location be-at-position be-opposite be-behind be-near be-in-front-of attentive-p apply-additional-preferences unimplemented gesture-handler))

(defvar *foreign-calls* '(talk))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   context setup
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defstruct context
  mesg
  lfs
  vv-uncertainty
  command
  args
  gesture
  success				;parse resulted in a mesg sent to robot
  translation)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   message queue
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defconstant +prompt-string+ "~%sentence:")

(defvar *msgbuf*)

(defvar *previous-context* nil) ; stores the previous action

(defvar *history* nil) ; stores all the previous contexts

(defun robots-file (filename)
  (if (and *robots-home* (not (equal "" *robots-home*)))
      (concatenate 'string *robots-home* "/" filename)
    filename))

;;from comp.lang.lisp
(defun load-compiled (pathname)
  "Compile pathname, if necessary, and load the compiled file."
  (unless (probe-file pathname)
    (error "The source file ~A doesn't exist!" pathname))
  (let ((compiled-pathname (compile-file-pathname pathname)))
    (unless (and (probe-file compiled-pathname)
                 (< (file-write-date pathname) 
                    (file-write-date compiled-pathname)))
      (compile-file pathname))
    (unless (probe-file compiled-pathname)
      (cerror "Load source file ~A instead."
              "Compilation of ~A didn't yield a compiled file named ~A"
              pathname compiled-pathname)
      (setq compiled-pathname pathname))
    (load compiled-pathname)))

(defun robots-load ()
;;  (load-compiled (robots-file "ff.lisp"))
;; there is a problem with viavoice to compile the foreign calls
#+ALLEGRO
  (load (robots-file "ff.lisp"))
;  (load-compiled (robots-file "foreign.lisp"))
  (load-compiled (robots-file "nlp.lisp"))
  (load-compiled (robots-file "utils.lisp"))
  (load-compiled (robots-file "viavoice.lisp"))
  (load-compiled (robots-file "macros.lisp"))
  (load-compiled (robots-file "lookup.lisp"))
  (load-compiled (robots-file "funtran.lisp"))
  (load-compiled (robots-file "focal.lisp"))
  (load-compiled (robots-file "gestures.lisp"))
  (load-compiled (robots-file "defmessage.lisp"))
  (load-compiled (robots-file "predicates.lisp"))
  (load-compiled (robots-file "defsubcommand.lisp"))
  (load-compiled (robots-file "defcommand.lisp")))

(defun load-ipc ()
  (load-compiled (identity (robots-file "ipc.lisp")))
  (load-compiled (identity (robots-file "ipc-structs.lisp")))
  (load-compiled (identity (robots-file "ipc-functions.lisp")))
  )

(defun load-challenge ()
  (load-compiled (identity (robots-file "nlp.lisp")))
  (load-compiled (identity (robots-file "utils.lisp")))
  (load-compiled (identity (robots-file "viavoice.lisp")))
  (load-compiled (identity (robots-file "macros.lisp")))
  (load-compiled (identity (robots-file "lookup.lisp")))
  (load-compiled (identity (robots-file "funtran.lisp")))
  (load-compiled (identity (robots-file "focal.lisp")))
  (load-compiled (identity (robots-file "preferences.lisp")))
  (load-compiled (identity (robots-file "translatelf.lisp")))
  (load-ipc)
  (load-compiled (identity (robots-file "gestures.lisp")))
  (load-compiled (identity (robots-file "challengemsg.lisp")))
  (load-compiled (identity (robots-file "predicates.lisp")))
  (load-compiled (identity (robots-file "defcommand.lisp")))
  (load-compiled (identity (robots-file "defsubcommand.lisp"))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; start in earnest
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun boot-robots ()
  (declare (special *commands*))
  (setf *history* nil)			;initialize
  (let ((validoption nil))
    (do ()
	(validoption)
      (format t "~%~%Which configuration would you like?")
      (format t "~%  a - trace all commands")
      (format t "~%  i - ipc")
      (format t "~%  n - no ipc connect")
      (format t "~%  l - log output")
      (format t "~%  q  - lisp listener")
      (format t "~%~%Your choice (a,i,n,l,q): ")
      (case (read)
	(a  (trace-all *commands*)
	    (trace-all *foreign-calls*))
	(i
	 (trace-all *commands*)
	 (trace-all *foreign-calls*)
	 (setf *gesture-init* t)
	 ;;ipc will branch into another thread
	 (ipc-connect))
	(q (return-from boot-robots))
	(l (dribble "interrob.log"))
	(n 

	   (setq validoption t))
	(otherwise (warn "Invalid option (a,i,n,l,q) pick again"))))

    (parser-top-without-speech)))

(defun my-init-spatial ()
  (unless *spatial-init*
    ;; check for return code before setting the flag
    (setf *spatial-init* (>= (handler-case
			      (init-spatial (getenv "SPATIAL_MACHINE_NAME")
					    (parse-integer 
					     (getenv "SPATIAL_PORT")))
			      (error (e)
			        (format t "~%Can't initial spatial module~%")
			        (write e :escape nil)
			        (format t "~%")
				-1))
			     0))))

;; check-for-my-name returns t if the addressee mentioned in the string
;; matches the environmental variable name (regardless of whether
;; the string is unsure (preceded by "??")

(defun check-for-my-name (voice-string)
  (when (not (empty-string-p voice-string))
    (let ((listified-string (split-string (string-trim '(#\space) voice-string)
					  #\space)))
      (setq *addressee-is-me*
	    (if (vv-uncertain-parse-p voice-string)
		(or (string-equal *robot-name* (string-right-trim 
						'(#\,)
						(second listified-string)))
		    (string-equal "robots" (string-right-trim
					    '(#\,)
					    (second listified-string))))
	      (or (string-equal *robot-name* (string-right-trim
					      '(#\,)
					      (first listified-string)))
		  (string-equal "robots" (string-right-trim 
					  '(#\,)
					  (first listified-string)))))))))



;;remove from *alt-foc-list* only those entities that are not in referents.lisp
;;because they need updating from the spatial reasoner
;(defun mycleanup ()
;  (declare (special *alt-foc-list*))
;  (let ((filtered-list))
;    (do ((entities *alt-foc-list* (cdr entities)))
;        ((null entities))
;      (destructuring-bind (id name type role referent)
;          (car entities)
;        (when (find referent *objlist* :test #'eql)
;          (push (car entities) filtered-list))))
;    (setf *alt-foc-list* (reverse filtered-list))))


(defun mycleanup ()
  (setf *parselist* nil)
  ;;force match for that, this and it with a dummy referent thing
  ;;SCT->;
  ;;(push (list (gentemp "N") 'singular 'registration-desk 
  ;;	      :to-loc 'registration-desk) *alt-foc-list*)
  (push (list (gentemp "N") 'singular (gentemp "C-"))
	*alt-foc-list*)
  (mapc #'(lambda (obj)
	    (setf (get obj :direction) nil)) *objlist*))

(defun trim-and-process (msg &optional (*current-speech-source*
					'somebody-else))
  (save-new-mesg msg)
  (interrob-process-sentence (string-right-trim '(#\. #\! #\?) msg))
  ;;(error (e) (write e :escape nil :stream t)
  )

(defun interrob-process-sentences (msglist)
  "pick the first message that parses"
  (with-context (current-context)
    ;; (print (setf (context-lfs current-context) '!))
    (do ((msg msglist (cdr msg)))
	((null msg))
      (trim-and-process (car msg))
      (when (context-lfs current-context)
	(return)))
    (when (null (context-lfs current-context))
      ;; (warn "can't parse or can't process")) ;; Unvalid parse"))))
      )))

(defun interrob-process-sentence (mesg)
;  (maybe-process-sentence (convert-100s mesg)
;				       (check-for-my-name mesg)
;				       (vv-uncertain-parse-p mesg))
  (maybe-process-sentence mesg (check-for-my-name mesg) nil))


;;sentences from the robot will always be understood
(defun maybe-process-sentence (mesg check-name-p uncertain-msg-p)
  (declare (special current-context))
  (if (not uncertain-msg-p)
      (process-sentence-in-earnest mesg check-name-p)
    (progn (viavoice-parse mesg)
	   (setf (context-vv-uncertainty current-context) t)))
  (setf (context-mesg current-context) mesg))

(defun process-sentence-in-earnest (mesg check-name-p)
  (declare (special current-context))
  (mycleanup)
  (setf *evaluate* check-name-p )
  (format t 
	  ;; "~&Somebody (or I) said to ~:[somebody else~;me~]: ~A"
	  ;; check-name-p mesg)
	  "I hear: ~a" mesg)
  #|(handler-case (print (list (type-of current-context)
			     (context-lfs current-context)
			     (setf (context-lfs current-context) '!))
		       )
		(error (e) (write e :escape nil)))
   |#
  (with-simple-restart (continue "continue computation")
    (handler-case		       
     (try-process-sentence (concatenate 'string mesg " .") check-name-p)
     (error (e) (continue e)))
    )	   
  (unless *evaluate*
    ;;those will otherwise be set in the defcommand macro
    ;;when evaluated
    (setf (context-args current-context) (collect-args-from-parse))))


(defun parser-top-without-speech ()
  (let ((prompt (format nil "~%sentence")))
    (do ((mesg (prompt-for-string :prompt prompt)
	       (prompt-for-string :prompt prompt)))
	((empty-string-p mesg))
      (interrob-process-sentences (list mesg))
      #+ALLEGRO
      (force-output excl::*dribble-stream*)
      #+CLISP
      (force-output system::*dribble-stream*))))


;(robots-load)
;(load-ipc)
;(load-challenge)
;(boot-robots)






