;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;             NOTICE OF COMPUTER PROGRAM USE RESTRICTIONS             ;;
;;                                                                     ;;
;;  The program was developed by the Navy Center for Applied           ;;
;;  Research in Artificial Intelligence.  Its distribution and         ;;
;;  use are governed by a Software Use Agreement.                      ;;
;;                                                                     ;;
;; This will certify that all authors of this software are or were     ;;
;; employees or under contract of the U.S. Government and performed    ;;
;; this work as part of their employment and that the software is      ;;
;; therefore not subject to U.S. Copyright protection.                 ;;
;;                                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; nlp.lisp,v 1.5 2003/07/09 14:38:13 thomas Exp
;;
;; ======================================================================
;; Interbot

; NLP (Natural Language Processor)

; Kenneth Wauchope
; Navy Center for Artificial Intelligence
; Naval Research Laboratory, Code 5512
; Washington, DC 20375-5337

; Adapted to a robotics domain:
; Dennis Perzanowski

;;; Loads code (except PROTEUS) and data for the InterVIEWER NLP component.
; ====================================================================== 
;;; PROTEUS data

(in-package cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (not (fboundp 'confirm-modules))
      (load "general/modules"))
  (confirm-modules "config"
		   "state"
		   "environment"
		   "semwdfunc"
                   ))
(in-package nlp)

(format t "~%Loading nlp.lisp....~1%")

;; (defvar *robots-home* (getenv "ROBOTS_HOME"))

(defvar *robots-data-dir* 
  (if (not (equal "" *robots-home*))
      (concatenate 'string *robots-home* "/" "data")
    "data"))  

(defun parser-answer (message)
  (if *error-on-parser-answer* 
      (error "Parser answer: ~A" message)
    (cond (*addressee-is-me*
	   (say-answer message)
	   (if (and *be-polite* *be-polite-now*)
	       (say-statement "Thanks."))))))

(defun parser-message (message)
  (unless (or (string-equal message "[done] ")
	      (not *addressee-is-me*))
    (talk-and-echo message)
    ))

(defun reference-error (message &optional det) 
  (cond (*addressee-is-me*
	 (cond ((search "[Nothing mentioned matches " message)
		(say-statement "I don't know what you are referring to")
		(throw 'reference-error 'error))
	       (t
		(parser-message message)
		(throw 'reference-error 'error)))))) 
					;why throw error anyway? (SCT)

;;(restore-readtable) to get back
;;function in proteus/enhance/ptop.lisp
;;might not need to be overwritten
(defun set-readtable ()
 ;; (set-macro-character #\. #'single-char-symbol)   ; allow FIGHTER NO. 4
 ;; genitive, contraction
;  (set-syntax-from-char #\' #\a)
  (set-macro-character #\' #'single-char-symbol)
  (set-macro-character #\? #'single-char-symbol)
  (set-macro-character #\[ #'single-char-symbol)
  (set-macro-character #\] #'single-char-symbol)
  (set-macro-character #\, #'single-char-symbol)
  (set-macro-character #\; #'single-char-symbol)
  ;;(set-macro-character #\" #'single-char-symbol) SCT->;
  ;;(set-macro-character #\: #'single-char-symbol) SCT->;
  ;;(set-macro-character #\# #'single-char-symbol) SCT->;
  )

(format t "~%Loading intsys and robotsup grammars....~2%")

(let ((*error-output* (make-string-output-stream))) ;suppress error messages
  (reload-grammars 
   (list (concatenate 'string *robots-data-dir* "/intsys.gram-lisp")
	 (concatenate 'string *robots-data-dir* "/robotsup.gram-lisp")
	 (concatenate 'string *robots-data-dir* "/robotsup2.gram-lisp")))
  (format *error-output* ">>>The listed errors are explainable, due to different BNF expansions~%   in the different NLP grammars.~2%")
  )

;;; additional lisp functions used in regularization

(defun catenate (x y)(format nil "~A ~A" x y))
(defun plus (x y)(+ x (or y 0)))
(defun minus (x &optional y)(if y (- x y) (- x)))
(defun times (x y)(* x y))
(defun numberfy (x)(read-from-string x))

;; the next two functions convert the digitized numbering
;; system of the robots into complex numbers.  E.g. 0 1 9 --> 19 for processing
;; in the procedural semantics robotranfuns and then passed to the robots
;; for correct data interpretation.
;; DP4/4/97

(defun make-10s-num (x y)
  (+ (* x 10) y))

(defun make-100s-num (x y z)
  (+ (* x 100) (* y 10) z))

;;; adding the following in order to stringify in robot input
;;; DP 10/19/95
;;DP 2/13/01 why i re-defined it AGAIN below is beyond me for
;; all this time, since the function is part of Proteus enhancements
;; to begin with!

;;(defun stringify (args)
;;  (if (null args) (format nil "~%")
;;    (concatenate 'string (format nil "~A " (first args))
;;		 (stringify (rest args)))))

(format t "~%Loading intsys and robotsup dictionaries....~2%")

(reload-dictionaries (list (concatenate 'string *robots-data-dir* "/intsys.dictionary")
			   (concatenate 'string *robots-data-dir* "/robotsup.dictionary")))
;;;----------------------------------------------------------------------
;;; load TINSEL

(format t "~%Loading TINSEL....")
;;(load-compile "init"  *tinsel-home*)
;;(load-compile "specify" *tinsel-home*)
; don't ignore adjectival premodifiers
(noignore-adjs)
;(noignore-anstg)

;; redefined from focalg.lisp
;(defun pick-one (referents)
;  (first (cdr referents)))

(defun pick-one (x)(cdr x))

;;; redefine make-np-index
;;probably due to a syntax change in the different versions of Lisp, because
;;original Tinsel has gensym--the one below uses gentemp. A warning is
;;generated during loading, so the format statement is added here to
;;give user some idea of what is going on during runtime.

(defun make-np-index ()(gentemp "N"))
;;(format t ">>>The above warning is explainable~%   due to a re-defined compiled function in Lisp.~2%")

;;; additional semantic preferences

;;(load-compile "preferences" *intervr-home*)

;;; TINSEL semantic model

(load-model (concatenate 'string *robots-data-dir* "/robotsemantics.lisp"))
;;;----------------------------------------------------------------------

;;(format t "~%   loading reference model...")
;; loading robot referents
(load-dir-file *robots-data-dir* #| "/robotreferents.lisp" |#
	       "/referents")
;;;----------------------------------------------------------------------
;;; load FUNTRAN

;;(format t "~%loading FUNTRAN...")
;;(load-compile "funtran" *funtran-home*)
;;(load-compile "funtran-redefs" *intervr-home*)

;;; LF transformations, ellipsis filling

;;(load-compile "transform" *intervr-home*)

(setq *show-nlp-output* t)
;;;----------------------------------------------------------------------

;(defun reference-error (message)
;  (talk message)
;  (talk-and-echo "I don't sense anything")
;  (throw 'reference-error 'error))
