;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/focal/focalg.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; FOCALG

;;; Original code and comments by Gina-Anne Levow, MIT


(DEFVAR *FOC-STACK* ())
; the stack of foci  to current point in discourse


(DEFVAR *CUR-FOCUS* ())
; current discourse focus


(DEFVAR *ALT-FOC-LIST* ())
; list of alternate foci from _last_ sentence 


(DEFVAR *ACTOR-FOCUS* ())
; current actor focus


(DEFUN CLEANUP ()
  (SETF *ACTOR-FOCUS* NIL)
  (SETF *CUR-FOCUS* NIL)
  (SETF *FOC-STACK* NIL))

(DEFUN CLEANUP! () (CLEANUP) (SETF *ALT-FOC-LIST* NIL))

(DEFUN FOC-ALG-INPUT (NEW-ALFL ANAPH-RES-LIST)
  (LET ((REFS (RESOLVE-ANAPHORS NEW-ALFL ANAPH-RES-LIST NIL)))
    (SETF NEW-ALFL (AFL-ANAPH-RES REFS NEW-ALFL)))
  (FOCUS-ALG NEW-ALFL))

(DEFUN RESOLVE-QUANTIFIER-NPS (ALFL)
  (IF (OR (NULL ALFL) (NULL (CAR ALFL)))
      NIL
    (LET ((NP (FIRST ALFL)) (NEXT (SECOND ALFL)))
      (WHEN (AND (NULL (THIRD NP)) (NULL (FIFTH NP)))
        (SETF (THIRD NP) (THIRD NEXT) (FIFTH NP) (FIFTH NEXT)))
      (RESOLVE-QUANTIFIER-NPS (CDR ALFL)))))

(DEFUN AFL-ANAPH-RES (RES-PAIRS ALFL)
  (IF (NULL RES-PAIRS)
      ALFL
    (AFL-ANAPH-RES (CDR RES-PAIRS)
     (ONE-ANAPH-AFL (CAR RES-PAIRS) ALFL 0))))

(DEFUN ONE-ANAPH-AFL (RES-PAIR ALFL NUM)
  (IF (CONSP (CAAR RES-PAIR)) (SETF RES-PAIR (CAR RES-PAIR)))
  (IF (OR (NULL ALFL) (> NUM (LENGTH ALFL)))
      (REFERENCE-ERROR "anaphor missing from noun phrase list")
    (IF (EQUAL (ID (CAR RES-PAIR)) (ID (NTH NUM ALFL)))
        (PROGN (SETF (FIFTH (NTH NUM ALFL)) (REF-ELT RES-PAIR))
               (SETF (THIRD (NTH NUM ALFL))
                     (MOST-SPECIFIC-TYPE (REF-ELT RES-PAIR) NIL))
               ALFL)
      (ONE-ANAPH-AFL RES-PAIR ALFL (+ NUM 1)))))

(DEFUN ID (ELT) (FIRST ELT))

(DEFUN REF-ELT (RES-PAIR) (CDR RES-PAIR))

(DEFUN RESOLVE-ANAPHORS (NEW-ALFL ANAPH-RES-LIST RES-PAIRS)
  (DECLARE (SPECIAL REF-PAIR))
  (IF (NULL ANAPH-RES-LIST)
      RES-PAIRS
    (LET* ((ANAPH (FIRST ANAPH-RES-LIST))
           (VAL
            (WHEN (IS-ASSOCIATION-ANAPHOR (THIRD ANAPH) NIL)
              (FIRST (PROCESS-ASSOCIATION-ANAPHOR (FIRST ANAPH)
                      (SECOND ANAPH) (THIRD ANAPH) (FOURTH ANAPH) NIL
                      NIL (THIRD ANAPH))))))
      (SETF REF-PAIR
            (IF VAL
                (CONS (BUTLAST VAL) (FIRST (LAST VAL)))
              (OR (FIND-INTRASENTENTIAL-REF ANAPH NEW-ALFL RES-PAIRS)
                  (FIND-REF (FIRST ANAPH-RES-LIST)))))
      (COND ((NULL REF-PAIR) (SETF RES-PAIRS RES-PAIRS))
            ((OR (AND (CONSP (CDR REF-PAIR)) (NULL (CDDR REF-PAIR)))
                 (EQUAL (SECOND (CAR REF-PAIR)) 'PLURAL)
                 (MEMBER (SECOND (CAR REF-PAIR))
                         '(THEM THEY THESE THOSE)))
             (IF (NULL RES-PAIRS)
                 (SETF RES-PAIRS (CONS REF-PAIR NIL))
               (SETF RES-PAIRS (CONS RES-PAIRS (CONS REF-PAIR NIL)))))
            (T
             (PROGN (SETF (CDR REF-PAIR) (PICK-ONE REF-PAIR))
                    (IF (NULL RES-PAIRS)
                        (SETF RES-PAIRS (CONS REF-PAIR NIL))
                      (SETF RES-PAIRS
                            (CONS RES-PAIRS (CONS REF-PAIR NIL)))))))
      (RESOLVE-ANAPHORS NEW-ALFL (CDR ANAPH-RES-LIST) RES-PAIRS))))

(DEFUN FIND-INTRASENTENTIAL-REF (ANAPH NEW-ALFL RES-PAIRS)
  (LET* ((INDEX (FIRST ANAPH))
         (PRIOR-DE
          (FIND-IF
             #'(LAMBDA (ELT)
                 (AND (EQ (FIRST ELT) INDEX) (THIRD ELT) (FIFTH ELT)))
             NEW-ALFL))
         (PRIOR-ANAPHOR
          (FIND-IF #'(LAMBDA (ELT) (EQ (FIRST (FIRST ELT)) INDEX))
                   RES-PAIRS))
         (CLASS
          (IF PRIOR-DE (THIRD PRIOR-DE) (THIRD (FIRST PRIOR-ANAPHOR))))
         (REFS (IF PRIOR-DE (FIFTH PRIOR-DE) (CDR PRIOR-ANAPHOR)))
         (DE
          (FIND-IF
             #'(LAMBDA (ELT)
                 (AND (EQ (FIRST ELT) INDEX)
                      (EQ (SECOND ELT) (SECOND ANAPH))))
             NEW-ALFL)))
    (WHEN (OR PRIOR-DE PRIOR-ANAPHOR)
      (SETF (THIRD DE) CLASS)
      (SETF (FIFTH DE) REFS)
      (CONS ANAPH REFS))))

;; "[redefined]"
;; (DEFUN PICK-ONE (REF-PAIR)
;;   (DECLARE (SPECIAL CHOICE))
;;   (FORMAT T "There is more than one possible referent.~%")
;;   (FORMAT T "Please enter the appropriate number.~%")
;;   (DISPLAY-LIST (CDR REF-PAIR) 1)
;;   (CLEAR-INPUT)
;;   (SETF CHOICE
;;         (- (CHAR-INT (CHAR (READ-LINE *STANDARD-INPUT* NIL NIL NIL) 0))
;;            48))
;;   (LIST (NTH (- CHOICE 1) (CDR REF-PAIR))))

(DEFUN DISPLAY-LIST (REF-LIST NUM)
  (IF (NULL REF-LIST)
      NIL
    (PROGN (PRINT NUM) (PRINT (CAR REF-LIST))
           (DISPLAY-LIST (CDR REF-LIST) (+ NUM 1)))))

;; "[redefined]"
;; (DEFUN FIND-REF (ANAPH &OPTIONAL NO-ERROR MODIFIERS)
;;   (IF MODIFIERS
;;       NIL
;;     (IF (NOT (EQUAL (FOURTH ANAPH) ':AGENT))
;;         (VALID-REF ANAPH NO-ERROR MODIFIERS)
;;       (IF (CAN-REF? ANAPH *ACTOR-FOCUS* NO-ERROR MODIFIERS)
;;           (CONS ANAPH *ACTOR-FOCUS*)
;;         (VALID-REF ANAPH NO-ERROR MODIFIERS)))))

(DEFVAR CUR-FOC-USED? ())

(DEFVAR ALFL-USED-NUM 0)

(DEFVAR ALFL-USED? ())

(DEFVAR STACK-USED? ())

(DEFUN VALID-REF (ANAPH &OPTIONAL NO-ERROR MODIFIERS)
  (DECLARE (SPECIAL FS-USED-NUM))
  (IF (CAN-REF? ANAPH *CUR-FOCUS* NO-ERROR MODIFIERS)
      (PROGN (SETF CUR-FOC-USED? T) (CONS ANAPH (FIFTH *CUR-FOCUS*)))
    (PROGN (SETF ALFL-USED-NUM
                 (CAN-REF-LIST? ANAPH *ALT-FOC-LIST* 1 NO-ERROR
                  MODIFIERS))
           (IF (> ALFL-USED-NUM 0)
               (PROGN (SETF ALFL-USED? T)
                      (CONS ANAPH
                            (FIFTH (NTH
                                    (- ALFL-USED-NUM 1)
                                    *ALT-FOC-LIST*))))
             (PROGN (SETF ALFL-USED? NIL)
                    (SETF FS-USED-NUM
                          (CAN-REF-LIST? ANAPH *FOC-STACK* 1 NO-ERROR
                           MODIFIERS))
                    (IF (> FS-USED-NUM 0)
                        (PROGN (SETF STACK-USED? T)
                               (CONS
                                ANAPH
                                (FIFTH
                                 (NTH (- FS-USED-NUM 1) *FOC-STACK*))))
                      (PROGN (SETF STACK-USED? NIL)
                             (UNLESS NO-ERROR
                               (REFERENCE-ERROR
                                (FORMAT
                                 NIL
                                 "[Nothing mentioned matches ~A]"
                                 (IF
                                  (MEMBER

                                   (SECOND ANAPH)
                                   '(SINGULAR PLURAL NOCOUNT))
                                  (TYPE-NAME (THIRD ANAPH))
                                  (SECOND ANAPH))))))))))))

(DEFUN CAN-REF-LIST? (ANAPH CAND-LIST NUM &OPTIONAL NO-ERROR MODIFIERS)
  (IF (NULL CAND-LIST)
      0
    (IF (CAN-REF? ANAPH (CAR CAND-LIST) NO-ERROR MODIFIERS)
        NUM
      (CAN-REF-LIST? ANAPH (CDR CAND-LIST) (+ NUM 1) NO-ERROR
       MODIFIERS))))

(DEFUN SAMENUM (ANAPH CAND)
  (IF (EQUAL ANAPH 'NOCOUNT)
      T
    (IF (OR (EQUAL ANAPH 'SINGULAR) (EQUAL ANAPH 'PLURAL))
        (EQUAL ANAPH CAND)
      (IF (MEMBER ANAPH '(IT THAT THIS HE HIM SHE HER))
          (NOT (EQUAL CAND 'PLURAL))
        (EQUAL CAND 'PLURAL)))))

(DEFUN CAN-REF? (ANAPH CAND &OPTIONAL NO-ERROR MODIFIERS)
  (IF (NULL MODIFIERS)
      (AND (SAMENUM (FOCAL-NUMBER ANAPH) (FOCAL-NUMBER CAND))
           (MATCH (FOCAL-TYPE ANAPH) (FOCAL-TYPE CAND))
           (NOT (EQ (SECOND CAND) 'YOU))
           (IF (NULL (FIFTH CAND)) (NOT NO-ERROR) T))
    (LET* ((NID NIL)
           (NCOUNT (SECOND ANAPH))
           (NTYPE (THIRD ANAPH))
           (NROLE NIL)
           (SPECIFS MODIFIERS)
           (NUM 'THE)
           (DET NCOUNT)
           (MOD-LIST (LIST 'TYPE NTYPE))
           (VROLES NIL)
           (NLIST NIL)
           (DE
            (FIRST (MODIFIERS NID NCOUNT NTYPE NROLE SPECIFS NUM DET
                    MOD-LIST VROLES NLIST 'NO-ERROR NIL)))
           (REF-SET (FIFTH DE)))
      (AND (SAMENUM (FOCAL-NUMBER ANAPH) (FOCAL-NUMBER CAND))
           (MEMBER (FIRST (FIFTH CAND)) REF-SET)))))

(DEFUN REDUCE-SPECS (SPECS)
  (MAPCAN #'(LAMBDA (SPEC)
              (LIST (CAR SPEC)
                    (IF (NUMBERP (SECOND SPEC))
                        (SECOND SPEC)
                      (NCLASS-TO-SPEC
                       (SECOND (THIRD (SECOND SPEC)))))))
          SPECS))

(DEFUN FOCAL-NUMBER (OBJ)
  (CASE (SECOND OBJ)
    ((SINGULAR PLURAL NOCOUNT) (SECOND OBJ))
    ((THAT IT HIM HE HER SHE ME I) 'SINGULAR)
    ((THEY THEM THESE THOSE US WE) 'PLURAL)
    (T 'SINGULAR)))

(DEFUN FOCAL-TYPE (OBJ) (CADDR OBJ))

(DEFUN ROLE (OBJ) (CADDDR OBJ))

(DEFUN MATCHES (TYPE1 TYPE2) (EQUAL TYPE1 TYPE2))

(DEFUN FOCUS-ALG (NEW-ALFL)
  (IF CUR-FOC-USED?
      (PROGN (SETF CUR-FOC-USED? NIL) T)
    (IF ALFL-USED?
        (PROGN (SETF ALFL-USED? NIL)
               (IF (< ALFL-USED-NUM 1)
                   (REFERENCE-ERROR "Hmmm...error in focus algorithm"))
               (SETF *CUR-FOCUS*
                     (NTH (- ALFL-USED-NUM 1) *ALT-FOC-LIST*))
               (SETF *FOC-STACK* (CONS *CUR-FOCUS* *FOC-STACK*))
               (SETF ALFL-USED-NUM 0))
      (PROGN (IF (NOT (NULL *CUR-FOCUS*))
                 (SETF *FOC-STACK* (CONS *CUR-FOCUS* *FOC-STACK*)))
             (SETF *CUR-FOCUS* (CAR NEW-ALFL)))))
  (SETF *ALT-FOC-LIST* NEW-ALFL))

(DEFUN VALID-REF-NO-ERROR (ANAPH)
  (DECLARE (SPECIAL FS-USED-NUM))
  (IF (CAN-REF? ANAPH *CUR-FOCUS*)
      (PROGN (SETF CUR-FOC-USED? T)
             (CONS (BUTLAST ANAPH) (FIFTH *CUR-FOCUS*)))
    (PROGN (SETF ALFL-USED-NUM (CAN-REF-LIST? ANAPH *ALT-FOC-LIST* 1))
           (IF (> ALFL-USED-NUM 0)
               (PROGN (SETF ALFL-USED? T)
                      (CONS (BUTLAST ANAPH)
                            (FIFTH (NTH
                                    (- ALFL-USED-NUM 1)
                                    *ALT-FOC-LIST*))))
             (PROGN (SETF FS-USED-NUM
                          (CAN-REF-LIST? ANAPH *FOC-STACK* 1))
                    (IF (> FS-USED-NUM 0)
                        (PROGN (SETF STACK-USED? T)
                               (CONS
                                (BUTLAST ANAPH)
                                (FIFTH
                                 (NTH (- FS-USED-NUM 1) *FOC-STACK*))))
                      NIL))))))