;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/focal/prediscr.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; PREDISCR

;;; Original code and comments by Gina-Anne Levow, MIT


(DEFUN DISC-SETUP (XN)
  (DECLARE (SPECIAL *ANAPHS-TO-RES* ALFL))
  (SETF *ANAPHS-TO-RES* NIL)
  (SETF ALFL (AGT-LAST (TRAV-MAIN XN) NIL NIL))
  (SETF *ANAPHS-TO-RES* (FIND-REST-REFS ALFL))
  ALFL)

(DEFUN FIND-REST-REFS (ALFL)
  (DECLARE (SPECIAL *ANAPHS-TO-RES*))
  (IF (NULL ALFL)
      *ANAPHS-TO-RES*
    (IF (EQUAL (FIFTH (CAR ALFL)) 'REF)
        (PROGN (SETF *ANAPHS-TO-RES* (CONS (CAR ALFL) *ANAPHS-TO-RES*))
               (FIND-REST-REFS (CDR ALFL)))
      (FIND-REST-REFS (CDR ALFL)))))

(DEFVAR *YOU* ())

;; "[redefined]"
;; (DEFUN TRAV-MAIN (LIST1 &AUX *WFF)
;;   (DECLARE (SPECIAL *YOU* *WFF))
;;   (SETQ *WFF LIST1)
;;   (IF (NULL LIST1)
;;       NIL
;;     (IF (EQUAL (CAR LIST1) 'ASKWH)
;;         (LET ((VAL (TRAV-VP (SETQ *WFF (THIRD LIST1)) NIL))
;;               (WH (SECOND LIST1)))
;;           (WHEN (EQ (FOURTH WH) 'PLURAL) (SETF (FOURTH WH) 'NOCOUNT))
;;           (LET ((WH-WFF (FIND-WH-WFF *WFF (SECOND WH))))
;;             (APPEND VAL
;;                     (TRAV-NP
;;                      (LIST (CONS (GET-PRO-SLOT WH-WFF (SECOND WH))
;;                                  (LIST WH)))
;;                      (GET-VERB WH-WFF)))))
;;       (IF (EQ (CAR LIST1) 'TELLIF)
;;           (TRAV-VP (SECOND LIST1) NIL)
;;         (IF (MEMBER (CAR LIST1) '(AND OR))
;;             (MELD (TRAV-VP (SECOND LIST1) NIL)
;;              (TRAV-MAIN (THIRD LIST1)))
;;           (IF (EQ (CAR LIST1) 'ADDRESS)
;;               (LET ((YOU
;;                      (TRAV-NP
;;                       (LIST (CONS (GET-YOU-SLOT (THIRD LIST1))
;;                                   (LIST (SECOND LIST1))))
;;                       (GET-VERB (THIRD LIST1)))))
;;                 (SETQ *YOU* (LAST (FIRST YOU)))
;;                 (IF (CONSP (FIRST *YOU*)) (SETQ *YOU* (FIRST *YOU*)))
;;                 (APPEND YOU (TRAV-MAIN (THIRD LIST1))))
;;             (TRAV-VP LIST1 NIL)))))))

(DEFUN MELD (LIST1 LIST2)
  (IF (NULL LIST2)
      NIL
    (IF (AND (EQUAL (FOURTH (CAR LIST1)) ':THEME)
             (EQUAL (FOURTH (CAR LIST1)) (FOURTH (CAR LIST2))))
        (LIST (CAR LIST1) (CAR LIST2) (APPEND (CDR LIST1) (CDR LIST2)))
      (APPEND LIST1 LIST2))))

(DEFUN GET-PRO-SLOT (WFF ID)
  (WHEN WFF
    (IF (ATOM (CAR WFF))
        (GET-PRO-SLOT (CDR WFF) ID)
      (GET-EMPTY (CDR WFF) ID))))

(DEFUN GET-EMPTY (ROLES ID)
  (IF (EQ (SECOND (CAR ROLES)) ID)
      (CAAR ROLES)
    (GET-EMPTY (CDR ROLES) ID)))

(DEFUN FIND-WH-WFF (WFF ID)
  (IF (FIND-IF
         #'(LAMBDA (ELT)
             (AND (CONSP ELT) (KEYWORDP (FIRST ELT))
                  (EQ (SECOND ELT) ID)))
         WFF)
      WFF
    (FIND-WH-WFF-IN-ARGS WFF ID)))

(DEFUN FIND-WH-WFF-IN-ARGS (WFF ID)
  (LET ((ELT (FIRST WFF)))
    (IF (NULL ELT)
        NIL
      (OR (AND (CONSP ELT)
               (IF (KEYWORDP (FIRST ELT))
                   (AND (CONSP (SECOND ELT))
                        (FIND-WH-WFF (SECOND ELT) ID))
                 (FIND-WH-WFF ELT ID)))
          (FIND-WH-WFF-IN-ARGS (CDR WFF) ID)))))

(DEFUN GET-YOU-SLOT (WFF)
  (LET ((ROLETERM (FIRST WFF)))
    (IF (NULL ROLETERM)
        NIL
      (IF (ATOM ROLETERM)
          (GET-YOU-SLOT (CDR WFF))
        (LET* ((ROLE (FIRST ROLETERM)) (TERM (SECOND ROLETERM)))
          (IF (AND (CONSP TERM) (MEMBER (FOURTH TERM) '(YOU NULLYOU)))
              ROLE
            (GET-YOU-SLOT (CDR WFF))))))))

(DEFUN GET-NTH-LIST (LIST1 NUM)
  (IF (NULL LIST1)
      NIL
    (IF (ATOM (CAR LIST1))
        (GET-NTH-LIST (CDR LIST1) NUM)
      (IF (> NUM 1)
          (GET-NTH-LIST (CDR LIST1) (- NUM 1))
        (IF (NULL (CDR LIST1)) LIST1 (CAR LIST1))))))

(DEFUN GET-REST (LIST1 NUM)
  (IF (NULL LIST1)
      NIL
    (IF (ATOM (CAR LIST1))
        (GET-REST (CDR LIST1) NUM)
      (IF (> NUM 1) (GET-REST (CDR LIST1) (- NUM 1)) LIST1))))

(DEFUN TRAV-VP (WFF VROLES)
  (IF (NULL WFF)
      NIL
    (IF (MEMBER 'ONEOF WFF)
        (PROGN (PARSER-MESSAGE "[Note: ambiguous semantics]")
               (TRAV-VP (SECOND (MEMBER 'ONEOF WFF)) VROLES))
      (IF (NULL VROLES)
          (TRAV-NP (GET-REST WFF 2) (GET-VERB WFF))
        (TRAV-NP (GET-REST WFF 2) VROLES)))))

(DEFVAR NLIST ())

(DEFUN ATOMIC (NPELT)
  (OR (ATOM NPELT)
      (AND (CONSP NPELT) (MEMBER (FIRST NPELT) '(AND OR))
           (ATOMIC (THIRD NPELT)))))

(DEFUN TRAV-NP (ELTS VROLES &AUX Q-OF-CLASS)
  (IF (NULL ELTS)
      NIL
    (LET* ((ELT (FIRST ELTS))
           (ELTROLE (FIRST ELT))
           (NPELT (OR (THIRD ELT) (SECOND ELT))))
      (IF (ATOMIC NPELT)
          (TRAV-NP (CDR ELTS) VROLES)
        (IF (MY-ASSOC :Q-OF NPELT)
            (LET ((SUB-NPELT
                   (OR (SECOND (MY-ASSOC :Q-OF NPELT))
                       `(NULL-DET ,(MAKE-NP-INDEX) (:CLASS ,Q-OF-CLASS)
                         NOCOUNT)))
                  (TOP-DE
                   (LIST (SECOND NPELT)
                         (IF (EQ (FIRST NPELT) 'ONE) 'SINGULAR 'PLURAL)
                         NIL ELTROLE NIL)))
              (CONS TOP-DE
                    (TRAV-NP (CONS (LIST ELTROLE SUB-NPELT) (CDR ELTS))
                     VROLES)))
          (IF (NOT (IS-REFERENTIAL NPELT))
              (APPEND (IF (EQ (FIRST NPELT) 'AND)
                          (FOREACH ELT IN (CDR NPELT) JOIN
                           (TRAV-VP ELT NIL))
                        (TRAV-VP NPELT NIL))
                      (TRAV-NP (CDR ELTS) VROLES))
            (IF (EQ (FIRST NPELT) 'ONEOF)
                (REFERENCE-ERROR "Ambiguous semantics")
              (LET* ((NTYPE
                      (LET ((VAL (GET-TYPE ELTROLE VROLES))
                            (CLASS (GET-CLASS NPELT)))
                        (IF (NULL VAL)
                            CLASS
                          (IF (GETF (GET CLASS 'SLOT-SPECS) :Q-OF)
                              VAL
                            (IF (CONSP VAL)
                                (REMOVE

                                 NIL
                                 (MAPCAR
                                  #'(LAMBDA
                                     (V)
                                     (PASS-CONSTRAINT CLASS V))
                                  VAL))
                              (OR (PASS-CONSTRAINT CLASS VAL)
                                  CLASS))))))
                     (NID (SECOND NPELT))
                     (NCOUNT (FOURTH NPELT)))
                (WHEN (CONSP NTYPE)
                  (SETQ NTYPE (REMOVE-DUPLICATES NTYPE))
                  (IF (NULL (CDR NTYPE)) (SETQ NTYPE (FIRST NTYPE))))
                (IF (OR (NULL NID) (EQ NCOUNT 'NULLAGENT))
                    (TRAV-NP (CDR ELTS) VROLES)
                  (LET ((DE
                         (OR (EXISTING-DE NPELT NID)
                             (TRAV-NP-SUB ELTROLE NPELT VROLES NTYPE
                              NID NCOUNT))))
                    (IF (SYMBOLP (FIRST DE)) (SETQ DE (LIST DE)))
                    (APPEND DE (TRAV-NP (CDR ELTS) VROLES))))))))))))

(DEFUN EXISTING-DE (NPELT NID)
  (DECLARE (SPECIAL *PREVIOUS-ALT-FOC-LIST*))
  (AND (IS-DEICTIC-NP NPELT) (MY-ASSOC NID *PREVIOUS-ALT-FOC-LIST*)))

(DEFUN PASS-CONSTRAINT (CLASS VAL)
  (IF (HAS-TYPE CLASS VAL)
      CLASS
    (IF (HAS-TYPE VAL CLASS)
        VAL
      (OR (PASSES-CONSTRAINT CLASS VAL)
          (IF (CONSTRAINT-PASSES VAL CLASS) CLASS)))))

(DEFUN TRAV-NP-SUB (ELTROLE NPELT VROLES NTYPE NID NCOUNT &AUX *TYP)
  (DECLARE (SPECIAL *TYP *SPEC *ANAPHS-TO-RES* *OBJLIST*))
  (IF (AND (EQUAL (FIRST NPELT) 'NAME)
           (NOT (MEMBER NCOUNT
                        '(ANYONE ANYTHING EVERYONE EVERYTHING SOMEONE
                          SOMETHING NULLAGENT))))
      (SETF *SPEC NCOUNT)
    (SETF *SPEC NIL))
  (SETF *TYP NTYPE)
  (IF (IS-ANAPHORIC NPELT)
      (SETF *ANAPHS-TO-RES*
            (APPEND *ANAPHS-TO-RES*
                    (LIST (LIST NID NCOUNT NTYPE ELTROLE)))))
  (IF (IS-YOU NPELT)
      (LET ((REF-SET (FOUND-YOU (FIRST NPELT) (FOURTH NPELT) NTYPE)))
        (LIST NID NCOUNT (MOST-SPECIFIC-TYPE REF-SET NTYPE) ELTROLE
              (IF (CONSP REF-SET)
                  (IF (CDR REF-SET) REF-SET (CAR REF-SET))
                REF-SET)))
    (IF (AND (IS-DEFINITE-NP NPELT) (NOT (IS-ANAPHORIC NPELT))
             (NOT (IS-DEICTIC-NP NPELT)))
        (PROCESS-DEFINITE-NP NID NCOUNT NTYPE ELTROLE NPELT VROLES *TYP
         *SPEC)
      (IF (MEMBER (FIRST NPELT) '(AND OR))
          (PROCESS-CONJOINED-NP NPELT ELTROLE VROLES NTYPE)
        (IF (NOT (NULL (FIFTH NPELT)))
            (MODIFIERS NID NCOUNT NTYPE ELTROLE (CDDDDR NPELT)
             (FIRST NPELT) (FOURTH NPELT) (LIST 'TYPE *TYP) VROLES NIL)
          (LET ((REF-SET
                 (IF (IS-ANAPHORIC NPELT)
                     NIL
                   (FOUND-ELT *TYP *SPEC *OBJLIST* (FIRST NPELT)
                    (FOURTH NPELT)))))
            (LIST NID NCOUNT (MOST-SPECIFIC-TYPE REF-SET NTYPE) ELTROLE
                  (IF (CONSP REF-SET)
                      (IF (CDR REF-SET) REF-SET (CAR REF-SET))
                    REF-SET))))))))

(DEFUN PROCESS-DEFINITE-NP
    (NID NCOUNT NTYPE ELTROLE NPELT VROLES *TYP *SPEC)
  (DECLARE (SPECIAL *TYP *OBJLIST* *YOU*))
  (LET* ((ANAPH (LIST NID NCOUNT NTYPE ELTROLE))
         (REFS (FIND-REF ANAPH 'NO-ERROR (NTHCDR 4 NPELT))))
    (IF (AND REFS (EQ (FIRST NPELT) 'THE))
        (APPEND (FIRST REFS) (LIST (CDR REFS)))
      (IF (IS-ASSOCIATION-ANAPHOR NTYPE NPELT)
          (PROCESS-ASSOCIATION-ANAPHOR NID NCOUNT NTYPE ELTROLE NPELT
           VROLES *TYP)
        (IF (NOT (NULL (FIFTH NPELT)))
            (MODIFIERS NID NCOUNT NTYPE ELTROLE (CDDDDR NPELT)
             (FIRST NPELT) (FOURTH NPELT) (LIST 'TYPE *TYP) VROLES NIL)
          (LET ((REF-SET
                 (FOUND-ELT *TYP *SPEC *OBJLIST* (FIRST NPELT)
                  (FOURTH NPELT))))
            (LIST NID NCOUNT (MOST-SPECIFIC-TYPE REF-SET NTYPE) ELTROLE
                  (IF (CONSP REF-SET)
                      (IF (CDR REF-SET) REF-SET (CAR REF-SET))
                    REF-SET))))))))

(DEFUN IS-ASSOCIATION-ANAPHOR (NTYPE NPELT)
  (OR (AND (EQ NTYPE 'P-STATION) (ASSOC :ID (NTHCDR 4 NPELT))
           (NOT (ASSOC :SECTOR-ID (NTHCDR 4 NPELT))))
      (AND (EQ NTYPE 'P-SECTOR) (NOT (ASSOC :ID (NTHCDR 4 NPELT))))))

(DEFUN PROCESS-ASSOCIATION-ANAPHOR
    (NID NCOUNT NTYPE ELTROLE NPELT VROLES *TYP)
  (LET* ((REF-PAIR
          (FIND-REF (LIST NIL 'NOCOUNT 'P-STATION-SECTOR NIL) 'NO-ERROR
           NIL))
         (REFS (CDR REF-PAIR))
         (REF (IF (CONSP REFS) (FIRST REFS) REFS))
         (SECTOR-ID (OR (GET REF :SECTOR-ID) (GET REF :ID))))
    (MODIFIERS NID NCOUNT NTYPE ELTROLE
     (CONS (IF (EQ NTYPE 'P-STATION)
               (LIST :SECTOR-ID SECTOR-ID)
             (LIST :ID SECTOR-ID))
           (NTHCDR 4 NPELT))
     (FIRST NPELT) (FOURTH NPELT) (LIST 'TYPE *TYP) VROLES NIL)))

(DEFUN PROCESS-CONJOINED-NP
    (NPELT ELTROLE VROLES NTYPE &AUX SYM ARG1 ARG2)
  (DECLARE (SPECIAL *WFF))
  (COND ((EQ (LENGTH NPELT) 4)
         (SETQ SYM (SECOND NPELT)
               ARG1 (THIRD NPELT)
               ARG2 (FOURTH NPELT))
         (INSERT-SYM-IN-ANAPHOR SYM *WFF))
        (T
         (SETQ SYM (MAKE-NP-INDEX)
               ARG1 (SECOND NPELT)
               ARG2 (THIRD NPELT))
         (INSERT-SYM-IN-ANAPHOR SYM *WFF)
         (RPLACD NPELT (CONS SYM (CDR NPELT)))))
  (LET ((REF-SET (CONJ-NP-OBJS ARG1 ARG2 ELTROLE VROLES)))
    (LIST SYM 'PLURAL (MOST-SPECIFIC-TYPE REF-SET NTYPE) ELTROLE
          REF-SET)))

(DEFUN INSERT-SYM-IN-ANAPHOR (SYM FORM)
  (WHEN (CONSP FORM)
    (IF (AND (EQ (FIRST FORM) 'PRON) (NULL (SECOND FORM)))
        (SETF (SECOND FORM) SYM)
      (OR (INSERT-SYM-IN-ANAPHOR SYM (CAR FORM))
          (INSERT-SYM-IN-ANAPHOR SYM (CDR FORM))))))

(DEFUN IS-REFERENTIAL (LF)
  (AND (CONSP LF)
       (OR (IS-Q (FIRST LF)) (MEMBER (FIRST LF) '(NAME PRON))
           (AND (MEMBER (FIRST LF) '(AND OR))
                (AND (IS-REFERENTIAL
                      (IF (IS-VAR (SECOND LF))
                          (FOURTH LF)
                        (SECOND LF)))
                     (IS-REFERENTIAL (THIRD LF)))))))

(DEFUN INSTANTIATE-OBJECT
    (NPELT NID NCOUNT NTYPE ELTROLE *TYP VROLES *SPEC)
  (DECLARE (IGNORE NPELT *TYP VROLES *SPEC))
  (LET ((REF (GENTEMP "INDEF-")))
    (SETF (GET REF 'TYPE) NTYPE)
    (LIST NID NCOUNT NTYPE ELTROLE (LIST REF))))

(DEFUN IS-NP-FORM (NPELT) (AND (CONSP NPELT) (> (LENGTH NPELT) 2)))

(DEFUN IS-YOU (NPELT)
  (AND (IS-NP-FORM NPELT)
       (MEMBER (FOURTH NPELT) '(YOU NULLYOU YOURSELF))))

(DEFUN IS-UNIVERSAL-NP (NPELT)
  (AND (IS-NP-FORM NPELT)
       (OR (EQ (FIRST NPELT) 'ALL)
           (MEMBER (FOURTH NPELT) '(EVERYONE EVERYTHING EVERYBODY)))))

(DEFUN IS-DEFINITE-NP (NPELT)
  (AND (IS-NP-FORM NPELT)
       (OR (MEMBER (FIRST NPELT) '(THE THAT THIS))
           (AND (EQ (FIRST NPELT) 'PRON)
                (MEMBER (FOURTH NPELT)
                        '(THAT THEY THEM IT HE SHE HIM HER ME I)))
           (AND (EQ (FIRST NPELT) 'NULL-DET)
                (EQ (FOURTH NPELT) 'SINGULAR)))))

(DEFUN IS-PLURAL-NP (NPELT)
  (AND (IS-NP-FORM NPELT)
       (OR (EQ (FOURTH NPELT) 'PLURAL)
           (AND (EQ (FIRST NPELT) 'PRON)
                (MEMBER (FOURTH NPELT)
                        '(THOSE THESE THEY THEM US WE))))))

(DEFUN IS-DEICTIC-NP (NPELT)
  (AND (IS-NP-FORM NPELT)
       (OR (EQ (FIRST NPELT) 'THIS)
           (MEMBER (FOURTH NPELT) '(THIS THESE)))))

(DEFUN IS-INDEFINITE-NP (NPELT)
  (AND (IS-NP-FORM NPELT)
       (OR (MEMBER (FIRST NPELT) '(SOME MANY MUCH MOST NO ONE NONE))
           (MEMBER (FOURTH NPELT)
                   '(ANYONE ANYTHING ANYBODY SOMEONE SOMETHING SOMEBODY
                     THIS THESE))
           (AND (EQ (FIRST NPELT) 'NULL-DET)
                (EQ (FOURTH NPELT) 'PLURAL)))))

;; "[redefined]"
;; (DEFUN REFERENCE-ERROR (MESSAGE)
;;   (PARSER-MESSAGE (FORMAT NIL "~A." MESSAGE))
;;   (THROW 'REFERENCE-ERROR 'ERROR))

;; "[redefined]"
;; (DEFUN PARSER-MESSAGE (MESSAGE) (FORMAT T ";~A~%" MESSAGE))

(DEFUN NLP-ERROR-MESSAGE (MESSAGE) (FORMAT T ">>Error: ~A~%" MESSAGE))

(DEFUN IS-ANAPHORIC (NPELT)
  (OR (AND (EQUAL (FIRST NPELT) 'PRON)
           (OR (MEMBER (FOURTH NPELT)
                       '(THEY THEM IT HE SHE HIM HER THAT))
               (IS-REFLEXIVE (FOURTH NPELT))))
      (EQ (FIRST NPELT) 'THAT)))

(DEFUN UPDATE-ANAPHOR-LIST (NID NCOUNT NTYPE ELTROLE)
  (DECLARE (SPECIAL *ANAPHS-TO-RES*))
  (SETF *ANAPHS-TO-RES*
        (APPEND *ANAPHS-TO-RES*
                (CONS (LIST NID NCOUNT NTYPE ELTROLE NIL) NIL))))

(DEFUN MOST-SPECIFIC-TYPE (SET TYPE)
  (IF (CONSP SET)
      (IF (OR (STRINGP (FIRST SET)) (NUMBERP (FIRST SET)))
          TYPE
        (CLOSEST-COMMON-ANCESTOR (GET-TINSEL-TYPE (FIRST SET))
         (CDR SET)))
    (OR TYPE (GET-TINSEL-TYPE SET))))

(DEFUN GET-TINSEL-TYPE (OBJ) (GET OBJ 'TYPE))

(DEFUN FLATTEN-LIST (LIST)
  (COND ((NOT (CONSP LIST)) NIL)
        ((CONSP (FIRST LIST))
         (APPEND (FLATTEN-LIST (FIRST LIST))
                 (FLATTEN-LIST (CDR LIST))))
        (T (CONS (FIRST LIST) (FLATTEN-LIST (CDR LIST))))))

(DEFUN CLOSEST-COMMON-ANCESTOR (TYPE OBJS)
  (COND ((NULL OBJS) TYPE)
        ((NULL TYPE) NIL)
        ((CONSP TYPE)
         (OR (CLOSEST-COMMON-ANCESTOR (CAR TYPE) OBJS)
             (CLOSEST-COMMON-ANCESTOR (CDR TYPE) OBJS)))
        (T
         (LET ((OBJTYPE (GET-TINSEL-TYPE (CAR OBJS))))
           (IF (HAS-TYPE OBJTYPE TYPE)
               (CLOSEST-COMMON-ANCESTOR TYPE (CDR OBJS))
             (CLOSEST-COMMON-ANCESTOR (GET TYPE 'ISA) OBJS))))))

(DEFUN VERBAL? (WFF)
  (IF (OR (EQ (GET (CAR WFF) 'LOGICAL-TYPE) 'OP1)
          (CHAR-EQUAL (CHAR (STRING (CAR WFF)) 0) #\V))
      T
    NIL))

(DEFUN ANSTG-PROC (TYPE ADJS DET NUM)
  (DECLARE (SPECIAL *OBJLIST*))
  (IF (NULL ADJS)
      (FOUND-ELT TYPE NIL *OBJLIST* DET NUM)
    (IF (NULL (CDR ADJS))
        (FOUND-ELT TYPE (ADJVAL ADJS) *OBJLIST* DET NUM)
      (ANSTG-PROC (FOUND-ELT TYPE (ADJVAL ADJS) *OBJLIST* DET NUM)
       (CDR ADJS) DET NUM))))

(DEFUN ADJVAL (ADJS)
  (COND ((NULL ADJS) NIL)
        ((ATOM ADJS) ADJS)
        ((ATOM (CAR ADJS)) (CAR ADJS))
        (T (MAPCAR #'FIRST ADJS))))

(DEFUN MODIFIERS
    (NID NCOUNT NTYPE NROLE SPECIFS NUM DET MOD-LIST VROLES NLIST
     &OPTIONAL NO-ERROR RELCLS)
  (DECLARE (SPECIAL *SPEC))
  (IF (NULL SPECIFS)
      (LET ((REF-SET
             (LOOKUP MOD-LIST NUM DET NTYPE NO-ERROR RELCLS NLIST)))
        (CONS (LIST NID NCOUNT (MOST-SPECIFIC-TYPE REF-SET NTYPE) NROLE
                    (IF (CDR REF-SET) REF-SET (CAR REF-SET)))
              NLIST))
    (LET ((SPEC (CAR SPECIFS)))
      (IF (EQUAL (CAR SPEC) ':COUNT)
          (MODIFIERS NID NCOUNT NTYPE NROLE (CDR SPECIFS) NUM DET
           (APPEND MOD-LIST (LIST ':COUNT (CADR SPEC))) VROLES NLIST
           NO-ERROR RELCLS)
        (IF (EQUAL (CAR SPEC) 'AN-STG)
            (PROGN (SETF SPEC (SECOND SPEC))
                   (MODIFIERS NID NCOUNT NTYPE NROLE (CDR SPECIFS) NUM
                    DET
                    (APPEND MOD-LIST
                            (LIST 'SPEC (ADJVAL (REVERSE SPEC))))
                    VROLES NLIST NO-ERROR RELCLS))
          (IF (KEYWORDP (CAR SPEC))
              (PROGN (SETF *SPEC
                           (IF (OR
                                (STRINGP (SECOND SPEC))
                                (NUMBERP (SECOND SPEC)))
                               (SECOND SPEC)
                             (IF (THIRD SPEC)
                                 (THIRD SPEC)
                               (NCLASS-TO-SPEC
                                (SECOND
                                 (MY-ASSOC :CLASS (SECOND SPEC)))))))
                     (MODIFIERS NID NCOUNT NTYPE NROLE (CDR SPECIFS)
                      NUM DET (APPEND MOD-LIST (LIST (CAR SPEC) *SPEC))
                      VROLES
                      (APPEND NLIST
                              (IF (SYMBOLP NTYPE)
                                  (TRAV-NP
                                   (LIST SPEC)
                                   (GET NTYPE 'SLOT-SPECS))
                                (FOREACH
                                 NT
                                 IN
                                 NTYPE
                                 JOIN
                                 (TRAV-NP
                                  (LIST SPEC)
                                  (GET NT 'SLOT-SPECS)))))
                      NO-ERROR RELCLS))
            (IF (VERBAL? SPEC)
                (LET* ((VERB (SECOND (GET-NTH-LIST SPEC 1)))
                       (ROLE (CONVERT-VT VERB)))
                  (IF ROLE
                      (MODIFIERS NID NCOUNT NTYPE NROLE (CDR SPECIFS)
                       NUM DET
                       (APPEND MOD-LIST
                               (REL-MOD-OF VERB (TRAV-VP SPEC NIL)))
                       VROLES (APPEND (TRAV-VP SPEC NIL) NLIST)
                       NO-ERROR RELCLS)
                    (MODIFIERS NID NCOUNT NTYPE NROLE (CDR SPECIFS) NUM
                     DET MOD-LIST VROLES
                     (APPEND (TRAV-VP SPEC NIL) NLIST) NO-ERROR
                     (CONS SPEC RELCLS)))))))))))

(DEFUN REL-MOD-OF (VERB NOUNS)
  (LIST (CONVERT-VT VERB) (OR (NCLASS-TO-SPEC (FIFTH (CAR NOUNS))) T)))

(DEFUN CONVERT-VT (VERB)
  (DECLARE (SPECIAL *VERB-SLOT-MAPPINGS*))
  (AND (BOUNDP '*VERB-SLOT-MAPPINGS*) (GETF *VERB-SLOT-MAPPINGS* VERB)))

;; "[redefined]"
;; (DEFUN LOOKUP
;;     (MOD-LIST DET NUMBER TYPE &OPTIONAL NO-ERROR RELCLS NLIST)
;;   (DECLARE (SPECIAL *OBJLIST*))
;;   (LET ((RESULT (LOOKUP-SUB MOD-LIST *OBJLIST* RELCLS NLIST)))
;;     (PROCESS-DET-AND-NUMBER RESULT
;;      (IF (AND (EQ DET 'NULL-DET) (GETF MOD-LIST :ID)) 'THE DET) NUMBER
;;      TYPE NO-ERROR)))

(DEFUN LOOKUP-SUB (MOD-LIST OLIST &OPTIONAL RELCLS NLIST &AUX VALS)
  (WHEN (AND NLIST (CONSP (FIRST NLIST)))
    (SETF MOD-LIST (SPECIFY-MODLIST MOD-LIST NLIST)))
  (DO* ((OBLIST OLIST (CDR OBLIST)) (VAL (CAR OBLIST) (CAR OBLIST)))
       ((NULL VAL) (RETURN VALS))
    (IF (AND (CHECK-VAL VAL MOD-LIST) (CHECK-RELCLS VAL RELCLS NLIST))
        (PUSH VAL VALS))))

(DEFUN SPECIFY-MODLIST (MOD-LIST NLIST)
  (IF (NULL NLIST)
      MOD-LIST
    (LET* ((DE (FIRST NLIST))
           (DE-CLASS (THIRD DE))
           (ROLE (FOURTH DE))
           (MEM (MEMBER ROLE MOD-LIST)))
      (WHEN (AND MEM (HAS-TYPE DE-CLASS (SECOND MEM)))
        (SETF (SECOND MEM) DE-CLASS))
      (SPECIFY-MODLIST MOD-LIST (CDR NLIST)))))

;; "[redefined]"
;; (DEFUN CHECK-RELCLS (VAL RELCLS NLIST)
;;   (DECLARE (IGNORE VAL RELCLS NLIST))
;;   T)

(DEFUN CHECK-VAL (VAL MOD-LIST)
  (LET ((PLIST (SYMBOL-PLIST VAL)))
    (WHEN PLIST (CHECK-VAL-1 PLIST MOD-LIST))))

(DEFUN CHECK-VAL-1 (PLIST MOD-LIST)
  (IF (NULL MOD-LIST)
      T
    (LET ((P-TYPE (GETF PLIST (FIRST MOD-LIST))))
      (IF (CHECK-VAL-2 P-TYPE (FIRST MOD-LIST) (SECOND MOD-LIST))
          (CHECK-VAL-1 PLIST (CDDR MOD-LIST))))))

(DEFUN CHECK-VAL-2 (P-TYPE KEY VAL)
  (IF (NULL VAL)
      T
    (IF (EQ KEY 'TYPE)
        (MATCH VAL P-TYPE)
      (IF (ATOM VAL)
          (OR (HAS-TYPE VAL P-TYPE) (HAS-TYPE P-TYPE VAL))
        (EVERY #'(LAMBDA (ITEM) (HAS-TYPE ITEM P-TYPE)) VAL)))))

(DEFUN CONJ-NP-OBJS (FST SND ELTROLE VROLES)
  (LET ((REF1
         (FIFTH (CAR (TRAV-NP (LIST (CONS ELTROLE (LIST FST)))
                      VROLES))))
        (REF2
         (FIFTH (CAR (TRAV-NP (LIST (CONS ELTROLE (LIST SND)))
                      VROLES)))))
    (APPEND (IF (CONSP REF1) REF1 (LIST REF1))
            (IF (CONSP REF2) REF2 (LIST REF2)))))

(DEFUN SEP-LIST (LIST1) (IF (NULL (SECOND LIST1)) (CAR LIST1) LIST1))

(DEFVAR *TYP ())

(DEFVAR *SPEC ())

(DEFUN NCLASS-TO-SPEC (TYP)
  (COND ((EQUAL TYP 'P-AMBIGUITY) 'D-AMBIGUITY)
        ((EQUAL TYP 'P-HISTORY) 'D-HISTORY)
        ((EQUAL TYP 'P-PROBABILITY) 'D-PROBABILITY)
        ((EQUAL TYP 'P-TEST) 'D-TEST)
        ((EQUAL TYP 'P-STATE) 'D-STATE)
        ((EQUAL TYP 'P-FIS) 'D-FIS)
        ((EQUAL TYP 'P-UNIX) 'D-UNIX)
        ((EQUAL TYP 'P-GRAPHIC) 'D-GRAPHIC)
        ((EQUAL TYP 'P-FAULT) 'D-FAULT)
        ((EQUAL TYP 'P-KNOWLEDGE) 'D-KNOWLEDGE)
        ((EQUAL TYP 'P-UNIT) 'D-UUT)
        (T TYP)))

(DEFUN MATCH (T1 T2)
  (IF (CONSP T1)
      (FIND-IF #'(LAMBDA (TN) (MATCH TN T2)) T1)
    (IF (CONSP T2)
        (FIND-IF #'(LAMBDA (TN) (MATCH T1 TN)) T2)
      (HAS-TYPE T2 T1))))

;; "[redefined]"
;; (DEFUN FOUND-ELT (TYPE SPEC OLIST DET VAL)
;;   (IF (OR (EQUAL SPEC 'LAST) (EQUAL SPEC 'CURRENT)
;;           (EQUAL SPEC 'PREVIOUS))
;;       (SETF SPEC NIL))
;;   (LET ((RESULT (FOUND-ELT-SUB TYPE SPEC OLIST)))
;;     (PROCESS-DET-AND-NUMBER RESULT DET VAL TYPE)))

(DEFUN TYPE-NAME (TYPE)
  (COND ((NULL TYPE) "")
        ((SYMBOLP TYPE)
         (SUBSTITUTE #\Space #\-
                     (STRING-DOWNCASE
                        (OR (FIRST (GET TYPE 'NLEX)) (STRING TYPE)))))
        ((CDR (REMOVE-DUPLICATES TYPE))
         (CONCATENATE 'STRING (TYPE-NAME (FIRST TYPE)) " or "
                      (TYPE-NAME (CDR TYPE))))
        (T (TYPE-NAME (FIRST TYPE)))))

(DEFUN PROCESS-DET-AND-NUMBER
    (RESULT DET NUMBER TYPE &OPTIONAL NO-ERROR YOU &AUX TYPE-NAME)
  (SETQ TYPE-NAME (TYPE-NAME TYPE))
  (IF (NULL RESULT)
      (IF NO-ERROR
          NIL
        (IF YOU
            (REFERENCE-ERROR
             (FORMAT NIL "You aren't addressing ~A" TYPE-NAME))
          (REFERENCE-ERROR
           (FORMAT NIL "No such ~A exists" TYPE-NAME))))
    (IF (CDR RESULT)
        (CASE DET
          ((THE NULL-DET)
           (IF (EQ NUMBER 'SINGULAR)
               (IF NO-ERROR
                   NIL
                 (PROGN (GENERATE-DE-FOR-SET RESULT)
                        (REFERENCE-ERROR
                         (FORMAT NIL "More than one such ~A exists"
                                 TYPE-NAME))))
             (PICK-ONE (CONS DET RESULT))))
          ((SOME NO ONE) (PICK-ONE (CONS DET RESULT)))
          ((WHICH MUCH) RESULT)
          (ALL RESULT)
          ((THAT THOSE) RESULT)
          (T
           (IF (EQ NUMBER 'SINGULAR)
               (IF NO-ERROR
                   NIL
                 (PROGN (GENERATE-DE-FOR-SET RESULT)
                        (REFERENCE-ERROR
                         (FORMAT NIL "More than one such ~A exists"
                                 TYPE-NAME))))
             RESULT)))
      (IF (EQ NUMBER 'PLURAL)
          (IF (EQ DET 'THE)
              (IF (OR (NUMBERP (FIRST RESULT))
                      (AND (SYMBOLP (FIRST RESULT))
                           (GET (FIRST RESULT) 'COLLECTIVE)))
                  RESULT
                (IF NO-ERROR
                    NIL
                  (PROGN (GENERATE-DE-FOR-SET RESULT)
                         (REFERENCE-ERROR
                          (FORMAT NIL "Only one such ~A exists"
                                  TYPE-NAME)))))
            RESULT)
        (IF (EQ NUMBER 'SINGULAR)
            (IF (AND (SYMBOLP (FIRST RESULT))
                     (GET (FIRST RESULT) 'COLLECTIVE))
                RESULT
              RESULT)
          RESULT)))))

(DEFUN GENERATE-DE-FOR-SET (REFS)
  (DECLARE (SPECIAL *CUR-FOCUS*))
  (WHEN (AND (CONSP REFS) (CONSP (FIRST REFS)))
    (SETQ REFS (MAPCAR #'(LAMBDA (R) (ATTRIBUTE-VALUE R)) REFS)))
  (WHEN (CONSP REFS)
    (LET* ((NP-ID (MAKE-NP-INDEX))
           (NUMBER (IF (CDR REFS) 'PLURAL 'SINGULAR))
           (SEMANTIC-TYPE (MOST-SPECIFIC-TYPE REFS NIL))
           (THEMATIC-ROLE NIL)
           (DE `(,NP-ID ,NUMBER ,SEMANTIC-TYPE ,THEMATIC-ROLE ,REFS)))
      (SETQ *CUR-FOCUS* DE))))

(DEFUN ATTRIBUTE-VALUE (REF)
  (LET ((LAST (FIRST (LAST REF))))
    (IF (CONSP LAST) (ATTRIBUTE-VALUE LAST) LAST)))

;; "[redefined]"
;; (DEFUN FOUND-YOU (DET VAL TYPE)
;;   (DECLARE (SPECIAL *YOU*))
;;   (LET* ((YOU-TYPE (MOST-SPECIFIC-TYPE *YOU* NIL))
;;          (RESULT
;;           (IF (OR (MATCH TYPE YOU-TYPE) (MATCH YOU-TYPE TYPE)) *YOU*)))
;;     (IF (PROCESS-DET-AND-NUMBER RESULT DET VAL TYPE NIL T) *YOU*)))

(DEFUN FOUND-ELT-SUB (TYPE SPEC OLIST &AUX OSPEC VALS)
  (DO* ((OBLIST OLIST (CDR OBLIST)) (VAL (CAR OBLIST) (CAR OBLIST)))
       ((NULL VAL) (RETURN VALS))
    (IF (AND (MATCH TYPE (GET VAL 'TYPE))
             (OR (NULL SPEC)
                 (IF (CONSP (SETQ OSPEC (GET VAL 'SPEC)))
                     (MEMBER SPEC OSPEC)
                   (EQUAL OSPEC SPEC))))
        (PUSH VAL VALS))))

(DEFUN TRAV-NP-LIST (ROLE NPS VROLES)
  (IF (NULL NPS)
      NIL
    (CONS (TRAV-NP (LIST (CONS ROLE (LIST (CAR NPS)))) VROLES)
          (TRAV-NP-LIST ROLE (CDR NPS) VROLES))))

(DEFVAR *ANAPHS-TO-RES* ())

(DEFUN GET-VERB (WFF) (GET (SECOND (MY-ASSOC :CLASS WFF)) 'SLOT-SPECS))

(DEFUN GET-TYPE (ELTROLE VROLES)
  (IF (NULL VROLES)
      NIL
    (IF (EQUAL (CAR VROLES) ELTROLE)
        (SECOND VROLES)
      (GET-TYPE ELTROLE (CDDR VROLES)))))

(DEFUN ROLE? (ELT) (FOURTH ELT))

(DEFUN AGT-LAST (OLD-ALFL TEMP-ALFL NEW-ALFL)
  (IF (NULL OLD-ALFL)
      (APPEND TEMP-ALFL NEW-ALFL)
    (IF (EQUAL (ROLE? (CAR OLD-ALFL)) ':AGENT)
        (COND ((NULL NEW-ALFL)
               (AGT-LAST (CDR OLD-ALFL) TEMP-ALFL
                (LIST (CAR OLD-ALFL))))
              ((ATOM NEW-ALFL)
               (AGT-LAST (CDR OLD-ALFL) TEMP-ALFL
                (LIST NEW-ALFL (CAR OLD-ALFL))))
              (T
               (AGT-LAST (CDR OLD-ALFL) TEMP-ALFL
                (CONS (CAR OLD-ALFL) NEW-ALFL))))
      (COND ((NULL TEMP-ALFL)
             (AGT-LAST (CDR OLD-ALFL) (CONS (CAR OLD-ALFL) NIL)
              NEW-ALFL))
            (T
             (AGT-LAST (CDR OLD-ALFL)
              (NCONC TEMP-ALFL (LIST (CAR OLD-ALFL))) NEW-ALFL))))))