;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/funtran/funtran.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; ======================================================================

;;; FUNTRAN (FUNctional TRANslator)


(DEFVAR *PREVIOUS-NATLANG-LF* ())
;; LF of previous utterance


(DEFVAR *TRANSFORMED-PREVIOUS-NATLANG-LF* ())

(DEFVAR *PREVIOUS-GRAPHIC-LF* ())
;; LF of previous graphical command


(DEFVAR *PREVIOUS-LFS* ())
;; stack of all previous LFs


(DEFVAR *PREVIOUS-LF* ())
;; previous LF to use for ellipsis


(DEFVAR *PREVIOUS-QX* ())
;; previous quantified expression


(DEFVAR *CORRECTION* ())
;; NP substitution is being attempted


(DEFVAR *PREVIOUS-ALT-FOC-LIST* ())
;; *alt-foc-list* of previous utterance


(DEFUN TRANSFORM-LF (LF) (DECLARE (IGNORE LF)))

;; "[redefined]"
;; (DEFUN HAS-FUNCTIONAL-TYPE (NP) (DECLARE (IGNORE NP)))

(DEFUN TRANSFORM-IDENTITY (LF) (DECLARE (IGNORE LF)))

(DEFUN NO-PREDICATE (LF) (DECLARE (IGNORE LF)))

(DEFUN VERB-ELLIPSIS (LF) (DECLARE (IGNORE LF)))

(DEFUN IN-SUBDIALOG (LF) (DECLARE (IGNORE LF)))

(DEFUN RETAIN-SYNTACTIC-ORDER (CLASS) (DECLARE (IGNORE CLASS)))

(DEFUN QUERIABLE-PRED (QX) (DECLARE (IGNORE QX)) T)

(DEFUN IS-COLLECTIVE (NP) (DECLARE (IGNORE NP)))

;; "[redefined]"
;; (DEFUN COMPARATIVE (SF) (DECLARE (IGNORE SF)))

(DEFUN TALLY-DEICTICS () NIL)

(DEFVAR *DEICTICS* ())

(DEFVAR *NUM-DEICTICS* ())

;; "[redefined]"
;; (DEFUN PROCESS-PARSES (PARSELIST)
;;   (DECLARE (SPECIAL *PRIOR-SUCCEEDED* *ORIGINAL-CONTEXT*))
;;   (TALLY-DEICTICS)
;;   (CATCH 'PROCESS-PARSES
;;     (SETQ *PRIOR-SUCCEEDED* NIL)
;;     (SETQ *ORIGINAL-CONTEXT* (SAVE-DISCOURSE-CONTEXT))
;;     (LET ((LFS
;;            (REMOVE-IF #'(LAMBDA (LF) (NOT (HAS-SEMANTICS LF)))
;;                       (FOREACH P IN PARSELIST COLLECT (GET-LF P)))))
;;       (IF (NULL LFS)
;;           (PARSER-ANSWER "Sorry, don't understand.")
;;         (RUN-DISCOURSE-AND-TRANSLATE LFS)))))

(DEFUN RUN-DISCOURSE-AND-TRANSLATE (LFS)
  (DECLARE (SPECIAL *PRIOR-SUCCEEDED* *ORIGINAL-CONTEXT*
            *PRIOR-CONTEXT*))
  (LET* ((RAW-LF (FIRST LFS))
         (TRANSFORMED-LF (TRANSFORM-LF RAW-LF))
         (LF (OR TRANSFORMED-LF RAW-LF))
         (LF-TO-SAVE
          (COND ((OR (NO-PREDICATE RAW-LF) (IN-SUBDIALOG RAW-LF)) NIL)
                ((VERB-ELLIPSIS RAW-LF) LF)
                (T LF))))
    (COND ((MEMTREE 'ONEOF LF)
           (RUN-DISCOURSE-AND-TRANSLATE
            (APPEND (CDR (EXPAND-ONEOFS LF)) (CDR LFS))))
          ((MEMBER (FIRST LF) '(AND OR)) (PROCESS-CONJOINED-LF LF))
          ((EQ (FIRST LF) 'IF) (PROCESS-HYPOTHETICAL-LF LF))
          ((EQ (RUN-DISCOURSE-ON-LF LF) 'ERROR)
           (COND ((CDR LFS)
                  (PARSER-MESSAGE "[next parse] ")
                  (RESTORE-DISCOURSE-CONTEXT *ORIGINAL-CONTEXT*)
                  (RUN-DISCOURSE-AND-TRANSLATE (CDR LFS)))
                 (T (SAVE-AS-PREVIOUS-LF LF-TO-SAVE TRANSFORMED-LF))))
          ((CDR LFS)
           (PARSER-MESSAGE "[next parse] ")
           (SETQ *PRIOR-SUCCEEDED* T)
           (SETQ *PRIOR-CONTEXT* (SAVE-DISCOURSE-CONTEXT))
           (RESTORE-DISCOURSE-CONTEXT *ORIGINAL-CONTEXT*)
           (LET ((RESULT (RUN-DISCOURSE-AND-TRANSLATE (CDR LFS))))
             (SAVE-AS-PREVIOUS-LF LF-TO-SAVE TRANSFORMED-LF)
             (IF (AND (EQ RESULT 'ERROR) (NOT (TRIVIAL-AMBIGUITY LF)))
                 (REFERENTIAL-AMBIGUITY-ERROR *ORIGINAL-CONTEXT*)
               (PROGN (RESTORE-DISCOURSE-CONTEXT *PRIOR-CONTEXT*)
                      (PROCESS-LF LF)))))
          (T
           (SAVE-AS-PREVIOUS-LF LF-TO-SAVE TRANSFORMED-LF)
           (IF *PRIOR-SUCCEEDED* 'ERROR (PROCESS-LF LF))))))

(DEFUN DONT-SAVE-AS-PREVIOUS-LF (LF) NIL)

(DEFUN SAVE-AS-PREVIOUS-LF (LF TRANSFORMED-LF)
  (DECLARE (SPECIAL *PREVIOUS-NATLANG-LF*
            *TRANSFORMED-PREVIOUS-NATLANG-LF* *PREVIOUS-QUESTION*))
  (UNLESS (DONT-SAVE-AS-PREVIOUS-LF LF)
    (WHEN LF (SETQ *PREVIOUS-NATLANG-LF* LF))
    (WHEN (MEMBER (FIRST LF) '(ASKWH REQUEST))
      (SETQ *PREVIOUS-QUESTION* LF))
    (SETQ *TRANSFORMED-PREVIOUS-NATLANG-LF* TRANSFORMED-LF)))

;; "[redefined]"
;; (DEFUN SAVE-DISCOURSE-CONTEXT ()
;;   (DECLARE (SPECIAL *ACTOR-FOCUS* *CUR-FOCUS* *FOC-STACK*
;;             *ALT-FOC-LIST* *YOU* *DEICTICS* *NUM-DEICTICS*))
;;   (LIST *ACTOR-FOCUS* *CUR-FOCUS* *FOC-STACK* *ALT-FOC-LIST* *YOU*
;;         *DEICTICS* *NUM-DEICTICS*))

;; "[redefined]"
;; (DEFUN RESTORE-DISCOURSE-CONTEXT (CONTEXT)
;;   (DECLARE (SPECIAL *ACTOR-FOCUS* *CUR-FOCUS* *FOC-STACK*
;;             *ALT-FOC-LIST* *YOU*))
;;   (SETQ *ACTOR-FOCUS* (FIRST CONTEXT)
;;         *CUR-FOCUS* (SECOND CONTEXT)
;;         *FOC-STACK* (THIRD CONTEXT)
;;         *ALT-FOC-LIST* (FOURTH CONTEXT)
;;         *YOU* (FIFTH CONTEXT)
;;         *DEICTICS* (SIXTH CONTEXT)
;;         *NUM-DEICTICS* (SEVENTH CONTEXT)))

;; "[redefined]"
;; (DEFUN REFERENTIAL-AMBIGUITY-ERROR (CONTEXT)
;;   (PARSER-ANSWER " Sorry, ambiguous sentence.")
;;   (RESTORE-DISCOURSE-CONTEXT CONTEXT)
;;   'ERROR)

;; "[redefined]"
;; (DEFUN PROCESS-LF (LF &AUX TR)
;;   (DECLARE (SPECIAL *ALT-FOC-LIST* *PREVIOUS-QX*))
;;   (DISPLAY-LF LF)
;;   (SETQ TR (TRANSLATE-LF LF))
;;   (SETF *PREVIOUS-QX* TR)
;;   (DISPLAY-TR TR)
;;   (DISPLAY-DES)
;;   (PROCESS-TRANSLATION TR *ALT-FOC-LIST*))

(DEFVAR *SHOW-NLP-OUTPUT* T)

;; "[redefined]"
;; (DEFUN DISPLAY-LF (LF)
;;   (DECLARE (SPECIAL *SHOW-NLP-OUTPUT*))
;;   (WHEN *SHOW-NLP-OUTPUT*
;;     (FORMAT T "~%;Semantic interpretation:~%")
;;     (PPRINT LF)
;;     (TERPRI)))

;; "[redefined]"
;; (DEFUN DISPLAY-TR (TR)
;;   (DECLARE (SPECIAL *SHOW-NLP-OUTPUT*))
;;   (WHEN *SHOW-NLP-OUTPUT*
;;     (FORMAT T "~%;Translation:~%")
;;     (PPRINT TR)
;;     (TERPRI)))

(DEFUN DISPLAY-DES ()
  (DECLARE (SPECIAL *SHOW-NLP-OUTPUT*))
  (WHEN *SHOW-NLP-OUTPUT*
    (FORMAT T "~%;Discourse entities:~%")
    (PPRINT *ALT-FOC-LIST*)
    (TERPRI)
    (TERPRI)))

(DEFVAR *EVALUATE* T)

;; "[redefined]"
;; (DEFUN PROCESS-TRANSLATION (TR NLIST &AUX PRED)
;;   (DECLARE (SPECIAL *PERFORMATIVES* *CORRECTION* *NEXTCODE* NLIST
;;             *PREVIOUS-QX* *ALT-FOC-LIST *PREVIOUS-ALT-FOC-LIST*))
;;   (SETQ *PREVIOUS-ALT-FOC-LIST* *ALT-FOC-LIST*)
;;   (COND ((OR (NOT (FBOUNDP (FIRST TR)))
;;              (AND (MEMBER (FIRST TR) *PERFORMATIVES*)
;;                   (AND (CONSP (SECOND TR))
;;                        (NOT (FBOUNDP (FIRST (SECOND TR)))))))
;;          (PARSER-ANSWER "Sorry, can't translate."))
;;         (T
;;          (PARSER-MESSAGE "[done] ")
;;          (IF (OR (NOT (MEMBER (FIRST TR) *PERFORMATIVES*))
;;                  (EQ (FIRST TR) 'COMMAND)
;;                  (OR (STRINGP (SECOND TR))
;;                      (QUERIABLE-PRED (SECOND TR))))
;;              (IF (STRINGP TR)
;;                  TR
;;                (IF (FBOUNDP (SETQ PRED (PREDICATE-OF TR)))
;;                    (WHEN *EVALUATE* (EVALUATE-TR TR))
;;                  (PARSER-ANSWER
;;                   (FORMAT NIL "Predicate ~A not defined." PRED))))
;;            (PARSER-ANSWER "I don't know.")))))

(DEFUN EVALUATE-TR (TR) (EVAL TR))

(DEFUN PROCESS-CONJOINED-LF (LF &AUX RESULT)
  (DECLARE (SPECIAL *NEXTCODE*))
  (PUSH `(RUN-DISCOURSE-AND-TRANSLATE ',(LIST (THIRD LF))) *NEXTCODE*)
  (SETQ RESULT (RUN-DISCOURSE-AND-TRANSLATE (LIST (SECOND LF))))
  (IF (EQ RESULT 'ERROR) (SETQ *NEXTCODE* NIL))
  RESULT)

(DEFUN PROCESS-HYPOTHETICAL-LF (LF)
  (PARSER-ANSWER "Sorry, don't know how to evaluate hypotheticals"))

;; "[redefined]"
;; (DEFUN TRANSLATE-LF (LF &KEY WH OBJECT YOU)
;;   (WHEN LF
;;     (TRANSFORM-IDENTITY LF)
;;     (CASE (FIRST LF)
;;       (ADDRESS
;;        (LET ((YOU (SECOND LF)))
;;          (SETF (FOURTH YOU) 'YOU)
;;          (TRANSLATE-LF (THIRD LF) :YOU YOU)))
;;       (ASKWH
;;        (ADD-PERFORMATIVE
;;         (CASE (FIRST (SECOND LF))
;;           (WHICH 'ASKWH)
;;           (MANY 'ASKCOUNT)
;;           (MUCH 'ASKQUANT)
;;           (T 'ASKWH))
;;         (QUANTIFY (THIRD LF) :YOU YOU :WH (SECOND LF))))
;;       ((REQUEST IMPER)
;;        (ADD-PERFORMATIVE (FIRST LF) (QUANTIFY (CDR LF) :YOU YOU)))
;;       (T (QUANTIFY LF :WH WH :OBJECT OBJECT)))))

;; "[redefined]"
;; (DEFUN ADD-PERFORMATIVE (TYPE QX)
;;   (IF (STRINGP QX)
;;       (LIST 'TELL QX)
;;     (LET ((SET-FORMER
;;            (COND ((MEMBER (FIRST QX)
;;                           '(FORALL FORMOST FORMANY EXISTS EXISTS!))
;;                   `(SETOF ,@(CDR QX)))
;;                  ((EQ (FIRST QX) 'NOT) `(SETOF ,@(CDR (SECOND QX))))
;;                  (T QX)))
;;           (PERFORM
;;            (CASE TYPE
;;              (ASKWH 'TELL)
;;              (ASKCOUNT 'TELLHOWMANY)
;;              (ASKQUANT 'TELL)
;;              (IMPER 'COMMAND)
;;              (REQUEST
;;               (CASE (FIRST QX)
;;                 (EXISTS
;;                  (IF (COMPARATIVE (THIRD QX)) 'TELLIFCOUNT 'TELLIFANY))
;;                 (NOT (IF (EQ (FIRST (SECOND QX)) 'EXISTS!)
;;                          'TELLIF
;;                        'TELLIFNONE))
;;                 (FORMANY 'TELLIFMANY)
;;                 (FORMOST 'TELLIFMOST)
;;                 (FORALL 'TELLIFALL)
;;                 (T 'TELLIF))))))
;;       (CASE PERFORM
;;         ((TELLIF COMMAND) (LIST PERFORM QX))
;;         (T (LIST PERFORM SET-FORMER))))))

(DEFUN QUANTIFY (LF &KEY WH OBJECT INDEX-VALS YOU)
  (IF (MEMBER 'PAST LF)
      "I don't remember"
    (IF (MEMBER 'FUTURE LF)
        "I can't foresee"
      (LET* ((LF-CLASS (GET-CLASS (IF (IS-OP2-FORM LF) (THIRD LF) LF)))
             (ARG-QUANTS (COLLECT-QUANTS LF))
             (QUANS (IF WH (CONS WH ARG-QUANTS) ARG-QUANTS))
             (QUANTS (IF YOU (CONS YOU QUANS) QUANS))
             (NOT (MEMBER 'NOT LF))
             (NOT-SCOPE (FIND-NOT-SCOPE LF))
             (SCOPED-QUANTS
              (IF (RETAIN-SYNTACTIC-ORDER LF-CLASS)
                  QUANTS
                (FIRST (QUANTIFIER-SCOPINGS
                        (IF (MEMBER 'PASSIVE LF)
                            (AGENT-LAST QUANTS)
                          QUANTS))))))
        (QUANTIF LF SCOPED-QUANTS INDEX-VALS NOT NOT-SCOPE :OBJECT
         OBJECT)))))

(DEFUN GET-CLASS (SIMPTERM)
  (DECLARE (SPECIAL *ALT-FOC-LIST*))
  (IF (CONSP SIMPTERM)
      (IF (OR (IS-ONEOF-INTERP SIMPTERM) (IS-ROLETERM SIMPTERM))
          (GET-CLASS (SECOND SIMPTERM))
        (SECOND (MY-ASSOC :CLASS SIMPTERM)))
    (THIRD (MY-ASSOC SIMPTERM *ALT-FOC-LIST*))))

(DEFUN FIND-NOT-SCOPE (LF)
  (IF (EQ (FIRST LF) 'ASKWH)
      (LET ((WH (SECOND LF)) (TERM (FIND-NOT-SCOPE (THIRD LF))))
        (IF (SYMBOLP TERM) WH TERM))
    (LET* ((ARGS (CDR (MEMBER (MY-ASSOC :CLASS LF) LF)))
           (FIRST-ARG (FIRST ARGS))
           (FIRST-TERM
            (IF (KEYWORDP (FIRST FIRST-ARG)) (SECOND FIRST-ARG)))
           (SECOND-ARG (SECOND ARGS))
           (SECOND-TERM
            (IF (KEYWORDP (FIRST SECOND-ARG)) (SECOND SECOND-ARG)))
           (THIRD-ARG (THIRD ARGS))
           (THIRD-TERM
            (IF (KEYWORDP (FIRST THIRD-ARG)) (SECOND THIRD-ARG))))
      (IF (AND (CONSP FIRST-TERM) (EQ (FOURTH FIRST-TERM) 'NULLAGENT))
          THIRD-TERM
        SECOND-TERM))))

(DEFUN COLLECT-QUANTS (FORM)
  (COND ((NULL FORM) NIL)
        ((CONSP FORM)
         (COND ((CONSP (FIRST FORM))
                (APPEND (COLLECT-QUANTS (FIRST FORM))
                        (COLLECT-QUANTS (CDR FORM))))
               ((KEYWORDP (FIRST FORM))
                (IF (THIRD FORM)
                    (COLLECT-QUANTS (THIRD FORM))
                  (COLLECT-QUANTS (SECOND FORM))))
               ((IS-REFERENTIAL FORM)
                (IF (HAS-FUNCTIONAL-TYPE FORM)
                    (CONS FORM (COLLECT-QUANTS (NTHCDR 4 FORM)))
                  (UNLESS (EQ (FOURTH FORM) 'NULLAGENT) (LIST FORM))))
               (T (COLLECT-QUANTS (CDR FORM)))))))

(DEFUN QUANTIF (LF QUANTS INDEX-VALS NOT NOT-SCOPE &KEY OBJECT YOU-VAR)
  (IF (NULL QUANTS)
      (LET* ((CLASS-ENTRY (MY-ASSOC :CLASS LF))
             (WFF-CLASS (SECOND CLASS-ENTRY))
             (ARGS (CDR (MEMBER CLASS-ENTRY LF)))
             (CODE
              (CONS WFF-CLASS
                    (QUANTI ARGS (REVERSE INDEX-VALS) :OBJECT
                     OBJECT))))
        (IF NOT (LIST 'NOT CODE) CODE))
    (LET* ((VAL (FIRST QUANTS))
           (NEG (IS-NEGATIVE-NP VAL))
           (NEGATE (AND NOT (EQUAL VAL NOT-SCOPE)))
           (QUANTIFIER
            (UNLESS (HAS-FUNCTIONAL-TYPE VAL)
              (COND ((IS-WH-NP VAL) 'SETOF)
                    ((EQ (FIRST VAL) 'MOST) 'FORMOST)
                    ((IS-COLLECTIVE VAL) 'EXISTS!)
                    ((OR (IS-UNIVERSAL-NP VAL)
                         (AND (IS-DEFINITE-NP VAL)
                              (MEMBER (FOURTH VAL)
                                      '(PLURAL THEM THEY)))
                         (AND (IS-YOU VAL) (NOT YOU-VAR))
                         (AND (CONSP VAL) (EQ (FIRST VAL) 'AND)))
                     'FORALL)
                    ((OR (IS-INDEFINITE-NP VAL) (IS-EACH-OTHER VAL)
                         (AND (CONSP VAL) (EQ (FIRST VAL) 'OR)))
                     'EXISTS)
                    ((OR (IS-DEFINITE-NP VAL) (EQ (FIRST VAL) 'NAME))
                     'EXISTS!))))
           (VAR
            (IF (AND YOU-VAR (IS-YOU VAL))
                YOU-VAR
              (IF QUANTIFIER (GENTEMP "X"))))
           (INDEX-VAL (LIST (SECOND VAL) (OR VAR (SET-FORMER VAL))))
           (CODE
            (QUANTIF LF (CDR QUANTS) (CONS INDEX-VAL INDEX-VALS)
             (AND NOT (NOT NEGATE)) NOT-SCOPE :YOU-VAR
             (OR YOU-VAR (IF (IS-YOU VAL) VAR)) :OBJECT OBJECT))
           (QX
            (IF QUANTIFIER
                (IF (IS-EACH-OTHER VAL)
                    (LET ((ANTECEDENT
                           (SECOND (FIRST (LAST INDEX-VALS)))))
                      `(,QUANTIFIER ,VAR
                        (REMOVE ,ANTECEDENT ,(SET-FORMER VAL)) ,CODE))
                  `(,QUANTIFIER ,VAR ,(SET-FORMER VAL) ,CODE))
              CODE)))
      (IF (OR NEG NEGATE) (LIST 'NOT QX) QX))))

(DEFUN SINGLETON-FORMER (VAL)
  (LET* ((INDEX (SECOND VAL))
         (CLASS (SECOND (THIRD VAL)))
         (MODS (NTHCDR 4 VAL))
         (TESTS
          (FOREACH M IN MODS JOIN
           (IF (KEYWORDP (FIRST M)) NIL (LIST (TRANSLATE-LF M))))))
    (WHEN (CDR TESTS) (SETQ TESTS (LIST (CONS 'AND TESTS))))
    `(SINGLETON ,INDEX ,CLASS ,@TESTS)))

(DEFUN SET-FORMER (VAL)
  (LET* ((INDEX (SECOND VAL))
         (CLASS
          (IF (MEMBER (FIRST VAL) '(AND OR))
              (GET-DE-CLASS (SECOND VAL))
            (SECOND (MY-ASSOC :CLASS VAL))))
         (MODS (NTHCDR 4 VAL))
         (TESTS
          (FOREACH M IN MODS JOIN
           (IF (KEYWORDP (FIRST M))
               NIL
             (IF (EQ (FIRST M) 'AN-STG)
                 (LIST M)
               (LIST (TRANSLATE-LF M)))))))
    (WHEN (CDR TESTS) (SETQ TESTS (LIST (CONS 'AND TESTS))))
    `(SETOF ,INDEX ,CLASS ,@TESTS)))

(DEFUN IS-WH-NP (VAL)
  (AND (CONSP VAL) (MEMBER (FIRST VAL) '(WHICH MANY MUCH))))

(DEFUN IS-NEGATIVE-NP (VAL)
  (AND (IS-INDEFINITE-NP VAL) (MEMBER (FIRST VAL) '(NO NONE))))

(DEFUN QUANTI (ARGS INDEX-VALS &KEY OBJECT)
  (IF (NULL ARGS)
      NIL
    (LET* ((ARG (FIRST ARGS))
           (ROLE (FIRST ARG))
           (FILLER (OR (THIRD ARG) (SECOND ARG)))
           (NEWFILLER (PROCESS-FILLER FILLER OBJECT INDEX-VALS)))
      (APPEND (WHEN NEWFILLER (LIST ROLE NEWFILLER))
              (QUANTI (CDR ARGS) INDEX-VALS :OBJECT OBJECT)))))

;; "[redefined]"
;; (DEFUN PROCESS-FILLER (FILLER OBJECT INDEX-VALS)
;;   (COND ((IS-VAR FILLER)
;;          (IF OBJECT
;;              (LIST 'QUOTE OBJECT)
;;            (OR (SECOND (MY-ASSOC FILLER INDEX-VALS)) FILLER)))
;;         ((OR (NUMBERP FILLER) (STRINGP FILLER)) FILLER)
;;         ((HAS-FUNCTIONAL-TYPE FILLER)
;;          (IF (IS-REFERENTIAL FILLER)
;;              (QUANTIF
;;               (APPEND (LIST (SECOND FILLER) (THIRD FILLER))
;;                       (NTHCDR 4 FILLER))
;;               NIL INDEX-VALS NIL NIL :OBJECT OBJECT)
;;            (QUANTIF FILLER NIL INDEX-VALS NIL NIL :OBJECT OBJECT)))
;;         ((IS-REFERENTIAL FILLER)
;;          (SECOND (MY-ASSOC (SECOND FILLER)
;;                   (IF (IS-EACH-OTHER FILLER)
;;                       (REVERSE INDEX-VALS)
;;                     INDEX-VALS))))
;;         (T
;;          (LIST 'QUOTE
;;                (QUANTIF FILLER NIL INDEX-VALS NIL NIL :OBJECT
;;                 OBJECT)))))

(DEFUN QUANTIFIER-SCOPINGS (QUANTS)
  (LIST (YOU-FIRST (ALL-FIRST (WH-FIRST (INDEF-FIRST QUANTS))))))

(DEFUN YOU-FIRST (VALS)
  (LET ((YOU (FIND-IF #'(LAMBDA (VAL) (IS-YOU VAL)) VALS)))
    (IF YOU (CONS YOU (REMOVE YOU VALS)) VALS)))

(DEFUN ALL-FIRST (VALS)
  (LET ((ALL
         (FIND-IF
            #'(LAMBDA (VAL)
                (OR (EQ (FIRST VAL) 'AND) (IS-UNIVERSAL-NP VAL)
                    (AND (IS-DEFINITE-NP VAL)
                         (NOT (EQ (FOURTH VAL) 'EACH-OTHER))
                         (IS-PLURAL-NP VAL))))
            VALS)))
    (IF ALL (CONS ALL (REMOVE ALL VALS)) VALS)))

(DEFUN WH-FIRST (VALS)
  (LET ((WH (FIND-IF #'(LAMBDA (VAL) (IS-WH-NP VAL)) VALS)))
    (IF WH (CONS WH (REMOVE WH VALS)) VALS)))

(DEFUN INDEF-FIRST (VALS)
  (LET ((INDEF
         (FIND-IF
            #'(LAMBDA (VAL)
                (OR (EQ (FIRST VAL) 'OR) (IS-INDEFINITE-NP VAL)))
            VALS)))
    (IF INDEF (CONS INDEF (REMOVE INDEF VALS)) VALS)))

(DEFUN FUNCTIONAL-LAST (VALS)
  (LET ((FUNC
         (FIND-IF #'(LAMBDA (VAL) (HAS-FUNCTIONAL-TYPE VAL)) VALS)))
    (IF FUNC (APPEND (REMOVE FUNC VALS) (LIST FUNC)) VALS)))

(DEFUN AGENT-LAST (VALS) (APPEND (CDR VALS) (LIST (FIRST VALS))))

(DEFUN TRANSLATE-ARG (VAL NLIST WH)
  (COND ((NUMBERP VAL) (LIST VAL))
        ((SYMBOLP VAL)
         (IF WH (LIST WH) (IF NLIST (GET-REFS VAL NLIST))))
        ((IS-REFERENTIAL VAL) (GET-REFS VAL NLIST))))

(DEFUN GET-REFS (VAL NLIST)
  (LET* ((ID (IF (SYMBOLP VAL) VAL (SECOND VAL)))
         (DE (FIND-IF #'(LAMBDA (E) (EQUAL ID (FIRST E))) NLIST))
         (REFS (FIFTH DE)))
    (IF (ATOM REFS) (LIST REFS) REFS)))

(DEFUN GET-DE-CLASS (ID)
  (DECLARE (SPECIAL *ALT-FOC-LIST*))
  (THIRD (FIND-IF #'(LAMBDA (E) (EQUAL ID (FIRST E))) *ALT-FOC-LIST*)))

(DEFUN MEMTREE (SYMBOL TREE)
  (COND ((NULL TREE) NIL)
        ((CONSP TREE)
         (OR (MEMTREE-FIRST SYMBOL (FIRST TREE))
             (MEMTREE SYMBOL (CDR TREE))))
        (T (EQ SYMBOL TREE))))

(DEFUN MEMTREE-FIRST (SYMBOL TREE)
  (IF (CONSP TREE) (MEMTREE SYMBOL TREE) (EQ SYMBOL TREE)))

(DEFUN EXPAND-ONEOFS (LF)
  (COND ((NULL LF) NIL)
        ((CONSP LF)
         (COND ((EQ (FIRST LF) 'ONEOF)
                (CONS 'ONEOF (REMOVE 'ONEOF (EXPAND-ONEOFS (CDR LF)))))
               ((CONSP (FIRST LF))
                (LET ((RESULT-1 (EXPAND-ONEOFS (FIRST LF)))
                      (RESULT-2 (EXPAND-ONEOFS (CDR LF))))
                  (IF (EQ (FIRST RESULT-1) 'ONEOF)
                      (IF (EQ (FIRST RESULT-2) 'ONEOF)
                          (CONS 'ONEOF
                                (FOREACH
                                 R1
                                 IN
                                 (CDR RESULT-1)
                                 JOIN
                                 (FOREACH
                                  R2
                                  IN
                                  (CDR RESULT-2)
                                  COLLECT
                                  (CONS R1 R2))))
                        (CONS 'ONEOF
                              (FOREACH R1 IN (CDR RESULT-1) COLLECT
                               (CONS R1 RESULT-2))))
                    (IF (EQ (FIRST RESULT-2) 'ONEOF)
                        (CONS 'ONEOF
                              (FOREACH R2 IN (CDR RESULT-2) COLLECT
                               (CONS (FIRST LF) R2)))
                      LF))))
               (T
                (LET ((RESULT (EXPAND-ONEOFS (CDR LF))))
                  (IF (EQ (FIRST RESULT) 'ONEOF)
                      (CONS 'ONEOF
                            (FOREACH R IN (CDR RESULT) COLLECT
                             (CONS (FIRST LF) R)))
                    LF)))))
        (T LF)))

(DEFUN TRIVIAL-AMBIGUITY (LF) (MEMTREE 'NULLAGENT LF))

;; "[redefined]"
;; (DEFUN PARSER-ANSWER (MESSAGE) (PARSER-MESSAGE MESSAGE))