;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/funtran/qx.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; ======================================================================

;;; FUNTRAN


(DEFMACRO SETOF (VAR CLASS-OR-SET &OPTIONAL TEST)
  (DECLARE (SPECIAL NLIST))
  `(IF (SYMBOLP ',CLASS-OR-SET)
       (GET-REFS ',VAR NLIST)
     (IF ',TEST
         (MAPCAN #'(LAMBDA (,VAR)
                     (DECLARE (SPECIAL ,VAR))
                     (LET ((RESULT ,TEST))
                       (AND RESULT
                            (IF (CONSP RESULT)
                                (LIST (CONS ,VAR RESULT))
                              (IF (STRINGP RESULT)
                                  (LIST (LIST ,VAR RESULT))
                                (LIST ,VAR))))))
                 ,CLASS-OR-SET)
       ,CLASS-OR-SET)))

(DEFMACRO EXISTS (VAR SET TEST)
  `(SOME #'(LAMBDA (,VAR) (DECLARE (SPECIAL ,VAR)) ,TEST) ,SET))

(DEFMACRO EXISTS! (VAR SET TEST)
  `(AND (EQ (LENGTH ,SET) 1)
        (SOME #'(LAMBDA (,VAR) (DECLARE (SPECIAL ,VAR)) ,TEST) ,SET)))

(DEFMACRO FORALL (VAR SET TEST)
  `(EVERY #'(LAMBDA (,VAR) (DECLARE (SPECIAL ,VAR)) ,TEST) ,SET))

(SETQ *PERFORMATIVES*
      '(TELLIF TELL TELLHOWMANY TELLIFANY TELLIFNONE TELLIFALL
        TELLIFMOST TELLIFMANY COMMAND))

(DEFVAR *SELF* ())

(DEFUN SELF-ADDRESSED () (MEMBER *SELF* *YOU*))

(DEFMACRO TELLIF (THEME)
  `(LET* ((ANSWER ,THEME)
          (RESPONSE
           (IF ANSWER
               (IF (STRINGP ANSWER)
                   (IF (STRING= ANSWER "I don't know")
                       (FORMAT NIL "~A." ANSWER)
                     (FORMAT NIL "Yes: ~A." ANSWER))
                 "Yes.")
             "No.")))
     (PARSER-ANSWER RESPONSE)
     (GENERATE-DE-FOR-SET ANSWER)))

(DEFUN EXISTENTIAL (PRED) (EQ PRED 'EXIST))

(DEFMACRO TELLIFANY (THEME)
  `(LET* ((RAW-POS-SET ,THEME)
          (POS-SET
           (IF (CONSP (FIRST RAW-POS-SET))
               (MAPCAR #'FIRST RAW-POS-SET)
             RAW-POS-SET))
          (DE-SET POS-SET)
          (ORIG-SET
           (IF (EQ (FIRST ',THEME) 'SETOF)
               (EVAL (THIRD ',THEME))
             ,THEME))
          (NEG-SET (SET-DIFFERENCE ORIG-SET POS-SET))
          (RESPONSE
           (COND ((NULL POS-SET) "No.")
                 ((NULL NEG-SET)
                  (IF (CDR POS-SET)
                      (IF (EXISTENTIAL (PREDICATE-OF ',THEME))
                          (FORMAT NIL "Yes, ~R." (LENGTH POS-SET))
                        "Yes, all.")
                    (FORMAT NIL "Yes, ~A." (FORMAT-ANSWER POS-SET))))
                 ((STRINGP POS-SET) (FORMAT NIL "~A." POS-SET))
                 ((<= (LENGTH POS-SET) (LENGTH NEG-SET))
                  (FORMAT NIL "Yes: ~A." (FORMAT-ANSWER POS-SET)))
                 ((> (LENGTH POS-SET) (LENGTH NEG-SET))
                  (FORMAT NIL "Yes, all but ~A."
                          (FORMAT-ANSWER NEG-SET))))))
     (PARSER-ANSWER RESPONSE)
     (GENERATE-DE-FOR-SET DE-SET)))

(DEFMACRO TELLIFNONE (THEME)
  `(LET* ((RAW-POS-SET ,THEME)
          (POS-SET
           (IF (CONSP (FIRST RAW-POS-SET))
               (MAPCAR #'FIRST RAW-POS-SET)
             RAW-POS-SET))
          (DE-SET POS-SET)
          (ORIG-SET
           (IF (EQ (FIRST ',THEME) 'SETOF)
               (EVAL (THIRD ',THEME))
             ,THEME))
          (NEG-SET (SET-DIFFERENCE ORIG-SET POS-SET))
          (RESPONSE
           (COND ((NULL POS-SET) "Yes, none.")
                 ((NULL NEG-SET)
                  (IF (CDR POS-SET)
                      "No, all."
                    (FORMAT NIL "No, ~A." (FORMAT-ANSWER POS-SET))))
                 ((STRINGP POS-SET) (FORMAT NIL "~A." POS-SET))
                 ((<= (LENGTH POS-SET) (LENGTH NEG-SET))
                  (FORMAT NIL "Only ~A." (FORMAT-ANSWER POS-SET)))
                 ((> (LENGTH POS-SET) (LENGTH NEG-SET))
                  (FORMAT NIL "All but ~A."
                          (FORMAT-ANSWER NEG-SET))))))
     (PARSER-ANSWER RESPONSE)
     (GENERATE-DE-FOR-SET DE-SET)))

(DEFMACRO TELLIFMOST (THEME)
  `(LET* ((RAW-POS-SET ,THEME)
          (POS-SET
           (IF (CONSP (FIRST RAW-POS-SET))
               (MAPCAR #'FIRST RAW-POS-SET)
             RAW-POS-SET))
          (DE-SET POS-SET)
          (ORIG-SET
           (IF (EQ (FIRST ',THEME) 'SETOF)
               (EVAL (THIRD ',THEME))
             ,THEME))
          (NEG-SET (SET-DIFFERENCE ORIG-SET POS-SET))
          (RESPONSE
           (COND ((NULL POS-SET) "No, none.")
                 ((NULL NEG-SET) "Yes, all.")
                 ((STRINGP POS-SET) (FORMAT NIL "~A." POS-SET))
                 ((<= (LENGTH POS-SET) (LENGTH NEG-SET))
                  (FORMAT NIL "No, only ~A."
                          (FORMAT NIL "~R" (LENGTH POS-SET))))
                 ((> (LENGTH POS-SET) (LENGTH NEG-SET))
                  (FORMAT NIL "Yes, all but ~A."
                          (FORMAT NIL "~R" (LENGTH NEG-SET)))))))
     (PARSER-ANSWER RESPONSE)
     (GENERATE-DE-FOR-SET DE-SET)))

(DEFMACRO TELLIFMANY (THEME)
  `(LET* ((RAW-POS-SET ,THEME)
          (POS-SET
           (IF (CONSP (FIRST RAW-POS-SET))
               (MAPCAR #'FIRST RAW-POS-SET)
             RAW-POS-SET))
          (DE-SET POS-SET)
          (ORIG-SET
           (IF (EQ (FIRST ',THEME) 'SETOF)
               (EVAL (THIRD ',THEME))
             ,THEME))
          (NEG-SET (SET-DIFFERENCE ORIG-SET POS-SET))
          (RESPONSE
           (COND ((NULL POS-SET) "No, none.")
                 ((NULL NEG-SET) "Yes, all.")
                 ((STRINGP POS-SET) (FORMAT NIL "~A." POS-SET))
                 (T "I'm not sure how many MANY is."))))
     (PARSER-ANSWER RESPONSE)
     (GENERATE-DE-FOR-SET DE-SET)))

(DEFUN COMPARATIVE (SF)
  (FIND (FIRST (FOURTH SF)) `(P-COUNT P-GREATER-COUNT P-SMALLER-COUNT)))

(DEFMACRO TELLIFCOUNT (THEME)
  `(LET* ((RAW-POS-SET ,THEME)
          (POS-SET
           (IF (CONSP (FIRST RAW-POS-SET))
               (MAPCAR #'FIRST RAW-POS-SET)
             RAW-POS-SET))
          (DE-SET POS-SET)
          (ORIG-SET
           (IF (EQ (FIRST ',THEME) 'SETOF)
               (EVAL (THIRD ',THEME))
             ,THEME))
          (COMPARATIVE
           (FIND (FIRST (FOURTH (THIRD ',THEME)))
                 '(P-COUNT P-GREATER-COUNT P-SMALLER-COUNT)))
          (NUM (LENGTH POS-SET))
          (GOAL (GETF (CDR (FOURTH (THIRD ',THEME))) :AT-LOC))
          (RESPONSE
           (CASE COMPARATIVE
             (P-COUNT
              (COND ((ZEROP NUM) "No, none.")
                    ((< NUM GOAL) (FORMAT NIL "No, only ~R." NUM))
                    ((= NUM GOAL) (FORMAT NIL "Yes, exactly ~R." NUM))
                    ((> NUM GOAL) (FORMAT NIL "No, more: ~R." NUM))))
             (P-GREATER-COUNT
              (COND ((ZEROP NUM) "No, none.")
                    ((< NUM GOAL) (FORMAT NIL "No, only ~R." NUM))
                    ((= NUM GOAL) (FORMAT NIL "No, exactly ~R." NUM))
                    ((> NUM GOAL) (FORMAT NIL "Yes, ~R." NUM))))
             (P-SMALLER-COUNT
              (COND ((ZEROP NUM) "No, none.")
                    ((< NUM GOAL) (FORMAT NIL "Yes, ~R." NUM))
                    ((= NUM GOAL) (FORMAT NIL "No, exactly ~R." NUM))
                    ((> NUM GOAL) (FORMAT NIL "No, ~R." NUM)))))))
     (PARSER-ANSWER RESPONSE)
     (GENERATE-DE-FOR-SET DE-SET)))

(DEFMACRO COMMAND (THEME) `(EVAL ',(COMMANDIFY THEME)))

(DEFUN PREDICATE-OF (QX)
  (CASE (FIRST QX)
    (NOT (PREDICATE-OF (SECOND QX)))
    ((SETOF FORALL EXISTS EXISTS!) (PREDICATE-OF (FOURTH QX)))
    (T (FIRST QX))))

(DEFUN COMMANDIFY (QX &KEY NOT)
  (CASE (FIRST QX)
    (NOT (COMMANDIFY (SECOND QX) :NOT (NOT NOT)))
    ((SETOF FORALL EXISTS EXISTS!)
     (LIST (FIRST QX) (SECOND QX) (THIRD QX)
           (COMMANDIFY (FOURTH QX) :NOT NOT)))
    (T (APPEND QX (LIST :COMMAND T) (IF NOT (LIST :NOT T))))))

(DEFUN BIND-VARIABLES (QX)
  (FOREACH ITEM IN QX COLLECT
   (COND ((IS-VAR ITEM) (LIST 'QUOTE (EVAL ITEM)))
         ((SYMBOLP ITEM) ITEM)
         ((SYMBOLP (SECOND ITEM)) ITEM)
         (T (LIST (FIRST ITEM) (BIND-VARIABLES (SECOND ITEM)))))))

;; "[redefined]"
;; (DEFUN FORMAT-ANSWER (LIST)
;;   (LET* ((FIRST (FIRST LIST))
;;          (STRING (FORMAT-ELEMENT FIRST))
;;          (REST (CDR LIST)))
;;     (IF REST
;;         (CONCATENATE 'STRING STRING (IF (CDR REST) ", " " and ")
;;                      (FORMAT-ANSWER REST))
;;       STRING)))

;; "[redefined]"
;; (DEFUN FORMAT-ELEMENT (ELT)
;;   (COND ((STRINGP ELT) ELT)
;;         ((NUMBERP ELT) (FORMAT NIL "~A" ELT))
;;         ((SYMBOLP ELT)
;;          (IF (GET ELT :ID)
;;              (FORMAT-ID-ELT ELT)
;;            (STRING-CAPITALIZE ELT)))
;;         (T
;;          (CONCATENATE 'STRING (FORMAT-ELEMENT (FIRST ELT)) ": "
;;                       (FORMAT-ELEMENT (SECOND ELT))
;;                       (IF (THIRD ELT)
;;                           (CONCATENATE 'STRING " & "
;;                                        (FORMAT-ELEMENT (THIRD ELT)))
;;                         "")))))

;; "[redefined]"
;; (DEFUN FORMAT-ID-ELT (ELT)
;;   (FORMAT NIL "~A #~A" (STRIP-TINSEL-CLASS ELT) (GET ELT :ID)))

(DEFUN STRIP-TINSEL-CLASS (ELT) (SUBSEQ (STRING (GET ELT 'TYPE)) 2))