;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/comp-types.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: rl-compiler -*-


(DEFCONSTANT END-OF-FILE (QUOTE EOF))

(DEFCONSTANT EMPTY-STRING "")

(DEFCONSTANT LEFT-STRING-DELIMITER #\")

(DEFCONSTANT RIGHT-STRING-DELIMITER #\")

(DEFCONSTANT LEFT-OPTION-DELIMITER #\{)

(DEFCONSTANT OPTION-TOKEN "{")

(DEFCONSTANT RIGHT-OPTION-DELIMITER #\})

(DEFCONSTANT LISP-COMMENT #\;)

(DEFCONSTANT RL-SPECIAL-TOKEN (QUOTE RL-SPECIAL))

(DEFCONSTANT RL-SYMBOL-TOKEN (QUOTE RL-SYMBOL))

(DEFCONSTANT RL-INTEGER-TOKEN (QUOTE RL-INTEGER))

(DEFCONSTANT RL-STRING-TOKEN (QUOTE RL-STRING))

(DEFCONSTANT RL-OPTION-TOKEN (QUOTE RL-OPTION))

(DEFCONSTANT RL-IGNORE (QUOTE RL-IGNORE))

(DEFCONSTANT RL-GRAMMAR-TOKEN (QUOTE GRAMMAR-TYPE))

(DEFCONSTANT RL-SUBSTATEMENT-TOKEN (QUOTE RL-SUBSTATEMENT-NAME))

(DEFCONSTANT RL-REGISTER-TOKEN (QUOTE RL-REGISTER))

(DEFCONSTANT RL-NAME-TOKEN (QUOTE RL-NAME))

(DEFCONSTANT RL-PREFIX (QUOTE RL-))

(DEFCONSTANT NULL-CATEGORY ())

(DEFCONSTANT BAD-TOKEN-MSG
    "~%BAD-TOKEN IN GRAMMAR FILE: ~A; IT SHALL BE IGNORED")

(DEFCONSTANT FILE-ATTRIBUTES
    ";;; -*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: User -*-")

(DEFUN SPECIAL-CHARACTER (C)
  (MEMBER C '(#\< #\> #\= #\: #\* #\. #\| #\! #\{ #\} #\, #\( #\))))

(DEFUN VALID-NON-ALPHANUMERIC (C) (MEMBER C '(#\- #\_ #\$ #\/)))

(DEFUN LEFT-DELIMIT-CHAR (C) (EQ C LEFT-STRING-DELIMITER))

(DEFUN WHITE-CHARACTER (C)
  (MEMBER C '(#\Tab #\Newline #\Page #\Space #\Return)))

(DEFUN IMBEDDED-CHARACTER (C) (MEMBER C '(#\Backspace #\Rubout)))

(DEFUN COMMENT-CHARACTER (C) (EQ C LISP-COMMENT))

(DEFUN IGNORE-SYMBOL (TOKEN)
  (OR (AND (STRINGP TOKEN)
           (MEMBER TOKEN '("A" "AN" "THE") :TEST #'EQUAL))
      (EQ TOKEN RL-IGNORE)))

(DEFUN RL-SYMBOL-TOKEN (TOKEN) (EQ TOKEN RL-SYMBOL-TOKEN))

(DEFUN STRING-TOKEN (TOKEN) (EQ TOKEN RL-STRING-TOKEN))

(DEFUN RL-SPECIAL-TOKEN (TOKEN) (EQ TOKEN RL-SPECIAL-TOKEN))

(DEFUN RL-INTEGER-TOKEN (TOKEN) (EQ TOKEN RL-INTEGER-TOKEN))

(DEFUN SUBSTATEMENT-TOKEN (TOKEN)
  (STRING-EQUAL (SUBSEQ (STRING TOKEN) 0 1) "$"))

(DEFUN REGISTER-TOKEN (TOKEN)
  (STRING-EQUAL (SUBSEQ (STRING TOKEN) 0 1) "X"))

(DEFUN RL-NAME-TOKEN (TOKEN) (ALPHA-CHAR-P (CHAR TOKEN 0)))

(DEFTYPE VALID-CHAR (&OPTIONAL C)
  `(OR (SATISFIES ALPHANUMERICP) (SATISFIES VALID-NON-ALPHANUMERIC)))

(DEFTYPE THROW-AWAY (&OPTIONAL C)
  `(OR (SATISFIES WHITE-CHARACTER) (SATISFIES IMBEDDED-CHARACTER)))

(DEFTYPE WHITE-CHAR (&OPTIONAL C) `(SATISFIES WHITE-CHARACTER))

(DEFTYPE INTEGER-CHAR (&OPTIONAL C) `(SATISFIES DIGIT-CHAR-P))

(DEFTYPE COMMENT (&OPTIONAL C) `(SATISFIES COMMENT-CHARACTER))

(DEFTYPE ALPHABETIC (&OPTIONAL C) `(SATISFIES ALPHA-CHAR-P))

(DEFTYPE SPECIAL-TOKEN (&OPTIONAL C) `(SATISFIES SPECIAL-CHARACTER))

(DEFTYPE LEFT-DELIMITER (&OPTIONAL C) `(SATISFIES LEFT-DELIMIT-CHAR))

(DEFTYPE IGNORED (&OPTIONAL TOKEN) `(SATISFIES IGNORE-SYMBOL))

(DEFTYPE RL-SYMBOL (&OPTIONAL TOKEN)
  `(OR (SATISFIES RL-SYMBOL-TOKEN) (SATISFIES RL-SPECIAL-TOKEN)))

(DEFTYPE RL-STRING (&OPTIONAL TOKEN) `(SATISFIES STRING-TOKEN))

(DEFTYPE RL-STRING (&OPTIONAL TOKEN) `(SATISFIES STRING-TOKEN))

(DEFTYPE RL-SPECIAL (&OPTIONAL TOKEN) `(SATISFIES RL-SPECIAL-TOKEN))

(DEFTYPE RL-SUBSTATEMENT (&OPTIONAL TOKEN)
  `(SATISFIES SUBSTATEMENT-TOKEN))

(DEFTYPE RL-REGISTER (&OPTIONAL TOKEN) `(SATISFIES REGISTER-TOKEN))

(DEFTYPE RL-NAME (&OPTIONAL TOKEN) `(SATISFIES RL-NAME-TOKEN))

(DEFTYPE RL-INTEGER (&OPTIONAL TOKEN) `(SATISFIES RL-INTEGER-TOKEN))