;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/idiom.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;



(DEFMACRO WORD (NAME DEFINITION)
  `(IF (CONSP ',NAME)
       (DEFIDIOMWORD ',NAME ',(MAKE_PLIST_1 DEFINITION))
     (DEFWORD ',NAME ',(MAKE_PLIST_1 DEFINITION))))

(DEFUN DEFIDIOMWORD (WORDLIST PLIST)
  (FOREACH WORD IN WORDLIST DO (DEFWORD WORD NIL))
  (PUSH (LIST (MAPCAR #'STRING WORDLIST) PLIST) *IDIOMS*))

(DEFMACRO NOUN (&KEY ROOT PLURAL ATTRIBUTES CLASS XN LEFT RIGHT)
  `(IF (OR ',LEFT ',RIGHT)
       (NOUN-IDIOM-FUNC :ROOT ',ROOT :PLURAL ',PLURAL :ATTRIBUTES
        ',ATTRIBUTES :CLASS ',CLASS :XN ',XN :LEFT ',LEFT :RIGHT
        ',RIGHT)
     (NOUN-FUNC :ROOT ',ROOT :PLURAL ',PLURAL :ATTRIBUTES ',ATTRIBUTES
      :CLASS ',CLASS :XN ',XN)))

(DEFUN NOUN-IDIOM-FUNC
    (&KEY ROOT PLURAL ATTRIBUTES CLASS XN LEFT RIGHT)
  (LET* ((ATTRS (MAKE_PLIST_1 ATTRIBUTES))
         (WORDLIST (APPEND LEFT (LIST ROOT) RIGHT))
         (STRING (SUBSTITUTE #\- #\Space (FORMAT NIL "~A" WORDLIST)))
         (TRANS
          (OR XN (INTERN (SUBSEQ STRING 1 (1- (LENGTH STRING)))))))
    (FOREACH WORD IN WORDLIST DO (DEFWORD WORD NIL))
    (DEFWORD (OR PLURAL (CONCAT ROOT 'S)) NIL)
    (WHEN CLASS
      (SETF (GET TRANS 'SEMANTIC-CLASSES)
            (IF (CONSP CLASS) CLASS (LIST CLASS))))
    (DEFIDIOMWORD WORDLIST
     `(N (T XN (,TRANS SINGULAR) SINGULAR (T) ,@ATTRS)))
    (DEFIDIOMWORD
     (APPEND LEFT (LIST (OR PLURAL (CONCAT ROOT 'S))) RIGHT)
     `(N (T XN (,TRANS PLURAL) PLURAL (T) ,@ATTRS)))))

(DEFMACRO VERB
    (&KEY ROOT 3PSING PAST PASTPART PRESPART OBJLIST ATTRIBUTES XN LEFT
     RIGHT)
  `(IF (OR ',LEFT ',RIGHT)
       (VERB-IDIOM-FUNC :ROOT ',ROOT :3PSING ',3PSING :PAST ',PAST
        :PASTPART ',PASTPART :PRESPART ',PRESPART :OBJLIST ',OBJLIST
        :ATTRIBUTES ',ATTRIBUTES :XN ',XN :LEFT ',LEFT :RIGHT ',RIGHT)
     (VERB-FUNC :ROOT ',ROOT :3PSING ',3PSING :PAST ',PAST :PASTPART
      ',PASTPART :PRESPART ',PRESPART :OBJLIST ',OBJLIST :ATTRIBUTES
      ',ATTRIBUTES :XN ',XN)))

;; "[redefined]"
;; (DEFUN VERB-IDIOM-FUNC
;;     (&KEY ROOT 3PSING PAST PASTPART PRESPART OBJLIST ATTRIBUTES XN LEFT
;;      RIGHT)
;;   (LET* ((ACTIVE_OBJLIST (MAKE_PLIST OBJLIST))
;;          (PASSIVE_OBJLIST (PASSIVATE (MAKE_PLIST OBJLIST)))
;;          (PAST2 (OR PAST (CONCAT (STRIP_E ROOT) 'ED)))
;;          (ATTRS (MAKE_PLIST_1 ATTRIBUTES))
;;          (WORDLIST (APPEND LEFT (LIST ROOT) RIGHT))
;;          (STRING (SUBSTITUTE #\- #\Space (FORMAT NIL "~A" WORDLIST)))
;;          (TRANS
;;           (OR XN (INTERN (SUBSEQ STRING 1 (1- (LENGTH STRING)))))))
;;     (LET ((PASTPART2 (OR PASTPART PAST2)))
;;       (FOREACH WORD IN WORDLIST DO (DEFWORD WORD NIL))
;;       (DEFWORD (OR 3PSING (CONCAT ROOT 'S)) NIL)
;;       (DEFWORD PAST2 NIL)
;;       (IF (NOT (EQUAL PAST2 PASTPART2)) (DEFWORD PASTPART2 NIL))
;;       (DEFWORD (OR PRESPART (CONCAT (STRIP_E ROOT) 'ING)) NIL)
;;       (DEFIDIOMWORD WORDLIST
;;        `(V (T SINGULAR (T) XN ,TRANS OBJLIST ,ACTIVE_OBJLIST ,@ATTRS)
;;          TV
;;          (T PLURAL (T) XN (PRESENT ,TRANS) OBJLIST ,ACTIVE_OBJLIST
;;           ,@ATTRS)))
;;       (DEFIDIOMWORD
;;        (APPEND LEFT (LIST (OR 3PSING (CONCAT ROOT 'S))) RIGHT)
;;        `(TV
;;          (T SINGULAR (T) XN (PRESENT ,TRANS) OBJLIST ,ACTIVE_OBJLIST
;;           ,@ATTRS)))
;;       (COND ((EQUAL PAST2 PASTPART2)
;;              (DEFIDIOMWORD (APPEND LEFT (LIST PAST2) RIGHT)
;;               `(TV (T XN (PAST ,TRANS) OBJLIST ,ACTIVE_OBJLIST ,@ATTRS)
;;                 VEN
;;                 (T XN ,TRANS OBJLIST ,ACTIVE_OBJLIST POBJLIST
;;                  ,PASSIVE_OBJLIST ,@ATTRS))))
;;             (T
;;              (DEFIDIOMWORD (APPEND LEFT (LIST PAST2) RIGHT)
;;               `(TV
;;                 (T XN (PAST ,TRANS) OBJLIST ,ACTIVE_OBJLIST ,@ATTRS)))
;;              (DEFIDIOMWORD (APPEND LEFT (LIST PASTPART2) RIGHT)
;;               `(VEN
;;                 (T XN ,TRANS OBJLIST ,ACTIVE_OBJLIST POBJLIST
;;                  ,PASSIVE_OBJLIST ,@ATTRS)))))
;;       (DEFIDIOMWORD
;;        (APPEND LEFT (LIST (OR PRESPART (CONCAT (STRIP_E ROOT) 'ING)))
;;                RIGHT)
;;        `(VING
;;          (T XN (PROG (EXCL::BQ-COMMA TRANS)) OBJLIST ,ACTIVE_OBJLIST
;;           ,@ATTRS))))))

(DEFUN GET-IDIOM-EDGES (LEFT RIGHT WORD)
  (FOREACH ENTRY IN *IDIOMS* DO
   (WHEN (STRING= (CAAR ENTRY)
                  (IF (STRINGP WORD) WORD (FORMAT NIL "~A" WORD)))
     (DO-IDIOM-EDGES LEFT RIGHT (CAR ENTRY) (CADR ENTRY)))))

(DEFUN DO-IDIOM-EDGES (LEFT RIGHT WORDLIST LEXDEFS)
  (COND ((NULL LEXDEFS) NIL)
        (T
         (LET ((CAT (CAR LEXDEFS)) (ATTS (CADR LEXDEFS)))
           (ADD-IDIOM-EDGE LEFT LEFT
            (MAKE-NODE :NAME CAT :SEMRULE NIL :ATTRIBUTES ATTS
             :DAUGHTERS (LIST (STRINGIFY WORDLIST)))
            CAT
            (FOREACH WORD IN WORDLIST COLLECT `(RULE-PART ,WORD NIL)))
           (DO-IDIOM-EDGES LEFT RIGHT WORDLIST (CDDR LEXDEFS))))))

(DEFUN STRINGIFY (WORDLIST)
  (LET ((STR (FORMAT NIL "~A" WORDLIST)))
    (SUBSEQ STR 1 (1- (LENGTH STR)))))

(DEFUN ADD-IDIOM-EDGE
    (LEFT RIGHT CONTENTS CAT NEEDED &AUX WORD NEWWORD)
  (DECLARE (SPECIAL END SENT))
  (SETQ NEWWORD (RULE-PART-CAT (CAR NEEDED)))
  (WHEN (AND (NOT (EQ RIGHT END))
             (EQUAL NEWWORD (SETQ WORD (SVREF SENT RIGHT))))
    (IDIOM-EXTEND LEFT (1+ RIGHT) CONTENTS CAT (CDR NEEDED))))

(DEFUN IDIOM-EXTEND (LEFT RIGHT CONTENTS CAT NEEDED)
  (IF NEEDED
      (ADD-IDIOM-EDGE LEFT RIGHT CONTENTS CAT NEEDED)
    (ADD-INACTIVE-EDGE LEFT RIGHT CONTENTS CAT NIL NIL NIL)))