;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/ptop-core.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: Lisp; Syntax: Common-lisp;  Base: 10; Package: User -*-


;; "[redefined]"
;; (DEFUN PROCESS-SENTENCE (SENTENCE-STRING &AUX WORDS-AND-CATS)
;;   (DECLARE (SPECIAL *SENTENCE* *TOPCAT* *PARSELIST* *DO-SELECTION*))
;;   (SETQ *SENTENCE*
;;         (WITH-INPUT-FROM-STRING (STREAM SENTENCE-STRING)
;;           (READ-SENTENCE STREAM)))
;;   (SETQ WORDS-AND-CATS (LEXICAL-LOOKUP *SENTENCE*))
;;   (WHEN WORDS-AND-CATS
;;     (SETQ *PARSELIST*
;;           (PARSE *TOPCAT* (CAR WORDS-AND-CATS) (CADR WORDS-AND-CATS)
;;            'ENGLISH-PARSER))
;;     (WHEN (AND *PARSELIST* *DO-SELECTION*) (APPLY-PREFERENCES))
;;     (WHEN *PARSELIST* (PROCESS-PARSES *PARSELIST*))))

(DEFUN STRIP-PACKAGE-NAME (SYMBOL) SYMBOL)

;; "[redefined]"
;; (DEFUN PROCESS-PARSES (PARSELIST) NIL)

;; "[redefined]"
;; (DEFUN APPLY-PREFERENCES () NIL)

(DEFUN GENERATE-TRACEFNS () NIL)

(DEFUN SINGLE-CHAR-SYMBOL (STREAM CHAR)
  (DECLARE (IGNORE STREAM))
  (MULTIPLE-VALUE-BIND (SYM WHERE) (INTERN (STRING CHAR)) SYM))

;; "[redefined]"
;; (DEFUN SET-READTABLE ()
;;   (SET-SYNTAX-FROM-CHAR #\' #\a)
;;   (SET-MACRO-CHARACTER #\? #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\[ #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\] #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\, #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\; #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\" #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\: #'SINGLE-CHAR-SYMBOL)
;;   (SET-MACRO-CHARACTER #\# #'SINGLE-CHAR-SYMBOL))

(DEFUN RESTORE-READTABLE () (SETQ *READTABLE* (COPY-READTABLE NIL)))

(DEFMACRO END-OF-SENTENCEP (C) `(TYPEP ,C 'END-OF-SENTENCE))

(DEFUN READ-SENTENCE (&OPTIONAL (STREAM *STANDARD-INPUT*))
  (SET-READTABLE)
  (READ-SENTENCE-LOOP STREAM))

(DEFUN READ-SENTENCE-LOOP (STREAM &AUX SENT WORD NEXTCHAR)
  (DECLARE (SPECIAL *TOPCAT*))
  (LOOP (SETQ NEXTCHAR (PEEK-CHAR T STREAM NIL 'EOF))
        (SETQ WORD
              (COND ((EQ NEXTCHAR 'EOF) 'EOF)
                    ((MEMBER NEXTCHAR '(#\( #\)) :TEST #'CHAR=)
                     (INTERN (STRING (READ-CHAR STREAM))))
                    ((EQ NEXTCHAR '#\.) (READ-CHAR STREAM) '\.)
                    (T (READ STREAM NIL 'EOF))))
        (WHEN (EQ WORD 'EOF)
          (RESTORE-READTABLE)
          (RETURN-FROM READ-SENTENCE-LOOP NIL))
        (PUSH (STRIP-PACKAGE-NAME WORD) SENT)
        (WHEN (END-OF-SENTENCEP WORD)
          (RESTORE-READTABLE)
          (WHEN (NOT (EQ *TOPCAT* 'SENTENCE)) (SETF SENT (CDR SENT)))
          (RETURN-FROM READ-SENTENCE-LOOP (NREVERSE SENT)))))

(DEFUN INITIALIZE-GRAMMARS (FILENAMES) (RELOAD-GRAMMARS FILENAMES))

(DEFUN RELOAD-GRAMMARS (FILENAMES)
  (DECLARE (SPECIAL *GRAMSYMBOLS* *RESTR-LIST* *TEST-GRAMMAR*
            *SUBSTMT-LIST* *DEFAULT-GRAM-LISP-PATHNAME* *HARDCODED-FNS*
            *GRAM-LIST*))
  (SETQ *GRAM-LIST* FILENAMES)
  (PURGEPROPS)
  (FOREACH SYM IN *GRAMSYMBOLS* DO
   (CASE (GET SYM 'GRAMMAR-TYPE) ((NON-TERMINAL TYPE) (SET SYM NIL)))
   (SETF (GET SYM 'GRAMMAR-TYPE) NIL))
  (SETQ *GRAMSYMBOLS* NIL)
  (SETQ *DEFAULT-GRAM-LISP-PATHNAME* (CAR FILENAMES))
  (FOREACH R IN *RESTR-LIST* DO (SETF (GET R 'IGNORE) NIL)
   (SETF (GET R 'TRACER) NIL))
  (SETQ *RESTR-LIST* NIL *SUBSTMT-LIST* NIL)
  (GRAMMAR-LOAD FILENAMES))

(DEFUN GRAMMAR-LOAD (GRAMMARS &AUX PORTS)
  (DECLARE (SPECIAL *GRAM-LOAD-TRACE* *METACONJFLAG*))
  (SETQ *REDEFINITION-ACTION* NIL)
  (UNWIND-PROTECT
      (PROG ()
            (SETQ PORTS
                  (FOREACH GRAM IN GRAMMARS COLLECT
                   (OPEN GRAM :DIRECTION :INPUT)))
            (FOREACH PORT IN PORTS DO (LOAD-BNFS PORT))
            (FOREACH PORT IN PORTS DO
             (LOAD-NONCONJUNCTIVE-RESTRS PORT))
            (WHEN *METACONJFLAG*
              (APPLY 'METACONJ NIL)
              (SETQ *METACONJFLAG* NIL)
              (FOREACH PORT IN PORTS DO
               (LOAD-CONJUNCTIVE-RESTRS PORT))))
    (FOREACH PORT IN PORTS DO (CLOSE PORT)))
  (SETQ *RESTR-LIST* (SORT *RESTR-LIST* #'STRING<)))

(DEFUN LOAD-BNFS (PORT)
  (LET ((RESUME-POINT (FILE-POSITION PORT)))
    (DO ((EXPR (READ PORT NIL 'EOF) (READ PORT NIL 'EOF)))
        ((OR (EQ EXPR 'EOF)
             (IF (OR (EQUAL EXPR '(APPLY 'METACONJ NIL))
                     (EQ (CAR EXPR) 'DEFRESTR))
                 (FILE-POSITION PORT RESUME-POINT)))
         NIL)
      (SETQ RESUME-POINT (FILE-POSITION PORT))
      (IF *GRAM-LOAD-TRACE* (FORMAT T "   expr = ~A~%" EXPR))
      (EVAL EXPR))))

(DEFUN LOAD-NONCONJUNCTIVE-RESTRS (PORT)
  (DO ((EXPR (READ PORT NIL 'EOF) (READ PORT NIL 'EOF)))
      ((OR (EQ EXPR 'EOF)
           (IF (EQUAL EXPR '(APPLY 'METACONJ NIL))
               (SETQ *METACONJFLAG* T)))
       NIL)
    (IF *GRAM-LOAD-TRACE* (FORMAT T "   expr = ~A~%" EXPR))
    (EVAL EXPR)))

(DEFUN LOAD-CONJUNCTIVE-RESTRS (PORT)
  (DO ((EXPR (READ PORT NIL 'EOF) (READ PORT NIL 'EOF)))
      ((EQ EXPR 'EOF) NIL)
    (IF *GRAM-LOAD-TRACE* (FORMAT T "   expr = ~A~%" EXPR))
    (EVAL EXPR)))

(DEFUN RELOAD-DICTIONARIES (FILENAMES)
  (DECLARE (SPECIAL *WORDLIST* *DICT-LIST* *IDIOMS*))
  (SETQ *DICT-LIST* FILENAMES)
  (FOREACH W IN *WORDLIST* DO (SETF (GET W 'WORD-DEFN) NIL)
   (SETF (GET W 'DEFINED-WORD) NIL))
  (SETQ *WORDLIST* NIL)
  (SETQ *IDIOMS* NIL)
  (DICTIONARY-LOAD FILENAMES))

(DEFUN DICTIONARY-LOAD (FILENAMES)
  (FOREACH F IN FILENAMES DO (READ-DICT F)))