;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/reader.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


; -*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: user -*-


(DEFUN ADD-CHAR-TO-RULE-TEXT (CHAR)
  (SETF *RULE-TEXT* (CONCATENATE 'STRING *RULE-TEXT* (STRING CHAR))))

(DEFUN GET-NEXT-CHARACTER
    (&OPTIONAL (STREAM *STANDARD-INPUT*) (EOF-ERROR-P NIL)
     (EOF-VALUE END-OF-FILE) (RECURSIVE-P NIL) &KEY WITH-WHITE-CHARS)
  (DO ((NEXT-CHAR
        (READ-CHAR STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P)))
      ((EQ NEXT-CHAR EOF-VALUE)
       (RETURN-FROM GET-NEXT-CHARACTER EOF-VALUE))
    (ADD-CHAR-TO-RULE-TEXT NEXT-CHAR)
    (TYPECASE NEXT-CHAR
      (THROW-AWAY
       (IF (NOT WITH-WHITE-CHARS)
           (SETF NEXT-CHAR (READ-CHAR STREAM EOF-ERROR-P EOF-VALUE))
         (IF (NOT (WHITE-CHAR-P NEXT-CHAR))
             (SETF NEXT-CHAR (READ-CHAR STREAM EOF-ERROR-P EOF-VALUE))
           (RETURN-FROM GET-NEXT-CHARACTER NEXT-CHAR))))
      (COMMENT (MAP NIL #'ADD-CHAR-TO-RULE-TEXT
                    (READ-LINE STREAM EOF-ERROR-P EOF-VALUE
                               RECURSIVE-P))
               (ADD-CHAR-TO-RULE-TEXT #\Newline)
               (SETF NEXT-CHAR
                     (READ-CHAR STREAM EOF-ERROR-P EOF-VALUE
                                RECURSIVE-P)))
      (T (RETURN-FROM GET-NEXT-CHARACTER NEXT-CHAR)))))

(DEFUN GET-SYMBOL-TOKEN
    (&OPTIONAL (STREAM *STANDARD-INPUT*) (EOF-ERROR-P NIL)
     (EOF-VALUE END-OF-FILE) (RECURSIVE-P NIL))
  (DECLARE (SPECIAL NEXT-CHARACTER))
  (DO ((NEW-TOKEN EMPTY-STRING)
       (NEW-TOKEN-TYPE)
       (PEEKED-AT
        (PEEK-CHAR NIL STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P)))
      ((NOT (VALID-CHAR-P PEEKED-AT))
       (SETQ NEW-TOKEN-TYPE
             (IF (IGNOREDP
                  (SETQ NEW-TOKEN
                        (CONCATENATE 'STRING NEW-TOKEN
                                     (STRING NEXT-CHARACTER))))
                 RL-IGNORE
               RL-SYMBOL-TOKEN))
       (RETURN-FROM GET-SYMBOL-TOKEN
         (VALUES (STRING-UPCASE NEW-TOKEN) NEW-TOKEN-TYPE)))
    (SETQ NEW-TOKEN
          (CONCATENATE 'STRING NEW-TOKEN (STRING NEXT-CHARACTER)))
    (SETQ NEXT-CHARACTER
          (GET-NEXT-CHARACTER STREAM EOF-ERROR-P EOF-VALUE
           RECURSIVE-P))
    (SETQ PEEKED-AT
          (PEEK-CHAR NIL STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P))))

(DEFUN GET-INTEGER-TOKEN
    (&OPTIONAL (STREAM *STANDARD-INPUT*) (EOF-ERROR-P NIL)
     (EOF-VALUE END-OF-FILE) (RECURSIVE-P NIL))
  (DECLARE (SPECIAL NEXT-CHARACTER))
  (DO ((NEW-TOKEN EMPTY-STRING)
       (PEEKED-AT
        (PEEK-CHAR NIL STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P)))
      ((NOT (DIGIT-CHAR-P PEEKED-AT))
       (RETURN-FROM GET-INTEGER-TOKEN
         (VALUES (PARSE-INTEGER
                    (CONCATENATE 'STRING NEW-TOKEN
                                 (STRING NEXT-CHARACTER)))
                 RL-INTEGER-TOKEN)))
    (SETQ NEW-TOKEN
          (CONCATENATE 'STRING NEW-TOKEN (STRING NEXT-CHARACTER)))
    (SETQ NEXT-CHARACTER
          (GET-NEXT-CHARACTER STREAM EOF-ERROR-P EOF-VALUE
           RECURSIVE-P))
    (SETQ PEEKED-AT
          (PEEK-CHAR NIL STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P))))

(DEFUN GET-DELIMITED-TOKEN
    (DELIMITER &OPTIONAL (STREAM *STANDARD-INPUT*) (EOF-ERROR-P NIL)
     (EOF-VALUE END-OF-FILE) (RECURSIVE-P NIL))
  (CASE DELIMITER
    (#\"
     (LET ((NEW-TOKEN EMPTY-STRING) NEW-CHAR)
       (LOOP (IF (EQ (SETQ NEW-CHAR
                           (GET-NEXT-CHARACTER STREAM EOF-ERROR-P
                            EOF-VALUE RECURSIVE-P :WITH-WHITE-CHARS T))
                     RIGHT-STRING-DELIMITER)
                 (RETURN-FROM GET-DELIMITED-TOKEN
                   (VALUES NEW-TOKEN RL-STRING-TOKEN))
               (SETQ NEW-TOKEN
                     (CONCATENATE 'STRING NEW-TOKEN
                                  (STRING-UPCASE

                                   (STRING NEW-CHAR))))))))
    (T (RETURN-FROM GET-DELIMITED-TOKEN (VALUES NIL NIL)))))

(DEFUN GET-OPTION
    (&OPTIONAL (STREAM *STANDARD-INPUT*) (EOF-ERROR-P NIL)
     (EOF-VALUE END-OF-FILE) (RECURSIVE-P NIL))
  (DO ((NEXT-CHARACTER
        (GET-NEXT-CHARACTER STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P
         :WITH-WHITE-CHARS T))
       (PEEKED-AT
        (PEEK-CHAR NIL STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P))
       (NEW-TOKEN EMPTY-STRING))
      ((EQ PEEKED-AT RIGHT-OPTION-DELIMITER)
       (RETURN-FROM GET-OPTION
         (VALUES (READ-FROM-STRING
                    (CONCATENATE 'STRING NEW-TOKEN
                                 (STRING-UPCASE

                                  (STRING NEXT-CHARACTER))))
                 RL-OPTION-TOKEN)))
    (SETQ NEW-TOKEN
          (CONCATENATE 'STRING NEW-TOKEN
                       (STRING-UPCASE NEXT-CHARACTER)))
    (IF (OR (SPECIAL-TOKENP NEXT-CHARACTER) (SPECIAL-TOKENP PEEKED-AT))
        (SETQ NEW-TOKEN
              (CONCATENATE 'STRING NEW-TOKEN (STRING #\Space))))
    (SETQ NEXT-CHARACTER
          (GET-NEXT-CHARACTER STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P
           :WITH-WHITE-CHARS T))
    (SETQ PEEKED-AT
          (PEEK-CHAR NIL STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P))))

(DEFUN BAD-TOKEN (TOKEN)
  (FORMAT *ERROR-OUTPUT* BAD-TOKEN-MSG (STRING-UPCASE TOKEN)))

(DEFUN GET-NEXT-TOKEN
    (&OPTIONAL (STREAM *STANDARD-INPUT*) (EOF-ERROR-P NIL)
     (EOF-VALUE END-OF-FILE) (RECURSIVE-P NIL))
  (LET ((NEXT-CHARACTER
         (GET-NEXT-CHARACTER STREAM EOF-ERROR-P EOF-VALUE RECURSIVE-P))
        NEXT-TOKEN
        TOKEN-TYPE)
    (DECLARE (SPECIAL NEXT-CHARACTER))
    (IF (EQ NEXT-CHARACTER EOF-VALUE)
        (RETURN-FROM GET-NEXT-TOKEN (VALUES NEXT-CHARACTER NIL))
      (TYPECASE NEXT-CHARACTER
        ((OR ALPHABETIC RL-SUBSTATEMENT)
         (MULTIPLE-VALUE-SETQ (NEXT-TOKEN TOKEN-TYPE)
           (GET-SYMBOL-TOKEN STREAM EOF-ERROR-P EOF-VALUE
            RECURSIVE-P)))
        (INTEGER-CHAR
         (MULTIPLE-VALUE-SETQ (NEXT-TOKEN TOKEN-TYPE)
           (GET-INTEGER-TOKEN STREAM EOF-ERROR-P EOF-VALUE
            RECURSIVE-P)))
        (LEFT-DELIMITER
         (MULTIPLE-VALUE-SETQ (NEXT-TOKEN TOKEN-TYPE)
           (GET-DELIMITED-TOKEN NEXT-CHARACTER STREAM EOF-ERROR-P
            EOF-VALUE RECURSIVE-P)))
        (SPECIAL-TOKEN (SETQ NEXT-TOKEN (STRING NEXT-CHARACTER))
         (SETQ TOKEN-TYPE RL-SPECIAL-TOKEN))
        (T (BAD-TOKEN NEXT-TOKEN)
         (SETF NEW-TOKEN
               (GET-NEXT-TOKEN STREAM EOF-ERROR-P EOF-VALUE
                RECURSIVE-P)))))
    (RETURN-FROM GET-NEXT-TOKEN (VALUES NEXT-TOKEN TOKEN-TYPE))))

(DEFUN READ-A-TOKEN (&OPTIONAL LAST-TOKEN)
  (DECLARE (SPECIAL PORT))
  (IF (EQUAL LAST-TOKEN OPTION-TOKEN)
      (GET-OPTION PORT)
    (GET-NEXT-TOKEN PORT)))

(DEFUN CALL-READER (PORT)
  (DECLARE (SPECIAL PORT))
  (DO ((TOKEN (READ-A-TOKEN) (READ-A-TOKEN TOKEN)))
      ((EQ TOKEN END-OF-FILE) (RETURN-FROM CALL-READER END-OF-FILE))
    (FORMAT *STANDARD-OUTPUT* "~%Token is ~A" TOKEN)))

(DEFUN TEST-READER (INFILE)
  (WITH-OPEN-FILE (IN-STREAM INFILE :DIRECTION :INPUT)
    (CALL-READER IN-STREAM)))