;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/sem-compile.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: rl-compiler -*-


(DEFUN COMPILE-SEMANTICS (SEM &AUX SEMANTICS)
  "This function takes the semantics (the section after the : in the
BNF grammar) and turns it all into lisp forms.  The rule is as follows:

    {NSTGO} -> NSTGO -> (get-sem NSTGO)
	{(VERB SUBJECT OBJECT) -> (VERB SUBJECT OBJECT) -> 
		(list (get-sem VERB nil)
		      (get-sem SUBJECT nil)
		      (get-sem OBJECT nil))
 	{1} -> 1 -> (num-sem 1)
	{(VERB SUBJECT OBJECT SA*)} -> (VERB SUBJECT OBJECT SA *) ->
		(list (get-sem VERB nil)
		      (get-sem SUBJECT nil)
		      (get-sem OBJECT *))
	{(VERB SUBJECT OBJECT !SA*)} -> (VERB SUBJECT OBJECT ! SA *) ->
		(list (get-sem VERB nil)
		      (get-sem SUBJECT nil)
		      . (get-sem OBJECT *))
	{(allowed-lisp-function (VERB SUBJECT OBJECT !SA*))} ->
		(allowed-lisp-function (VERB SUBJECT OBJECT ! SA *)) ->
		(allowed-lisp-function (compile-semantics
					(VERB SUBJECT OBJECT ! SA *)))"
  (COND ((NULL SEM) NIL)
        ((NUMBERP SEM) `(NUMSEM ,SEM))
        ((EQ SEM 'NULLSEM) 'NULLSEM)
        ((SYMBOLP SEM)
         (IF (MEMBER (GET SEM 'GRAMMAR-TYPE) '(TERMINAL NON-TERMINAL))
             `(GET-SEM ,SEM NIL)
           `',SEM))
        ((STRINGP SEM) `',SEM)
        (T
         (COND ((MEMBER (CAR SEM) *ALLOWED-LISP-FUNCTIONS*)
                (SETF SEMANTICS `(,(CAR SEM)))
                (SETF SEM (CDR SEM)))
               ((EQ (CAR SEM) '!)
                (SETF SEMANTICS '(APPEND))
                (SETF SEM (CDR SEM)))
               (T (SETF SEMANTICS '(LIST))))
         (DO ((CURRENT-SEXPR (CAR SEM) (CAR SEM)))
             ((NULL SEM) SEMANTICS)
           (SETF SEM (CDR SEM))
           (COND ((EQ '! CURRENT-SEXPR)
                  (IF (EQ '* (CAR (CDR SEM)))
                      (PROGN (SETF SEMANTICS
                                   `(APPEND
                                     ,SEMANTICS
                                     (GET-SEM ,(CAR SEM) *)))
                             (SETF SEM (CDR (CDR SEM))))
                    (PROGN (SETF SEMANTICS
                                 `(APPEND
                                   ,SEMANTICS
                                   ,(COMPILE-SEMANTICS (CAR SEM))))
                           (SETF SEM (CDR SEM)))))
                 ((AND (ATOM CURRENT-SEXPR) (EQ '* (CAR SEM)))
                  (SETF SEMANTICS
                        (APPEND SEMANTICS
                                `((GET-SEM ,CURRENT-SEXPR *))))
                  (SETF SEM (CDR SEM)))
                 (T
                  (SETF SEMANTICS
                        (APPEND SEMANTICS
                                `(,(COMPILE-SEMANTICS
                                    CURRENT-SEXPR))))))))))