;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/semchart.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: Lisp; Syntax: Common-lisp; Base: 10; Package: user -*-


(EVAL-WHEN (COMPILE LOAD EVAL)
  (DEFMACRO GRAMRECORD (A1 A2 A3)
    `(PROG ()
           (SETF (GET ',A1 ',A3) ',A2)
           (PUSHNEW ',A1 *GRAMSYMBOLS*))))

(DEFUN PARSE (ROOT-NODE SENT CAT-LIST-VECTOR CALLER)
  (DECLARE (SPECIAL *PARLIM* *DEBUGFLAG* *EDGEFLAG* SENT EDGECOUNT
            ROOT-NODE END *VERTEXPROPS* *GRAMSYMBOLS* *PARSELIST*
            LAST-SENTENCE-PARSED FRONTIER *AGENDA* *CONFIGFLAG* HERE
            NULLSEM CALLER *PARLIMTAG* *MODE*))
  (PROG (START LEFT RIGHT)
        (SETF EDGECOUNT (SETF FRONTIER (SETF START (SETF LEFT 0))))
        (SETF LAST-SENTENCE-PARSED SENT)
        (SETF *PARSELIST* NIL)
        (SETF *AGENDA* NIL)
        (PURGEPROPS)
        (SETQ END (LENGTH SENT))
        (DO ()
            ((EQ RIGHT END) NIL)
          (SETF RIGHT (1+ LEFT))
          (GET-LEX-EDGES LEFT RIGHT (SVREF CAT-LIST-VECTOR LEFT))
          (WHEN (EQ CALLER 'ENGLISH-PARSER)
            (GET-IDIOM-EDGES LEFT RIGHT (SVREF SENT LEFT)))
          (SETF LEFT RIGHT))
        (CATCH *PARLIMTAG*
          (PROGN (CASE *MODE*
                   (TD (SEEK START ROOT-NODE 'INIT))
                   (BU
                    (DO ((I 0 (1+ I)))
                        ((= I END))
                      (SEEK I (ELT SENT I) 'INIT))
                    (FOREACH G IN *GRAMSYMBOLS* DO
                     (IF (EQ (GET G 'GRAMMAR-TYPE) 'NULLCAT)
                         (DO ((I 0 (1+ I)))
                             ((> I END))
                           (SEEK I G 'INIT))))))
                 (RUN-CONFIGS)))
        (GENERATE-FOREST)
        (SETQ *PARSELIST*
              (IF *PARSELIST* *PARSELIST* (GOOD-PARSE ROOT-NODE END)))
        (RETURN-FROM PARSE
          (FOREACH E IN *PARSELIST* COLLECT
           (INACTIVE-EDGE-CONTENTS E)))))

(DEFUN PRINT-VEC (VECTOR VSIZE)
  (DO ((INDEX 0)
       (LINELENGTH 0)
       (LNGTH 0)
       (ITEM (SVREF VECTOR 0) (SVREF VECTOR INDEX)))
      ((EQ (SETF INDEX (1+ INDEX)) VSIZE)
       (FORMAT *STANDARD-OUTPUT* "~A ~%" ITEM))
    (IF (> (SETF LINELENGTH
                 (+ (1+ LINELENGTH) (SETQ LNGTH (LENGTH ITEM))))
           60)
        (COND ((> LNGTH 60) (PPRINT ITEM) (SETQ LINELENGTH 0))
              (T
               (FORMAT *STANDARD-OUTPUT* "~%~A " ITEM)
               (SETF LINELENGTH (1+ LNGTH))))
      (FORMAT *STANDARD-OUTPUT* "~A " ITEM))))

(DEFUN RUN-CONFIGS ()
  (DECLARE (SPECIAL *AGENDA* *CONFIGFLAG*))
  (DO ((TASK (CAR *AGENDA*) (CAR *AGENDA*)))
      ((NULL *AGENDA*) NIL)
    (COND (*CONFIGFLAG*
           (PRINT '(RETURNING TO *AGENDA*))
           (PPRINT *AGENDA*)))
    (SETF *AGENDA* (CDR *AGENDA*))
    (ADD-ACTIVE-EDGE (CONFIG-VERTEX TASK) (CONFIG-VERTEX TASK) NIL
     (MAKE-NODE :NAME NIL :SEMRULE (CONFIG-SEMRULE TASK) :ATTRIBUTES
      NIL :DAUGHTERS NIL)
     (CONFIG-CAT TASK) (CONFIG-NEEDED TASK) (CONFIG-GENITOR TASK) NIL)))

(DEFUN GET-LEX-EDGES (LEFT RIGHT LEXDEFS)
  (COND ((NULL LEXDEFS) (MAKE-LEX-EDGE LEFT RIGHT NIL NIL))
        ((ATOM LEXDEFS)
         (ERROR "Ill-formed category in cat-list-vector"))
        ((NULL (CDR LEXDEFS))
         (MAKE-LEX-EDGE LEFT RIGHT (CAR LEXDEFS) NIL))
        (T (GET-LEX-EDGES1 LEFT RIGHT LEXDEFS))))

(DEFUN MAKE-LEX-EDGE (LEFT RIGHT SYMBOL ATTRIBUTES)
  (DECLARE (SPECIAL SENT))
  (ADD-INACTIVE-EDGE LEFT RIGHT
   (GET-LEX-TRANS SYMBOL (SVREF SENT LEFT) ATTRIBUTES) SYMBOL T
   (SVREF SENT LEFT) NIL))

(DEFUN GET-LEX-EDGES1 (LEFT RIGHT LEXDEFS)
  (COND ((NULL LEXDEFS) NIL)
        (T
         (MAKE-LEX-EDGE LEFT RIGHT (CAR LEXDEFS) (CADR LEXDEFS))
         (GET-LEX-EDGES1 LEFT RIGHT (CDDR LEXDEFS)))))

(DEFUN GET-LEX-TRANS (SYMBOL WORD ATTRIBUTES)
  (DECLARE (SPECIAL CALLER))
  (CASE CALLER
    (ENGLISH-PARSER (GET-ENGLISH-LEX-TRANS SYMBOL WORD ATTRIBUTES))
    (RL-COMPILER (GET-RL-LEX-TRANS SYMBOL WORD ATTRIBUTES))))

(DEFUN GET-ENGLISH-LEX-TRANS (SYMBOL WORD ATTRIBUTES)
  (MAKE-NODE :NAME SYMBOL :SEMRULE NIL :ATTRIBUTES ATTRIBUTES
   :DAUGHTERS (LIST WORD)))

(DEFUN GET-RL-LEX-TRANS (SYMBOL WORD ATTRIBUTE)
  (COND ((OR (LISTP WORD) (NUMBERP WORD)) `',WORD)
        ((STRINGP SYMBOL) NIL)
        (T `',(CONCAT WORD))))

(DEFUN GOOD-PARSE (ROOT-NODE END)
  (LET ((FULL-NODES (GET-CAT-EDGES ROOT-NODE 'INACTIVEOUT 0)))
    (IF FULL-NODES
        (FOREACH E IN FULL-NODES JOIN
         (IF (EQ (INACTIVE-EDGE-RIGHT E) END) (LIST E) NIL))
      NIL)))

(DEFUN PURGEPROPS ()
  (DECLARE (SPECIAL *GRAMSYMBOLS* *VERTEXPROPS*))
  (PROG (C P)
        (FOREACH C IN *GRAMSYMBOLS* DO (DECLARE (SPECIAL C))
         (FOREACH P IN *VERTEXPROPS* DO (REMOVE-PROPERTY C P)))))

(DEFUN GET-CAT-EDGES (CAT VERTEXPROP VERTEX)
  (PROG (VECTOR)
        (IF (SETF VECTOR (GET CAT VERTEXPROP))
            (RETURN-FROM GET-CAT-EDGES (SVREF VECTOR VERTEX)))))

(DEFUN ADD-INACTIVE-EDGE
    (LEFT RIGHT CONTENTS CAT LEXFLAG ACTGENITOR INACTGENITOR)
  (DECLARE (SPECIAL *DEBUGFLAG* *PARLIM* *EDGEFLAG* EDGECOUNT RIGHT
            CONTENTS *MODE*))
  (PROG (NEWEDGE COUNTER)
        (DECLARE (SPECIAL COUNTER))
        (IF *EDGEFLAG* (SETQ COUNTER (SETQ EDGECOUNT (1+ EDGECOUNT))))
        (SETF NEWEDGE
              (CREATE-INACTIVE-EDGE
               (IF *DEBUGFLAG* (CONS COUNTER ACTGENITOR)) INACTGENITOR
               LEFT RIGHT CONTENTS CAT LEXFLAG))
        (IF *PARLIM* (PARLIMCHECK LEFT RIGHT NEWEDGE))
        (FOREACH E IN (GET-CAT-EDGES CAT 'SOUGHTIN LEFT) DO
         (DECLARE (SPECIAL LEFT RIGHT CONTENTS))
         (EXTEND (ACTIVE-EDGE-LEFT E) (ACTIVE-EDGE-CONTENTS E)
          (ACTIVE-EDGE-PARTTREE E) (ACTIVE-EDGE-CAT E)
          (ACTIVE-EDGE-NEEDED E) RIGHT CONTENTS
          (IF *DEBUGFLAG* (CAR (ACTIVE-EDGE-NAME E))) COUNTER))
        (IF (EQ *MODE* 'BU) (SEEK LEFT CAT COUNTER))
        (RETURN-FROM ADD-INACTIVE-EDGE NEWEDGE)))

(DEFUN ADD-ACTIVE-EDGE
    (LEFT RIGHT CONTENTS PARTTREE CAT NEEDED ACTGENITOR INACTGENITOR)
  (DECLARE (SPECIAL *EDGEFLAG* EDGECOUNT LEFT RIGHT CONTENTS PARTTREE
            CAT NEEDED SENT *DEBUGFLAG* END *MODE*))
  (PROG (NEWEDGE NEWCAT EXTENDERS COUNTER WORD)
        (DECLARE (SPECIAL COUNTER))
        (IF *EDGEFLAG* (SETQ COUNTER (SETQ EDGECOUNT (1+ EDGECOUNT))))
        (SETQ NEWEDGE
              (CREATE-ACTIVE-EDGE
               (IF *DEBUGFLAG* (CONS COUNTER ACTGENITOR)) INACTGENITOR
               LEFT RIGHT CONTENTS PARTTREE CAT NEEDED))
        (CASE (GET-GRAMMAR-TYPE
               (SETQ NEWCAT (RULE-PART-CAT (CAR NEEDED))))
          (TERMINAL
           (FOREACH E IN (GET-CAT-EDGES NEWCAT 'INACTIVEOUT RIGHT) DO
            (EXTEND LEFT CONTENTS PARTTREE CAT NEEDED
             (INACTIVE-EDGE-RIGHT E) (INACTIVE-EDGE-CONTENTS E) COUNTER
             (CAR (INACTIVE-EDGE-NAME E)))))
          (NULLCAT
           (EXTEND LEFT CONTENTS PARTTREE CAT NEEDED RIGHT
            (GET-LEX-TRANS NEWCAT NIL NIL) COUNTER NIL))
          (STRING (IF (AND (NOT (EQ RIGHT END))
                           (EQUAL NEWCAT
                                  (SETQ WORD (SVREF SENT RIGHT))))
                      (EXTEND LEFT CONTENTS PARTTREE CAT NEEDED
                       (1+ RIGHT) (GET-LEX-TRANS WORD WORD NIL) COUNTER
                       NIL)))
          (NON-TERMINAL
           (IF (SETQ EXTENDERS
                     (GET-CAT-EDGES NEWCAT 'INACTIVEOUT RIGHT))
               (FOREACH E IN EXTENDERS DO
                (EXTEND LEFT CONTENTS PARTTREE CAT NEEDED
                 (INACTIVE-EDGE-RIGHT E) (INACTIVE-EDGE-CONTENTS E)
                 COUNTER (CAR (INACTIVE-EDGE-NAME E)))))
           (IF (EQ *MODE* 'TD) (SEEK RIGHT NEWCAT COUNTER)))
          (T (ERROR "~A is an undeclared grammar category!" NEWCAT)))
        (RETURN NEWEDGE)))

(DEFUN GET-GRAMMAR-TYPE (CAT)
  (COND ((STRINGP CAT) 'STRING) (T (GET CAT 'GRAMMAR-TYPE))))

(DEFUN SEEK (VERTEX CAT GENITOR)
  (DECLARE (SPECIAL *AGENDA* CAT VERTEX GENITOR END *MODE*))
  (PROG (NEWRULE)
        (COND ((AND (STRINGP CAT) (EQ *MODE* 'BU))
               (FOREACH RULE IN (WHOCARES-BU CAT) DO
                (LET ((LHS-CAT (CAR RULE)) (OPTION (CDR RULE)))
                  (PUSHAGENDA VERTEX LHS-CAT GENITOR OPTION))))
              ((AND CAT (NOT (VERTEXPROP CAT T 'SOUGHTVECTOR VERTEX)))
               (CASE *MODE*
                 (TD
                  (SETQ NEWRULE
                        (IF (BOUNDP CAT)
                            (SYMBOL-VALUE CAT)
                          (ERROR "~A has no expansion!" CAT)))
                  (FOREACH OPTION IN NEWRULE DO
                   (PUSHAGENDA VERTEX CAT GENITOR OPTION)))
                 (BU
                  (FOREACH RULE IN (WHOCARES-BU CAT) DO
                   (LET ((LHS-CAT (CAR RULE)) (OPTION (CDR RULE)))
                     (PUSHAGENDA VERTEX LHS-CAT GENITOR OPTION)))))))))

(DEFUN PUSHAGENDA (VERTEX CAT GENITOR OPTION)
  (DECLARE (SPECIAL *AGENDA*))
  (PUSH (MAKE-CONFIG :CAT CAT :NEEDED (CDR OPTION) :SEMRULE
         (OPTION-SEMRULE OPTION) :VERTEX VERTEX :GENITOR GENITOR)
        *AGENDA*))

(DEFUN EXTEND
    (NEWLEFT ACTCONTENTS PARTTREE CAT NEEDED NEWRIGHT INACTCONTENTS
     ACTGENITOR INACTGENITOR)
  (PROG (RESTRICTION NEWPARTTREE NEWCONTENTS NEWNEEDED)
        (SETF RESTRICTION (RULE-PART-RESTRICTIONS (CAR NEEDED)))
        (SETF NEWNEEDED (CDR NEEDED))
        (SETF NEWCONTENTS (APPEND ACTCONTENTS (LIST INACTCONTENTS)))
        (RETURN-FROM EXTEND
          (OR (EQ (SETQ NEWPARTTREE
                        (IF (OR RESTRICTION (NOT NEWNEEDED))
                            (INVOKE-GRAMMAR-ROUTINE RESTRICTION CAT
                             PARTTREE NEWCONTENTS NEWNEEDED NEWLEFT
                             NEWRIGHT)
                          PARTTREE))
                  'FAIL)
              (IF NEWNEEDED
                  (ADD-ACTIVE-EDGE NEWLEFT NEWRIGHT NEWCONTENTS
                   NEWPARTTREE CAT NEWNEEDED ACTGENITOR INACTGENITOR)
                (ADD-INACTIVE-EDGE NEWLEFT NEWRIGHT NEWPARTTREE CAT NIL
                 ACTGENITOR INACTGENITOR))))))

(DEFUN CREATE-ACTIVE-EDGE
    (NAME INACTGENITOR LEFT RIGHT CONTENTS PARTTREE CAT NEEDED)
  (DECLARE (SPECIAL *DEBUGFLAG* *VERTEXPROPS*))
  (PROG (EDGE SOUGHT)
        (SETQ EDGE
              (MAKE-ACTIVE-EDGE :NAME NAME :LEFT LEFT :RIGHT RIGHT
               :CONTENTS CONTENTS :PARTTREE PARTTREE :CAT CAT :NEEDED
               NEEDED))
        (IF (SYMBOLP (SETQ SOUGHT (RULE-PART-CAT (CAR NEEDED))))
            (VERTEXPROP SOUGHT EDGE 'SOUGHTIN RIGHT))
        (IF *DEBUGFLAG*
            (PARSE-TRAP-FCN NAME INACTGENITOR 'ACTIVE-EDGE CAT LEFT
             RIGHT CONTENTS NEEDED NIL))
        (RETURN-FROM CREATE-ACTIVE-EDGE EDGE)))

(DEFUN CREATE-INACTIVE-EDGE
    (NAME INACTGENITOR LEFT RIGHT CONTENTS CAT LEXFLAG)
  (DECLARE (SPECIAL VERTEXPROP FRONTIER *DEBUGFLAG*))
  (PROG (EDGE)
        (SETF EDGE
              (MAKE-INACTIVE-EDGE :NAME NAME :LEFT LEFT :RIGHT RIGHT
               :CONTENTS CONTENTS))
        (IF CAT
            (VERTEXPROP CAT EDGE 'INACTIVEOUT LEFT)
          (OR (NOT LEXFLAG)
              (IF (> RIGHT FRONTIER) (SETQ FRONTIER RIGHT))))
        (IF *DEBUGFLAG*
            (PARSE-TRAP-FCN NAME INACTGENITOR 'INACTIVE-EDGE CAT LEFT
             RIGHT CONTENTS NIL LEXFLAG))
        (RETURN-FROM CREATE-INACTIVE-EDGE EDGE)))

(DEFUN VERTEXPROP (CAT VALUE PROPERTY VERTEX)
  (DECLARE (SPECIAL END))
  (PROG (VECTOR OLDVALUE)
        (COND ((SETQ VECTOR (GET CAT PROPERTY))
               (SETF (SVREF VECTOR VERTEX)
                     (CONS VALUE
                           (SETQ OLDVALUE (SVREF VECTOR VERTEX))))
               (RETURN-FROM VERTEXPROP OLDVALUE))
              (T
               (SETQ VECTOR
                     (SETF (GET CAT PROPERTY)
                           (MAKE-SEQUENCE 'VECTOR (1+ END)
                             :INITIAL-ELEMENT NIL)))
               (SETF (SVREF VECTOR VERTEX) (LIST VALUE))))))

(DEFUN INVOKE-GRAMMAR-ROUTINE
    (ROUTINE SYMBOL PARTTREE DTRS NEEDED LEFTVERTEX RIGHTVERTEX)
  (DECLARE (SPECIAL CALLER))
  (CASE CALLER
    (ENGLISH-PARSER
     (RETURN-FROM INVOKE-GRAMMAR-ROUTINE
       (INVOKE-ENGLISH-GRAMMAR-ROUTINE ROUTINE SYMBOL PARTTREE DTRS
        NEEDED LEFTVERTEX RIGHTVERTEX)))
    (RL-COMPILER
     (RETURN-FROM INVOKE-GRAMMAR-ROUTINE
       (INVOKE-RL-GRAMMAR-ROUTINE ROUTINE SYMBOL PARTTREE DTRS NEEDED
        LEFTVERTEX RIGHTVERTEX)))
    (T
     (ERROR "~%Chart Parser called with unknown module name: ~A~%"
            CALLER))))

(DEFUN INVOKE-RL-GRAMMAR-ROUTINE
    (ROUTINE SYMBOL PARTTREE DTRS NEEDED LEFTVERTEX RIGHTVERTEX)
  (DECLARE (IGNORE SYMBOL PARTTREE NEEDED LEFTVERTEX RIGHTVERTEX))
  `(LET ((DAUGHTERS (LIST ,@DTRS)))
     (DECLARE (SPECIAL DAUGHTERS))
     ,(IF ROUTINE ROUTINE `(GAPPEND DAUGHTERS))))

(DEFUN INVOKE-ENGLISH-GRAMMAR-ROUTINE
    (ROUTINES SYMBOL PARTTREE DAUGHTERS ACTIVE-NODE LEFTVERTEX
     RIGHTVERTEX &AUX TRACEFNS)
  (DECLARE (SPECIAL LEFTVERTEX RIGHTVERTEX *FULLTRACE*))
  (SETQ TRACEFNS (GENERATE-TRACEFNS))
  (LET ((HERE
         (IF (NODE-NAME PARTTREE)
             (MAKE-NODE :NAME SYMBOL :SEMRULE (NODE-SEMRULE PARTTREE)
              :ATTRIBUTES
              (FOREACH X IN (NODE-ATTRIBUTES PARTTREE) COLLECT X)
              :DAUGHTERS DAUGHTERS)
           (MAKE-NODE :NAME SYMBOL :SEMRULE (NODE-SEMRULE PARTTREE)
            :ATTRIBUTES NIL :DAUGHTERS DAUGHTERS))))
    (DECLARE (SPECIAL HERE))
    (IF (IF ROUTINES
            (DO ((RLIST ROUTINES) (ROUTINE (CAR ROUTINES)) (FAIL))
                ((PROG2 (WHEN (AND *FULLTRACE* (GET ROUTINE 'TRACER)
                                   (NOT (GET ROUTINE 'IGNORE)))
                          (SETF SYSTEM::*DEBUG-PRINT-LENGTH* 2
                                SYSTEM::*DEBUG-PRINT-LEVEL* 2)
                          (EVAL `(TRACE ,@TRACEFNS)))
                        (SETF FAIL
                              (AND (NOT (GET ROUTINE 'IGNORE))
                                   (NOT (APPLY ROUTINE NIL))))
                        (WHEN (AND *FULLTRACE* (GET ROUTINE 'TRACER)
                                   (NOT (GET ROUTINE 'IGNORE)))
                          (SETF SYSTEM::*DEBUG-PRINT-LENGTH* 10
                                SYSTEM::*DEBUG-PRINT-LEVEL* 3)
                          (EVAL `(UNTRACE ,@TRACEFNS)))
                        (WHEN (AND FAIL (GET ROUTINE 'WFFTRACE)
                                   (NOT (GET ROUTINE 'IGNORE))
                                   (NOT (GET ROUTINE 'TRACER)))
                          (WHEN *FULLTRACE*
                            (SETF SYSTEM::*DEBUG-PRINT-LENGTH* 2
                                  SYSTEM::*DEBUG-PRINT-LEVEL* 2)
                            (EVAL `(TRACE ,@TRACEFNS)))
                          (APPLY ROUTINE NIL)
                          (WHEN *FULLTRACE*
                            (SETF SYSTEM::*DEBUG-PRINT-LENGTH* 10
                                  SYSTEM::*DEBUG-PRINT-LEVEL* 3)
                            (EVAL `(UNTRACE ,@TRACEFNS))))
                        (WHEN (AND (NOT FAIL) (GET ROUTINE 'TRACER)
                                   (NOT (GET ROUTINE 'IGNORE)))
                          (FORMAT T "~A succeeded at ~A" ROUTINE
                                  SYMBOL)
                          (PRINT-WORDS-SUBSUMED LEFTVERTEX RIGHTVERTEX)
                          (TERPRI))
                        (WHEN (AND FAIL
                                   (OR
                                    (GET ROUTINE 'TRACER)
                                    (GET ROUTINE 'WFFTRACE)))
                          (FORMAT *STANDARD-OUTPUT* "~A failed at ~A"
                                  ROUTINE SYMBOL)
                          (PRINT-WORDS-SUBSUMED LEFTVERTEX RIGHTVERTEX)
                          (TERPRI)))
                 NIL)
              (IF (SETF RLIST (CDR RLIST))
                  (SETF ROUTINE (CAR RLIST))
                (RETURN HERE)))
          HERE)
        (COND ((AND (GET SYMBOL 'SEMANTIC-TYPE) (NOT ACTIVE-NODE)
                    (NOT (GET-ATTRIBUTES (NODE-ATTRIBUTES HERE)
                          'CONJOMIT)))
               (LET ((NULLSEM NIL))
                 (DECLARE (SPECIAL NULLSEM))
                 (ASSIGN-SEM HERE))
               (IF (CHECK-SELECTION) HERE 'FAIL))
              (T HERE))
      'FAIL)))

(DEFUN CHECK-SELECTION () T)

(DEFUN PARLIMCHECK (LEFT RIGHT NEWEDGE)
  (DECLARE (SPECIAL ROOT-NODE *PARLIM* *PARLIMTAG* *PARSELIST* END))
  (IF (AND (EQ RIGHT END) (EQ LEFT 0)
           (MEMBER NEWEDGE (GET-CAT-EDGES ROOT-NODE 'INACTIVEOUT 0)))
      (AND (PUSH NEWEDGE *PARSELIST*)
           (IF (EQ (LENGTH *PARSELIST*) *PARLIM*)
               (THROW *PARLIMTAG* *PARSELIST*)))))

(DEFUN DEBUG-TOGGLE ()
  (DECLARE (SPECIAL *DEBUGFLAG* *EDGEFLAG*))
  (IF *DEBUGFLAG*
      (SETF *DEBUGFLAG* (SETQ *EDGEFLAG* NIL))
    (SETQ *DEBUGFLAG* (SETQ *EDGEFLAG* T))))

(DEFUN PARSE-TRAP-FCN
    (NAME INACTGENITOR OPERATION SYMBOL LEFT RIGHT CONTENTS NEEDED
     LEXFLAG &AUX STARTING-WORD ENDING-WORD)
  (DECLARE (SPECIAL SENT CALLER))
  (IF (NOT LEXFLAG)
      (FORMAT *STANDARD-OUTPUT* "~A: ~A ~A" NAME OPERATION SYMBOL))
  (IF LEXFLAG
      (FORMAT *STANDARD-OUTPUT* "'~A ~A" (SVREF SENT LEFT)
              (LIST (1+ LEFT)))
    (PRINT-WORDS-SUBSUMED LEFT RIGHT))
  (WHEN (AND CONTENTS SYMBOL (NOT (TERMCAT SYMBOL)))
    (FORMAT *STANDARD-OUTPUT* "~%     contains: ")
    (CASE CALLER
      (ENGLISH-PARSER
       (FOREACH C IN
        (IF (EQ OPERATION 'ACTIVE-EDGE)
            CONTENTS
          (NODE-DAUGHTERS CONTENTS))
        DO
        (FORMAT *STANDARD-OUTPUT* "~A "
                (IF (STRINGP C) C (NODE-NAME C)))))
      (RL-COMPILER (FORMAT T "...")))
    (FORMAT *STANDARD-OUTPUT* "(~A)" INACTGENITOR))
  (WHEN NEEDED
    (FORMAT *STANDARD-OUTPUT* "~%     needs: ")
    (FOREACH C IN NEEDED DO
     (FORMAT *STANDARD-OUTPUT* "~A " (RULE-PART-CAT C))))
  (TERPRI))

(DEFUN PRINT-WORDS-SUBSUMED (LEFT RIGHT)
  (DECLARE (SPECIAL SENT END))
  (LET ((STARTING-WORD (IF (EQ LEFT END) '*EOS* (SVREF SENT LEFT)))
        (ENDING-WORD
         (IF (EQ RIGHT END)
             '*EOS*
           (SVREF SENT (IF (EQ RIGHT LEFT) LEFT (1- RIGHT))))))
    (IF (NOT (EQ LEFT RIGHT))
        (FORMAT *STANDARD-OUTPUT* " subsuming ")
      (FORMAT *STANDARD-OUTPUT* " at "))
    (FORMAT *STANDARD-OUTPUT* "'~A ~A" STARTING-WORD (LIST (1+ LEFT)))
    (WHEN (> RIGHT (1+ LEFT))
      (IF (> RIGHT (+ 2 LEFT)) (FORMAT *STANDARD-OUTPUT* " ..."))
      (FORMAT *STANDARD-OUTPUT* " '~A ~A" ENDING-WORD (LIST RIGHT)))))

(DEFUN PRINT-FURTHEST-WORD ()
  (DECLARE (SPECIAL FRONTIER LAST-SENTENCE-PARSED))
  (FORMAT *STANDARD-OUTPUT* "  Furthest token analyzed was ~A "
          (IF (> FRONTIER 0)
              (IF (EQ FRONTIER (LENGTH LAST-SENTENCE-PARSED))
                  '*EOS
                (SVREF LAST-SENTENCE-PARSED (1- FRONTIER)))
            "... "))
  (IF (> FRONTIER 0)
      (FORMAT *STANDARD-OUTPUT* "~A" (LIST 'TOKEN 'NUMBER FRONTIER)))
  (TERPRI))

(DEFUN GENERATE-FOREST ()
  (DECLARE (SPECIAL *FOREST* *GRAMSYMBOLS* END))
  (SETQ *FOREST* (MAKE-ARRAY (LIST (1+ END))))
  (FOREACH G IN *GRAMSYMBOLS* DO
   (LET ((VEC (GET G 'INACTIVEOUT)))
     (IF VEC
         (DO ((I 0 (1+ I)))
             ((> I END))
           (FOREACH E IN (ELT VEC I) DO (PUSH E (ELT *FOREST* I))))))))