;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/semhouse.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: lisp; Syntax: Common-lisp; Base: 10; Package: User -*-


(DEFUN HOUSE (RESTR HOUSING)
  (DECLARE (SPECIAL RESTR))
  (LET ((INDEF (CAR HOUSING))
        (OPTION-SPEC (CADR HOUSING))
        (ELEMENT-SPEC (CADDR HOUSING)))
    (DECLARE (SPECIAL OPTION-SPEC ELEMENT-SPEC D))
    (FOREACH D IN INDEF DO
     (FOREACH DEF IN (EVAL D) DO
      (HOUSE-IN-DEF DEF OPTION-SPEC ELEMENT-SPEC)))))

(DEFUN HOUSE-IN-DEF (DEF OPTION-SPEC ELEMENT-SPEC)
  (DECLARE (SPECIAL OPTION-SPEC ELEMENT-SPEC))
  (PROG (OPTIONS FOUND)
        (DECLARE (SPECIAL FOUND))
        (SETQ *LHS* DEF)
        (SETF OPTIONS (REVERSE (EVAL DEF)))
        (SETF FOUND NIL)
        (COND ((NUMBERP OPTION-SPEC)
               (IF (< (LENGTH OPTIONS) OPTION-SPEC)
                   (FORMAT *ERROR-OUTPUT*
                           "***not enough options on RHS of ~A to house ~A~%"
                           *LHS* RESTR)
                 (HOUSE-IN-OPTION (CDR (NTH (1- OPTION-SPEC) OPTIONS))
                  ELEMENT-SPEC)))
              ((EQL OPTION-SPEC 'EVERY)
               (FOREACH OP IN OPTIONS DO
                (HOUSE-IN-OPTION (CDR OP) ELEMENT-SPEC)))
              ((CONSP OPTION-SPEC)
               (FOREACH SPEC IN OPTION-SPEC DO
                (HOUSE-IN-DEF DEF SPEC ELEMENT-SPEC)))
              (T
               (FOREACH OP IN OPTIONS DO
                (LET ((RULE-PARTS (CDR OP)))
                  (COND ((EQ (RULE-PART-CAT (CAR RULE-PARTS))
                             OPTION-SPEC)
                         (HOUSE-IN-OPTION RULE-PARTS ELEMENT-SPEC)
                         (SETQ FOUND T)))))
               (IF (NOT FOUND)
                   (FORMAT *ERROR-OUTPUT*
                           "***no option on RHS of ~A to house ~A~%"
                           *LHS* RESTR))))))

(DEFUN GENERATE-RULE (OPTION)
  `(,*LHS* -> ,@(MAPCAR #'RULE-PART-CAT OPTION)))

(DEFUN HOUSE-IN-OPTION (OPTION ELEMENT-SPEC)
  (DECLARE (SPECIAL RESTR FOUND))
  (PROG (FOUND)
        (SETF FOUND NIL)
        (COND ((NUMBERP ELEMENT-SPEC)
               (IF (< (LENGTH OPTION) ELEMENT-SPEC)
                   (FORMAT *ERROR-OUTPUT*
                           "***not enough elements in ~A to house ~A~%"
                           (GENERATE-RULE OPTION) RESTR)
                 (HOUSE-IN-ELEMENT (NTH (1- ELEMENT-SPEC) OPTION))))
              ((EQL ELEMENT-SPEC 'LAST)
               (HOUSE-IN-ELEMENT (CAR (LAST OPTION))))
              ((EQL ELEMENT-SPEC 'EVERY)
               (FOREACH ELEM IN OPTION DO (HOUSE-IN-ELEMENT ELEM)))
              (T
               (FOREACH ELEM IN OPTION DO
                (COND ((EQL (RULE-PART-CAT ELEM) ELEMENT-SPEC)
                       (HOUSE-IN-ELEMENT ELEM)
                       (SETQ FOUND T))))
               (IF (NOT FOUND)
                   (FORMAT *ERROR-OUTPUT*
                           "***no element in ~A to house ~A~%"
                           (GENERATE-RULE OPTION) RESTR))))))

(DEFUN HOUSE-IN-ELEMENT (ELEM)
  (DECLARE (SPECIAL RESTR))
  (WHEN (NOT (MEMBER RESTR (RULE-PART-RESTRICTIONS ELEM)))
    (SETF (RULE-PART-RESTRICTIONS ELEM)
          (APPEND (RULE-PART-RESTRICTIONS ELEM) (LIST RESTR)))))

(DEFUN HOUSING-ERROR ()
  (PRINC (FORMAT NIL "~% *** error in housing for restriction ~A~%"
                 RESTR)))

(DEFUN ADD-RNAME (RNAME BODY)
  (COND ((NULL BODY) NIL)
        ((LISTP BODY)
         (CONS (ADD-RNAME RNAME (CAR BODY))
               (ADD-RNAME RNAME (CDR BODY))))
        ((EQUAL (SUBSEQ (FORMAT NIL "~A" BODY) 0 1) "$")
         (CONCAT RNAME BODY))
        (T BODY)))