;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/enhance/semwdfunc.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: Lisp; Syntax: Common-lisp; Base: 10; Package: english-parser -*- 


(DEFMACRO WORD (NAME DEFINITION)
  `(DEFWORD ',NAME ',(MAKE_PLIST_1 DEFINITION)))

(DEFMACRO NOUN (&KEY ROOT PLURAL ATTRIBUTES CLASS XN)
  `(NOUN-FUNC :ROOT ',ROOT :PLURAL ',PLURAL :ATTRIBUTES ',ATTRIBUTES
    :CLASS ',CLASS :XN ',XN))

;; "[redefined]"
;; (DEFUN NOUN-FUNC (&KEY ROOT PLURAL ATTRIBUTES CLASS XN)
;;   (LET ((ATTRS (MAKE_PLIST_1 ATTRIBUTES)) (TRANS (OR XN ROOT)))
;;     (WHEN CLASS
;;       (SETF (GET TRANS 'SEMANTIC-CLASSES)
;;             (IF (CONSP CLASS) CLASS (LIST CLASS))))
;;     (DEFWORD ROOT `(N (T XN (,TRANS SINGULAR) SINGULAR (T) ,@ATTRS)))
;;     (DEFWORD (OR PLURAL (CONCAT ROOT 'S))
;;      `(N (T XN (,TRANS PLURAL) PLURAL (T) ,@ATTRS)))))

(DEFMACRO VERB
    (&KEY ROOT 3PSING PAST PASTPART PRESPART OBJLIST ATTRIBUTES XN)
  `(VERB-FUNC :ROOT ',ROOT :3PSING ',3PSING :PAST ',PAST :PASTPART
    ',PASTPART :PRESPART ',PRESPART :OBJLIST ',OBJLIST :ATTRIBUTES
    ',ATTRIBUTES :XN ',XN))

;; "[redefined]"
;; (DEFUN VERB-FUNC
;;     (&KEY ROOT 3PSING PAST PASTPART PRESPART OBJLIST ATTRIBUTES XN)
;;   (LET ((ACTIVE_OBJLIST (MAKE_PLIST OBJLIST))
;;         (PASSIVE_OBJLIST (PASSIVATE (MAKE_PLIST OBJLIST)))
;;         (PAST2 (OR PAST (CONCAT (STRIP_E ROOT) 'ED)))
;;         (ATTRS (MAKE_PLIST_1 ATTRIBUTES))
;;         (TRANS (OR XN ROOT)))
;;     (LET ((PASTPART2 (OR PASTPART PAST2)))
;;       (DEFWORD ROOT
;;        `(V (T SINGULAR (T) XN ,TRANS OBJLIST ,ACTIVE_OBJLIST ,@ATTRS)
;;          TV
;;          (T PLURAL (T) XN (PRESENT ,TRANS) OBJLIST ,ACTIVE_OBJLIST
;;           ,@ATTRS)))
;;       (DEFWORD (OR 3PSING (CONCAT ROOT 'S))
;;        `(TV
;;          (T SINGULAR (T) XN (PRESENT ,TRANS) OBJLIST ,ACTIVE_OBJLIST
;;           ,@ATTRS)))
;;       (COND ((EQUAL PAST2 PASTPART2)
;;              (DEFWORD PAST2
;;               `(TV (T XN (PAST ,TRANS) OBJLIST ,ACTIVE_OBJLIST ,@ATTRS)
;;                 VEN
;;                 (T XN ,TRANS OBJLIST ,ACTIVE_OBJLIST POBJLIST
;;                  ,PASSIVE_OBJLIST ,@ATTRS))))
;;             (T
;;              (DEFWORD PAST2
;;               `(TV
;;                 (T XN (PAST ,TRANS) OBJLIST ,ACTIVE_OBJLIST ,@ATTRS)))
;;              (DEFWORD PASTPART2
;;               `(VEN
;;                 (T XN ,TRANS OBJLIST ,ACTIVE_OBJLIST POBJLIST
;;                  ,PASSIVE_OBJLIST ,@ATTRS)))))
;;       (DEFWORD (OR PRESPART (CONCAT (STRIP_E ROOT) 'ING))
;;        `(VING
;;          (T XN (PROG (EXCL::BQ-COMMA TRANS)) OBJLIST ,ACTIVE_OBJLIST
;;           ,@ATTRS))))))

(DEFUN PASSIVATE (OBJLIST)
  (COND ((NULL OBJLIST) NIL)
        ((EQ (CAR OBJLIST) 'T) (CONS 'T (PASSIVATE (CDR OBJLIST))))
        ((ATOM (CAR OBJLIST))
         (APPEND (PASSIVATE_1 (CAR OBJLIST) (CADR OBJLIST))
                 (PASSIVATE (CDDR OBJLIST))))))

(DEFUN PASSIVATE_1 (OBJECT ATTRIBUTE)
  (CASE OBJECT
    (NSTGO (LIST 'NULLOBJ ATTRIBUTE))
    (NPN (LIST 'PN ATTRIBUTE))
    (NTOBE (LIST 'TOBE ATTRIBUTE))
    (NTOVO (LIST 'TOVO ATTRIBUTE))
    (DP (LIST 'DP ATTRIBUTE))
    (DP2 (LIST 'DP ATTRIBUTE))
    (THATS (LIST 'THATS ATTRIBUTE))
    (NN (LIST 'NSTGO ATTRIBUTE))
    (NNPN (LIST 'NPN ATTRIBUTE))
    (PN (LIST 'P1 ATTRIBUTE))
    (T NIL)))

(DEFUN MAKE_PLIST (ATTRIBUTES) (CONS T (MAKE_PLIST_1 ATTRIBUTES)))

(DEFUN MAKE_PLIST_1 (ATTRIBUTES)
  (COND ((NULL ATTRIBUTES) NIL)
        ((EQ (CAR ATTRIBUTES) 'XN)
         (CONS 'XN
               (CONS (CADR ATTRIBUTES)
                     (MAKE_PLIST_1 (CDDR ATTRIBUTES)))))
        ((OR (NULL (CDR ATTRIBUTES)) (ATOM (CADR ATTRIBUTES)))
         (CONS (CAR ATTRIBUTES)
               (CONS '(T) (MAKE_PLIST_1 (CDR ATTRIBUTES)))))
        (T
         (CONS (CAR ATTRIBUTES)
               (CONS (MAKE_PLIST (CADR ATTRIBUTES))
                     (MAKE_PLIST_1 (CDDR ATTRIBUTES)))))))

(DEFUN STRIP_E (WORD)
  (LET ((BACKWARDS (REVERSE (SYMBOL-NAME WORD))))
    (COND ((STRING-EQUAL (SUBSEQ BACKWARDS 0 1) "e")
           (INTERN (REVERSE (SUBSEQ BACKWARDS 1))))
          (T WORD))))

;; "[redefined]"
;; (DEFUN DEFWORD (WORD DEFN)
;;   (DECLARE (SPECIAL *WORDLIST*))
;;   (SETF (GET WORD 'WORD-DEFN) (APPEND DEFN (GET WORD 'WORD-DEFN)))
;;   (SETF (GET WORD 'DEFINED-WORD) T)
;;   (PUSHNEW WORD *WORDLIST*))

(DEFUN DIC-EVAL (STREAM CHAR)
  (DECLARE (IGNORE CHAR))
  (EVAL (READ STREAM T NIL T)))

(DEFUN NORMAL-CHAR (STREAM CHAR) (DECLARE (IGNORE CHAR)) NIL)

(DEFUN RAISING (&REST OP)
  `(LAMBDA (X) (LAMBDA (Q) ,(APPEND OP '(Q X)))))

(DEFUN V-RAISING (&REST OP)
  `(LAMBDA (X) (LAMBDA (Q) ,(APPEND OP '((Q X))))))

(DEFUN READ-DICT (FILENAME)
  (RESTORE-READTABLE)
  (SET-MACRO-CHARACTER #\$ #'DIC-EVAL)
  (LOAD FILENAME)
  (SET-MACRO-CHARACTER #\$ #'NORMAL-CHAR)
  (SET-SYNTAX-FROM-CHAR #\$ #\A))

(DEFUN RELOAD-DICT (DICTFILE)
  (PROG (W)
        (FOREACH W IN *WORDLIST* DO (REMPROP W 'WORD-DEFN)
         (REMPROP W 'DEFINED-WORD))
        (SETQ *WORDLIST* NIL)
        (READ-DICT DICTFILE)))