;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/parser/parse.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;


;;; -*- Mode: Lisp; Syntax: Common-lisp; Base: 10; Package: user -*- 


(DEFUN PARSE-ENGLISH-SYNTAX (SENTENCE &AUX I WORDS-AND-CATS)
  (SETF SENTENCE
        (FOREACH WORD IN SENTENCE COLLECT (STRIP-PACKAGE-NAME WORD)))
  (SETF WORDS-AND-CATS (LEXICAL-LOOKUP SENTENCE))
  (SETF *PARSELIST*
        (IF WORDS-AND-CATS
            (PARSE 'SENTENCE (CAR WORDS-AND-CATS) (CADR WORDS-AND-CATS)
             'ENGLISH-PARSER)
          NIL)))

;; "[redefined]"
;; (DEFUN LEXICAL-LOOKUP (SENTENCE)
;;   (LET ((UNDEFINED-WORDS NIL))
;;     (FOREACH W IN SENTENCE DO
;;      (WHEN (NOT (OR (NUMBERP W) (GET W 'DEFINED-WORD)))
;;        (FORMAT *STANDARD-OUTPUT* "*** undefined word ~A~%" W)
;;        (SETQ UNDEFINED-WORDS T)))
;;     (IF UNDEFINED-WORDS
;;         NIL
;;       (LIST (APPLY #'VECTOR
;;                    (FOREACH W IN SENTENCE COLLECT
;;                     (IF (NUMBERP W)
;;                         (FORMAT NIL "~A" W)
;;                       (SYMBOL-NAME W))))
;;             (APPLY #'VECTOR
;;                    (FOREACH W IN SENTENCE COLLECT
;;                     (IF (NUMBERP W)
;;                         `(Q (T XN ,W))
;;                       (GET W 'WORD-DEFN))))))))

(DEFUN NEW-EGPARSE (ENGLISH-SENTENCE)
  (LET ((WORD-AND-CATS (LEXICAL-LOOKUP ENGLISH-SENTENCE)))
    (IF WORD-AND-CATS
        (PARSE 'SENTENCE (CAR WORD-AND-CATS) (CADR WORD-AND-CATS)
         'ENGLISH-PARSER))))

(DEFUN EGPARSE (ENGLISH-SENTENCE)
  (LET (W)
    (NPARSE 'SENTENCE
     (APPLY #'VECTOR
            (FOREACH W IN ENGLISH-SENTENCE COLLECT
             (SYMBOL-NAME (INTERN (MAKE-SYMBOL (FORMAT NIL "~A" W))))))
     (APPLY #'VECTOR
            (FOREACH W IN ENGLISH-SENTENCE COLLECT
             (GET W 'WORD-DEFN))))))

(DEFUN NPARSE (ROOT-NODE SENT CAT-LIST-VECTOR)
  (SELECT-ASSERTION
   (PARSE ROOT-NODE SENT CAT-LIST-VECTOR 'ENGLISH-PARSER)))

(DEFUN ENGLISH-PARSE (INPUT-STRING)
  (LET ((ENGLISH-SENTENCE
         (MAPCAR #'(LAMBDA (W)
                     (INTERN (MAKE-SYMBOL (STRING-UPCASE W))))
                 INPUT-STRING)))
    (SELECT-ASSERTION
     (PARSE 'SENTENCE
      (APPLY #'VECTOR (MAPCAR #'SYMBOL-NAME ENGLISH-SENTENCE))
      (APPLY #'VECTOR
             (MAPCAR #'(LAMBDA (W) (GET W 'WORD-DEFN))
                     ENGLISH-SENTENCE))
      'ENGLISH-PARSER))))

(EXPORT '(PROCESS-ASSERTION REGULARIZED-PARSE))

(DEFUN REGULARIZED-PARSE (INPUT-SENTENCE)
  (MAPCAR #'(LAMBDA (P)
              (PROCESS-ASSERTION (GETF (CDR (NODE-ATTRIBUTES P)) 'XN)))
          (ENGLISH-PARSE INPUT-SENTENCE)))