;;;;;;;;;;;;;;;;;;;
;;;
;;; DO NOT EDIT!
;;;
;;; This file was extracted automatically from
;;;   "~nlp/proteus/windows/log.lisp"
;;;
;;; Original comments are retained, but may not apply,
;;; because of code filtering; ie, some code has been
;;; commented out. Such code is tagged '[redefined]'.
;;;



(SETQ TABB "      ")

(SETQ 2TABB "            ")

(SETQ SCREEN *STANDARD-OUTPUT*)

(DEFUN CREATE-SEE-ALSO (ID SENTLIST &AUX STR)
  (SETQ STR "")
  (DO ((SENT SENTLIST (CDR SENT)))
      ((NULL SENT))
    (IF (NOT (EQUAL (CAR SENT) ID))
        (SETQ STR (CONCATENATE 'STRING STR ", " (CAR SENT)))))
  (IF (NOT (EQUAL STR "")) (SETQ STR (SUBSEQ STR 2 (LENGTH STR))))
  STR)

(DEFUN GRAM-SORT (&AUX NEWLIST)
  (SETQ NEWLIST NIL)
  (DO ((ORIG *COMPILED-RULES* (CDR ORIG)))
      ((EQUAL ORIG NIL) NIL)
    (COND ((EQUAL (GET (CAR ORIG) 'GRAMMAR-TYPE) 'NON-TERMINAL)
           (SETQ NEWLIST (CONS (CAR ORIG) NEWLIST))
           (SETQ *COMPILED-RULES*
                 (REMOVE (CAR ORIG) *COMPILED-RULES*)))))
  (DO ((ORIG *COMPILED-RULES* (CDR ORIG)))
      ((EQUAL ORIG NIL) NIL)
    (COND ((EQUAL (GET (CAR ORIG) 'GRAMMAR-TYPE) 'ROUTINE)
           (SETQ NEWLIST (CONS (CAR ORIG) NEWLIST))
           (SETQ *COMPILED-RULES*
                 (REMOVE (CAR ORIG) *COMPILED-RULES*)))))
  (SETQ *COMPILED-RULES* (APPEND (REVERSE NEWLIST) *COMPILED-RULES*)))

(DEFUN REMOVE-DUP-STRING (THELIST)
  (DO ((ORIG THELIST (CDR ORIG)) (NEWLIST NIL))
      ((EQUAL ORIG NIL) NEWLIST)
    (IF (EQUAL (FIND (CAR ORIG) NEWLIST :TEST #'EQUAL) NIL)
        (SETQ NEWLIST (CONS (CAR ORIG) NEWLIST)))))

(DEFUN FINDEND (STR INDEX &AUX LAST)
  (SETQ LAST
        (DO ((IDX INDEX (+ IDX 1)) (ABORT "F"))
            ((OR (EQUAL IDX (LENGTH STR)) (EQUAL ABORT "T")) IDX)
          (IF (EQUAL (CHAR STR IDX) #\Space) (SETQ ABORT "T"))))
  (IF (EQUAL LAST (LENGTH STR)) (- LAST 1) (- LAST 2)))

(DEFUN GET-SENTLIST ()
  (DO ((INDEX 0 (+ INDEX 1))
       (LIST NIL)
       (STR (STRING-UPCASE (READ-LINE)))
       (LAST 0))
      ((EQUAL INDEX (LENGTH STR)) (REVERSE LIST))
    (COND ((NOT (EQUAL (CHAR STR INDEX) #\Space))
           (SETQ LAST (FINDEND STR INDEX))
           (SETQ LIST (CONS (SUBSEQ STR INDEX (+ LAST 1)) LIST))
           (SETQ INDEX LAST)))))

(DEFUN GET-COMMENTS (TYPE STR1 &OPTIONAL STR2 &AUX COMMENTS)
  (SETQ COMMENTS
        (DO ((COMMENTS NIL (CONS (READ-LINE) COMMENTS))
             (COUNT 0 (+ COUNT 1)))
            ((EQUAL (CAR COMMENTS) "!") COMMENTS)
          (COND ((ZEROP COUNT)
                 (FORMAT T "comments: ")
                 (IF (EQUAL TYPE 'GRAMLOG)
                     (FORMAT T (CONCATENATE 'STRING "  " STR1 " "))
                   (FORMAT T
                           (CONCATENATE 'STRING "  " (SUBSEQ STR1 0 1)
                                        (SUBSEQ STR2 0 1) ":")))
                 (FORMAT T ">"))
                (T (FORMAT T "           >")))))
  (SETQ COMMENTS (REVERSE (CDR COMMENTS)))
  (IF (EQUAL TYPE 'GRAMLOG)
      (SETQ COMMENTS
            (CONS (CONCATENATE 'STRING STR1 "  " (CAR COMMENTS))
                  (CDR COMMENTS)))
    (SETQ COMMENTS
          (CONS (CONCATENATE 'STRING (SUBSEQ STR1 0 1)
                             (SUBSEQ STR2 0 1) ": " (CAR COMMENTS))
                (CDR COMMENTS)))))

(DEFUN EMPTYTRASH ()
  (DO ((TRASH (READ-CHAR-NO-HANG) (READ-CHAR-NO-HANG)))
      ((NULL TRASH)) ))

(DEFUN PROMPT-USER (THEPROMPT CHOICES &OPTIONAL PROMPT2 &AUX ANSWER)
  (SETQ ANSWER
        (DO ((ANSWER NIL (READ-CHAR)))
            ((NUMBERP (POSITION ANSWER CHOICES)) ANSWER)
          (EMPTYTRASH)
          (IF PROMPT2 (FORMAT T PROMPT2))
          (FORMAT T THEPROMPT)))
  (EMPTYTRASH)
  ANSWER)

(DEFUN WRITE-DATE (RULE WHERE)
  (TERPRI WHERE)
  (PRINC TABB WHERE)
  (PRINC (GET RULE 'MONTH) WHERE)
  (PRINC "/" WHERE)
  (PRINC (GET RULE 'DAY) WHERE)
  (PRINC "/" WHERE)
  (PRINC (GET RULE 'YEAR) WHERE))

(DEFUN WRITE-COMMENTS (COMMENTS WHERE)
  (DO ((ALINE COMMENTS (CDR ALINE)))
      ((NULL ALINE) NIL)
    (TERPRI WHERE)
    (PRINC 2TABB WHERE)
    (PRINC (CAR ALINE) WHERE)))

(DEFUN WRITE-RULE-TEXT (STR WHERE)
  (DO ((INDEX (POSITION #\Newline STR) (POSITION #\Newline STR)))
      ((NULL INDEX) NIL)
    (PRINC 2TABB WHERE)
    (PRINC (SUBSEQ STR 0 INDEX) WHERE)
    (TERPRI WHERE)
    (SETQ STR (SUBSEQ STR (+ INDEX 1) (LENGTH STR))))
  (COND ((NOT (EQUAL STR ""))
         (PRINC 2TABB WHERE)
         (PRINC STR WHERE)
         (TERPRI WHERE))))

(DEFUN WRITE-GRAMLOG (RULE COMMENTS WHERE)
  (TERPRI WHERE)
  (PRINC "#" WHERE)
  (TERPRI)
  (PRINC RULE WHERE)
  (WRITE-DATE RULE WHERE)
  (WRITE-COMMENTS COMMENTS WHERE)
  (TERPRI WHERE)
  (WRITE-RULE-TEXT (GET RULE 'RULE-TEXT) WHERE))

(DEFUN WRITE-SENTLOG
    (THESENT PSTAT RSTAT BATCHID COMMENTS DOALSO SEEALSO RULE WHERE)
  (TERPRI WHERE)
  (PRINC "#" WHERE)
  (TERPRI)
  (PRINC THESENT WHERE)
  (PRINC "   " WHERE)
  (PRINC PSTAT WHERE)
  (PRINC "    " WHERE)
  (PRINC RSTAT WHERE)
  (WRITE-DATE RULE WHERE)
  (IF (NOT (EQUAL BATCHID ""))
      (PRINC (CONCATENATE 'STRING " run " BATCHID) WHERE))
  (COND ((AND DOALSO (NOT (EQUAL SEEALSO "")))
         (TERPRI WHERE)
         (PRINC (CONCATENATE 'STRING 2TABB "See Also:" SEEALSO)
                WHERE)))
  (WRITE-COMMENTS COMMENTS WHERE)
  (TERPRI WHERE))

(DEFUN CONFIRMABORT ()
  (TERPRI)
  (FORMAT T "If you abort,  ALL entries already created will be lost.")
  (TERPRI)
  (FORMAT T
          "ALL rules (whether already logged or not) will be saved for")
  (TERPRI)
  (FORMAT T "later logging.")
  (TERPRI)
  (TERPRI)
  (PROMPT-USER "Do you wish to abort? (y/n)>" "YyNn"))

(DEFUN GRAMMAR-LOG (RULE LOGIT)
  (TERPRI)
  (DO ((CONFIRM ""))
      ((OR (NUMBERP (POSITION CONFIRM "Yy" :TEST 'EQUAL))
           (NUMBERP (POSITION LOGIT "NnAaXx" :TEST 'EQUAL))))
    (SETQ COMMENTS NIL)
    (TERPRI)
    (FORMAT T (GET RULE 'RULE-TEXT))
    (TERPRI)
    (TERPRI)
    (SETQ LOGIT (PROMPT-USER "log? (y/n/x/a)> " "YyNnXxAa"))
    (COND ((NUMBERP (POSITION LOGIT "Yy" :TEST 'EQUAL))
           (FORMAT T "sentence id(s) >")
           (SETQ *SENTLIST* (GET-SENTLIST))
           (DO ((SENTID *SENTLIST* (CDR SENTID)))
               ((NULL SENTID) NIL)
             (SETQ COMMENTS
                   (APPEND COMMENTS
                           (GET-COMMENTS 'GRAMLOG (CAR SENTID))))
             (IF (NULL (CDR SENTID)) (TERPRI)))
           (WRITE-GRAMLOG RULE COMMENTS SCREEN)
           (TERPRI)
           (SETQ CONFIRM
                 (PROMPT-USER "save log as shown above? (y/n)>"
                  "YyNn"))
           (COND ((NUMBERP (POSITION CONFIRM "Yy" :TEST 'EQUAL))
                  (WRITE-GRAMLOG RULE COMMENTS *GRAMFILE*))))
          ((NUMBERP (POSITION LOGIT "Aa" :TEST 'EQUAL))
           (IF (NUMBERP (POSITION (CONFIRMABORT) "Yy" :TEST 'EQUAL))
               (SETQ *ABORT* T)
             (SETQ LOGIT "")))))
  LOGIT)
;;;pass value back 


(DEFUN SENTENCE-LOG (RULE)
  (TERPRI)
  (DO ((SENT *SENTLIST* (CDR SENT))
       (PSTAT NIL)
       (RSTAT NIL)
       (DUMMY NIL)
       (BATCHID NIL)
       (DOALSO NIL)
       (SEEALSO ""))
      ((NULL SENT) NIL)
    (DO ((CONFIRM "") (FILLER "" ""))
        ((NUMBERP (POSITION CONFIRM "Yy" :TEST 'EQUAL)))
      (TERPRI)
      (SETQ DUMMY
            (PROMPT-USER "     parse status (G,B,N) >" "GgBbNn"
             (CAR SENT)))
      (COND ((NUMBERP (POSITION DUMMY "Gg")) (SETQ PSTAT "GOODPAR"))
            ((NUMBERP (POSITION DUMMY "Bb")) (SETQ PSTAT "BADPAR"))
            (T (SETQ PSTAT "NOPAR")))
      (COND ((NUMBERP (POSITION DUMMY "GgBb"))
             (DO ((LOOP 0 (+ LOOP 1)))
                 ((EQUAL LOOP (LENGTH (CAR SENT))))
               (SETQ FILLER (CONCATENATE 'STRING " " FILLER)))
             (SETQ DUMMY
                   (PROMPT-USER "     reg. status (G,B) >" "GgBb"
                    FILLER))
             (COND ((NUMBERP (POSITION DUMMY "Gg"))
                    (SETQ RSTAT "GOODREG"))
                   (T (SETQ RSTAT "BADREG"))))
            (T (SETQ RSTAT "NOREG")))
      (FORMAT T "                batch id >")
      (SETQ BATCHID (READ-LINE))
      (SETQ DOALSO
            (NUMBERP (POSITION
                        (PROMPT-USER "create 'See Also' list? (y/n)>"
                         "YyNn")
                        "Yy")))
      (IF DOALSO
          (SETQ SEEALSO (CREATE-SEE-ALSO (CAR SENT) *SENTLIST*)))
      (SETQ COMMENTS (GET-COMMENTS 'SENTLOG PSTAT RSTAT))
      (WRITE-SENTLOG (CAR SENT) PSTAT RSTAT BATCHID COMMENTS DOALSO
       SEEALSO RULE SCREEN)
      (TERPRI)
      (SETQ CONFIRM
            (PROMPT-USER "save log as shown above? (y/n)>" "YyNn"))
      (IF (NUMBERP (POSITION CONFIRM "Yy" :TEST 'EQUAL))
          (WRITE-SENTLOG (CAR SENT) PSTAT RSTAT BATCHID COMMENTS DOALSO
           SEEALSO RULE *SENTFILE*)))))

(DEFUN OPEN-FILES ()
  (IF (DIRECTORY "gramlog")
      (RUN-UNIX-PROGRAM "cp" :ARGUMENTS '("gramlog" "newgram")))
  (SETQ *GRAMFILE*
        (OPEN "newgram" :DIRECTION :OUTPUT
          :IF-EXISTS :APPEND
          :IF-DOES-NOT-EXIST :CREATE))
  (IF (DIRECTORY "sentlog")
      (RUN-UNIX-PROGRAM "cp" :ARGUMENTS '("sentlog" "newsent")))
  (SETQ *SENTFILE*
        (OPEN "newsent" :DIRECTION :OUTPUT
          :IF-EXISTS :APPEND
          :IF-DOES-NOT-EXIST :CREATE)))

(DEFUN CLOSE-FILES ()
  (CLOSE *GRAMFILE*)
  (CLOSE *SENTFILE*)
  (COND (*ABORT* (DELETE-FILE "newgram") (DELETE-FILE "newsent"))
        (T
         (IF (DIRECTORY "gramlog") (DELETE-FILE "gramlog"))
         (RENAME-FILE "newgram" "gramlog")
         (IF (DIRECTORY "sentlog") (DELETE-FILE "sentlog"))
         (RENAME-FILE "newsent" "sentlog"))))

(DEFUN ADD-DATE (&AUX NEWLIST SEC MINS HRS DY MNTH YR DUMMY FIXEDYR)
  (SETQ NEWLIST NIL)
  (DO ((RULE *COMPILED-RULES* (CDR RULE)))
      ((NULL RULE))
    (MULTIPLE-VALUE-SETQ (SEC MINS HRS DY MNTH YR) (GET-DECODED-TIME))
    (MULTIPLE-VALUE-SETQ (DUMMY FIXEDYR) (TRUNCATE YR 100))
    (SETF (GET (CAR RULE) 'MONTH) MNTH)
    (SETF (GET (CAR RULE) 'DAY) DY)
    (SETF (GET (CAR RULE) 'YEAR) FIXEDYR)
    (SETQ NEWLIST (CONS (CAR RULE) NEWLIST)))
  (SETQ *COMPILED-RULES* NEWLIST))
;;;Yes, the list should be left reversed.


(DEFUN LOAD-RULES (&AUX RULES RULEFILE)
  (SETQ RULES NIL)
  (SETQ RULEFILE
        (OPEN "unfinished" :DIRECTION :INPUT :IF-DOES-NOT-EXIST NIL))
  (COND ((NOT (NULL RULEFILE))
         (DO ((HOLD (READ RULEFILE NIL NIL) (READ RULEFILE NIL NIL)))
             ((NULL HOLD))
           (SETQ RULES (CONS HOLD RULES))
           (SETQ HOLD (READ RULEFILE))
           (IF (NOT (NULL HOLD))
               (SETF (GET (CAR RULES) 'GRAMMAR-TYPE) HOLD))
           (SETF (GET (CAR RULES) 'RULE-TEXT) (READ RULEFILE))
           (SETF (GET (CAR RULES) 'MONTH) (READ RULEFILE))
           (SETF (GET (CAR RULES) 'DAY) (READ RULEFILE))
           (SETF (GET (CAR RULES) 'YEAR) (READ RULEFILE)))
         (CLOSE RULEFILE)
         (DELETE-FILE "unfinished")))
  (REVERSE RULES))

(DEFUN SAVE-RULES (&AUX RULEFILE)
  (COND ((NOT (NULL *COMPILED-RULES*))
         (SETQ RULEFILE
               (OPEN "unfinished" :DIRECTION :OUTPUT
                 :IF-DOES-NOT-EXIST :CREATE))
         (DO ((RULE *COMPILED-RULES* (CDR RULE)))
             ((NULL RULE))
           (PRINT (CAR RULE) RULEFILE)
           (PRINT (GET (CAR RULE) 'GRAMMAR-TYPE) RULEFILE)
           (PRINT (GET (CAR RULE) 'RULE-TEXT) RULEFILE)
           (PRINT (GET (CAR RULE) 'MONTH) RULEFILE)
           (PRINT (GET (CAR RULE) 'DAY) RULEFILE)
           (PRINT (GET (CAR RULE) 'YEAR) RULEFILE))
         (CLOSE RULEFILE))))

(DEFUN DO-THE-LOG (&AUX *NEW-RULES*)
  (COND ((NULL (GET (CAR *COMPILED-RULES*) 'NEWONES))
         (TERPRI)
         (FORMAT T
                 "The following are UNFINISHED rules from the last session")
         (TERPRI)))
  (SETQ *NEW-RULES* *COMPILED-RULES*)
  (DO ((RULE *COMPILED-RULES* (CDR RULE)) (LOGIT "" ""))
      ((NULL RULE))
    (COND ((NOT (NULL (GET (CAR *NEW-RULES*) 'NEWONES)))
           (TERPRI)
           (FORMAT T "The following are rules compiled TODAY")
           (TERPRI)))
    (SETQ *SENTLIST* NIL)
    (SETQ LOGIT (GRAMMAR-LOG (CAR RULE) LOGIT))
    (COND ((NUMBERP (POSITION LOGIT "YyNn" :TEST 'EQUAL))
           (SENTENCE-LOG (CAR RULE))
           (SETQ *NEW-RULES* (REMOVE (CAR RULE) *NEW-RULES*)))
          ((NUMBERP (POSITION LOGIT "Xx" :TEST 'EQUAL))
           (SETQ RULE NIL))
          (T (SETQ RULE NIL) (SETQ *ABORT* T))))
  (IF (NOT *ABORT*) (SETQ *COMPILED-RULES* *NEW-RULES*)))

(DEFUN LOG-PROGRAM ()
  (ADD-DATE)
  (GRAM-SORT)
  (SETF (GET (CAR *COMPILED-RULES*) 'NEWONES) T)
  (SETQ *COMPILED-RULES* (APPEND (LOAD-RULES) *COMPILED-RULES*))
  (COND ((NOT (NULL *COMPILED-RULES*))
         (SETQ *ABORT* NIL)
         (OPEN-FILES)
         (DO-THE-LOG)
         (CLOSE-FILES)
         (SAVE-RULES)
         (SETQ *COMPILED-RULES* NIL)
         (TERPRI)
         (PRINC 2TABB)
         (FORMAT T "END OF LOG SESSION"))
        (T (PRINC 2TABB) (FORMAT T "THERE ARE NO RULES TO BE LOGGED")))
  (TERPRI))